<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositAccount StructType
 * @subpackage Structs
 */
class DepositAccount extends AbstractStructBase
{
    /**
     * The ACCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACCOUNT_OBJID;
    /**
     * Constructor method for DepositAccount
     * @uses DepositAccount::setACCOUNT_OBJID()
     * @param string $aCCOUNT_OBJID
     */
    public function __construct($aCCOUNT_OBJID = null)
    {
        $this
            ->setACCOUNT_OBJID($aCCOUNT_OBJID);
    }
    /**
     * Get ACCOUNT_OBJID value
     * @return string
     */
    public function getACCOUNT_OBJID()
    {
        return $this->{'ACCOUNT-OBJID'};
    }
    /**
     * Set ACCOUNT_OBJID value
     * @param string $aCCOUNT_OBJID
     * @return \StructType\DepositAccount
     */
    public function setACCOUNT_OBJID($aCCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNT_OBJID) && !is_string($aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCCOUNT_OBJID, true), gettype($aCCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCCOUNT_OBJID) && !preg_match('/([0-9])*/', $aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCCOUNT_OBJID, true)), __LINE__);
        }
        $this->ACCOUNT_OBJID = $this->{'ACCOUNT-OBJID'} = $aCCOUNT_OBJID;
        return $this;
    }
}
