<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DISCOUNT StructType
 * @subpackage Structs
 */
class DISCOUNT extends AbstractStructBase
{
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The tobesoldfrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $tobesoldfrom;
    /**
     * The tobesoldto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $tobesoldto;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $discount;
    /**
     * The discountgroup
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $discountgroup;
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $servicetype;
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The ratefilter
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratefilter;
    /**
     * The yield
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $yield;
    /**
     * The guesttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $guesttype;
    /**
     * The minstaylength
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $minstaylength;
    /**
     * The discountblocked
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $discountblocked;
    /**
     * The trackingcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $trackingcode;
    /**
     * The calculationmethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $calculationmethod;
    /**
     * The DISCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $DISCOUNT_OBJID;
    /**
     * The GUEST
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUEST[]
     */
    public $GUEST;
    /**
     * Constructor method for DISCOUNT
     * @uses DISCOUNT::setDatefrom()
     * @uses DISCOUNT::setDateto()
     * @uses DISCOUNT::setTobesoldfrom()
     * @uses DISCOUNT::setTobesoldto()
     * @uses DISCOUNT::setDiscount()
     * @uses DISCOUNT::setDiscountgroup()
     * @uses DISCOUNT::setServicetype()
     * @uses DISCOUNT::setServicecode()
     * @uses DISCOUNT::setRatesegment()
     * @uses DISCOUNT::setRatecategory()
     * @uses DISCOUNT::setRatefilter()
     * @uses DISCOUNT::setYield()
     * @uses DISCOUNT::setGuesttype()
     * @uses DISCOUNT::setMinstaylength()
     * @uses DISCOUNT::setDiscountblocked()
     * @uses DISCOUNT::setTrackingcode()
     * @uses DISCOUNT::setCalculationmethod()
     * @uses DISCOUNT::setDISCOUNT_OBJID()
     * @uses DISCOUNT::setGUEST()
     * @param string $datefrom
     * @param string $dateto
     * @param string $tobesoldfrom
     * @param string $tobesoldto
     * @param string $discount
     * @param string $discountgroup
     * @param string $servicetype
     * @param string $servicecode
     * @param string $ratesegment
     * @param string $ratecategory
     * @param string $ratefilter
     * @param string $yield
     * @param string $guesttype
     * @param string $minstaylength
     * @param string $discountblocked
     * @param string $trackingcode
     * @param string $calculationmethod
     * @param string $dISCOUNT_OBJID
     * @param \StructType\GUEST[] $gUEST
     */
    public function __construct($datefrom = null, $dateto = null, $tobesoldfrom = null, $tobesoldto = null, $discount = null, $discountgroup = null, $servicetype = null, $servicecode = null, $ratesegment = null, $ratecategory = null, $ratefilter = null, $yield = null, $guesttype = null, $minstaylength = null, $discountblocked = null, $trackingcode = null, $calculationmethod = null, $dISCOUNT_OBJID = null, array $gUEST = array())
    {
        $this
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setTobesoldfrom($tobesoldfrom)
            ->setTobesoldto($tobesoldto)
            ->setDiscount($discount)
            ->setDiscountgroup($discountgroup)
            ->setServicetype($servicetype)
            ->setServicecode($servicecode)
            ->setRatesegment($ratesegment)
            ->setRatecategory($ratecategory)
            ->setRatefilter($ratefilter)
            ->setYield($yield)
            ->setGuesttype($guesttype)
            ->setMinstaylength($minstaylength)
            ->setDiscountblocked($discountblocked)
            ->setTrackingcode($trackingcode)
            ->setCalculationmethod($calculationmethod)
            ->setDISCOUNT_OBJID($dISCOUNT_OBJID)
            ->setGUEST($gUEST);
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\DISCOUNT
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\DISCOUNT
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get tobesoldfrom value
     * @return string
     */
    public function getTobesoldfrom()
    {
        return $this->tobesoldfrom;
    }
    /**
     * Set tobesoldfrom value
     * @param string $tobesoldfrom
     * @return \StructType\DISCOUNT
     */
    public function setTobesoldfrom($tobesoldfrom = null)
    {
        // validation for constraint: string
        if (!is_null($tobesoldfrom) && !is_string($tobesoldfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tobesoldfrom, true), gettype($tobesoldfrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($tobesoldfrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $tobesoldfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($tobesoldfrom, true)), __LINE__);
        }
        $this->tobesoldfrom = $tobesoldfrom;
        return $this;
    }
    /**
     * Get tobesoldto value
     * @return string
     */
    public function getTobesoldto()
    {
        return $this->tobesoldto;
    }
    /**
     * Set tobesoldto value
     * @param string $tobesoldto
     * @return \StructType\DISCOUNT
     */
    public function setTobesoldto($tobesoldto = null)
    {
        // validation for constraint: string
        if (!is_null($tobesoldto) && !is_string($tobesoldto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tobesoldto, true), gettype($tobesoldto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($tobesoldto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $tobesoldto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($tobesoldto, true)), __LINE__);
        }
        $this->tobesoldto = $tobesoldto;
        return $this;
    }
    /**
     * Get discount value
     * @return string
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param string $discount
     * @return \StructType\DISCOUNT
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($discount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($discount, true)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get discountgroup value
     * @return string
     */
    public function getDiscountgroup()
    {
        return $this->discountgroup;
    }
    /**
     * Set discountgroup value
     * @param string $discountgroup
     * @return \StructType\DISCOUNT
     */
    public function setDiscountgroup($discountgroup = null)
    {
        // validation for constraint: string
        if (!is_null($discountgroup) && !is_string($discountgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountgroup, true), gettype($discountgroup)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($discountgroup) && mb_strlen($discountgroup) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($discountgroup)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($discountgroup) && mb_strlen($discountgroup) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($discountgroup)), __LINE__);
        }
        $this->discountgroup = $discountgroup;
        return $this;
    }
    /**
     * Get servicetype value
     * @return string
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\DISCOUNT
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($servicetype) && mb_strlen($servicetype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($servicetype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($servicetype) && mb_strlen($servicetype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\DISCOUNT
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\DISCOUNT
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\DISCOUNT
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ratecategory) && mb_strlen($ratecategory) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($ratecategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratecategory) && mb_strlen($ratecategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get ratefilter value
     * @return string
     */
    public function getRatefilter()
    {
        return $this->ratefilter;
    }
    /**
     * Set ratefilter value
     * @param string $ratefilter
     * @return \StructType\DISCOUNT
     */
    public function setRatefilter($ratefilter = null)
    {
        // validation for constraint: string
        if (!is_null($ratefilter) && !is_string($ratefilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratefilter, true), gettype($ratefilter)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($ratefilter) && mb_strlen($ratefilter) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($ratefilter)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratefilter) && mb_strlen($ratefilter) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratefilter)), __LINE__);
        }
        $this->ratefilter = $ratefilter;
        return $this;
    }
    /**
     * Get yield value
     * @return string
     */
    public function getYield()
    {
        return $this->yield;
    }
    /**
     * Set yield value
     * @param string $yield
     * @return \StructType\DISCOUNT
     */
    public function setYield($yield = null)
    {
        // validation for constraint: string
        if (!is_null($yield) && !is_string($yield)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yield, true), gettype($yield)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($yield) && mb_strlen($yield) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($yield)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($yield) && mb_strlen($yield) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($yield)), __LINE__);
        }
        $this->yield = $yield;
        return $this;
    }
    /**
     * Get guesttype value
     * @return string
     */
    public function getGuesttype()
    {
        return $this->guesttype;
    }
    /**
     * Set guesttype value
     * @param string $guesttype
     * @return \StructType\DISCOUNT
     */
    public function setGuesttype($guesttype = null)
    {
        // validation for constraint: string
        if (!is_null($guesttype) && !is_string($guesttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guesttype, true), gettype($guesttype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($guesttype) && mb_strlen($guesttype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($guesttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guesttype) && mb_strlen($guesttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guesttype)), __LINE__);
        }
        $this->guesttype = $guesttype;
        return $this;
    }
    /**
     * Get minstaylength value
     * @return string
     */
    public function getMinstaylength()
    {
        return $this->minstaylength;
    }
    /**
     * Set minstaylength value
     * @param string $minstaylength
     * @return \StructType\DISCOUNT
     */
    public function setMinstaylength($minstaylength = null)
    {
        // validation for constraint: string
        if (!is_null($minstaylength) && !is_string($minstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minstaylength, true), gettype($minstaylength)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($minstaylength) && !preg_match('/([-+]){0,1}([0-9])*/', $minstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($minstaylength, true)), __LINE__);
        }
        $this->minstaylength = $minstaylength;
        return $this;
    }
    /**
     * Get discountblocked value
     * @return string
     */
    public function getDiscountblocked()
    {
        return $this->discountblocked;
    }
    /**
     * Set discountblocked value
     * @param string $discountblocked
     * @return \StructType\DISCOUNT
     */
    public function setDiscountblocked($discountblocked = null)
    {
        // validation for constraint: string
        if (!is_null($discountblocked) && !is_string($discountblocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountblocked, true), gettype($discountblocked)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($discountblocked) && !preg_match('/([-+]){0,1}([0-9])*/', $discountblocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($discountblocked, true)), __LINE__);
        }
        $this->discountblocked = $discountblocked;
        return $this;
    }
    /**
     * Get trackingcode value
     * @return string
     */
    public function getTrackingcode()
    {
        return $this->trackingcode;
    }
    /**
     * Set trackingcode value
     * @param string $trackingcode
     * @return \StructType\DISCOUNT
     */
    public function setTrackingcode($trackingcode = null)
    {
        // validation for constraint: string
        if (!is_null($trackingcode) && !is_string($trackingcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingcode, true), gettype($trackingcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($trackingcode) && mb_strlen($trackingcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($trackingcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($trackingcode) && mb_strlen($trackingcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($trackingcode)), __LINE__);
        }
        $this->trackingcode = $trackingcode;
        return $this;
    }
    /**
     * Get calculationmethod value
     * @return string
     */
    public function getCalculationmethod()
    {
        return $this->calculationmethod;
    }
    /**
     * Set calculationmethod value
     * @param string $calculationmethod
     * @return \StructType\DISCOUNT
     */
    public function setCalculationmethod($calculationmethod = null)
    {
        // validation for constraint: string
        if (!is_null($calculationmethod) && !is_string($calculationmethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calculationmethod, true), gettype($calculationmethod)), __LINE__);
        }
        $this->calculationmethod = $calculationmethod;
        return $this;
    }
    /**
     * Get DISCOUNT_OBJID value
     * @return string
     */
    public function getDISCOUNT_OBJID()
    {
        return $this->{'DISCOUNT-OBJID'};
    }
    /**
     * Set DISCOUNT_OBJID value
     * @param string $dISCOUNT_OBJID
     * @return \StructType\DISCOUNT
     */
    public function setDISCOUNT_OBJID($dISCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($dISCOUNT_OBJID) && !is_string($dISCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dISCOUNT_OBJID, true), gettype($dISCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($dISCOUNT_OBJID) && !preg_match('/([0-9])*/', $dISCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($dISCOUNT_OBJID, true)), __LINE__);
        }
        $this->DISCOUNT_OBJID = $this->{'DISCOUNT-OBJID'} = $dISCOUNT_OBJID;
        return $this;
    }
    /**
     * Get GUEST value
     * @return \StructType\GUEST[]|null
     */
    public function getGUEST()
    {
        return $this->GUEST;
    }
    /**
     * This method is responsible for validating the values passed to the setGUEST method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUEST method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTForArrayConstraintsFromSetGUEST(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dISCOUNTGUESTItem) {
            // validation for constraint: itemType
            if (!$dISCOUNTGUESTItem instanceof \StructType\GUEST) {
                $invalidValues[] = is_object($dISCOUNTGUESTItem) ? get_class($dISCOUNTGUESTItem) : sprintf('%s(%s)', gettype($dISCOUNTGUESTItem), var_export($dISCOUNTGUESTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST[] $gUEST
     * @return \StructType\DISCOUNT
     */
    public function setGUEST(array $gUEST = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTArrayErrorMessage = self::validateGUESTForArrayConstraintsFromSetGUEST($gUEST))) {
            throw new \InvalidArgumentException($gUESTArrayErrorMessage, __LINE__);
        }
        $this->GUEST = $gUEST;
        return $this;
    }
    /**
     * Add item to GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST $item
     * @return \StructType\DISCOUNT
     */
    public function addToGUEST(\StructType\GUEST $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUEST) {
            throw new \InvalidArgumentException(sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUEST[] = $item;
        return $this;
    }
}
