<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryUpselling StructType
 * @subpackage Structs
 */
class CategoryUpselling extends AbstractStructBase
{
    /**
     * The upgradecategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $upgradecategory;
    /**
     * The hassuccessor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hassuccessor;
    /**
     * The RoomCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomCategory[]
     */
    public $RoomCategory;
    /**
     * Constructor method for CategoryUpselling
     * @uses CategoryUpselling::setUpgradecategory()
     * @uses CategoryUpselling::setHassuccessor()
     * @uses CategoryUpselling::setRoomCategory()
     * @param string $upgradecategory
     * @param string $hassuccessor
     * @param \StructType\RoomCategory[] $roomCategory
     */
    public function __construct($upgradecategory = null, $hassuccessor = null, array $roomCategory = array())
    {
        $this
            ->setUpgradecategory($upgradecategory)
            ->setHassuccessor($hassuccessor)
            ->setRoomCategory($roomCategory);
    }
    /**
     * Get upgradecategory value
     * @return string
     */
    public function getUpgradecategory()
    {
        return $this->upgradecategory;
    }
    /**
     * Set upgradecategory value
     * @param string $upgradecategory
     * @return \StructType\CategoryUpselling
     */
    public function setUpgradecategory($upgradecategory = null)
    {
        // validation for constraint: string
        if (!is_null($upgradecategory) && !is_string($upgradecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upgradecategory, true), gettype($upgradecategory)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($upgradecategory) && !preg_match('/([-+]){0,1}([0-9])*/', $upgradecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($upgradecategory, true)), __LINE__);
        }
        $this->upgradecategory = $upgradecategory;
        return $this;
    }
    /**
     * Get hassuccessor value
     * @return string
     */
    public function getHassuccessor()
    {
        return $this->hassuccessor;
    }
    /**
     * Set hassuccessor value
     * @param string $hassuccessor
     * @return \StructType\CategoryUpselling
     */
    public function setHassuccessor($hassuccessor = null)
    {
        // validation for constraint: string
        if (!is_null($hassuccessor) && !is_string($hassuccessor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hassuccessor, true), gettype($hassuccessor)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hassuccessor) && !preg_match('/([-+]){0,1}([0-9])*/', $hassuccessor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hassuccessor, true)), __LINE__);
        }
        $this->hassuccessor = $hassuccessor;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return \StructType\RoomCategory[]|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomCategoryForArrayConstraintsFromSetRoomCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryUpsellingRoomCategoryItem) {
            // validation for constraint: itemType
            if (!$categoryUpsellingRoomCategoryItem instanceof \StructType\RoomCategory) {
                $invalidValues[] = is_object($categoryUpsellingRoomCategoryItem) ? get_class($categoryUpsellingRoomCategoryItem) : sprintf('%s(%s)', gettype($categoryUpsellingRoomCategoryItem), var_export($categoryUpsellingRoomCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomCategory property can only contain items of type \StructType\RoomCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomCategory[] $roomCategory
     * @return \StructType\CategoryUpselling
     */
    public function setRoomCategory(array $roomCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($roomCategoryArrayErrorMessage = self::validateRoomCategoryForArrayConstraintsFromSetRoomCategory($roomCategory))) {
            throw new \InvalidArgumentException($roomCategoryArrayErrorMessage, __LINE__);
        }
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Add item to RoomCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomCategory $item
     * @return \StructType\CategoryUpselling
     */
    public function addToRoomCategory(\StructType\RoomCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomCategory) {
            throw new \InvalidArgumentException(sprintf('The RoomCategory property can only contain items of type \StructType\RoomCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomCategory[] = $item;
        return $this;
    }
}
