<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CONTACT-PERSON StructType
 * @subpackage Structs
 */
class CONTACT_PERSON extends AbstractStructBase
{
    /**
     * The CONTACT_PERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $CONTACT_PERSON_OBJID;
    /**
     * The CONTACT_PERSON_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $CONTACT_PERSON_CENTRALID;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $firstName;
    /**
     * The guestType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guestType;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $matchcode;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subsubcountry;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The pobox
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $pobox;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email;
    /**
     * The guestHotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestHotel;
    /**
     * The guestNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestNo;
    /**
     * The identificationNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $identificationNo;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $marketsegment;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone;
    /**
     * The phone2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone2;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $mobile1;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $fax;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $language;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $status;
    /**
     * The isadmin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $isadmin;
    /**
     * The function
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $function;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * Constructor method for CONTACT-PERSON
     * @uses CONTACT_PERSON::setCONTACT_PERSON_OBJID()
     * @uses CONTACT_PERSON::setCONTACT_PERSON_CENTRALID()
     * @uses CONTACT_PERSON::setAddress()
     * @uses CONTACT_PERSON::setLastName()
     * @uses CONTACT_PERSON::setFirstName()
     * @uses CONTACT_PERSON::setGuestType()
     * @uses CONTACT_PERSON::setMatchcode()
     * @uses CONTACT_PERSON::setCountry()
     * @uses CONTACT_PERSON::setSubcountry()
     * @uses CONTACT_PERSON::setSubsubcountry()
     * @uses CONTACT_PERSON::setCity()
     * @uses CONTACT_PERSON::setPobox()
     * @uses CONTACT_PERSON::setPostcode()
     * @uses CONTACT_PERSON::setStreet()
     * @uses CONTACT_PERSON::setEmail()
     * @uses CONTACT_PERSON::setGuestHotel()
     * @uses CONTACT_PERSON::setGuestNo()
     * @uses CONTACT_PERSON::setIdentificationNo()
     * @uses CONTACT_PERSON::setBirthdate()
     * @uses CONTACT_PERSON::setRatesegment()
     * @uses CONTACT_PERSON::setMarketsegment()
     * @uses CONTACT_PERSON::setPhone()
     * @uses CONTACT_PERSON::setPhone2()
     * @uses CONTACT_PERSON::setMobile1()
     * @uses CONTACT_PERSON::setFax()
     * @uses CONTACT_PERSON::setLanguage()
     * @uses CONTACT_PERSON::setStatus()
     * @uses CONTACT_PERSON::setIsadmin()
     * @uses CONTACT_PERSON::setFunction()
     * @uses CONTACT_PERSON::setComment()
     * @param string $cONTACT_PERSON_OBJID
     * @param string $cONTACT_PERSON_CENTRALID
     * @param string $address
     * @param string $lastName
     * @param string $firstName
     * @param string $guestType
     * @param string $matchcode
     * @param string $country
     * @param string $subcountry
     * @param string $subsubcountry
     * @param string $city
     * @param string $pobox
     * @param string $postcode
     * @param string $street
     * @param string $email
     * @param string $guestHotel
     * @param string $guestNo
     * @param string $identificationNo
     * @param string $birthdate
     * @param string $ratesegment
     * @param string $marketsegment
     * @param string $phone
     * @param string $phone2
     * @param string $mobile1
     * @param string $fax
     * @param string $language
     * @param string $status
     * @param string $isadmin
     * @param string $function
     * @param string $comment
     */
    public function __construct($cONTACT_PERSON_OBJID = null, $cONTACT_PERSON_CENTRALID = null, $address = null, $lastName = null, $firstName = null, $guestType = null, $matchcode = null, $country = null, $subcountry = null, $subsubcountry = null, $city = null, $pobox = null, $postcode = null, $street = null, $email = null, $guestHotel = null, $guestNo = null, $identificationNo = null, $birthdate = null, $ratesegment = null, $marketsegment = null, $phone = null, $phone2 = null, $mobile1 = null, $fax = null, $language = null, $status = null, $isadmin = null, $function = null, $comment = null)
    {
        $this
            ->setCONTACT_PERSON_OBJID($cONTACT_PERSON_OBJID)
            ->setCONTACT_PERSON_CENTRALID($cONTACT_PERSON_CENTRALID)
            ->setAddress($address)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setGuestType($guestType)
            ->setMatchcode($matchcode)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setSubsubcountry($subsubcountry)
            ->setCity($city)
            ->setPobox($pobox)
            ->setPostcode($postcode)
            ->setStreet($street)
            ->setEmail($email)
            ->setGuestHotel($guestHotel)
            ->setGuestNo($guestNo)
            ->setIdentificationNo($identificationNo)
            ->setBirthdate($birthdate)
            ->setRatesegment($ratesegment)
            ->setMarketsegment($marketsegment)
            ->setPhone($phone)
            ->setPhone2($phone2)
            ->setMobile1($mobile1)
            ->setFax($fax)
            ->setLanguage($language)
            ->setStatus($status)
            ->setIsadmin($isadmin)
            ->setFunction($function)
            ->setComment($comment);
    }
    /**
     * Get CONTACT_PERSON_OBJID value
     * @return string
     */
    public function getCONTACT_PERSON_OBJID()
    {
        return $this->{'CONTACT-PERSON-OBJID'};
    }
    /**
     * Set CONTACT_PERSON_OBJID value
     * @param string $cONTACT_PERSON_OBJID
     * @return \StructType\CONTACT_PERSON
     */
    public function setCONTACT_PERSON_OBJID($cONTACT_PERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cONTACT_PERSON_OBJID) && !is_string($cONTACT_PERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cONTACT_PERSON_OBJID, true), gettype($cONTACT_PERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cONTACT_PERSON_OBJID) && !preg_match('/([0-9])*/', $cONTACT_PERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cONTACT_PERSON_OBJID, true)), __LINE__);
        }
        $this->CONTACT_PERSON_OBJID = $this->{'CONTACT-PERSON-OBJID'} = $cONTACT_PERSON_OBJID;
        return $this;
    }
    /**
     * Get CONTACT_PERSON_CENTRALID value
     * @return string
     */
    public function getCONTACT_PERSON_CENTRALID()
    {
        return $this->{'CONTACT-PERSON-CENTRALID'};
    }
    /**
     * Set CONTACT_PERSON_CENTRALID value
     * @param string $cONTACT_PERSON_CENTRALID
     * @return \StructType\CONTACT_PERSON
     */
    public function setCONTACT_PERSON_CENTRALID($cONTACT_PERSON_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($cONTACT_PERSON_CENTRALID) && !is_string($cONTACT_PERSON_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cONTACT_PERSON_CENTRALID, true), gettype($cONTACT_PERSON_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cONTACT_PERSON_CENTRALID) && !preg_match('/([0-9])*/', $cONTACT_PERSON_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cONTACT_PERSON_CENTRALID, true)), __LINE__);
        }
        $this->CONTACT_PERSON_CENTRALID = $this->{'CONTACT-PERSON-CENTRALID'} = $cONTACT_PERSON_CENTRALID;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\CONTACT_PERSON
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\CONTACT_PERSON
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\CONTACT_PERSON
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($firstName) && mb_strlen($firstName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($firstName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($firstName) && mb_strlen($firstName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get guestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->guestType;
    }
    /**
     * Set guestType value
     * @param string $guestType
     * @return \StructType\CONTACT_PERSON
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: string
        if (!is_null($guestType) && !is_string($guestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestType, true), gettype($guestType)), __LINE__);
        }
        $this->guestType = $guestType;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\CONTACT_PERSON
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($matchcode) && mb_strlen($matchcode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($matchcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($matchcode) && mb_strlen($matchcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($matchcode)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\CONTACT_PERSON
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\CONTACT_PERSON
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\CONTACT_PERSON
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\CONTACT_PERSON
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get pobox value
     * @return string
     */
    public function getPobox()
    {
        return $this->pobox;
    }
    /**
     * Set pobox value
     * @param string $pobox
     * @return \StructType\CONTACT_PERSON
     */
    public function setPobox($pobox = null)
    {
        // validation for constraint: string
        if (!is_null($pobox) && !is_string($pobox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pobox, true), gettype($pobox)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($pobox) && mb_strlen($pobox) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($pobox)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($pobox) && mb_strlen($pobox) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($pobox)), __LINE__);
        }
        $this->pobox = $pobox;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\CONTACT_PERSON
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\CONTACT_PERSON
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CONTACT_PERSON
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email) && mb_strlen($email) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email) && mb_strlen($email) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get guestHotel value
     * @return string
     */
    public function getGuestHotel()
    {
        return $this->guestHotel;
    }
    /**
     * Set guestHotel value
     * @param string $guestHotel
     * @return \StructType\CONTACT_PERSON
     */
    public function setGuestHotel($guestHotel = null)
    {
        // validation for constraint: string
        if (!is_null($guestHotel) && !is_string($guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestHotel, true), gettype($guestHotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestHotel) && !preg_match('/([-+]){0,1}([0-9])*/', $guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestHotel, true)), __LINE__);
        }
        $this->guestHotel = $guestHotel;
        return $this;
    }
    /**
     * Get guestNo value
     * @return string
     */
    public function getGuestNo()
    {
        return $this->guestNo;
    }
    /**
     * Set guestNo value
     * @param string $guestNo
     * @return \StructType\CONTACT_PERSON
     */
    public function setGuestNo($guestNo = null)
    {
        // validation for constraint: string
        if (!is_null($guestNo) && !is_string($guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestNo, true), gettype($guestNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestNo) && !preg_match('/([-+]){0,1}([0-9])*/', $guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestNo, true)), __LINE__);
        }
        $this->guestNo = $guestNo;
        return $this;
    }
    /**
     * Get identificationNo value
     * @return string
     */
    public function getIdentificationNo()
    {
        return $this->identificationNo;
    }
    /**
     * Set identificationNo value
     * @param string $identificationNo
     * @return \StructType\CONTACT_PERSON
     */
    public function setIdentificationNo($identificationNo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNo) && !is_string($identificationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNo, true), gettype($identificationNo)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($identificationNo) && mb_strlen($identificationNo) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($identificationNo)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($identificationNo) && mb_strlen($identificationNo) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($identificationNo)), __LINE__);
        }
        $this->identificationNo = $identificationNo;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\CONTACT_PERSON
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\CONTACT_PERSON
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\CONTACT_PERSON
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($marketsegment) && mb_strlen($marketsegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($marketsegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($marketsegment) && mb_strlen($marketsegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\CONTACT_PERSON
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone) && mb_strlen($phone) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get phone2 value
     * @return string
     */
    public function getPhone2()
    {
        return $this->phone2;
    }
    /**
     * Set phone2 value
     * @param string $phone2
     * @return \StructType\CONTACT_PERSON
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone2) && mb_strlen($phone2) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone2) && mb_strlen($phone2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone2)), __LINE__);
        }
        $this->phone2 = $phone2;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\CONTACT_PERSON
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
    /**
     * Get fax value
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\CONTACT_PERSON
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fax) && mb_strlen($fax) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($fax)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($fax) && mb_strlen($fax) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\CONTACT_PERSON
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CONTACT_PERSON
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($status) && !preg_match('/([-+]){0,1}([0-9])*/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($status, true)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get isadmin value
     * @return string
     */
    public function getIsadmin()
    {
        return $this->isadmin;
    }
    /**
     * Set isadmin value
     * @param string $isadmin
     * @return \StructType\CONTACT_PERSON
     */
    public function setIsadmin($isadmin = null)
    {
        // validation for constraint: string
        if (!is_null($isadmin) && !is_string($isadmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isadmin, true), gettype($isadmin)), __LINE__);
        }
        $this->isadmin = $isadmin;
        return $this;
    }
    /**
     * Get function value
     * @return string
     */
    public function getFunction()
    {
        return $this->function;
    }
    /**
     * Set function value
     * @param string $function
     * @return \StructType\CONTACT_PERSON
     */
    public function setFunction($function = null)
    {
        // validation for constraint: string
        if (!is_null($function) && !is_string($function)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($function, true), gettype($function)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($function) && mb_strlen($function) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($function)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($function) && mb_strlen($function) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($function)), __LINE__);
        }
        $this->function = $function;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\CONTACT_PERSON
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($comment) && mb_strlen($comment) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($comment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($comment) && mb_strlen($comment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
