<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for COMPANY StructType
 * @subpackage Structs
 */
class COMPANY extends AbstractStructBase
{
    /**
     * The COMPANY_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $COMPANY_OBJID;
    /**
     * Constructor method for COMPANY
     * @uses COMPANY::setCOMPANY_OBJID()
     * @param string $cOMPANY_OBJID
     */
    public function __construct($cOMPANY_OBJID = null)
    {
        $this
            ->setCOMPANY_OBJID($cOMPANY_OBJID);
    }
    /**
     * Get COMPANY_OBJID value
     * @return string
     */
    public function getCOMPANY_OBJID()
    {
        return $this->{'COMPANY-OBJID'};
    }
    /**
     * Set COMPANY_OBJID value
     * @param string $cOMPANY_OBJID
     * @return \StructType\COMPANY
     */
    public function setCOMPANY_OBJID($cOMPANY_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cOMPANY_OBJID) && !is_string($cOMPANY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOMPANY_OBJID, true), gettype($cOMPANY_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cOMPANY_OBJID) && !preg_match('/([0-9])*/', $cOMPANY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cOMPANY_OBJID, true)), __LINE__);
        }
        $this->COMPANY_OBJID = $this->{'COMPANY-OBJID'} = $cOMPANY_OBJID;
        return $this;
    }
}
