<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CITYLEDGER-SEARCH StructType
 * @subpackage Structs
 */
class CITYLEDGER_SEARCH extends AbstractStructBase
{
    /**
     * The invoiceno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $invoiceno;
    /**
     * The invoicenoset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoicenoset;
    /**
     * Constructor method for CITYLEDGER-SEARCH
     * @uses CITYLEDGER_SEARCH::setInvoiceno()
     * @uses CITYLEDGER_SEARCH::setInvoicenoset()
     * @param string $invoiceno
     * @param string $invoicenoset
     */
    public function __construct($invoiceno = null, $invoicenoset = null)
    {
        $this
            ->setInvoiceno($invoiceno)
            ->setInvoicenoset($invoicenoset);
    }
    /**
     * Get invoiceno value
     * @return string
     */
    public function getInvoiceno()
    {
        return $this->invoiceno;
    }
    /**
     * Set invoiceno value
     * @param string $invoiceno
     * @return \StructType\CITYLEDGER_SEARCH
     */
    public function setInvoiceno($invoiceno = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceno) && !is_string($invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceno, true), gettype($invoiceno)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($invoiceno) && !preg_match('/([0-9])*/', $invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($invoiceno, true)), __LINE__);
        }
        $this->invoiceno = $invoiceno;
        return $this;
    }
    /**
     * Get invoicenoset value
     * @return string
     */
    public function getInvoicenoset()
    {
        return $this->invoicenoset;
    }
    /**
     * Set invoicenoset value
     * @param string $invoicenoset
     * @return \StructType\CITYLEDGER_SEARCH
     */
    public function setInvoicenoset($invoicenoset = null)
    {
        // validation for constraint: string
        if (!is_null($invoicenoset) && !is_string($invoicenoset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicenoset, true), gettype($invoicenoset)), __LINE__);
        }
        $this->invoicenoset = $invoicenoset;
        return $this;
    }
}
