<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CITYLEDGER StructType
 * @subpackage Structs
 */
class CITYLEDGER extends AbstractStructBase
{
    /**
     * The CITYLEDGER_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $CITYLEDGER_OBJID;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The amountadjusted
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountadjusted;
    /**
     * The currencyamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyamount;
    /**
     * The outstandingamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $outstandingamount;
    /**
     * The currencyexchangefactor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyexchangefactor;
    /**
     * The invoicetext
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoicetext;
    /**
     * The proformano
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $proformano;
    /**
     * The cardnumberdescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cardnumberdescription;
    /**
     * The reminderlevel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $reminderlevel;
    /**
     * The lastamendedon
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $lastamendedon;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The INVOICE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The RESERVATION
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RESERVATION[]
     */
    public $RESERVATION;
    /**
     * The ACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ACCOUNT[]
     */
    public $ACCOUNT;
    /**
     * Constructor method for CITYLEDGER
     * @uses CITYLEDGER::setCITYLEDGER_OBJID()
     * @uses CITYLEDGER::setDate()
     * @uses CITYLEDGER::setTypeofpayment()
     * @uses CITYLEDGER::setAmount()
     * @uses CITYLEDGER::setAmountadjusted()
     * @uses CITYLEDGER::setCurrencyamount()
     * @uses CITYLEDGER::setOutstandingamount()
     * @uses CITYLEDGER::setCurrencyexchangefactor()
     * @uses CITYLEDGER::setInvoicetext()
     * @uses CITYLEDGER::setProformano()
     * @uses CITYLEDGER::setCardnumberdescription()
     * @uses CITYLEDGER::setReminderlevel()
     * @uses CITYLEDGER::setLastamendedon()
     * @uses CITYLEDGER::setComment()
     * @uses CITYLEDGER::setINVOICE()
     * @uses CITYLEDGER::setRESERVATION()
     * @uses CITYLEDGER::setACCOUNT()
     * @param string $cITYLEDGER_OBJID
     * @param string $date
     * @param string $typeofpayment
     * @param string $amount
     * @param string $amountadjusted
     * @param string $currencyamount
     * @param string $outstandingamount
     * @param string $currencyexchangefactor
     * @param string $invoicetext
     * @param string $proformano
     * @param string $cardnumberdescription
     * @param string $reminderlevel
     * @param string $lastamendedon
     * @param string $comment
     * @param \StructType\INVOICE[] $iNVOICE
     * @param \StructType\RESERVATION[] $rESERVATION
     * @param \StructType\ACCOUNT[] $aCCOUNT
     */
    public function __construct($cITYLEDGER_OBJID = null, $date = null, $typeofpayment = null, $amount = null, $amountadjusted = null, $currencyamount = null, $outstandingamount = null, $currencyexchangefactor = null, $invoicetext = null, $proformano = null, $cardnumberdescription = null, $reminderlevel = null, $lastamendedon = null, $comment = null, array $iNVOICE = array(), array $rESERVATION = array(), array $aCCOUNT = array())
    {
        $this
            ->setCITYLEDGER_OBJID($cITYLEDGER_OBJID)
            ->setDate($date)
            ->setTypeofpayment($typeofpayment)
            ->setAmount($amount)
            ->setAmountadjusted($amountadjusted)
            ->setCurrencyamount($currencyamount)
            ->setOutstandingamount($outstandingamount)
            ->setCurrencyexchangefactor($currencyexchangefactor)
            ->setInvoicetext($invoicetext)
            ->setProformano($proformano)
            ->setCardnumberdescription($cardnumberdescription)
            ->setReminderlevel($reminderlevel)
            ->setLastamendedon($lastamendedon)
            ->setComment($comment)
            ->setINVOICE($iNVOICE)
            ->setRESERVATION($rESERVATION)
            ->setACCOUNT($aCCOUNT);
    }
    /**
     * Get CITYLEDGER_OBJID value
     * @return string
     */
    public function getCITYLEDGER_OBJID()
    {
        return $this->{'CITYLEDGER-OBJID'};
    }
    /**
     * Set CITYLEDGER_OBJID value
     * @param string $cITYLEDGER_OBJID
     * @return \StructType\CITYLEDGER
     */
    public function setCITYLEDGER_OBJID($cITYLEDGER_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cITYLEDGER_OBJID) && !is_string($cITYLEDGER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cITYLEDGER_OBJID, true), gettype($cITYLEDGER_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cITYLEDGER_OBJID) && !preg_match('/([0-9])*/', $cITYLEDGER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cITYLEDGER_OBJID, true)), __LINE__);
        }
        $this->CITYLEDGER_OBJID = $this->{'CITYLEDGER-OBJID'} = $cITYLEDGER_OBJID;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\CITYLEDGER
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\CITYLEDGER
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\CITYLEDGER
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get amountadjusted value
     * @return string
     */
    public function getAmountadjusted()
    {
        return $this->amountadjusted;
    }
    /**
     * Set amountadjusted value
     * @param string $amountadjusted
     * @return \StructType\CITYLEDGER
     */
    public function setAmountadjusted($amountadjusted = null)
    {
        // validation for constraint: string
        if (!is_null($amountadjusted) && !is_string($amountadjusted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountadjusted, true), gettype($amountadjusted)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountadjusted) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountadjusted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountadjusted, true)), __LINE__);
        }
        $this->amountadjusted = $amountadjusted;
        return $this;
    }
    /**
     * Get currencyamount value
     * @return string
     */
    public function getCurrencyamount()
    {
        return $this->currencyamount;
    }
    /**
     * Set currencyamount value
     * @param string $currencyamount
     * @return \StructType\CITYLEDGER
     */
    public function setCurrencyamount($currencyamount = null)
    {
        // validation for constraint: string
        if (!is_null($currencyamount) && !is_string($currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyamount, true), gettype($currencyamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyamount, true)), __LINE__);
        }
        $this->currencyamount = $currencyamount;
        return $this;
    }
    /**
     * Get outstandingamount value
     * @return string
     */
    public function getOutstandingamount()
    {
        return $this->outstandingamount;
    }
    /**
     * Set outstandingamount value
     * @param string $outstandingamount
     * @return \StructType\CITYLEDGER
     */
    public function setOutstandingamount($outstandingamount = null)
    {
        // validation for constraint: string
        if (!is_null($outstandingamount) && !is_string($outstandingamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outstandingamount, true), gettype($outstandingamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($outstandingamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $outstandingamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($outstandingamount, true)), __LINE__);
        }
        $this->outstandingamount = $outstandingamount;
        return $this;
    }
    /**
     * Get currencyexchangefactor value
     * @return string
     */
    public function getCurrencyexchangefactor()
    {
        return $this->currencyexchangefactor;
    }
    /**
     * Set currencyexchangefactor value
     * @param string $currencyexchangefactor
     * @return \StructType\CITYLEDGER
     */
    public function setCurrencyexchangefactor($currencyexchangefactor = null)
    {
        // validation for constraint: string
        if (!is_null($currencyexchangefactor) && !is_string($currencyexchangefactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyexchangefactor, true), gettype($currencyexchangefactor)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyexchangefactor) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyexchangefactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyexchangefactor, true)), __LINE__);
        }
        $this->currencyexchangefactor = $currencyexchangefactor;
        return $this;
    }
    /**
     * Get invoicetext value
     * @return string
     */
    public function getInvoicetext()
    {
        return $this->invoicetext;
    }
    /**
     * Set invoicetext value
     * @param string $invoicetext
     * @return \StructType\CITYLEDGER
     */
    public function setInvoicetext($invoicetext = null)
    {
        // validation for constraint: string
        if (!is_null($invoicetext) && !is_string($invoicetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicetext, true), gettype($invoicetext)), __LINE__);
        }
        $this->invoicetext = $invoicetext;
        return $this;
    }
    /**
     * Get proformano value
     * @return string
     */
    public function getProformano()
    {
        return $this->proformano;
    }
    /**
     * Set proformano value
     * @param string $proformano
     * @return \StructType\CITYLEDGER
     */
    public function setProformano($proformano = null)
    {
        // validation for constraint: string
        if (!is_null($proformano) && !is_string($proformano)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proformano, true), gettype($proformano)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($proformano) && !preg_match('/([-+]){0,1}([0-9])*/', $proformano)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($proformano, true)), __LINE__);
        }
        $this->proformano = $proformano;
        return $this;
    }
    /**
     * Get cardnumberdescription value
     * @return string
     */
    public function getCardnumberdescription()
    {
        return $this->cardnumberdescription;
    }
    /**
     * Set cardnumberdescription value
     * @param string $cardnumberdescription
     * @return \StructType\CITYLEDGER
     */
    public function setCardnumberdescription($cardnumberdescription = null)
    {
        // validation for constraint: string
        if (!is_null($cardnumberdescription) && !is_string($cardnumberdescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardnumberdescription, true), gettype($cardnumberdescription)), __LINE__);
        }
        $this->cardnumberdescription = $cardnumberdescription;
        return $this;
    }
    /**
     * Get reminderlevel value
     * @return string
     */
    public function getReminderlevel()
    {
        return $this->reminderlevel;
    }
    /**
     * Set reminderlevel value
     * @param string $reminderlevel
     * @return \StructType\CITYLEDGER
     */
    public function setReminderlevel($reminderlevel = null)
    {
        // validation for constraint: string
        if (!is_null($reminderlevel) && !is_string($reminderlevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reminderlevel, true), gettype($reminderlevel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($reminderlevel) && !preg_match('/([-+]){0,1}([0-9])*/', $reminderlevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($reminderlevel, true)), __LINE__);
        }
        $this->reminderlevel = $reminderlevel;
        return $this;
    }
    /**
     * Get lastamendedon value
     * @return string
     */
    public function getLastamendedon()
    {
        return $this->lastamendedon;
    }
    /**
     * Set lastamendedon value
     * @param string $lastamendedon
     * @return \StructType\CITYLEDGER
     */
    public function setLastamendedon($lastamendedon = null)
    {
        // validation for constraint: string
        if (!is_null($lastamendedon) && !is_string($lastamendedon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastamendedon, true), gettype($lastamendedon)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($lastamendedon) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $lastamendedon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($lastamendedon, true)), __LINE__);
        }
        $this->lastamendedon = $lastamendedon;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\CITYLEDGER
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * This method is responsible for validating the values passed to the setINVOICE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINVOICE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINVOICEForArrayConstraintsFromSetINVOICE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cITYLEDGERINVOICEItem) {
            // validation for constraint: itemType
            if (!$cITYLEDGERINVOICEItem instanceof \StructType\INVOICE) {
                $invalidValues[] = is_object($cITYLEDGERINVOICEItem) ? get_class($cITYLEDGERINVOICEItem) : sprintf('%s(%s)', gettype($cITYLEDGERINVOICEItem), var_export($cITYLEDGERINVOICEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\CITYLEDGER
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        // validation for constraint: array
        if ('' !== ($iNVOICEArrayErrorMessage = self::validateINVOICEForArrayConstraintsFromSetINVOICE($iNVOICE))) {
            throw new \InvalidArgumentException($iNVOICEArrayErrorMessage, __LINE__);
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\CITYLEDGER
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get RESERVATION value
     * @return \StructType\RESERVATION[]|null
     */
    public function getRESERVATION()
    {
        return $this->RESERVATION;
    }
    /**
     * This method is responsible for validating the values passed to the setRESERVATION method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRESERVATION method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRESERVATIONForArrayConstraintsFromSetRESERVATION(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cITYLEDGERRESERVATIONItem) {
            // validation for constraint: itemType
            if (!$cITYLEDGERRESERVATIONItem instanceof \StructType\RESERVATION) {
                $invalidValues[] = is_object($cITYLEDGERRESERVATIONItem) ? get_class($cITYLEDGERRESERVATIONItem) : sprintf('%s(%s)', gettype($cITYLEDGERRESERVATIONItem), var_export($cITYLEDGERRESERVATIONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RESERVATION property can only contain items of type \StructType\RESERVATION, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RESERVATION value
     * @throws \InvalidArgumentException
     * @param \StructType\RESERVATION[] $rESERVATION
     * @return \StructType\CITYLEDGER
     */
    public function setRESERVATION(array $rESERVATION = array())
    {
        // validation for constraint: array
        if ('' !== ($rESERVATIONArrayErrorMessage = self::validateRESERVATIONForArrayConstraintsFromSetRESERVATION($rESERVATION))) {
            throw new \InvalidArgumentException($rESERVATIONArrayErrorMessage, __LINE__);
        }
        $this->RESERVATION = $rESERVATION;
        return $this;
    }
    /**
     * Add item to RESERVATION value
     * @throws \InvalidArgumentException
     * @param \StructType\RESERVATION $item
     * @return \StructType\CITYLEDGER
     */
    public function addToRESERVATION(\StructType\RESERVATION $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RESERVATION) {
            throw new \InvalidArgumentException(sprintf('The RESERVATION property can only contain items of type \StructType\RESERVATION, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RESERVATION[] = $item;
        return $this;
    }
    /**
     * Get ACCOUNT value
     * @return \StructType\ACCOUNT[]|null
     */
    public function getACCOUNT()
    {
        return $this->ACCOUNT;
    }
    /**
     * This method is responsible for validating the values passed to the setACCOUNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setACCOUNT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateACCOUNTForArrayConstraintsFromSetACCOUNT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cITYLEDGERACCOUNTItem) {
            // validation for constraint: itemType
            if (!$cITYLEDGERACCOUNTItem instanceof \StructType\ACCOUNT) {
                $invalidValues[] = is_object($cITYLEDGERACCOUNTItem) ? get_class($cITYLEDGERACCOUNTItem) : sprintf('%s(%s)', gettype($cITYLEDGERACCOUNTItem), var_export($cITYLEDGERACCOUNTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ACCOUNT property can only contain items of type \StructType\ACCOUNT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\ACCOUNT[] $aCCOUNT
     * @return \StructType\CITYLEDGER
     */
    public function setACCOUNT(array $aCCOUNT = array())
    {
        // validation for constraint: array
        if ('' !== ($aCCOUNTArrayErrorMessage = self::validateACCOUNTForArrayConstraintsFromSetACCOUNT($aCCOUNT))) {
            throw new \InvalidArgumentException($aCCOUNTArrayErrorMessage, __LINE__);
        }
        $this->ACCOUNT = $aCCOUNT;
        return $this;
    }
    /**
     * Add item to ACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\ACCOUNT $item
     * @return \StructType\CITYLEDGER
     */
    public function addToACCOUNT(\StructType\ACCOUNT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ACCOUNT) {
            throw new \InvalidArgumentException(sprintf('The ACCOUNT property can only contain items of type \StructType\ACCOUNT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ACCOUNT[] = $item;
        return $this;
    }
}
