<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CATEGORY StructType
 * @subpackage Structs
 */
class CATEGORY extends AbstractStructBase
{
    /**
     * The LANGUAGE_COMMENTS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LANGUAGE_COMMENTS
     */
    public $LANGUAGE_COMMENTS;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The headcategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $headcategory;
    /**
     * The roomtype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $roomtype;
    /**
     * The containsbeds
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $containsbeds;
    /**
     * The classification
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $classification;
    /**
     * The grouping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $grouping;
    /**
     * The ratetable
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $ratetable;
    /**
     * The salescategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $salescategory;
    /**
     * The salescategorymaxavailability
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $salescategorymaxavailability;
    /**
     * The salescatalgorithm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $salescatalgorithm;
    /**
     * The permanentrental
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $permanentrental;
    /**
     * The minnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $minnoofpax;
    /**
     * The maxnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $maxnoofpax;
    /**
     * The maxnoofadults
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $maxnoofadults;
    /**
     * The stdpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $stdpax;
    /**
     * The extrabeds
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $extrabeds;
    /**
     * The hskcleaningpoints
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hskcleaningpoints;
    /**
     * The hskarrivalcleaningpoints
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hskarrivalcleaningpoints;
    /**
     * The hskdeparturecleaningpoints
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hskdeparturecleaningpoints;
    /**
     * The INTERNET_AVAILABILITY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\INTERNET_AVAILABILITY
     */
    public $INTERNET_AVAILABILITY;
    /**
     * The INTERNET
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\INTERNET[]
     */
    public $INTERNET;
    /**
     * The OVERBOOKING_DATA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OVERBOOKING_DATA
     */
    public $OVERBOOKING_DATA;
    /**
     * The OVERBOOKING
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OVERBOOKING[]
     */
    public $OVERBOOKING;
    /**
     * The CATEGORY_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $CATEGORY_OBJID;
    /**
     * Constructor method for CATEGORY
     * @uses CATEGORY::setLANGUAGE_COMMENTS()
     * @uses CATEGORY::setCategory()
     * @uses CATEGORY::setDescription()
     * @uses CATEGORY::setHeadcategory()
     * @uses CATEGORY::setRoomtype()
     * @uses CATEGORY::setContainsbeds()
     * @uses CATEGORY::setClassification()
     * @uses CATEGORY::setGrouping()
     * @uses CATEGORY::setRatetable()
     * @uses CATEGORY::setSalescategory()
     * @uses CATEGORY::setSalescategorymaxavailability()
     * @uses CATEGORY::setSalescatalgorithm()
     * @uses CATEGORY::setPermanentrental()
     * @uses CATEGORY::setMinnoofpax()
     * @uses CATEGORY::setMaxnoofpax()
     * @uses CATEGORY::setMaxnoofadults()
     * @uses CATEGORY::setStdpax()
     * @uses CATEGORY::setExtrabeds()
     * @uses CATEGORY::setHskcleaningpoints()
     * @uses CATEGORY::setHskarrivalcleaningpoints()
     * @uses CATEGORY::setHskdeparturecleaningpoints()
     * @uses CATEGORY::setINTERNET_AVAILABILITY()
     * @uses CATEGORY::setINTERNET()
     * @uses CATEGORY::setOVERBOOKING_DATA()
     * @uses CATEGORY::setOVERBOOKING()
     * @uses CATEGORY::setCATEGORY_OBJID()
     * @param \StructType\LANGUAGE_COMMENTS $lANGUAGE_COMMENTS
     * @param string $category
     * @param string $description
     * @param string $headcategory
     * @param string $roomtype
     * @param string $containsbeds
     * @param string $classification
     * @param string $grouping
     * @param string $ratetable
     * @param string $salescategory
     * @param string $salescategorymaxavailability
     * @param string $salescatalgorithm
     * @param string $permanentrental
     * @param string $minnoofpax
     * @param string $maxnoofpax
     * @param string $maxnoofadults
     * @param string $stdpax
     * @param string $extrabeds
     * @param string $hskcleaningpoints
     * @param string $hskarrivalcleaningpoints
     * @param string $hskdeparturecleaningpoints
     * @param \StructType\INTERNET_AVAILABILITY $iNTERNET_AVAILABILITY
     * @param \StructType\INTERNET[] $iNTERNET
     * @param \StructType\OVERBOOKING_DATA $oVERBOOKING_DATA
     * @param \StructType\OVERBOOKING[] $oVERBOOKING
     * @param string $cATEGORY_OBJID
     */
    public function __construct(\StructType\LANGUAGE_COMMENTS $lANGUAGE_COMMENTS = null, $category = null, $description = null, $headcategory = null, $roomtype = null, $containsbeds = null, $classification = null, $grouping = null, $ratetable = null, $salescategory = null, $salescategorymaxavailability = null, $salescatalgorithm = null, $permanentrental = null, $minnoofpax = null, $maxnoofpax = null, $maxnoofadults = null, $stdpax = null, $extrabeds = null, $hskcleaningpoints = null, $hskarrivalcleaningpoints = null, $hskdeparturecleaningpoints = null, \StructType\INTERNET_AVAILABILITY $iNTERNET_AVAILABILITY = null, array $iNTERNET = array(), \StructType\OVERBOOKING_DATA $oVERBOOKING_DATA = null, array $oVERBOOKING = array(), $cATEGORY_OBJID = null)
    {
        $this
            ->setLANGUAGE_COMMENTS($lANGUAGE_COMMENTS)
            ->setCategory($category)
            ->setDescription($description)
            ->setHeadcategory($headcategory)
            ->setRoomtype($roomtype)
            ->setContainsbeds($containsbeds)
            ->setClassification($classification)
            ->setGrouping($grouping)
            ->setRatetable($ratetable)
            ->setSalescategory($salescategory)
            ->setSalescategorymaxavailability($salescategorymaxavailability)
            ->setSalescatalgorithm($salescatalgorithm)
            ->setPermanentrental($permanentrental)
            ->setMinnoofpax($minnoofpax)
            ->setMaxnoofpax($maxnoofpax)
            ->setMaxnoofadults($maxnoofadults)
            ->setStdpax($stdpax)
            ->setExtrabeds($extrabeds)
            ->setHskcleaningpoints($hskcleaningpoints)
            ->setHskarrivalcleaningpoints($hskarrivalcleaningpoints)
            ->setHskdeparturecleaningpoints($hskdeparturecleaningpoints)
            ->setINTERNET_AVAILABILITY($iNTERNET_AVAILABILITY)
            ->setINTERNET($iNTERNET)
            ->setOVERBOOKING_DATA($oVERBOOKING_DATA)
            ->setOVERBOOKING($oVERBOOKING)
            ->setCATEGORY_OBJID($cATEGORY_OBJID);
    }
    /**
     * Get LANGUAGE_COMMENTS value
     * @return \StructType\LANGUAGE_COMMENTS
     */
    public function getLANGUAGE_COMMENTS()
    {
        return $this->{'LANGUAGE-COMMENTS'};
    }
    /**
     * Set LANGUAGE_COMMENTS value
     * @param \StructType\LANGUAGE_COMMENTS $lANGUAGE_COMMENTS
     * @return \StructType\CATEGORY
     */
    public function setLANGUAGE_COMMENTS(\StructType\LANGUAGE_COMMENTS $lANGUAGE_COMMENTS = null)
    {
        $this->LANGUAGE_COMMENTS = $this->{'LANGUAGE-COMMENTS'} = $lANGUAGE_COMMENTS;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\CATEGORY
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CATEGORY
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get headcategory value
     * @return string
     */
    public function getHeadcategory()
    {
        return $this->headcategory;
    }
    /**
     * Set headcategory value
     * @param string $headcategory
     * @return \StructType\CATEGORY
     */
    public function setHeadcategory($headcategory = null)
    {
        // validation for constraint: string
        if (!is_null($headcategory) && !is_string($headcategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($headcategory, true), gettype($headcategory)), __LINE__);
        }
        $this->headcategory = $headcategory;
        return $this;
    }
    /**
     * Get roomtype value
     * @return string
     */
    public function getRoomtype()
    {
        return $this->roomtype;
    }
    /**
     * Set roomtype value
     * @param string $roomtype
     * @return \StructType\CATEGORY
     */
    public function setRoomtype($roomtype = null)
    {
        // validation for constraint: string
        if (!is_null($roomtype) && !is_string($roomtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomtype, true), gettype($roomtype)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($roomtype) && !preg_match('/([-+]){0,1}([0-9])*/', $roomtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($roomtype, true)), __LINE__);
        }
        $this->roomtype = $roomtype;
        return $this;
    }
    /**
     * Get containsbeds value
     * @return string
     */
    public function getContainsbeds()
    {
        return $this->containsbeds;
    }
    /**
     * Set containsbeds value
     * @param string $containsbeds
     * @return \StructType\CATEGORY
     */
    public function setContainsbeds($containsbeds = null)
    {
        // validation for constraint: string
        if (!is_null($containsbeds) && !is_string($containsbeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containsbeds, true), gettype($containsbeds)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($containsbeds) && !preg_match('/([-+]){0,1}([0-9])*/', $containsbeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($containsbeds, true)), __LINE__);
        }
        $this->containsbeds = $containsbeds;
        return $this;
    }
    /**
     * Get classification value
     * @return string
     */
    public function getClassification()
    {
        return $this->classification;
    }
    /**
     * Set classification value
     * @param string $classification
     * @return \StructType\CATEGORY
     */
    public function setClassification($classification = null)
    {
        // validation for constraint: string
        if (!is_null($classification) && !is_string($classification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classification, true), gettype($classification)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($classification) && mb_strlen($classification) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($classification)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($classification) && mb_strlen($classification) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($classification)), __LINE__);
        }
        $this->classification = $classification;
        return $this;
    }
    /**
     * Get grouping value
     * @return string
     */
    public function getGrouping()
    {
        return $this->grouping;
    }
    /**
     * Set grouping value
     * @param string $grouping
     * @return \StructType\CATEGORY
     */
    public function setGrouping($grouping = null)
    {
        // validation for constraint: string
        if (!is_null($grouping) && !is_string($grouping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grouping, true), gettype($grouping)), __LINE__);
        }
        $this->grouping = $grouping;
        return $this;
    }
    /**
     * Get ratetable value
     * @return string
     */
    public function getRatetable()
    {
        return $this->ratetable;
    }
    /**
     * Set ratetable value
     * @param string $ratetable
     * @return \StructType\CATEGORY
     */
    public function setRatetable($ratetable = null)
    {
        // validation for constraint: string
        if (!is_null($ratetable) && !is_string($ratetable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratetable, true), gettype($ratetable)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($ratetable) && !preg_match('/([-+]){0,1}([0-9])*/', $ratetable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($ratetable, true)), __LINE__);
        }
        $this->ratetable = $ratetable;
        return $this;
    }
    /**
     * Get salescategory value
     * @return string
     */
    public function getSalescategory()
    {
        return $this->salescategory;
    }
    /**
     * Set salescategory value
     * @param string $salescategory
     * @return \StructType\CATEGORY
     */
    public function setSalescategory($salescategory = null)
    {
        // validation for constraint: string
        if (!is_null($salescategory) && !is_string($salescategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salescategory, true), gettype($salescategory)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($salescategory) && !preg_match('/([-+]){0,1}([0-9])*/', $salescategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($salescategory, true)), __LINE__);
        }
        $this->salescategory = $salescategory;
        return $this;
    }
    /**
     * Get salescategorymaxavailability value
     * @return string
     */
    public function getSalescategorymaxavailability()
    {
        return $this->salescategorymaxavailability;
    }
    /**
     * Set salescategorymaxavailability value
     * @param string $salescategorymaxavailability
     * @return \StructType\CATEGORY
     */
    public function setSalescategorymaxavailability($salescategorymaxavailability = null)
    {
        // validation for constraint: string
        if (!is_null($salescategorymaxavailability) && !is_string($salescategorymaxavailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salescategorymaxavailability, true), gettype($salescategorymaxavailability)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($salescategorymaxavailability) && !preg_match('/([-+]){0,1}([0-9])*/', $salescategorymaxavailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($salescategorymaxavailability, true)), __LINE__);
        }
        $this->salescategorymaxavailability = $salescategorymaxavailability;
        return $this;
    }
    /**
     * Get salescatalgorithm value
     * @return string
     */
    public function getSalescatalgorithm()
    {
        return $this->salescatalgorithm;
    }
    /**
     * Set salescatalgorithm value
     * @param string $salescatalgorithm
     * @return \StructType\CATEGORY
     */
    public function setSalescatalgorithm($salescatalgorithm = null)
    {
        // validation for constraint: string
        if (!is_null($salescatalgorithm) && !is_string($salescatalgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salescatalgorithm, true), gettype($salescatalgorithm)), __LINE__);
        }
        $this->salescatalgorithm = $salescatalgorithm;
        return $this;
    }
    /**
     * Get permanentrental value
     * @return string
     */
    public function getPermanentrental()
    {
        return $this->permanentrental;
    }
    /**
     * Set permanentrental value
     * @param string $permanentrental
     * @return \StructType\CATEGORY
     */
    public function setPermanentrental($permanentrental = null)
    {
        // validation for constraint: string
        if (!is_null($permanentrental) && !is_string($permanentrental)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($permanentrental, true), gettype($permanentrental)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($permanentrental) && !preg_match('/([-+]){0,1}([0-9])*/', $permanentrental)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($permanentrental, true)), __LINE__);
        }
        $this->permanentrental = $permanentrental;
        return $this;
    }
    /**
     * Get minnoofpax value
     * @return string
     */
    public function getMinnoofpax()
    {
        return $this->minnoofpax;
    }
    /**
     * Set minnoofpax value
     * @param string $minnoofpax
     * @return \StructType\CATEGORY
     */
    public function setMinnoofpax($minnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($minnoofpax) && !is_string($minnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minnoofpax, true), gettype($minnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($minnoofpax) && !preg_match('/([0-9])*/', $minnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($minnoofpax, true)), __LINE__);
        }
        $this->minnoofpax = $minnoofpax;
        return $this;
    }
    /**
     * Get maxnoofpax value
     * @return string
     */
    public function getMaxnoofpax()
    {
        return $this->maxnoofpax;
    }
    /**
     * Set maxnoofpax value
     * @param string $maxnoofpax
     * @return \StructType\CATEGORY
     */
    public function setMaxnoofpax($maxnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($maxnoofpax) && !is_string($maxnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxnoofpax, true), gettype($maxnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($maxnoofpax) && !preg_match('/([0-9])*/', $maxnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($maxnoofpax, true)), __LINE__);
        }
        $this->maxnoofpax = $maxnoofpax;
        return $this;
    }
    /**
     * Get maxnoofadults value
     * @return string
     */
    public function getMaxnoofadults()
    {
        return $this->maxnoofadults;
    }
    /**
     * Set maxnoofadults value
     * @param string $maxnoofadults
     * @return \StructType\CATEGORY
     */
    public function setMaxnoofadults($maxnoofadults = null)
    {
        // validation for constraint: string
        if (!is_null($maxnoofadults) && !is_string($maxnoofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxnoofadults, true), gettype($maxnoofadults)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($maxnoofadults) && !preg_match('/([0-9])*/', $maxnoofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($maxnoofadults, true)), __LINE__);
        }
        $this->maxnoofadults = $maxnoofadults;
        return $this;
    }
    /**
     * Get stdpax value
     * @return string
     */
    public function getStdpax()
    {
        return $this->stdpax;
    }
    /**
     * Set stdpax value
     * @param string $stdpax
     * @return \StructType\CATEGORY
     */
    public function setStdpax($stdpax = null)
    {
        // validation for constraint: string
        if (!is_null($stdpax) && !is_string($stdpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stdpax, true), gettype($stdpax)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($stdpax) && !preg_match('/([0-9])*/', $stdpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($stdpax, true)), __LINE__);
        }
        $this->stdpax = $stdpax;
        return $this;
    }
    /**
     * Get extrabeds value
     * @return string
     */
    public function getExtrabeds()
    {
        return $this->extrabeds;
    }
    /**
     * Set extrabeds value
     * @param string $extrabeds
     * @return \StructType\CATEGORY
     */
    public function setExtrabeds($extrabeds = null)
    {
        // validation for constraint: string
        if (!is_null($extrabeds) && !is_string($extrabeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extrabeds, true), gettype($extrabeds)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($extrabeds) && !preg_match('/([0-9])*/', $extrabeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($extrabeds, true)), __LINE__);
        }
        $this->extrabeds = $extrabeds;
        return $this;
    }
    /**
     * Get hskcleaningpoints value
     * @return string
     */
    public function getHskcleaningpoints()
    {
        return $this->hskcleaningpoints;
    }
    /**
     * Set hskcleaningpoints value
     * @param string $hskcleaningpoints
     * @return \StructType\CATEGORY
     */
    public function setHskcleaningpoints($hskcleaningpoints = null)
    {
        // validation for constraint: string
        if (!is_null($hskcleaningpoints) && !is_string($hskcleaningpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hskcleaningpoints, true), gettype($hskcleaningpoints)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hskcleaningpoints) && !preg_match('/([-+]){0,1}([0-9])*/', $hskcleaningpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hskcleaningpoints, true)), __LINE__);
        }
        $this->hskcleaningpoints = $hskcleaningpoints;
        return $this;
    }
    /**
     * Get hskarrivalcleaningpoints value
     * @return string
     */
    public function getHskarrivalcleaningpoints()
    {
        return $this->hskarrivalcleaningpoints;
    }
    /**
     * Set hskarrivalcleaningpoints value
     * @param string $hskarrivalcleaningpoints
     * @return \StructType\CATEGORY
     */
    public function setHskarrivalcleaningpoints($hskarrivalcleaningpoints = null)
    {
        // validation for constraint: string
        if (!is_null($hskarrivalcleaningpoints) && !is_string($hskarrivalcleaningpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hskarrivalcleaningpoints, true), gettype($hskarrivalcleaningpoints)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hskarrivalcleaningpoints) && !preg_match('/([-+]){0,1}([0-9])*/', $hskarrivalcleaningpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hskarrivalcleaningpoints, true)), __LINE__);
        }
        $this->hskarrivalcleaningpoints = $hskarrivalcleaningpoints;
        return $this;
    }
    /**
     * Get hskdeparturecleaningpoints value
     * @return string
     */
    public function getHskdeparturecleaningpoints()
    {
        return $this->hskdeparturecleaningpoints;
    }
    /**
     * Set hskdeparturecleaningpoints value
     * @param string $hskdeparturecleaningpoints
     * @return \StructType\CATEGORY
     */
    public function setHskdeparturecleaningpoints($hskdeparturecleaningpoints = null)
    {
        // validation for constraint: string
        if (!is_null($hskdeparturecleaningpoints) && !is_string($hskdeparturecleaningpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hskdeparturecleaningpoints, true), gettype($hskdeparturecleaningpoints)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hskdeparturecleaningpoints) && !preg_match('/([-+]){0,1}([0-9])*/', $hskdeparturecleaningpoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hskdeparturecleaningpoints, true)), __LINE__);
        }
        $this->hskdeparturecleaningpoints = $hskdeparturecleaningpoints;
        return $this;
    }
    /**
     * Get INTERNET_AVAILABILITY value
     * @return \StructType\INTERNET_AVAILABILITY
     */
    public function getINTERNET_AVAILABILITY()
    {
        return $this->{'INTERNET-AVAILABILITY'};
    }
    /**
     * Set INTERNET_AVAILABILITY value
     * @param \StructType\INTERNET_AVAILABILITY $iNTERNET_AVAILABILITY
     * @return \StructType\CATEGORY
     */
    public function setINTERNET_AVAILABILITY(\StructType\INTERNET_AVAILABILITY $iNTERNET_AVAILABILITY = null)
    {
        $this->INTERNET_AVAILABILITY = $this->{'INTERNET-AVAILABILITY'} = $iNTERNET_AVAILABILITY;
        return $this;
    }
    /**
     * Get INTERNET value
     * @return \StructType\INTERNET[]
     */
    public function getINTERNET()
    {
        return $this->INTERNET;
    }
    /**
     * This method is responsible for validating the values passed to the setINTERNET method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINTERNET method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINTERNETForArrayConstraintsFromSetINTERNET(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cATEGORYINTERNETItem) {
            // validation for constraint: itemType
            if (!$cATEGORYINTERNETItem instanceof \StructType\INTERNET) {
                $invalidValues[] = is_object($cATEGORYINTERNETItem) ? get_class($cATEGORYINTERNETItem) : sprintf('%s(%s)', gettype($cATEGORYINTERNETItem), var_export($cATEGORYINTERNETItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INTERNET property can only contain items of type \StructType\INTERNET, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INTERNET value
     * @throws \InvalidArgumentException
     * @param \StructType\INTERNET[] $iNTERNET
     * @return \StructType\CATEGORY
     */
    public function setINTERNET(array $iNTERNET = array())
    {
        // validation for constraint: array
        if ('' !== ($iNTERNETArrayErrorMessage = self::validateINTERNETForArrayConstraintsFromSetINTERNET($iNTERNET))) {
            throw new \InvalidArgumentException($iNTERNETArrayErrorMessage, __LINE__);
        }
        $this->INTERNET = $iNTERNET;
        return $this;
    }
    /**
     * Add item to INTERNET value
     * @throws \InvalidArgumentException
     * @param \StructType\INTERNET $item
     * @return \StructType\CATEGORY
     */
    public function addToINTERNET(\StructType\INTERNET $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INTERNET) {
            throw new \InvalidArgumentException(sprintf('The INTERNET property can only contain items of type \StructType\INTERNET, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INTERNET[] = $item;
        return $this;
    }
    /**
     * Get OVERBOOKING_DATA value
     * @return \StructType\OVERBOOKING_DATA
     */
    public function getOVERBOOKING_DATA()
    {
        return $this->{'OVERBOOKING-DATA'};
    }
    /**
     * Set OVERBOOKING_DATA value
     * @param \StructType\OVERBOOKING_DATA $oVERBOOKING_DATA
     * @return \StructType\CATEGORY
     */
    public function setOVERBOOKING_DATA(\StructType\OVERBOOKING_DATA $oVERBOOKING_DATA = null)
    {
        $this->OVERBOOKING_DATA = $this->{'OVERBOOKING-DATA'} = $oVERBOOKING_DATA;
        return $this;
    }
    /**
     * Get OVERBOOKING value
     * @return \StructType\OVERBOOKING[]
     */
    public function getOVERBOOKING()
    {
        return $this->OVERBOOKING;
    }
    /**
     * This method is responsible for validating the values passed to the setOVERBOOKING method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOVERBOOKING method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOVERBOOKINGForArrayConstraintsFromSetOVERBOOKING(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cATEGORYOVERBOOKINGItem) {
            // validation for constraint: itemType
            if (!$cATEGORYOVERBOOKINGItem instanceof \StructType\OVERBOOKING) {
                $invalidValues[] = is_object($cATEGORYOVERBOOKINGItem) ? get_class($cATEGORYOVERBOOKINGItem) : sprintf('%s(%s)', gettype($cATEGORYOVERBOOKINGItem), var_export($cATEGORYOVERBOOKINGItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OVERBOOKING property can only contain items of type \StructType\OVERBOOKING, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OVERBOOKING value
     * @throws \InvalidArgumentException
     * @param \StructType\OVERBOOKING[] $oVERBOOKING
     * @return \StructType\CATEGORY
     */
    public function setOVERBOOKING(array $oVERBOOKING = array())
    {
        // validation for constraint: array
        if ('' !== ($oVERBOOKINGArrayErrorMessage = self::validateOVERBOOKINGForArrayConstraintsFromSetOVERBOOKING($oVERBOOKING))) {
            throw new \InvalidArgumentException($oVERBOOKINGArrayErrorMessage, __LINE__);
        }
        $this->OVERBOOKING = $oVERBOOKING;
        return $this;
    }
    /**
     * Add item to OVERBOOKING value
     * @throws \InvalidArgumentException
     * @param \StructType\OVERBOOKING $item
     * @return \StructType\CATEGORY
     */
    public function addToOVERBOOKING(\StructType\OVERBOOKING $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OVERBOOKING) {
            throw new \InvalidArgumentException(sprintf('The OVERBOOKING property can only contain items of type \StructType\OVERBOOKING, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OVERBOOKING[] = $item;
        return $this;
    }
    /**
     * Get CATEGORY_OBJID value
     * @return string|null
     */
    public function getCATEGORY_OBJID()
    {
        return $this->{'CATEGORY-OBJID'};
    }
    /**
     * Set CATEGORY_OBJID value
     * @param string $cATEGORY_OBJID
     * @return \StructType\CATEGORY
     */
    public function setCATEGORY_OBJID($cATEGORY_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cATEGORY_OBJID) && !is_string($cATEGORY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cATEGORY_OBJID, true), gettype($cATEGORY_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cATEGORY_OBJID) && !preg_match('/([0-9])*/', $cATEGORY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cATEGORY_OBJID, true)), __LINE__);
        }
        $this->CATEGORY_OBJID = $this->{'CATEGORY-OBJID'} = $cATEGORY_OBJID;
        return $this;
    }
}
