<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CARD StructType
 * @subpackage Structs
 */
class CARD extends AbstractStructBase
{
    /**
     * The token
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $token;
    /**
     * The tokenValidUntil
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $tokenValidUntil;
    /**
     * The TYPE
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $TYPE;
    /**
     * The NUMBER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NUMBER;
    /**
     * The VALID_FROM
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $VALID_FROM;
    /**
     * The VALID_TO
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $VALID_TO;
    /**
     * The LEVEL
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $LEVEL;
    /**
     * The STATUS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $STATUS;
    /**
     * The VALIDFROM
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $VALIDFROM;
    /**
     * The VALIDTO
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $VALIDTO;
    /**
     * The CARDTEXT
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $CARDTEXT;
    /**
     * The EXTERNALREFERENCE
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $EXTERNALREFERENCE;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $externalreference;
    /**
     * The extaddref
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $extaddref;
    /**
     * The extaddreftype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $extaddreftype;
    /**
     * The serviceprovider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceprovider;
    /**
     * The validationdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $validationdate;
    /**
     * The cardtext
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $cardtext;
    /**
     * Constructor method for CARD
     * @uses CARD::setToken()
     * @uses CARD::setTokenValidUntil()
     * @uses CARD::setTYPE()
     * @uses CARD::setNUMBER()
     * @uses CARD::setVALID_FROM()
     * @uses CARD::setVALID_TO()
     * @uses CARD::setLEVEL()
     * @uses CARD::setSTATUS()
     * @uses CARD::setVALIDFROM()
     * @uses CARD::setVALIDTO()
     * @uses CARD::setCARDTEXT()
     * @uses CARD::setEXTERNALREFERENCE()
     * @uses CARD::setType_1()
     * @uses CARD::setExternalreference_1()
     * @uses CARD::setExtaddref()
     * @uses CARD::setExtaddreftype()
     * @uses CARD::setServiceprovider()
     * @uses CARD::setValidationdate()
     * @uses CARD::setCardtext_1()
     * @param string $token
     * @param string $tokenValidUntil
     * @param string $tYPE
     * @param string $nUMBER
     * @param string $vALID_FROM
     * @param string $vALID_TO
     * @param string $lEVEL
     * @param string $sTATUS
     * @param string $vALIDFROM
     * @param string $vALIDTO
     * @param string $cARDTEXT
     * @param string $eXTERNALREFERENCE
     * @param string $type
     * @param string $externalreference
     * @param string $extaddref
     * @param string $extaddreftype
     * @param string $serviceprovider
     * @param string $validationdate
     * @param string $cardtext
     */
    public function __construct($token = null, $tokenValidUntil = null, $tYPE = null, $nUMBER = null, $vALID_FROM = null, $vALID_TO = null, $lEVEL = null, $sTATUS = null, $vALIDFROM = null, $vALIDTO = null, $cARDTEXT = null, $eXTERNALREFERENCE = null, $type_1 = null, $externalreference_1 = null, $extaddref = null, $extaddreftype = null, $serviceprovider = null, $validationdate = null, $cardtext_1 = null)
    {
        $this
            ->setToken($token)
            ->setTokenValidUntil($tokenValidUntil)
            ->setTYPE($tYPE)
            ->setNUMBER($nUMBER)
            ->setVALID_FROM($vALID_FROM)
            ->setVALID_TO($vALID_TO)
            ->setLEVEL($lEVEL)
            ->setSTATUS($sTATUS)
            ->setVALIDFROM($vALIDFROM)
            ->setVALIDTO($vALIDTO)
            ->setCARDTEXT($cARDTEXT)
            ->setEXTERNALREFERENCE($eXTERNALREFERENCE)
            ->setType_1($type_1)
            ->setExternalreference_1($externalreference_1)
            ->setExtaddref($extaddref)
            ->setExtaddreftype($extaddreftype)
            ->setServiceprovider($serviceprovider)
            ->setValidationdate($validationdate)
            ->setCardtext_1($cardtext_1);
    }
    /**
     * Get token value
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\CARD
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($token) && mb_strlen($token) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($token)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($token) && mb_strlen($token) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get tokenValidUntil value
     * @return string
     */
    public function getTokenValidUntil()
    {
        return $this->tokenValidUntil;
    }
    /**
     * Set tokenValidUntil value
     * @param string $tokenValidUntil
     * @return \StructType\CARD
     */
    public function setTokenValidUntil($tokenValidUntil = null)
    {
        // validation for constraint: string
        if (!is_null($tokenValidUntil) && !is_string($tokenValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenValidUntil, true), gettype($tokenValidUntil)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($tokenValidUntil) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $tokenValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($tokenValidUntil, true)), __LINE__);
        }
        $this->tokenValidUntil = $tokenValidUntil;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @param string $tYPE
     * @return \StructType\CARD
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tYPE) && !is_string($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tYPE, true), gettype($tYPE)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($tYPE) && mb_strlen($tYPE) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($tYPE)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($tYPE) && mb_strlen($tYPE) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($tYPE)), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Get NUMBER value
     * @return string
     */
    public function getNUMBER()
    {
        return $this->NUMBER;
    }
    /**
     * Set NUMBER value
     * @param string $nUMBER
     * @return \StructType\CARD
     */
    public function setNUMBER($nUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($nUMBER) && !is_string($nUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nUMBER, true), gettype($nUMBER)), __LINE__);
        }
        $this->NUMBER = $nUMBER;
        return $this;
    }
    /**
     * Get VALID_FROM value
     * @return string
     */
    public function getVALID_FROM()
    {
        return $this->{'VALID-FROM'};
    }
    /**
     * Set VALID_FROM value
     * @param string $vALID_FROM
     * @return \StructType\CARD
     */
    public function setVALID_FROM($vALID_FROM = null)
    {
        // validation for constraint: string
        if (!is_null($vALID_FROM) && !is_string($vALID_FROM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vALID_FROM, true), gettype($vALID_FROM)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($vALID_FROM) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $vALID_FROM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($vALID_FROM, true)), __LINE__);
        }
        $this->VALID_FROM = $this->{'VALID-FROM'} = $vALID_FROM;
        return $this;
    }
    /**
     * Get VALID_TO value
     * @return string
     */
    public function getVALID_TO()
    {
        return $this->{'VALID-TO'};
    }
    /**
     * Set VALID_TO value
     * @param string $vALID_TO
     * @return \StructType\CARD
     */
    public function setVALID_TO($vALID_TO = null)
    {
        // validation for constraint: string
        if (!is_null($vALID_TO) && !is_string($vALID_TO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vALID_TO, true), gettype($vALID_TO)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($vALID_TO) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $vALID_TO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($vALID_TO, true)), __LINE__);
        }
        $this->VALID_TO = $this->{'VALID-TO'} = $vALID_TO;
        return $this;
    }
    /**
     * Get LEVEL value
     * @return string
     */
    public function getLEVEL()
    {
        return $this->LEVEL;
    }
    /**
     * Set LEVEL value
     * @param string $lEVEL
     * @return \StructType\CARD
     */
    public function setLEVEL($lEVEL = null)
    {
        // validation for constraint: string
        if (!is_null($lEVEL) && !is_string($lEVEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lEVEL, true), gettype($lEVEL)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($lEVEL) && mb_strlen($lEVEL) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($lEVEL)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($lEVEL) && mb_strlen($lEVEL) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($lEVEL)), __LINE__);
        }
        $this->LEVEL = $lEVEL;
        return $this;
    }
    /**
     * Get STATUS value
     * @return string
     */
    public function getSTATUS()
    {
        return $this->STATUS;
    }
    /**
     * Set STATUS value
     * @param string $sTATUS
     * @return \StructType\CARD
     */
    public function setSTATUS($sTATUS = null)
    {
        // validation for constraint: string
        if (!is_null($sTATUS) && !is_string($sTATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTATUS, true), gettype($sTATUS)), __LINE__);
        }
        $this->STATUS = $sTATUS;
        return $this;
    }
    /**
     * Get VALIDFROM value
     * @return string
     */
    public function getVALIDFROM()
    {
        return $this->VALIDFROM;
    }
    /**
     * Set VALIDFROM value
     * @param string $vALIDFROM
     * @return \StructType\CARD
     */
    public function setVALIDFROM($vALIDFROM = null)
    {
        // validation for constraint: string
        if (!is_null($vALIDFROM) && !is_string($vALIDFROM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vALIDFROM, true), gettype($vALIDFROM)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($vALIDFROM) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $vALIDFROM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($vALIDFROM, true)), __LINE__);
        }
        $this->VALIDFROM = $vALIDFROM;
        return $this;
    }
    /**
     * Get VALIDTO value
     * @return string
     */
    public function getVALIDTO()
    {
        return $this->VALIDTO;
    }
    /**
     * Set VALIDTO value
     * @param string $vALIDTO
     * @return \StructType\CARD
     */
    public function setVALIDTO($vALIDTO = null)
    {
        // validation for constraint: string
        if (!is_null($vALIDTO) && !is_string($vALIDTO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vALIDTO, true), gettype($vALIDTO)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($vALIDTO) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $vALIDTO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($vALIDTO, true)), __LINE__);
        }
        $this->VALIDTO = $vALIDTO;
        return $this;
    }
    /**
     * Get CARDTEXT value
     * @return string
     */
    public function getCARDTEXT()
    {
        return $this->CARDTEXT;
    }
    /**
     * Set CARDTEXT value
     * @param string $cARDTEXT
     * @return \StructType\CARD
     */
    public function setCARDTEXT($cARDTEXT = null)
    {
        // validation for constraint: string
        if (!is_null($cARDTEXT) && !is_string($cARDTEXT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cARDTEXT, true), gettype($cARDTEXT)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cARDTEXT) && mb_strlen($cARDTEXT) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($cARDTEXT)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cARDTEXT) && mb_strlen($cARDTEXT) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cARDTEXT)), __LINE__);
        }
        $this->CARDTEXT = $cARDTEXT;
        return $this;
    }
    /**
     * Get EXTERNALREFERENCE value
     * @return string
     */
    public function getEXTERNALREFERENCE()
    {
        return $this->EXTERNALREFERENCE;
    }
    /**
     * Set EXTERNALREFERENCE value
     * @param string $eXTERNALREFERENCE
     * @return \StructType\CARD
     */
    public function setEXTERNALREFERENCE($eXTERNALREFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($eXTERNALREFERENCE) && !is_string($eXTERNALREFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eXTERNALREFERENCE, true), gettype($eXTERNALREFERENCE)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($eXTERNALREFERENCE) && mb_strlen($eXTERNALREFERENCE) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($eXTERNALREFERENCE)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($eXTERNALREFERENCE) && mb_strlen($eXTERNALREFERENCE) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($eXTERNALREFERENCE)), __LINE__);
        }
        $this->EXTERNALREFERENCE = $eXTERNALREFERENCE;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType_1()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\CARD
     */
    public function setType_1($type_1 = null)
    {
        // validation for constraint: string
        if (!is_null($type_1) && !is_string($type_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type_1, true), gettype($type_1)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($type_1) && mb_strlen($type_1) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($type_1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($type_1) && mb_strlen($type_1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($type_1)), __LINE__);
        }
        $this->type = $type_1;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string|null
     */
    public function getExternalreference_1()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\CARD
     */
    public function setExternalreference_1($externalreference_1 = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference_1) && !is_string($externalreference_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference_1, true), gettype($externalreference_1)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($externalreference_1) && mb_strlen($externalreference_1) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($externalreference_1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference_1) && mb_strlen($externalreference_1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference_1)), __LINE__);
        }
        $this->externalreference = $externalreference_1;
        return $this;
    }
    /**
     * Get extaddref value
     * @return string|null
     */
    public function getExtaddref()
    {
        return $this->extaddref;
    }
    /**
     * Set extaddref value
     * @param string $extaddref
     * @return \StructType\CARD
     */
    public function setExtaddref($extaddref = null)
    {
        // validation for constraint: string
        if (!is_null($extaddref) && !is_string($extaddref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extaddref, true), gettype($extaddref)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($extaddref) && mb_strlen($extaddref) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($extaddref)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($extaddref) && mb_strlen($extaddref) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($extaddref)), __LINE__);
        }
        $this->extaddref = $extaddref;
        return $this;
    }
    /**
     * Get extaddreftype value
     * @return string|null
     */
    public function getExtaddreftype()
    {
        return $this->extaddreftype;
    }
    /**
     * Set extaddreftype value
     * @param string $extaddreftype
     * @return \StructType\CARD
     */
    public function setExtaddreftype($extaddreftype = null)
    {
        // validation for constraint: string
        if (!is_null($extaddreftype) && !is_string($extaddreftype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extaddreftype, true), gettype($extaddreftype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($extaddreftype) && mb_strlen($extaddreftype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($extaddreftype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($extaddreftype) && mb_strlen($extaddreftype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($extaddreftype)), __LINE__);
        }
        $this->extaddreftype = $extaddreftype;
        return $this;
    }
    /**
     * Get serviceprovider value
     * @return string|null
     */
    public function getServiceprovider()
    {
        return $this->serviceprovider;
    }
    /**
     * Set serviceprovider value
     * @param string $serviceprovider
     * @return \StructType\CARD
     */
    public function setServiceprovider($serviceprovider = null)
    {
        // validation for constraint: string
        if (!is_null($serviceprovider) && !is_string($serviceprovider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceprovider, true), gettype($serviceprovider)), __LINE__);
        }
        $this->serviceprovider = $serviceprovider;
        return $this;
    }
    /**
     * Get validationdate value
     * @return string|null
     */
    public function getValidationdate()
    {
        return $this->validationdate;
    }
    /**
     * Set validationdate value
     * @param string $validationdate
     * @return \StructType\CARD
     */
    public function setValidationdate($validationdate = null)
    {
        // validation for constraint: string
        if (!is_null($validationdate) && !is_string($validationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationdate, true), gettype($validationdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($validationdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $validationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($validationdate, true)), __LINE__);
        }
        $this->validationdate = $validationdate;
        return $this;
    }
    /**
     * Get cardtext value
     * @return string|null
     */
    public function getCardtext_1()
    {
        return $this->cardtext;
    }
    /**
     * Set cardtext value
     * @param string $cardtext
     * @return \StructType\CARD
     */
    public function setCardtext_1($cardtext_1 = null)
    {
        // validation for constraint: string
        if (!is_null($cardtext_1) && !is_string($cardtext_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardtext_1, true), gettype($cardtext_1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cardtext_1) && mb_strlen($cardtext_1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($cardtext_1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cardtext_1) && mb_strlen($cardtext_1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cardtext_1)), __LINE__);
        }
        $this->cardtext = $cardtext_1;
        return $this;
    }
}
