<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivitySearch StructType
 * @subpackage Structs
 */
class ActivitySearch extends AbstractStructBase
{
    /**
     * The externalid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalid;
    /**
     * The hotels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hotels;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The trailtype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $trailtype;
    /**
     * The activitytype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $activitytype;
    /**
     * The activitysubtype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $activitysubtype;
    /**
     * The refobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $refobjid;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The onlyOpen
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $onlyOpen;
    /**
     * Constructor method for ActivitySearch
     * @uses ActivitySearch::setExternalid()
     * @uses ActivitySearch::setHotels()
     * @uses ActivitySearch::setUser()
     * @uses ActivitySearch::setTrailtype()
     * @uses ActivitySearch::setActivitytype()
     * @uses ActivitySearch::setActivitysubtype()
     * @uses ActivitySearch::setRefobjid()
     * @uses ActivitySearch::setDatefrom()
     * @uses ActivitySearch::setDateto()
     * @uses ActivitySearch::setOnlyOpen()
     * @param string $externalid
     * @param string $hotels
     * @param string $user
     * @param string $trailtype
     * @param string $activitytype
     * @param string $activitysubtype
     * @param string $refobjid
     * @param string $datefrom
     * @param string $dateto
     * @param string $onlyOpen
     */
    public function __construct($externalid = null, $hotels = null, $user = null, $trailtype = null, $activitytype = null, $activitysubtype = null, $refobjid = null, $datefrom = null, $dateto = null, $onlyOpen = null)
    {
        $this
            ->setExternalid($externalid)
            ->setHotels($hotels)
            ->setUser($user)
            ->setTrailtype($trailtype)
            ->setActivitytype($activitytype)
            ->setActivitysubtype($activitysubtype)
            ->setRefobjid($refobjid)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setOnlyOpen($onlyOpen);
    }
    /**
     * Get externalid value
     * @return string|null
     */
    public function getExternalid()
    {
        return $this->externalid;
    }
    /**
     * Set externalid value
     * @param string $externalid
     * @return \StructType\ActivitySearch
     */
    public function setExternalid($externalid = null)
    {
        // validation for constraint: string
        if (!is_null($externalid) && !is_string($externalid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalid, true), gettype($externalid)), __LINE__);
        }
        $this->externalid = $externalid;
        return $this;
    }
    /**
     * Get hotels value
     * @return string|null
     */
    public function getHotels()
    {
        return $this->hotels;
    }
    /**
     * Set hotels value
     * @param string $hotels
     * @return \StructType\ActivitySearch
     */
    public function setHotels($hotels = null)
    {
        // validation for constraint: string
        if (!is_null($hotels) && !is_string($hotels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotels, true), gettype($hotels)), __LINE__);
        }
        $this->hotels = $hotels;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\ActivitySearch
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($user) && mb_strlen($user) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($user)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($user) && mb_strlen($user) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get trailtype value
     * @return string|null
     */
    public function getTrailtype()
    {
        return $this->trailtype;
    }
    /**
     * Set trailtype value
     * @param string $trailtype
     * @return \StructType\ActivitySearch
     */
    public function setTrailtype($trailtype = null)
    {
        // validation for constraint: string
        if (!is_null($trailtype) && !is_string($trailtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailtype, true), gettype($trailtype)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($trailtype) && !preg_match('/([-+]){0,1}([0-9])*/', $trailtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($trailtype, true)), __LINE__);
        }
        $this->trailtype = $trailtype;
        return $this;
    }
    /**
     * Get activitytype value
     * @return string|null
     */
    public function getActivitytype()
    {
        return $this->activitytype;
    }
    /**
     * Set activitytype value
     * @param string $activitytype
     * @return \StructType\ActivitySearch
     */
    public function setActivitytype($activitytype = null)
    {
        // validation for constraint: string
        if (!is_null($activitytype) && !is_string($activitytype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activitytype, true), gettype($activitytype)), __LINE__);
        }
        $this->activitytype = $activitytype;
        return $this;
    }
    /**
     * Get activitysubtype value
     * @return string|null
     */
    public function getActivitysubtype()
    {
        return $this->activitysubtype;
    }
    /**
     * Set activitysubtype value
     * @param string $activitysubtype
     * @return \StructType\ActivitySearch
     */
    public function setActivitysubtype($activitysubtype = null)
    {
        // validation for constraint: string
        if (!is_null($activitysubtype) && !is_string($activitysubtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activitysubtype, true), gettype($activitysubtype)), __LINE__);
        }
        $this->activitysubtype = $activitysubtype;
        return $this;
    }
    /**
     * Get refobjid value
     * @return string|null
     */
    public function getRefobjid()
    {
        return $this->refobjid;
    }
    /**
     * Set refobjid value
     * @param string $refobjid
     * @return \StructType\ActivitySearch
     */
    public function setRefobjid($refobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refobjid) && !is_string($refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refobjid, true), gettype($refobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refobjid) && !preg_match('/([0-9])*/', $refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refobjid, true)), __LINE__);
        }
        $this->refobjid = $refobjid;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string|null
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\ActivitySearch
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string|null
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\ActivitySearch
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get onlyOpen value
     * @return string|null
     */
    public function getOnlyOpen()
    {
        return $this->onlyOpen;
    }
    /**
     * Set onlyOpen value
     * @param string $onlyOpen
     * @return \StructType\ActivitySearch
     */
    public function setOnlyOpen($onlyOpen = null)
    {
        // validation for constraint: string
        if (!is_null($onlyOpen) && !is_string($onlyOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlyOpen, true), gettype($onlyOpen)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($onlyOpen) && !preg_match('/([-+]){0,1}([0-9])*/', $onlyOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($onlyOpen, true)), __LINE__);
        }
        $this->onlyOpen = $onlyOpen;
        return $this;
    }
}
