<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activity StructType
 * @subpackage Structs
 */
class Activity extends AbstractStructBase
{
    /**
     * The ACTIVITY_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACTIVITY_OBJID;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The appointmentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $appointmentdate;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $time;
    /**
     * The EXT_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EXT_ID;
    /**
     * The reftreeobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $reftreeobjid;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The refobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $refobjid;
    /**
     * The ExternalID_Act
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExternalID_Act
     */
    public $ExternalID_Act;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The enddate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $enddate;
    /**
     * The endtime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $endtime;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The FollowUps
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FollowUps[]
     */
    public $FollowUps;
    /**
     * The ExternalFile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalFile[]
     */
    public $ExternalFile;
    /**
     * Constructor method for Activity
     * @uses Activity::setACTIVITY_OBJID()
     * @uses Activity::setDescription()
     * @uses Activity::setAppointmentdate()
     * @uses Activity::setTime()
     * @uses Activity::setEXT_ID()
     * @uses Activity::setReftreeobjid()
     * @uses Activity::setType()
     * @uses Activity::setRefobjid()
     * @uses Activity::setExternalID_Act()
     * @uses Activity::setUser()
     * @uses Activity::setStatus()
     * @uses Activity::setLocation()
     * @uses Activity::setEnddate()
     * @uses Activity::setEndtime()
     * @uses Activity::setComment()
     * @uses Activity::setFollowUps()
     * @uses Activity::setExternalFile()
     * @param string $aCTIVITY_OBJID
     * @param string $description
     * @param string $appointmentdate
     * @param string $time
     * @param string $eXT_ID
     * @param string $reftreeobjid
     * @param string $type
     * @param string $refobjid
     * @param \StructType\ExternalID_Act $externalID_Act
     * @param string $user
     * @param string $status
     * @param string $location
     * @param string $enddate
     * @param string $endtime
     * @param string $comment
     * @param \StructType\FollowUps[] $followUps
     * @param \StructType\ExternalFile[] $externalFile
     */
    public function __construct($aCTIVITY_OBJID = null, $description = null, $appointmentdate = null, $time = null, $eXT_ID = null, $reftreeobjid = null, $type = null, $refobjid = null, \StructType\ExternalID_Act $externalID_Act = null, $user = null, $status = null, $location = null, $enddate = null, $endtime = null, $comment = null, array $followUps = array(), array $externalFile = array())
    {
        $this
            ->setACTIVITY_OBJID($aCTIVITY_OBJID)
            ->setDescription($description)
            ->setAppointmentdate($appointmentdate)
            ->setTime($time)
            ->setEXT_ID($eXT_ID)
            ->setReftreeobjid($reftreeobjid)
            ->setType($type)
            ->setRefobjid($refobjid)
            ->setExternalID_Act($externalID_Act)
            ->setUser($user)
            ->setStatus($status)
            ->setLocation($location)
            ->setEnddate($enddate)
            ->setEndtime($endtime)
            ->setComment($comment)
            ->setFollowUps($followUps)
            ->setExternalFile($externalFile);
    }
    /**
     * Get ACTIVITY_OBJID value
     * @return string
     */
    public function getACTIVITY_OBJID()
    {
        return $this->{'ACTIVITY-OBJID'};
    }
    /**
     * Set ACTIVITY_OBJID value
     * @param string $aCTIVITY_OBJID
     * @return \StructType\Activity
     */
    public function setACTIVITY_OBJID($aCTIVITY_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCTIVITY_OBJID) && !is_string($aCTIVITY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCTIVITY_OBJID, true), gettype($aCTIVITY_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCTIVITY_OBJID) && !preg_match('/([0-9])*/', $aCTIVITY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCTIVITY_OBJID, true)), __LINE__);
        }
        $this->ACTIVITY_OBJID = $this->{'ACTIVITY-OBJID'} = $aCTIVITY_OBJID;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Activity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($description) && mb_strlen($description) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get appointmentdate value
     * @return string
     */
    public function getAppointmentdate()
    {
        return $this->appointmentdate;
    }
    /**
     * Set appointmentdate value
     * @param string $appointmentdate
     * @return \StructType\Activity
     */
    public function setAppointmentdate($appointmentdate = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentdate) && !is_string($appointmentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentdate, true), gettype($appointmentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($appointmentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $appointmentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($appointmentdate, true)), __LINE__);
        }
        $this->appointmentdate = $appointmentdate;
        return $this;
    }
    /**
     * Get time value
     * @return string
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\Activity
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($time) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($time, true)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get EXT_ID value
     * @return string
     */
    public function getEXT_ID()
    {
        return $this->EXT_ID;
    }
    /**
     * Set EXT_ID value
     * @param string $eXT_ID
     * @return \StructType\Activity
     */
    public function setEXT_ID($eXT_ID = null)
    {
        // validation for constraint: string
        if (!is_null($eXT_ID) && !is_string($eXT_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eXT_ID, true), gettype($eXT_ID)), __LINE__);
        }
        $this->EXT_ID = $eXT_ID;
        return $this;
    }
    /**
     * Get reftreeobjid value
     * @return string
     */
    public function getReftreeobjid()
    {
        return $this->reftreeobjid;
    }
    /**
     * Set reftreeobjid value
     * @param string $reftreeobjid
     * @return \StructType\Activity
     */
    public function setReftreeobjid($reftreeobjid = null)
    {
        // validation for constraint: string
        if (!is_null($reftreeobjid) && !is_string($reftreeobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reftreeobjid, true), gettype($reftreeobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($reftreeobjid) && !preg_match('/([0-9])*/', $reftreeobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($reftreeobjid, true)), __LINE__);
        }
        $this->reftreeobjid = $reftreeobjid;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Activity
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($type) && mb_strlen($type) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($type) && mb_strlen($type) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get refobjid value
     * @return string
     */
    public function getRefobjid()
    {
        return $this->refobjid;
    }
    /**
     * Set refobjid value
     * @param string $refobjid
     * @return \StructType\Activity
     */
    public function setRefobjid($refobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refobjid) && !is_string($refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refobjid, true), gettype($refobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refobjid) && !preg_match('/([0-9])*/', $refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refobjid, true)), __LINE__);
        }
        $this->refobjid = $refobjid;
        return $this;
    }
    /**
     * Get ExternalID_Act value
     * @return \StructType\ExternalID_Act|null
     */
    public function getExternalID_Act()
    {
        return $this->ExternalID_Act;
    }
    /**
     * Set ExternalID_Act value
     * @param \StructType\ExternalID_Act $externalID_Act
     * @return \StructType\Activity
     */
    public function setExternalID_Act(\StructType\ExternalID_Act $externalID_Act = null)
    {
        $this->ExternalID_Act = $externalID_Act;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\Activity
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($user) && mb_strlen($user) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($user)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($user) && mb_strlen($user) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Activity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($status) && mb_strlen($status) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($status)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($status) && mb_strlen($status) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\Activity
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($location) && mb_strlen($location) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($location)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($location) && mb_strlen($location) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get enddate value
     * @return string|null
     */
    public function getEnddate()
    {
        return $this->enddate;
    }
    /**
     * Set enddate value
     * @param string $enddate
     * @return \StructType\Activity
     */
    public function setEnddate($enddate = null)
    {
        // validation for constraint: string
        if (!is_null($enddate) && !is_string($enddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enddate, true), gettype($enddate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($enddate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $enddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($enddate, true)), __LINE__);
        }
        $this->enddate = $enddate;
        return $this;
    }
    /**
     * Get endtime value
     * @return string|null
     */
    public function getEndtime()
    {
        return $this->endtime;
    }
    /**
     * Set endtime value
     * @param string $endtime
     * @return \StructType\Activity
     */
    public function setEndtime($endtime = null)
    {
        // validation for constraint: string
        if (!is_null($endtime) && !is_string($endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endtime, true), gettype($endtime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($endtime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($endtime, true)), __LINE__);
        }
        $this->endtime = $endtime;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\Activity
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get FollowUps value
     * @return \StructType\FollowUps[]|null
     */
    public function getFollowUps()
    {
        return $this->FollowUps;
    }
    /**
     * This method is responsible for validating the values passed to the setFollowUps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFollowUps method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFollowUpsForArrayConstraintsFromSetFollowUps(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityFollowUpsItem) {
            // validation for constraint: itemType
            if (!$activityFollowUpsItem instanceof \StructType\FollowUps) {
                $invalidValues[] = is_object($activityFollowUpsItem) ? get_class($activityFollowUpsItem) : sprintf('%s(%s)', gettype($activityFollowUpsItem), var_export($activityFollowUpsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FollowUps property can only contain items of type \StructType\FollowUps, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FollowUps value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowUps[] $followUps
     * @return \StructType\Activity
     */
    public function setFollowUps(array $followUps = array())
    {
        // validation for constraint: array
        if ('' !== ($followUpsArrayErrorMessage = self::validateFollowUpsForArrayConstraintsFromSetFollowUps($followUps))) {
            throw new \InvalidArgumentException($followUpsArrayErrorMessage, __LINE__);
        }
        $this->FollowUps = $followUps;
        return $this;
    }
    /**
     * Add item to FollowUps value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowUps $item
     * @return \StructType\Activity
     */
    public function addToFollowUps(\StructType\FollowUps $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FollowUps) {
            throw new \InvalidArgumentException(sprintf('The FollowUps property can only contain items of type \StructType\FollowUps, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FollowUps[] = $item;
        return $this;
    }
    /**
     * Get ExternalFile value
     * @return \StructType\ExternalFile[]|null
     */
    public function getExternalFile()
    {
        return $this->ExternalFile;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalFileForArrayConstraintsFromSetExternalFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityExternalFileItem) {
            // validation for constraint: itemType
            if (!$activityExternalFileItem instanceof \StructType\ExternalFile) {
                $invalidValues[] = is_object($activityExternalFileItem) ? get_class($activityExternalFileItem) : sprintf('%s(%s)', gettype($activityExternalFileItem), var_export($activityExternalFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExternalFile property can only contain items of type \StructType\ExternalFile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExternalFile value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalFile[] $externalFile
     * @return \StructType\Activity
     */
    public function setExternalFile(array $externalFile = array())
    {
        // validation for constraint: array
        if ('' !== ($externalFileArrayErrorMessage = self::validateExternalFileForArrayConstraintsFromSetExternalFile($externalFile))) {
            throw new \InvalidArgumentException($externalFileArrayErrorMessage, __LINE__);
        }
        $this->ExternalFile = $externalFile;
        return $this;
    }
    /**
     * Add item to ExternalFile value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalFile $item
     * @return \StructType\Activity
     */
    public function addToExternalFile(\StructType\ExternalFile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalFile) {
            throw new \InvalidArgumentException(sprintf('The ExternalFile property can only contain items of type \StructType\ExternalFile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExternalFile[] = $item;
        return $this;
    }
}
