<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ARRIVAL StructType
 * @subpackage Structs
 */
class ARRIVAL extends AbstractStructBase
{
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $arrival;
    /**
     * The arrivaltime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $arrivaltime;
    /**
     * The tooltip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tooltip;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The viparrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $viparrival;
    /**
     * The amenities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $amenities;
    /**
     * Constructor method for ARRIVAL
     * @uses ARRIVAL::setArrival()
     * @uses ARRIVAL::setArrivaltime()
     * @uses ARRIVAL::setTooltip()
     * @uses ARRIVAL::setComment()
     * @uses ARRIVAL::setViparrival()
     * @uses ARRIVAL::setAmenities()
     * @param string $arrival
     * @param string $arrivaltime
     * @param string $tooltip
     * @param string $comment
     * @param string $viparrival
     * @param string $amenities
     */
    public function __construct($arrival = null, $arrivaltime = null, $tooltip = null, $comment = null, $viparrival = null, $amenities = null)
    {
        $this
            ->setArrival($arrival)
            ->setArrivaltime($arrivaltime)
            ->setTooltip($tooltip)
            ->setComment($comment)
            ->setViparrival($viparrival)
            ->setAmenities($amenities);
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\ARRIVAL
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get arrivaltime value
     * @return string
     */
    public function getArrivaltime()
    {
        return $this->arrivaltime;
    }
    /**
     * Set arrivaltime value
     * @param string $arrivaltime
     * @return \StructType\ARRIVAL
     */
    public function setArrivaltime($arrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivaltime) && !is_string($arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivaltime, true), gettype($arrivaltime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($arrivaltime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($arrivaltime, true)), __LINE__);
        }
        $this->arrivaltime = $arrivaltime;
        return $this;
    }
    /**
     * Get tooltip value
     * @return string
     */
    public function getTooltip()
    {
        return $this->tooltip;
    }
    /**
     * Set tooltip value
     * @param string $tooltip
     * @return \StructType\ARRIVAL
     */
    public function setTooltip($tooltip = null)
    {
        // validation for constraint: string
        if (!is_null($tooltip) && !is_string($tooltip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tooltip, true), gettype($tooltip)), __LINE__);
        }
        $this->tooltip = $tooltip;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\ARRIVAL
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get viparrival value
     * @return string
     */
    public function getViparrival()
    {
        return $this->viparrival;
    }
    /**
     * Set viparrival value
     * @param string $viparrival
     * @return \StructType\ARRIVAL
     */
    public function setViparrival($viparrival = null)
    {
        // validation for constraint: string
        if (!is_null($viparrival) && !is_string($viparrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viparrival, true), gettype($viparrival)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($viparrival) && mb_strlen($viparrival) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($viparrival)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($viparrival) && mb_strlen($viparrival) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($viparrival)), __LINE__);
        }
        $this->viparrival = $viparrival;
        return $this;
    }
    /**
     * Get amenities value
     * @return string
     */
    public function getAmenities()
    {
        return $this->amenities;
    }
    /**
     * Set amenities value
     * @param string $amenities
     * @return \StructType\ARRIVAL
     */
    public function setAmenities($amenities = null)
    {
        // validation for constraint: string
        if (!is_null($amenities) && !is_string($amenities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amenities, true), gettype($amenities)), __LINE__);
        }
        $this->amenities = $amenities;
        return $this;
    }
}
