<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALLOTMENTSEARCH StructType
 * @subpackage Structs
 */
class ALLOTMENTSEARCH extends AbstractStructBase
{
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The allotmenttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $allotmenttype;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $category;
    /**
     * The HOLDER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HOLDER
     */
    public $HOLDER;
    /**
     * Constructor method for ALLOTMENTSEARCH
     * @uses ALLOTMENTSEARCH::setDatefrom()
     * @uses ALLOTMENTSEARCH::setDateto()
     * @uses ALLOTMENTSEARCH::setStatus()
     * @uses ALLOTMENTSEARCH::setAllotmenttype()
     * @uses ALLOTMENTSEARCH::setCategory()
     * @uses ALLOTMENTSEARCH::setHOLDER()
     * @param string $datefrom
     * @param string $dateto
     * @param string $status
     * @param string $allotmenttype
     * @param string $category
     * @param \StructType\HOLDER $hOLDER
     */
    public function __construct($datefrom = null, $dateto = null, $status = null, $allotmenttype = null, $category = null, \StructType\HOLDER $hOLDER = null)
    {
        $this
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setStatus($status)
            ->setAllotmenttype($allotmenttype)
            ->setCategory($category)
            ->setHOLDER($hOLDER);
    }
    /**
     * Get datefrom value
     * @return string|null
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\ALLOTMENTSEARCH
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string|null
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\ALLOTMENTSEARCH
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ALLOTMENTSEARCH
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get allotmenttype value
     * @return string|null
     */
    public function getAllotmenttype()
    {
        return $this->allotmenttype;
    }
    /**
     * Set allotmenttype value
     * @param string $allotmenttype
     * @return \StructType\ALLOTMENTSEARCH
     */
    public function setAllotmenttype($allotmenttype = null)
    {
        // validation for constraint: string
        if (!is_null($allotmenttype) && !is_string($allotmenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allotmenttype, true), gettype($allotmenttype)), __LINE__);
        }
        $this->allotmenttype = $allotmenttype;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ALLOTMENTSEARCH
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get HOLDER value
     * @return \StructType\HOLDER|null
     */
    public function getHOLDER()
    {
        return $this->HOLDER;
    }
    /**
     * Set HOLDER value
     * @param \StructType\HOLDER $hOLDER
     * @return \StructType\ALLOTMENTSEARCH
     */
    public function setHOLDER(\StructType\HOLDER $hOLDER = null)
    {
        $this->HOLDER = $hOLDER;
        return $this;
    }
}
