<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALLOTMENTPACKAGE StructType
 * @subpackage Structs
 */
class ALLOTMENTPACKAGE extends AbstractStructBase
{
    /**
     * The ALLOTMENTPACKAGE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ALLOTMENTPACKAGE_OBJID;
    /**
     * The ALLOTMENTPACKAGE_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ALLOTMENTPACKAGE_CENTRALID;
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The guesttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $guesttype;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * Constructor method for ALLOTMENTPACKAGE
     * @uses ALLOTMENTPACKAGE::setALLOTMENTPACKAGE_OBJID()
     * @uses ALLOTMENTPACKAGE::setALLOTMENTPACKAGE_CENTRALID()
     * @uses ALLOTMENTPACKAGE::setServicecode()
     * @uses ALLOTMENTPACKAGE::setDescription()
     * @uses ALLOTMENTPACKAGE::setRatesegment()
     * @uses ALLOTMENTPACKAGE::setGuesttype()
     * @uses ALLOTMENTPACKAGE::setCurrency()
     * @param string $aLLOTMENTPACKAGE_OBJID
     * @param string $aLLOTMENTPACKAGE_CENTRALID
     * @param string $servicecode
     * @param string $description
     * @param string $ratesegment
     * @param string $guesttype
     * @param string $currency
     */
    public function __construct($aLLOTMENTPACKAGE_OBJID = null, $aLLOTMENTPACKAGE_CENTRALID = null, $servicecode = null, $description = null, $ratesegment = null, $guesttype = null, $currency = null)
    {
        $this
            ->setALLOTMENTPACKAGE_OBJID($aLLOTMENTPACKAGE_OBJID)
            ->setALLOTMENTPACKAGE_CENTRALID($aLLOTMENTPACKAGE_CENTRALID)
            ->setServicecode($servicecode)
            ->setDescription($description)
            ->setRatesegment($ratesegment)
            ->setGuesttype($guesttype)
            ->setCurrency($currency);
    }
    /**
     * Get ALLOTMENTPACKAGE_OBJID value
     * @return string
     */
    public function getALLOTMENTPACKAGE_OBJID()
    {
        return $this->{'ALLOTMENTPACKAGE-OBJID'};
    }
    /**
     * Set ALLOTMENTPACKAGE_OBJID value
     * @param string $aLLOTMENTPACKAGE_OBJID
     * @return \StructType\ALLOTMENTPACKAGE
     */
    public function setALLOTMENTPACKAGE_OBJID($aLLOTMENTPACKAGE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOTMENTPACKAGE_OBJID) && !is_string($aLLOTMENTPACKAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLLOTMENTPACKAGE_OBJID, true), gettype($aLLOTMENTPACKAGE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aLLOTMENTPACKAGE_OBJID) && !preg_match('/([0-9])*/', $aLLOTMENTPACKAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aLLOTMENTPACKAGE_OBJID, true)), __LINE__);
        }
        $this->ALLOTMENTPACKAGE_OBJID = $this->{'ALLOTMENTPACKAGE-OBJID'} = $aLLOTMENTPACKAGE_OBJID;
        return $this;
    }
    /**
     * Get ALLOTMENTPACKAGE_CENTRALID value
     * @return string
     */
    public function getALLOTMENTPACKAGE_CENTRALID()
    {
        return $this->{'ALLOTMENTPACKAGE-CENTRALID'};
    }
    /**
     * Set ALLOTMENTPACKAGE_CENTRALID value
     * @param string $aLLOTMENTPACKAGE_CENTRALID
     * @return \StructType\ALLOTMENTPACKAGE
     */
    public function setALLOTMENTPACKAGE_CENTRALID($aLLOTMENTPACKAGE_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOTMENTPACKAGE_CENTRALID) && !is_string($aLLOTMENTPACKAGE_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLLOTMENTPACKAGE_CENTRALID, true), gettype($aLLOTMENTPACKAGE_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aLLOTMENTPACKAGE_CENTRALID) && !preg_match('/([0-9])*/', $aLLOTMENTPACKAGE_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aLLOTMENTPACKAGE_CENTRALID, true)), __LINE__);
        }
        $this->ALLOTMENTPACKAGE_CENTRALID = $this->{'ALLOTMENTPACKAGE-CENTRALID'} = $aLLOTMENTPACKAGE_CENTRALID;
        return $this;
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\ALLOTMENTPACKAGE
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ALLOTMENTPACKAGE
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\ALLOTMENTPACKAGE
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get guesttype value
     * @return string
     */
    public function getGuesttype()
    {
        return $this->guesttype;
    }
    /**
     * Set guesttype value
     * @param string $guesttype
     * @return \StructType\ALLOTMENTPACKAGE
     */
    public function setGuesttype($guesttype = null)
    {
        // validation for constraint: string
        if (!is_null($guesttype) && !is_string($guesttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guesttype, true), gettype($guesttype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($guesttype) && mb_strlen($guesttype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($guesttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guesttype) && mb_strlen($guesttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guesttype)), __LINE__);
        }
        $this->guesttype = $guesttype;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ALLOTMENTPACKAGE
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
}
