<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ACLInfo StructType
 * @subpackage Structs
 */
class ACLInfo extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $Type;
    /**
     * The Typename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Typename;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Key;
    /**
     * The Subkey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Subkey;
    /**
     * The HasExecutionRight
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $HasExecutionRight;
    /**
     * The HasViewRight
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $HasViewRight;
    /**
     * Constructor method for ACLInfo
     * @uses ACLInfo::setType()
     * @uses ACLInfo::setTypename()
     * @uses ACLInfo::setKey()
     * @uses ACLInfo::setSubkey()
     * @uses ACLInfo::setHasExecutionRight()
     * @uses ACLInfo::setHasViewRight()
     * @param string $type
     * @param string $typename
     * @param string $key
     * @param string $subkey
     * @param string $hasExecutionRight
     * @param string $hasViewRight
     */
    public function __construct($type = null, $typename = null, $key = null, $subkey = null, $hasExecutionRight = null, $hasViewRight = null)
    {
        $this
            ->setType($type)
            ->setTypename($typename)
            ->setKey($key)
            ->setSubkey($subkey)
            ->setHasExecutionRight($hasExecutionRight)
            ->setHasViewRight($hasViewRight);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ACLInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($type) && !preg_match('/([-+]){0,1}([0-9])*/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Typename value
     * @return string
     */
    public function getTypename()
    {
        return $this->Typename;
    }
    /**
     * Set Typename value
     * @param string $typename
     * @return \StructType\ACLInfo
     */
    public function setTypename($typename = null)
    {
        // validation for constraint: string
        if (!is_null($typename) && !is_string($typename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typename, true), gettype($typename)), __LINE__);
        }
        $this->Typename = $typename;
        return $this;
    }
    /**
     * Get Key value
     * @return string
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \StructType\ACLInfo
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Subkey value
     * @return string
     */
    public function getSubkey()
    {
        return $this->Subkey;
    }
    /**
     * Set Subkey value
     * @param string $subkey
     * @return \StructType\ACLInfo
     */
    public function setSubkey($subkey = null)
    {
        // validation for constraint: string
        if (!is_null($subkey) && !is_string($subkey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subkey, true), gettype($subkey)), __LINE__);
        }
        $this->Subkey = $subkey;
        return $this;
    }
    /**
     * Get HasExecutionRight value
     * @return string
     */
    public function getHasExecutionRight()
    {
        return $this->HasExecutionRight;
    }
    /**
     * Set HasExecutionRight value
     * @param string $hasExecutionRight
     * @return \StructType\ACLInfo
     */
    public function setHasExecutionRight($hasExecutionRight = null)
    {
        // validation for constraint: string
        if (!is_null($hasExecutionRight) && !is_string($hasExecutionRight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hasExecutionRight, true), gettype($hasExecutionRight)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hasExecutionRight) && !preg_match('/([-+]){0,1}([0-9])*/', $hasExecutionRight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hasExecutionRight, true)), __LINE__);
        }
        $this->HasExecutionRight = $hasExecutionRight;
        return $this;
    }
    /**
     * Get HasViewRight value
     * @return string
     */
    public function getHasViewRight()
    {
        return $this->HasViewRight;
    }
    /**
     * Set HasViewRight value
     * @param string $hasViewRight
     * @return \StructType\ACLInfo
     */
    public function setHasViewRight($hasViewRight = null)
    {
        // validation for constraint: string
        if (!is_null($hasViewRight) && !is_string($hasViewRight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hasViewRight, true), gettype($hasViewRight)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hasViewRight) && !preg_match('/([-+]){0,1}([0-9])*/', $hasViewRight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hasViewRight, true)), __LINE__);
        }
        $this->HasViewRight = $hasViewRight;
        return $this;
    }
}
