<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SUSERSEARCHV ServiceType
 * @subpackage Services
 */
class SUSERSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_USER_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_USER_SEARCH_V002](../S_USER_SEARCH_V002) - Added language to output### GeneralThis service searches for users.### Input- operatorID: In case the user is not found in
     * database the ablSalesPerson pool is searched.### Output- firstName- lastName- phone- email- fax- department- description- comment- hotelsPreferred
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_USER_SEARCH_V001Request $body
     * @return \StructType\S_USER_SEARCH_V001Response|bool
     */
    public function S_USER_SEARCH_V001(\StructType\S_USER_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_USER_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_USER_SEARCH_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for users.### Input- Operator can be used to search for an exact user matching the provided operator value. Alternatively, not providing an operator but a salesPerson instead searches for a user by
     * the assigned sales person.### Output- firstName- lastName- phone- email- fax- department- description- comment- hotelsPreferred- language
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_USER_SEARCH_V002Request $body
     * @return \StructType\S_USER_SEARCH_V002Response|bool
     */
    public function S_USER_SEARCH_V002(\StructType\S_USER_SEARCH_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_USER_SEARCH_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_USER_SEARCH_V001Response|\StructType\S_USER_SEARCH_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
