<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SSYSMESSAGEADDV ServiceType
 * @subpackage Services
 */
class SSYSMESSAGEADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_SYSMESSAGE_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service is used to create system messages.### InputIn addition to the SecurityID, the message text, message level, hotel and task id must also be specified:- messageText: Mandatory. The message text to be shown.-
     * messageLevel: Mandatory. Possible message levels are:- -2 - not defined- -1 - cricitcal- 0 - error- 1 - warning 1- 2 - warning 2- 3 - info- 4 - internal info- taskID: Optional. Can be used to specify another process where the system message was send
     * from.- hotel: Mandatory. The hotel for which the system message should be applied to.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_SYSMESSAGE_ADD_V001Request $body
     * @return \StructType\S_SYSMESSAGE_ADD_V001Response|bool
     */
    public function S_SYSMESSAGE_ADD_V001(\StructType\S_SYSMESSAGE_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_SYSMESSAGE_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_SYSMESSAGE_ADD_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service is used to create system messages.### InputIn addition to the SecurityID, the text id, message level and hotel must also be specified:- textid: Mandatory. The message text to be shown.- messageLevel:
     * Mandatory. Possible message levels are:- -2 - not defined- -1 - cricitcal- 0 - error- 1 - warning 1- 2 - warning 2- 3 - info- 4 - internal info- hotel: Mandatory. The hotel for which the system message should be applied to.- TextParameter: Optional.
     * Parameters for the Message Text.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_SYSMESSAGE_ADD_V002Request $body
     * @return \StructType\S_SYSMESSAGE_ADD_V002Response|bool
     */
    public function S_SYSMESSAGE_ADD_V002(\StructType\S_SYSMESSAGE_ADD_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_SYSMESSAGE_ADD_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_SYSMESSAGE_ADD_V001Response|\StructType\S_SYSMESSAGE_ADD_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
