<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SROOMINGLISTCLEANROOMAUTOASSIGNV ServiceType
 * @subpackage Services
 */
class SROOMINGLISTCLEANROOMAUTOASSIGNV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for a matching clean room and assigns it to a rooming list. In case no clean room is available, an error is returned.### Input- ROOMINGLIST-OBJID: ObjID of the rooming list, which can be obtained from
     * defined services. Mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Request $body
     * @return \StructType\S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Response|bool
     */
    public function S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001(\StructType\S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
