<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRESERVATIONCHANGEPREVIEWV ServiceType
 * @subpackage Services
 */
class SRESERVATIONCHANGEPREVIEWV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_RESERVATION_CHANGE_PREVIEW_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralService is calculating the delta amount (Gross in a gross rate system, net in a net rate system) between a persisted reservation (can be found by CentralID or ObjID) and this requested.### Input- RESERVATION-CENTRALID:
     * CentralID of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the reservation.- RESERVATION-OBJID: ObjID of the reservation. Optional, but one out of RESERVATION-CENTRALID or
     * RESERVATION-OBJID needs to be sent to find the reservation.- arrival: Mandatory. Arrival date of the reservation to be calculated.- departure: Mandatory. Departure date of the reservation to be calculated.- category: Mandatory. Category of the
     * reservation to be calculated.- ratecategory: Mandatory. Rate category of the reservation to be calculated.- ratesegment: Optional. Rate segment of the reservation to be calculated.- 1:N blocks with reservation packages (ReservationPackage), which
     * consists of service, datefrom and dateto. At least one package needs to fit arrival and departure date of the requested reservation.- service: Mandatory. Service code of the reservation package/service.- datefrom: Mandatory. Begin date of the
     * reservation package/service.- dateto: Mandatory. End date of the reservation package/service.- 1:N blocks with rooms, which consists of category, 1:N blocks persons, that also have 1:N blocks person packages.- category: Mandatory. Category of the
     * room.- person consists of datefrom, dateto, ratecategory, ratesegment and 1:N blocks of person packages (PersonPackage)- datefrom: Mandatory. Arrival date of the person (must fit the reservation arrival date).- dateto: Mandatory. Departure date of
     * the person (must fit the reservation departure date).- ratecategory: Mandatory. Rate category of the person.- ratesegment: Optional. Rate segment of the person.- personPackages consists of service, datefrom, dateto- service: Mandatory. Service code
     * of the person package/service.- datefrom: Mandatory. Begin date of the person package/service.- dateto: Mandatory. End date of the person package/service.### Output- RESERVATION-CENTRALID: CentralID of the reservation.- RESERVATION-OBJID: ObjID of
     * the reservation.- total: Total amount of the persisted reservation.- depositrequired: Required deposit amount of the persisted reservation.- depositpayed: Payed deposit amount of the persisted reservation.- depositopen: Open deposit amount of the
     * persisted reservation.- forecast: Forecast amount of the requested reservation (total amount, in case of the requested data would be applied on the reservation).- delta: Delta amount between the current total amount of the persisted reservation and
     * the calculate rate forecast for the requested reservation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RESERVATION_CHANGE_PREVIEW_V001Request $body
     * @return \StructType\S_RESERVATION_CHANGE_PREVIEW_V001Response|bool
     */
    public function S_RESERVATION_CHANGE_PREVIEW_V001(\StructType\S_RESERVATION_CHANGE_PREVIEW_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RESERVATION_CHANGE_PREVIEW_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_RESERVATION_CHANGE_PREVIEW_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
