<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SPRODUCTFEATURESGETV ServiceType
 * @subpackage Services
 */
class SPRODUCTFEATURESGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_PRODUCT_FEATURES_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service can be used to query features attached to a specific product and whether they are enabled or not### Input- Product: SIHOT product to query features for. Valid options can be queried through the combobox with
     * key "SihotProduct"
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_PRODUCT_FEATURES_GET_V001Request $body
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Response|bool
     */
    public function S_PRODUCT_FEATURES_GET_V001(\StructType\S_PRODUCT_FEATURES_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_PRODUCT_FEATURES_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
