<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SPAYMENTCOMMITV ServiceType
 * @subpackage Services
 */
class SPAYMENTCOMMITV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_PAYMENT_COMMIT_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service commits a successful payment that was created by an init payment request with the payment engine.### Input- cardInfoRefID. Mandatory. Object ID of the card info that was created during the inital payment
     * request.- serviceProvider. Mandatory. The service provider used for the payment.- returnCode. Mandatory. Return code of the payment engine. Only a positive value is allowed here ("0").- transactionID. Mandatory. The transaction ID of the payment.-
     * cardtypecode. Mandatory. The external card type received from the payment provider.- amount. Mandatory. The payment amount- currency. Mandatory. The currency of the payment amount- description. Optional. manual text of the payment- receipt. Optional.
     * The merchant receipt created from the payment provider.- receiptCardHolder. Optional. The card holder receipt created from the payment provider.- emvTerminal. Optional. The terminal used for the payment.- clientPID. Optional. The process ID of the
     * crossbow client that started the payment process.### Output- PaymentObjID. The objid of the payment data stored in SIHOT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_PAYMENT_COMMIT_V001Request $body
     * @return \StructType\S_PAYMENT_COMMIT_V001Response|bool
     */
    public function S_PAYMENT_COMMIT_V001(\StructType\S_PAYMENT_COMMIT_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_PAYMENT_COMMIT_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_PAYMENT_COMMIT_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
