<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SNOTIFICATIONERRORSETV ServiceType
 * @subpackage Services
 */
class SNOTIFICATIONERRORSETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_NOTIFICATION_ERROR_SET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service sets an error for a notification (autotask). This usually means that the notification could not be successfully processed by the external system, after it was received.### Input- TASK-OBJID: ObjID of the
     * notification (autotask) that will be set as an error.- ErrorMsg: Error message describing the error that occurred.- SysMessage: If set (1) then a server message referring to this error will be generated in SIHOT.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_NOTIFICATION_ERROR_SET_V001Request $body
     * @return \StructType\S_NOTIFICATION_ERROR_SET_V001Response|bool
     */
    public function S_NOTIFICATION_ERROR_SET_V001(\StructType\S_NOTIFICATION_ERROR_SET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_NOTIFICATION_ERROR_SET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_NOTIFICATION_ERROR_SET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
