<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SMOBILELOSTANDFOUNDMODIFYV ServiceType
 * @subpackage Services
 */
class SMOBILELOSTANDFOUNDMODIFYV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_MOBILE_LOST_AND_FOUND_MODIFY_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralModifies a lost and found entry.### Input- LOST-AND-FOUND-OBJID: ObjID of the lost and found, which can be obtained from defined services. Mandatory- type: Use the key from the comboxbox -> "FT". Optional- status: Use the
     * key from the comboxbox -> "S1". Optional
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_MOBILE_LOST_AND_FOUND_MODIFY_V001Request $body
     * @return \StructType\S_MOBILE_LOST_AND_FOUND_MODIFY_V001Response|bool
     */
    public function S_MOBILE_LOST_AND_FOUND_MODIFY_V001(\StructType\S_MOBILE_LOST_AND_FOUND_MODIFY_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_MOBILE_LOST_AND_FOUND_MODIFY_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_MOBILE_LOST_AND_FOUND_MODIFY_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
