<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SINVOICEGETV ServiceType
 * @subpackage Services
 */
class SINVOICEGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_INVOICE_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_INVOICE_GET_V002](../S_INVOICE_GET_V002) - Extended with reservation information and pdf as base64.### GeneralThis service returns a specific invoice### Input-
     * INVOICE-OBJID: ObjID of the invoice, which can be obtained from other defined services. Mandatory### Output- invoice information- list of payment-, service postings- invoiceholder information: this information are saved on the invoice. If you need
     * more information from guest then use other serivce- list of vats and taxs- currency information- used combo box:- invoicenoset "RKWD"- hotel "HNA"- accounttype "38CB"- vat "53"- service "09Tax"- taxFormel "FO"
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_INVOICE_GET_V001Request $body
     * @return \StructType\S_INVOICE_GET_V001Response|bool
     */
    public function S_INVOICE_GET_V001(\StructType\S_INVOICE_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_INVOICE_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_INVOICE_GET_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns a specific invoice### Input- INVOICE-OBJID: ObjID of the invoice, which can be obtained from other defined services. Mandatory### Output- invoice information- list of payment-, service postings-
     * invoiceholder information: this information are saved on the invoice. If you need more information from guest then use other serivce- list of vats and taxs- currency information- front office reservation information- used combo box:- invoicenoset
     * "RKWD"- hotel "HNA"- accounttype "38CB"- vat "53"- service "09Tax"- taxFormel "FO"
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_INVOICE_GET_V002Request $body
     * @return \StructType\S_INVOICE_GET_V002Response|bool
     */
    public function S_INVOICE_GET_V002(\StructType\S_INVOICE_GET_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_INVOICE_GET_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_INVOICE_GET_V001Response|\StructType\S_INVOICE_GET_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
