<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SINVOICEEMAILSETV ServiceType
 * @subpackage Services
 */
class SINVOICEEMAILSETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_INVOICE_EMAIL_SET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralSets the email for a specific invoice### Input- INVOICE-OBJID: ObjID of the invoice, which can be obtained from other defined services. Mandatory - EMAIL: Email to be set as "Electronic invoicing email". Mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_INVOICE_EMAIL_SET_V001Request $body
     * @return \StructType\S_INVOICE_EMAIL_SET_V001Response|bool
     */
    public function S_INVOICE_EMAIL_SET_V001(\StructType\S_INVOICE_EMAIL_SET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_INVOICE_EMAIL_SET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_INVOICE_EMAIL_SET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
