<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTSETTLEMENTPROFILEREMOVEV ServiceType
 * @subpackage Services
 */
class SGUESTSETTLEMENTPROFILEREMOVEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service removes settlement profiles from a specific guest.### Input- GUEST-OBJID: ObjID of the guest, which can be obtained from defined servicesor- GUEST-CENTRALID: CentralID of the guest, which can be obtained from
     * defined services- SETTLEMENT-PROFILE-OBJID: ObjID of the settlement profile guest to be removed, which can be obtained from defined servicesor- SETTLEMENT-PROFILE-CENTRALID: CentralID of the settlement profile guest to be removed, which can be
     * obtained from defined services
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Request $body
     * @return \StructType\S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Response|bool
     */
    public function S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001(\StructType\S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
