<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTMERGEV ServiceType
 * @subpackage Services
 */
class SGUESTMERGEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_MERGE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service merges several guest profiles into a target profile.### Input- TARGET-GUEST: Mandatory. ObjID of the target guest profile- SOURCE-GUEST: Mandatory. ObjID of the guest profile(s) to be merged into TARGET_GUEST-
     * Additional optional settings for which fields are to be merged (birthDate, ...)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_MERGE_V001Request $body
     * @return \StructType\S_GUEST_MERGE_V001Response|bool
     */
    public function S_GUEST_MERGE_V001(\StructType\S_GUEST_MERGE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_MERGE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_MERGE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
