<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTLOYALTYCARDSMODIFYV ServiceType
 * @subpackage Services
 */
class SGUESTLOYALTYCARDSMODIFYV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_LOYALTY_CARDS_MODIFY_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service modifies a loyalty card for a given guest.### Input- LOYALTY-CARD-OBJID: ObjID of the loyalty card, which can be obtained from other defined services### Output
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_LOYALTY_CARDS_MODIFY_V001Request $body
     * @return \StructType\S_GUEST_LOYALTY_CARDS_MODIFY_V001Response|bool
     */
    public function S_GUEST_LOYALTY_CARDS_MODIFY_V001(\StructType\S_GUEST_LOYALTY_CARDS_MODIFY_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_LOYALTY_CARDS_MODIFY_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_LOYALTY_CARDS_MODIFY_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
