<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTCRITERIAMODIFYV ServiceType
 * @subpackage Services
 */
class SGUESTCRITERIAMODIFYV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_CRITERIA_MODIFY_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralModifies a guest criteria from a specific guest.### Input- GUEST-OBJID: ObjID of the guest, which can be obtained from defined servicesor- GUEST-CENTRALID: CentralID of the guest, which can be obtained from defined
     * services
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_CRITERIA_MODIFY_V001Request $body
     * @return \StructType\S_GUEST_CRITERIA_MODIFY_V001Response|bool
     */
    public function S_GUEST_CRITERIA_MODIFY_V001(\StructType\S_GUEST_CRITERIA_MODIFY_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_CRITERIA_MODIFY_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_CRITERIA_MODIFY_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
