<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGORESERVATIONSEARCHV ServiceType
 * @subpackage Services
 */
class SGORESERVATIONSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GO_RESERVATION_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for reservations.### Input- kiosksearch: reservation number. Optional- name1: Name of the booker with "startsWith" matching. Optional- resnofrom: start reservation number. Optional- resnoto: end
     * reservation number. Optional- gdsresnumber: GDS number of the reservation. Optional- arrival: arrival date of the reservation. Optional- departure: departure date of the reservation. Optional- findPersons: "name1" will also match with persons not
     * just the reservation owner. Optional### OutputList of reservation matching the request
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GO_RESERVATION_SEARCH_V001Request $body
     * @return \StructType\S_GO_RESERVATION_SEARCH_V001Response|bool
     */
    public function S_GO_RESERVATION_SEARCH_V001(\StructType\S_GO_RESERVATION_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GO_RESERVATION_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GO_RESERVATION_SEARCH_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
