<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGOPERSONMODIFYV ServiceType
 * @subpackage Services
 */
class SGOPERSONMODIFYV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GO_PERSON_MODIFY_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service modifies a person.### Input- PERSON-OBJID:ObjID of the person, which can be obtained from defined services. Mandatory- All data to be changed
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GO_PERSON_MODIFY_V001Request $body
     * @return \StructType\S_GO_PERSON_MODIFY_V001Response|bool
     */
    public function S_GO_PERSON_MODIFY_V001(\StructType\S_GO_PERSON_MODIFY_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GO_PERSON_MODIFY_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GO_PERSON_MODIFY_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
