<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGOCONFIGV ServiceType
 * @subpackage Services
 */
class SGOCONFIGV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GO_CONFIG_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns registry data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GO_CONFIG_V001Request $body
     * @return \StructType\S_GO_CONFIG_V001Response|bool
     */
    public function S_GO_CONFIG_V001(\StructType\S_GO_CONFIG_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GO_CONFIG_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GO_CONFIG_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns registry data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GO_CONFIG_V002Request $body
     * @return \StructType\S_GO_CONFIG_V002Response|bool
     */
    public function S_GO_CONFIG_V002(\StructType\S_GO_CONFIG_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GO_CONFIG_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GO_CONFIG_V001Response|\StructType\S_GO_CONFIG_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
