<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SEVENTRESERVATIONTRAILNODEGETV ServiceType
 * @subpackage Services
 */
class SEVENTRESERVATIONTRAILNODEGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_EVENT_RESERVATION_TRAIL_NODE_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns all trails stored below an event reservation.### Input- EVENT-RESERVATION-OBJID: ObjID of the event reservation### Output- Node1Type: The first node from trail structure. Value is always 4 characters
     * long -> e.g. 0000.- Node2Type: Increasing number below the NodeType (0000, 0001, 0002 and so on...)- description: description from trail- status: combo box("ts") key value- beginDate: format: yyyy-mm-DD- beginTime: format: hh:mm- endDate: format:
     * yyyy-mm-DD- endTime: format: hh:mm- user:sihot userID- comment: string comment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request $body
     * @return \StructType\S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Response|bool
     */
    public function S_EVENT_RESERVATION_TRAIL_NODE_GET_V001(\StructType\S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_EVENT_RESERVATION_TRAIL_NODE_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
