<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SDISCOUNTSEARCHV ServiceType
 * @subpackage Services
 */
class SDISCOUNTSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_DISCOUNT_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for discounts.### Input- Date from- Date to- Discount group - Service type- Service code- Rate segment- Rate category- Rate filter: by default this filter is set with "All rate filters". This value
     * can be override with the following registries:- Standard rate filter [8618]- Do not allow automatic setting of service filter in all service filters [9732]### OutputList of discounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_DISCOUNT_SEARCH_V001Request $body
     * @return \StructType\S_DISCOUNT_SEARCH_V001Response|bool
     */
    public function S_DISCOUNT_SEARCH_V001(\StructType\S_DISCOUNT_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_DISCOUNT_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_DISCOUNT_SEARCH_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
