<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SCOMBOBOXSEARCHV ServiceType
 * @subpackage Services
 */
class SCOMBOBOXSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_COMBOBOX_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for combo box entries by a specific type.The entries can be optionally filtered by a specific language.### Input- Type: Mandatory. The combo box type.- Language: Optional. Get the combo box entries in
     * a specific language. If no language is given, the entries will be returned in all available languages.### Output- Description: The name/description of the combo box.- Entries: Entries grouped by language - Language: The language of the Group - Entry:
     * The list of combo box entries - Key: The unique identifier of the combo box entry. - Value: The text of the combo box entry. - Sorting: Display order of the combo box entry.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_COMBOBOX_SEARCH_V001Request $body
     * @return \StructType\S_COMBOBOX_SEARCH_V001Response|bool
     */
    public function S_COMBOBOX_SEARCH_V001(\StructType\S_COMBOBOX_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_COMBOBOX_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_COMBOBOX_SEARCH_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service searches for combo box entries by a specific type.The entries can be optionally filtered by a specific language.### Input- Type: Mandatory. The combo box type.- Language: Optional. Get the combo box entries in
     * a specific language. If no language is given, the entries will be returned in all available languages.### Output- Description: The name/description of the combo box.- Entries: Entries grouped by language - Language: The language of the Group - Entry:
     * The list of combo box entries - Key: The unique identifier of the combo box entry.- Value: The text of the combo box entry.- Sorting: Display order of the combo box entry.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_COMBOBOX_SEARCH_V002Request $body
     * @return \StructType\S_COMBOBOX_SEARCH_V002Response|bool
     */
    public function S_COMBOBOX_SEARCH_V002(\StructType\S_COMBOBOX_SEARCH_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_COMBOBOX_SEARCH_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_COMBOBOX_SEARCH_V01
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_COMBOBOX_SEARCH_V001](../S_COMBOBOX_SEARCH_V001) - Replaced due to naming convention### GeneralThis service searches for combo box entries by a specific type;The entries
     * can be optionally filtered by a specific language.### Input- Type: Mandatory. The combo box type.- Language: Optional. Get the combo box entries in a specific language. If no language is given, the entries will be returned in all available
     * languages.### Output- Description: The name/description of the combo box.- Entries: Entries grouped by language - Language: The language of the Group - Entry: The list of combo box entries - Key: The unique identifier of the combo box entry. - Value:
     * The text of the combo box entry. - Sorting: Display order of the combo box entry.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_COMBOBOX_SEARCH_V01Request $body
     * @return \StructType\S_COMBOBOX_SEARCH_V01Response|bool
     */
    public function S_COMBOBOX_SEARCH_V01(\StructType\S_COMBOBOX_SEARCH_V01Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_COMBOBOX_SEARCH_V01($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_COMBOBOX_SEARCH_V02
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_COMBOBOX_SEARCH_V002](../S_COMBOBOX_SEARCH_V002) - Replaced due to naming convention### GeneralThis service searches for combo box entries by a specific type;The entries
     * can be optionally filtered by a specific language.### Input- Type: Mandatory. The combo box type.- Language: Optional. Get the combo box entries in a specific language. If no language is given, the entries will be returned in all available
     * languages.### Output- Description: The name/description of the combo box.- Entries: Entries grouped by language - Language: The language of the Group - Entry: The list of combo box entries - Key: The unique identifier of the combo box entry. - Value:
     * The text of the combo box entry. - Sorting: Display order of the combo box entry.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_COMBOBOX_SEARCH_V02Request $body
     * @return \StructType\S_COMBOBOX_SEARCH_V02Response|bool
     */
    public function S_COMBOBOX_SEARCH_V02(\StructType\S_COMBOBOX_SEARCH_V02Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_COMBOBOX_SEARCH_V02($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_COMBOBOX_SEARCH_V001Response|\StructType\S_COMBOBOX_SEARCH_V002Response|\StructType\S_COMBOBOX_SEARCH_V01Response|\StructType\S_COMBOBOX_SEARCH_V02Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
