<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SBEDCATEGORYMASTERFILEINTERNETGETV ServiceType
 * @subpackage Services
 */
class SBEDCATEGORYMASTERFILEINTERNETGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns the internet availability of a given bed category. ### Input- Bed CATEGORY-OBJID: Object ID of the category, which can be obtained from other defined services. Mandatory.### OutputList with internet
     * availability.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request $body
     * @return \StructType\S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Response|bool
     */
    public function S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001(\StructType\S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
