<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SBEDCATEGORYMASTERFILECOMMENTSTOREV ServiceType
 * @subpackage Services
 */
class SBEDCATEGORYMASTERFILECOMMENTSTOREV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service modifies the comments of a given bed category. The previous information will be deleted and the new information will be stored. ### Input- Bed CATEGORY-OBJID: Object ID of the category, which can be obtained
     * from other defined services. Mandatory.- LANGUAGE-COMMENT: Language comments per language code and comment information. Mandatory.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request $body
     * @return \StructType\S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Response|bool
     */
    public function S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001(\StructType\S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
