<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SAUTHENTICATEHOTELV ServiceType
 * @subpackage Services
 */
class SAUTHENTICATEHOTELV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_AUTHENTICATE_HOTEL_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service performs a new authentication for a hotel change. If the authentication is successful, a securityID is returned and can be used to access all other available services within the new hotel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_AUTHENTICATE_HOTEL_V001Request $body
     * @return \StructType\S_AUTHENTICATE_HOTEL_V001Response|bool
     */
    public function S_AUTHENTICATE_HOTEL_V001(\StructType\S_AUTHENTICATE_HOTEL_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_AUTHENTICATE_HOTEL_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_AUTHENTICATE_HOTEL_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
