<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SACLINFOGETV ServiceType
 * @subpackage Services
 */
class SACLINFOGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ACL_INFO_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service is used to query ACL rights that apply to the current user as determined by the SecurityID.### InputIn addition to the SecurityID, the required ACL right must also be specified using type, key and subkey:-
     * layout rights: - type: 0 - key: layout-id (example: ID_SIHOT_PACKAGE_MASTER) - subkey: <empty> - right: view right- function rights: - type: 1 - key: business object class (example: BO_PackageMasterFile) - subkey: function (example: update) - right:
     * execute right- relation rights: - type: 2 - key: business object class (example: BO_PackageMasterFile) - subkey: relation (example: getPartLists) - right: execute right- batch rights: - type: 5 - key: batch name (example: anreiseliste) - subkey:
     * <empty></empty> - right: view right- service rights: - type: 6 - key: service id (example: GuestSearch) - subkey: <empty></empty> - right: execute right- feature rights: - type: 7 - key: feature number (example: 5 /* disable overbooking flag in a
     * reservation *[:slash:]) - subkey: <empty></empty> - right: execute right### OutputThe service will return information about the required ACL right (execution right or view right, see above).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACL_INFO_GET_V001Request $body
     * @return \StructType\S_ACL_INFO_GET_V001Response|bool
     */
    public function S_ACL_INFO_GET_V001(\StructType\S_ACL_INFO_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACL_INFO_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ACL_INFO_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
