<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate ServiceType
 * @subpackage Services
 */
class Authenticate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Authenticate
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_AUTHENTICATE_V001](../S_AUTHENTICATE_V001) - Replaced due to naming convention### GeneralThis service performs an authentication. If the authentication is successful, a
     * securityID is returned and can be used to access all other available services.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticateRequest $body
     * @return \StructType\AuthenticateResponse|bool
     */
    public function Authenticate(\StructType\AuthenticateRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Authenticate($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthenticateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
