<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://partner-api.sihot.com/PDOCS/API/CBS/SihotServices01?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://partner-api.sihot.com/PDOCS/API/CBS/SihotServices01?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \ServiceType\Authenticate($options);
/**
 * Sample call for Authenticate operation/method
 */
if ($authenticate->Authenticate(new \StructType\AuthenticateRequest()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for GIFTVOUCHERREDEEMV ServiceType
 */
$gIFTVOUCHERREDEEMV = new \ServiceType\GIFTVOUCHERREDEEMV($options);
/**
 * Sample call for GIFT_VOUCHER_REDEEM_V01 operation/method
 */
if ($gIFTVOUCHERREDEEMV->GIFT_VOUCHER_REDEEM_V01(new \StructType\GIFT_VOUCHER_REDEEM_V01Request()) !== false) {
    print_r($gIFTVOUCHERREDEEMV->getResult());
} else {
    print_r($gIFTVOUCHERREDEEMV->getLastError());
}
/**
 * Samples for GIFTVOUCHERSEARCHV ServiceType
 */
$gIFTVOUCHERSEARCHV = new \ServiceType\GIFTVOUCHERSEARCHV($options);
/**
 * Sample call for GIFT_VOUCHER_SEARCH_V01 operation/method
 */
if ($gIFTVOUCHERSEARCHV->GIFT_VOUCHER_SEARCH_V01(new \StructType\GIFT_VOUCHER_SEARCH_V01Request()) !== false) {
    print_r($gIFTVOUCHERSEARCHV->getResult());
} else {
    print_r($gIFTVOUCHERSEARCHV->getLastError());
}
/**
 * Samples for GIFTVOUCHERSELLV ServiceType
 */
$gIFTVOUCHERSELLV = new \ServiceType\GIFTVOUCHERSELLV($options);
/**
 * Sample call for GIFT_VOUCHER_SELL_V01 operation/method
 */
if ($gIFTVOUCHERSELLV->GIFT_VOUCHER_SELL_V01(new \StructType\GIFT_VOUCHER_SELL_V01Request()) !== false) {
    print_r($gIFTVOUCHERSELLV->getResult());
} else {
    print_r($gIFTVOUCHERSELLV->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetCategoryMapping operation/method
 */
if ($get->GetCategoryMapping(new \StructType\GetCategoryMappingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPackageMapping operation/method
 */
if ($get->GetPackageMapping(new \StructType\GetPackageMappingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServiceMapping operation/method
 */
if ($get->GetServiceMapping(new \StructType\GetServiceMappingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for SACCOUNTADDSERVICEV ServiceType
 */
$sACCOUNTADDSERVICEV = new \ServiceType\SACCOUNTADDSERVICEV($options);
/**
 * Sample call for S_ACCOUNT_ADD_SERVICE_V001 operation/method
 */
if ($sACCOUNTADDSERVICEV->S_ACCOUNT_ADD_SERVICE_V001(new \StructType\S_ACCOUNT_ADD_SERVICE_V001Request()) !== false) {
    print_r($sACCOUNTADDSERVICEV->getResult());
} else {
    print_r($sACCOUNTADDSERVICEV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_ADD_SERVICE_V002 operation/method
 */
if ($sACCOUNTADDSERVICEV->S_ACCOUNT_ADD_SERVICE_V002(new \StructType\S_ACCOUNT_ADD_SERVICE_V002Request()) !== false) {
    print_r($sACCOUNTADDSERVICEV->getResult());
} else {
    print_r($sACCOUNTADDSERVICEV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_ADD_SERVICE_V003 operation/method
 */
if ($sACCOUNTADDSERVICEV->S_ACCOUNT_ADD_SERVICE_V003(new \StructType\S_ACCOUNT_ADD_SERVICE_V003Request()) !== false) {
    print_r($sACCOUNTADDSERVICEV->getResult());
} else {
    print_r($sACCOUNTADDSERVICEV->getLastError());
}
/**
 * Samples for SACCOUNTADDSERVICEWITHMANUALRATEV ServiceType
 */
$sACCOUNTADDSERVICEWITHMANUALRATEV = new \ServiceType\SACCOUNTADDSERVICEWITHMANUALRATEV($options);
/**
 * Sample call for S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001 operation/method
 */
if ($sACCOUNTADDSERVICEWITHMANUALRATEV->S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001(new \StructType\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001Request()) !== false) {
    print_r($sACCOUNTADDSERVICEWITHMANUALRATEV->getResult());
} else {
    print_r($sACCOUNTADDSERVICEWITHMANUALRATEV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002 operation/method
 */
if ($sACCOUNTADDSERVICEWITHMANUALRATEV->S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002(new \StructType\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request()) !== false) {
    print_r($sACCOUNTADDSERVICEWITHMANUALRATEV->getResult());
} else {
    print_r($sACCOUNTADDSERVICEWITHMANUALRATEV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003 operation/method
 */
if ($sACCOUNTADDSERVICEWITHMANUALRATEV->S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003(new \StructType\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003Request()) !== false) {
    print_r($sACCOUNTADDSERVICEWITHMANUALRATEV->getResult());
} else {
    print_r($sACCOUNTADDSERVICEWITHMANUALRATEV->getLastError());
}
/**
 * Samples for SACCOUNTCANCELSERVICEV ServiceType
 */
$sACCOUNTCANCELSERVICEV = new \ServiceType\SACCOUNTCANCELSERVICEV($options);
/**
 * Sample call for S_ACCOUNT_CANCEL_SERVICE_V001 operation/method
 */
if ($sACCOUNTCANCELSERVICEV->S_ACCOUNT_CANCEL_SERVICE_V001(new \StructType\S_ACCOUNT_CANCEL_SERVICE_V001Request()) !== false) {
    print_r($sACCOUNTCANCELSERVICEV->getResult());
} else {
    print_r($sACCOUNTCANCELSERVICEV->getLastError());
}
/**
 * Samples for SACCOUNTGETV ServiceType
 */
$sACCOUNTGETV = new \ServiceType\SACCOUNTGETV($options);
/**
 * Sample call for S_ACCOUNT_GET_V001 operation/method
 */
if ($sACCOUNTGETV->S_ACCOUNT_GET_V001(new \StructType\S_ACCOUNT_GET_V001Request()) !== false) {
    print_r($sACCOUNTGETV->getResult());
} else {
    print_r($sACCOUNTGETV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_GET_V002 operation/method
 */
if ($sACCOUNTGETV->S_ACCOUNT_GET_V002(new \StructType\S_ACCOUNT_GET_V002Request()) !== false) {
    print_r($sACCOUNTGETV->getResult());
} else {
    print_r($sACCOUNTGETV->getLastError());
}
/**
 * Samples for SACCOUNTINACTIVATEV ServiceType
 */
$sACCOUNTINACTIVATEV = new \ServiceType\SACCOUNTINACTIVATEV($options);
/**
 * Sample call for S_ACCOUNT_INACTIVATE_V001 operation/method
 */
if ($sACCOUNTINACTIVATEV->S_ACCOUNT_INACTIVATE_V001(new \StructType\S_ACCOUNT_INACTIVATE_V001Request()) !== false) {
    print_r($sACCOUNTINACTIVATEV->getResult());
} else {
    print_r($sACCOUNTINACTIVATEV->getLastError());
}
/**
 * Samples for SACCOUNTPAYMENTADDV ServiceType
 */
$sACCOUNTPAYMENTADDV = new \ServiceType\SACCOUNTPAYMENTADDV($options);
/**
 * Sample call for S_ACCOUNT_PAYMENT_ADD_V001 operation/method
 */
if ($sACCOUNTPAYMENTADDV->S_ACCOUNT_PAYMENT_ADD_V001(new \StructType\S_ACCOUNT_PAYMENT_ADD_V001Request()) !== false) {
    print_r($sACCOUNTPAYMENTADDV->getResult());
} else {
    print_r($sACCOUNTPAYMENTADDV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_PAYMENT_ADD_V002 operation/method
 */
if ($sACCOUNTPAYMENTADDV->S_ACCOUNT_PAYMENT_ADD_V002(new \StructType\S_ACCOUNT_PAYMENT_ADD_V002Request()) !== false) {
    print_r($sACCOUNTPAYMENTADDV->getResult());
} else {
    print_r($sACCOUNTPAYMENTADDV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_PAYMENT_ADD_V003 operation/method
 */
if ($sACCOUNTPAYMENTADDV->S_ACCOUNT_PAYMENT_ADD_V003(new \StructType\S_ACCOUNT_PAYMENT_ADD_V003Request()) !== false) {
    print_r($sACCOUNTPAYMENTADDV->getResult());
} else {
    print_r($sACCOUNTPAYMENTADDV->getLastError());
}
/**
 * Samples for SACCOUNTPAYMENTINSTRUCTIONSGETV ServiceType
 */
$sACCOUNTPAYMENTINSTRUCTIONSGETV = new \ServiceType\SACCOUNTPAYMENTINSTRUCTIONSGETV($options);
/**
 * Sample call for S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001 operation/method
 */
if ($sACCOUNTPAYMENTINSTRUCTIONSGETV->S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001(new \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Request()) !== false) {
    print_r($sACCOUNTPAYMENTINSTRUCTIONSGETV->getResult());
} else {
    print_r($sACCOUNTPAYMENTINSTRUCTIONSGETV->getLastError());
}
/**
 * Samples for SACCOUNTPAYMENTINSTRUCTIONSSETV ServiceType
 */
$sACCOUNTPAYMENTINSTRUCTIONSSETV = new \ServiceType\SACCOUNTPAYMENTINSTRUCTIONSSETV($options);
/**
 * Sample call for S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001 operation/method
 */
if ($sACCOUNTPAYMENTINSTRUCTIONSSETV->S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001(new \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request()) !== false) {
    print_r($sACCOUNTPAYMENTINSTRUCTIONSSETV->getResult());
} else {
    print_r($sACCOUNTPAYMENTINSTRUCTIONSSETV->getLastError());
}
/**
 * Samples for SACCOUNTPOSTPACKAGEINADVANCEV ServiceType
 */
$sACCOUNTPOSTPACKAGEINADVANCEV = new \ServiceType\SACCOUNTPOSTPACKAGEINADVANCEV($options);
/**
 * Sample call for S_ACCOUNT_POST_PACKAGE_IN_ADVANCE_V001 operation/method
 */
if ($sACCOUNTPOSTPACKAGEINADVANCEV->S_ACCOUNT_POST_PACKAGE_IN_ADVANCE_V001(new \StructType\S_ACCOUNT_POST_PACKAGE_IN_ADVANCE_V001Request()) !== false) {
    print_r($sACCOUNTPOSTPACKAGEINADVANCEV->getResult());
} else {
    print_r($sACCOUNTPOSTPACKAGEINADVANCEV->getLastError());
}
/**
 * Samples for SACCOUNTSEARCHV ServiceType
 */
$sACCOUNTSEARCHV = new \ServiceType\SACCOUNTSEARCHV($options);
/**
 * Sample call for S_ACCOUNT_SEARCH_V001 operation/method
 */
if ($sACCOUNTSEARCHV->S_ACCOUNT_SEARCH_V001(new \StructType\S_ACCOUNT_SEARCH_V001Request()) !== false) {
    print_r($sACCOUNTSEARCHV->getResult());
} else {
    print_r($sACCOUNTSEARCHV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_SEARCH_V002 operation/method
 */
if ($sACCOUNTSEARCHV->S_ACCOUNT_SEARCH_V002(new \StructType\S_ACCOUNT_SEARCH_V002Request()) !== false) {
    print_r($sACCOUNTSEARCHV->getResult());
} else {
    print_r($sACCOUNTSEARCHV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_SEARCH_V003 operation/method
 */
if ($sACCOUNTSEARCHV->S_ACCOUNT_SEARCH_V003(new \StructType\S_ACCOUNT_SEARCH_V003Request()) !== false) {
    print_r($sACCOUNTSEARCHV->getResult());
} else {
    print_r($sACCOUNTSEARCHV->getLastError());
}
/**
 * Samples for SACCOUNTSERVICEADDV ServiceType
 */
$sACCOUNTSERVICEADDV = new \ServiceType\SACCOUNTSERVICEADDV($options);
/**
 * Sample call for S_ACCOUNT_SERVICE_ADD_V001 operation/method
 */
if ($sACCOUNTSERVICEADDV->S_ACCOUNT_SERVICE_ADD_V001(new \StructType\S_ACCOUNT_SERVICE_ADD_V001Request()) !== false) {
    print_r($sACCOUNTSERVICEADDV->getResult());
} else {
    print_r($sACCOUNTSERVICEADDV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_SERVICE_ADD_V002 operation/method
 */
if ($sACCOUNTSERVICEADDV->S_ACCOUNT_SERVICE_ADD_V002(new \StructType\S_ACCOUNT_SERVICE_ADD_V002Request()) !== false) {
    print_r($sACCOUNTSERVICEADDV->getResult());
} else {
    print_r($sACCOUNTSERVICEADDV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_SERVICE_ADD_V003 operation/method
 */
if ($sACCOUNTSERVICEADDV->S_ACCOUNT_SERVICE_ADD_V003(new \StructType\S_ACCOUNT_SERVICE_ADD_V003Request()) !== false) {
    print_r($sACCOUNTSERVICEADDV->getResult());
} else {
    print_r($sACCOUNTSERVICEADDV->getLastError());
}
/**
 * Samples for SACCOUNTSERVICECANCELV ServiceType
 */
$sACCOUNTSERVICECANCELV = new \ServiceType\SACCOUNTSERVICECANCELV($options);
/**
 * Sample call for S_ACCOUNT_SERVICE_CANCEL_V001 operation/method
 */
if ($sACCOUNTSERVICECANCELV->S_ACCOUNT_SERVICE_CANCEL_V001(new \StructType\S_ACCOUNT_SERVICE_CANCEL_V001Request()) !== false) {
    print_r($sACCOUNTSERVICECANCELV->getResult());
} else {
    print_r($sACCOUNTSERVICECANCELV->getLastError());
}
/**
 * Samples for SACCOUNTSERVICEWITHMANUALRATEADDV ServiceType
 */
$sACCOUNTSERVICEWITHMANUALRATEADDV = new \ServiceType\SACCOUNTSERVICEWITHMANUALRATEADDV($options);
/**
 * Sample call for S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V001 operation/method
 */
if ($sACCOUNTSERVICEWITHMANUALRATEADDV->S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V001(new \StructType\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V001Request()) !== false) {
    print_r($sACCOUNTSERVICEWITHMANUALRATEADDV->getResult());
} else {
    print_r($sACCOUNTSERVICEWITHMANUALRATEADDV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V002 operation/method
 */
if ($sACCOUNTSERVICEWITHMANUALRATEADDV->S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V002(new \StructType\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V002Request()) !== false) {
    print_r($sACCOUNTSERVICEWITHMANUALRATEADDV->getResult());
} else {
    print_r($sACCOUNTSERVICEWITHMANUALRATEADDV->getLastError());
}
/**
 * Sample call for S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V003 operation/method
 */
if ($sACCOUNTSERVICEWITHMANUALRATEADDV->S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V003(new \StructType\S_ACCOUNT_SERVICE_WITH_MANUAL_RATE_ADD_V003Request()) !== false) {
    print_r($sACCOUNTSERVICEWITHMANUALRATEADDV->getResult());
} else {
    print_r($sACCOUNTSERVICEWITHMANUALRATEADDV->getLastError());
}
/**
 * Samples for SACCOUNTSETTLEV ServiceType
 */
$sACCOUNTSETTLEV = new \ServiceType\SACCOUNTSETTLEV($options);
/**
 * Sample call for S_ACCOUNT_SETTLE_V001 operation/method
 */
if ($sACCOUNTSETTLEV->S_ACCOUNT_SETTLE_V001(new \StructType\S_ACCOUNT_SETTLE_V001Request()) !== false) {
    print_r($sACCOUNTSETTLEV->getResult());
} else {
    print_r($sACCOUNTSETTLEV->getLastError());
}
/**
 * Samples for SACCOUNTV ServiceType
 */
$sACCOUNTV = new \ServiceType\SACCOUNTV($options);
/**
 * Sample call for S_ACCOUNT_V001 operation/method
 */
if ($sACCOUNTV->S_ACCOUNT_V001(new \StructType\S_ACCOUNT_V001Request()) !== false) {
    print_r($sACCOUNTV->getResult());
} else {
    print_r($sACCOUNTV->getLastError());
}
/**
 * Samples for SACLINFOGETV ServiceType
 */
$sACLINFOGETV = new \ServiceType\SACLINFOGETV($options);
/**
 * Sample call for S_ACL_INFO_GET_V001 operation/method
 */
if ($sACLINFOGETV->S_ACL_INFO_GET_V001(new \StructType\S_ACL_INFO_GET_V001Request()) !== false) {
    print_r($sACLINFOGETV->getResult());
} else {
    print_r($sACLINFOGETV->getLastError());
}
/**
 * Samples for SACTIVITYADDV ServiceType
 */
$sACTIVITYADDV = new \ServiceType\SACTIVITYADDV($options);
/**
 * Sample call for S_ACTIVITY_ADD_V001 operation/method
 */
if ($sACTIVITYADDV->S_ACTIVITY_ADD_V001(new \StructType\S_ACTIVITY_ADD_V001Request()) !== false) {
    print_r($sACTIVITYADDV->getResult());
} else {
    print_r($sACTIVITYADDV->getLastError());
}
/**
 * Samples for SACTIVITYGETV ServiceType
 */
$sACTIVITYGETV = new \ServiceType\SACTIVITYGETV($options);
/**
 * Sample call for S_ACTIVITY_GET_V001 operation/method
 */
if ($sACTIVITYGETV->S_ACTIVITY_GET_V001(new \StructType\S_ACTIVITY_GET_V001Request()) !== false) {
    print_r($sACTIVITYGETV->getResult());
} else {
    print_r($sACTIVITYGETV->getLastError());
}
/**
 * Sample call for S_ACTIVITY_GET_V002 operation/method
 */
if ($sACTIVITYGETV->S_ACTIVITY_GET_V002(new \StructType\S_ACTIVITY_GET_V002Request()) !== false) {
    print_r($sACTIVITYGETV->getResult());
} else {
    print_r($sACTIVITYGETV->getLastError());
}
/**
 * Samples for SACTIVITYMODIFYSTATUSV ServiceType
 */
$sACTIVITYMODIFYSTATUSV = new \ServiceType\SACTIVITYMODIFYSTATUSV($options);
/**
 * Sample call for S_ACTIVITY_MODIFY_STATUS_V001 operation/method
 */
if ($sACTIVITYMODIFYSTATUSV->S_ACTIVITY_MODIFY_STATUS_V001(new \StructType\S_ACTIVITY_MODIFY_STATUS_V001Request()) !== false) {
    print_r($sACTIVITYMODIFYSTATUSV->getResult());
} else {
    print_r($sACTIVITYMODIFYSTATUSV->getLastError());
}
/**
 * Samples for SACTIVITYMODIFYV ServiceType
 */
$sACTIVITYMODIFYV = new \ServiceType\SACTIVITYMODIFYV($options);
/**
 * Sample call for S_ACTIVITY_MODIFY_V001 operation/method
 */
if ($sACTIVITYMODIFYV->S_ACTIVITY_MODIFY_V001(new \StructType\S_ACTIVITY_MODIFY_V001Request()) !== false) {
    print_r($sACTIVITYMODIFYV->getResult());
} else {
    print_r($sACTIVITYMODIFYV->getLastError());
}
/**
 * Samples for SACTIVITYREMOVEV ServiceType
 */
$sACTIVITYREMOVEV = new \ServiceType\SACTIVITYREMOVEV($options);
/**
 * Sample call for S_ACTIVITY_REMOVE_V001 operation/method
 */
if ($sACTIVITYREMOVEV->S_ACTIVITY_REMOVE_V001(new \StructType\S_ACTIVITY_REMOVE_V001Request()) !== false) {
    print_r($sACTIVITYREMOVEV->getResult());
} else {
    print_r($sACTIVITYREMOVEV->getLastError());
}
/**
 * Samples for SACTIVITYSEARCHV ServiceType
 */
$sACTIVITYSEARCHV = new \ServiceType\SACTIVITYSEARCHV($options);
/**
 * Sample call for S_ACTIVITY_SEARCH_V001 operation/method
 */
if ($sACTIVITYSEARCHV->S_ACTIVITY_SEARCH_V001(new \StructType\S_ACTIVITY_SEARCH_V001Request()) !== false) {
    print_r($sACTIVITYSEARCHV->getResult());
} else {
    print_r($sACTIVITYSEARCHV->getLastError());
}
/**
 * Sample call for S_ACTIVITY_SEARCH_V002 operation/method
 */
if ($sACTIVITYSEARCHV->S_ACTIVITY_SEARCH_V002(new \StructType\S_ACTIVITY_SEARCH_V002Request()) !== false) {
    print_r($sACTIVITYSEARCHV->getResult());
} else {
    print_r($sACTIVITYSEARCHV->getLastError());
}
/**
 * Samples for SACTIVITYSTATUSMODIFYV ServiceType
 */
$sACTIVITYSTATUSMODIFYV = new \ServiceType\SACTIVITYSTATUSMODIFYV($options);
/**
 * Sample call for S_ACTIVITY_STATUS_MODIFY_V001 operation/method
 */
if ($sACTIVITYSTATUSMODIFYV->S_ACTIVITY_STATUS_MODIFY_V001(new \StructType\S_ACTIVITY_STATUS_MODIFY_V001Request()) !== false) {
    print_r($sACTIVITYSTATUSMODIFYV->getResult());
} else {
    print_r($sACTIVITYSTATUSMODIFYV->getLastError());
}
/**
 * Samples for SACTIVIYGETV ServiceType
 */
$sACTIVIYGETV = new \ServiceType\SACTIVIYGETV($options);
/**
 * Sample call for S_ACTIVIY_GET_V001 operation/method
 */
if ($sACTIVIYGETV->S_ACTIVIY_GET_V001(new \StructType\S_ACTIVIY_GET_V001Request()) !== false) {
    print_r($sACTIVIYGETV->getResult());
} else {
    print_r($sACTIVIYGETV->getLastError());
}
/**
 * Sample call for S_ACTIVIY_GET_V002 operation/method
 */
if ($sACTIVIYGETV->S_ACTIVIY_GET_V002(new \StructType\S_ACTIVIY_GET_V002Request()) !== false) {
    print_r($sACTIVIYGETV->getResult());
} else {
    print_r($sACTIVIYGETV->getLastError());
}
/**
 * Samples for SACTIVIYMODIFYSTATUSV ServiceType
 */
$sACTIVIYMODIFYSTATUSV = new \ServiceType\SACTIVIYMODIFYSTATUSV($options);
/**
 * Sample call for S_ACTIVIY_MODIFY_STATUS_V001 operation/method
 */
if ($sACTIVIYMODIFYSTATUSV->S_ACTIVIY_MODIFY_STATUS_V001(new \StructType\S_ACTIVIY_MODIFY_STATUS_V001Request()) !== false) {
    print_r($sACTIVIYMODIFYSTATUSV->getResult());
} else {
    print_r($sACTIVIYMODIFYSTATUSV->getLastError());
}
/**
 * Samples for SACTIVIYMODIFYV ServiceType
 */
$sACTIVIYMODIFYV = new \ServiceType\SACTIVIYMODIFYV($options);
/**
 * Sample call for S_ACTIVIY_MODIFY_V001 operation/method
 */
if ($sACTIVIYMODIFYV->S_ACTIVIY_MODIFY_V001(new \StructType\S_ACTIVIY_MODIFY_V001Request()) !== false) {
    print_r($sACTIVIYMODIFYV->getResult());
} else {
    print_r($sACTIVIYMODIFYV->getLastError());
}
/**
 * Samples for SADDSETTLEMENTPROFILEV ServiceType
 */
$sADDSETTLEMENTPROFILEV = new \ServiceType\SADDSETTLEMENTPROFILEV($options);
/**
 * Sample call for S_ADD_SETTLEMENT_PROFILE_V001 operation/method
 */
if ($sADDSETTLEMENTPROFILEV->S_ADD_SETTLEMENT_PROFILE_V001(new \StructType\S_ADD_SETTLEMENT_PROFILE_V001Request()) !== false) {
    print_r($sADDSETTLEMENTPROFILEV->getResult());
} else {
    print_r($sADDSETTLEMENTPROFILEV->getLastError());
}
/**
 * Samples for SALLOTMENTCONTRACTFORECASTGETV ServiceType
 */
$sALLOTMENTCONTRACTFORECASTGETV = new \ServiceType\SALLOTMENTCONTRACTFORECASTGETV($options);
/**
 * Sample call for S_ALLOTMENT_CONTRACTFORECAST_GET_V001 operation/method
 */
if ($sALLOTMENTCONTRACTFORECASTGETV->S_ALLOTMENT_CONTRACTFORECAST_GET_V001(new \StructType\S_ALLOTMENT_CONTRACTFORECAST_GET_V001Request()) !== false) {
    print_r($sALLOTMENTCONTRACTFORECASTGETV->getResult());
} else {
    print_r($sALLOTMENTCONTRACTFORECASTGETV->getLastError());
}
/**
 * Samples for SALLOTMENTDETAILSGETV ServiceType
 */
$sALLOTMENTDETAILSGETV = new \ServiceType\SALLOTMENTDETAILSGETV($options);
/**
 * Sample call for S_ALLOTMENT_DETAILS_GET_V001 operation/method
 */
if ($sALLOTMENTDETAILSGETV->S_ALLOTMENT_DETAILS_GET_V001(new \StructType\S_ALLOTMENT_DETAILS_GET_V001Request()) !== false) {
    print_r($sALLOTMENTDETAILSGETV->getResult());
} else {
    print_r($sALLOTMENTDETAILSGETV->getLastError());
}
/**
 * Samples for SALLOTMENTEXTERNALIDSGETV ServiceType
 */
$sALLOTMENTEXTERNALIDSGETV = new \ServiceType\SALLOTMENTEXTERNALIDSGETV($options);
/**
 * Sample call for S_ALLOTMENT_EXTERNALIDS_GET_V001 operation/method
 */
if ($sALLOTMENTEXTERNALIDSGETV->S_ALLOTMENT_EXTERNALIDS_GET_V001(new \StructType\S_ALLOTMENT_EXTERNALIDS_GET_V001Request()) !== false) {
    print_r($sALLOTMENTEXTERNALIDSGETV->getResult());
} else {
    print_r($sALLOTMENTEXTERNALIDSGETV->getLastError());
}
/**
 * Samples for SALLOTMENTFORECASTGETV ServiceType
 */
$sALLOTMENTFORECASTGETV = new \ServiceType\SALLOTMENTFORECASTGETV($options);
/**
 * Sample call for S_ALLOTMENT_FORECAST_GET_V001 operation/method
 */
if ($sALLOTMENTFORECASTGETV->S_ALLOTMENT_FORECAST_GET_V001(new \StructType\S_ALLOTMENT_FORECAST_GET_V001Request()) !== false) {
    print_r($sALLOTMENTFORECASTGETV->getResult());
} else {
    print_r($sALLOTMENTFORECASTGETV->getLastError());
}
/**
 * Samples for SALLOTMENTGETV ServiceType
 */
$sALLOTMENTGETV = new \ServiceType\SALLOTMENTGETV($options);
/**
 * Sample call for S_ALLOTMENT_GET_V001 operation/method
 */
if ($sALLOTMENTGETV->S_ALLOTMENT_GET_V001(new \StructType\S_ALLOTMENT_GET_V001Request()) !== false) {
    print_r($sALLOTMENTGETV->getResult());
} else {
    print_r($sALLOTMENTGETV->getLastError());
}
/**
 * Samples for SALLOTMENTPACKAGESGETV ServiceType
 */
$sALLOTMENTPACKAGESGETV = new \ServiceType\SALLOTMENTPACKAGESGETV($options);
/**
 * Sample call for S_ALLOTMENT_PACKAGES_GET_V001 operation/method
 */
if ($sALLOTMENTPACKAGESGETV->S_ALLOTMENT_PACKAGES_GET_V001(new \StructType\S_ALLOTMENT_PACKAGES_GET_V001Request()) !== false) {
    print_r($sALLOTMENTPACKAGESGETV->getResult());
} else {
    print_r($sALLOTMENTPACKAGESGETV->getLastError());
}
/**
 * Samples for SALLOTMENTRESTRICTIONSGETV ServiceType
 */
$sALLOTMENTRESTRICTIONSGETV = new \ServiceType\SALLOTMENTRESTRICTIONSGETV($options);
/**
 * Sample call for S_ALLOTMENT_RESTRICTIONS_GET_V001 operation/method
 */
if ($sALLOTMENTRESTRICTIONSGETV->S_ALLOTMENT_RESTRICTIONS_GET_V001(new \StructType\S_ALLOTMENT_RESTRICTIONS_GET_V001Request()) !== false) {
    print_r($sALLOTMENTRESTRICTIONSGETV->getResult());
} else {
    print_r($sALLOTMENTRESTRICTIONSGETV->getLastError());
}
/**
 * Sample call for S_ALLOTMENT_RESTRICTIONS_GET_V002 operation/method
 */
if ($sALLOTMENTRESTRICTIONSGETV->S_ALLOTMENT_RESTRICTIONS_GET_V002(new \StructType\S_ALLOTMENT_RESTRICTIONS_GET_V002Request()) !== false) {
    print_r($sALLOTMENTRESTRICTIONSGETV->getResult());
} else {
    print_r($sALLOTMENTRESTRICTIONSGETV->getLastError());
}
/**
 * Samples for SALLOTMENTRESTRICTIONSEARCHV ServiceType
 */
$sALLOTMENTRESTRICTIONSEARCHV = new \ServiceType\SALLOTMENTRESTRICTIONSEARCHV($options);
/**
 * Sample call for S_ALLOTMENT_RESTRICTION_SEARCH_V001 operation/method
 */
if ($sALLOTMENTRESTRICTIONSEARCHV->S_ALLOTMENT_RESTRICTION_SEARCH_V001(new \StructType\S_ALLOTMENT_RESTRICTION_SEARCH_V001Request()) !== false) {
    print_r($sALLOTMENTRESTRICTIONSEARCHV->getResult());
} else {
    print_r($sALLOTMENTRESTRICTIONSEARCHV->getLastError());
}
/**
 * Sample call for S_ALLOTMENT_RESTRICTION_SEARCH_V002 operation/method
 */
if ($sALLOTMENTRESTRICTIONSEARCHV->S_ALLOTMENT_RESTRICTION_SEARCH_V002(new \StructType\S_ALLOTMENT_RESTRICTION_SEARCH_V002Request()) !== false) {
    print_r($sALLOTMENTRESTRICTIONSEARCHV->getResult());
} else {
    print_r($sALLOTMENTRESTRICTIONSEARCHV->getLastError());
}
/**
 * Samples for SALLOTMENTSEARCHV ServiceType
 */
$sALLOTMENTSEARCHV = new \ServiceType\SALLOTMENTSEARCHV($options);
/**
 * Sample call for S_ALLOTMENT_SEARCH_V001 operation/method
 */
if ($sALLOTMENTSEARCHV->S_ALLOTMENT_SEARCH_V001(new \StructType\S_ALLOTMENT_SEARCH_V001Request()) !== false) {
    print_r($sALLOTMENTSEARCHV->getResult());
} else {
    print_r($sALLOTMENTSEARCHV->getLastError());
}
/**
 * Samples for SARRIVALSEARCHV ServiceType
 */
$sARRIVALSEARCHV = new \ServiceType\SARRIVALSEARCHV($options);
/**
 * Sample call for S_ARRIVAL_SEARCH_V001 operation/method
 */
if ($sARRIVALSEARCHV->S_ARRIVAL_SEARCH_V001(new \StructType\S_ARRIVAL_SEARCH_V001Request()) !== false) {
    print_r($sARRIVALSEARCHV->getResult());
} else {
    print_r($sARRIVALSEARCHV->getLastError());
}
/**
 * Sample call for S_ARRIVAL_SEARCH_V002 operation/method
 */
if ($sARRIVALSEARCHV->S_ARRIVAL_SEARCH_V002(new \StructType\S_ARRIVAL_SEARCH_V002Request()) !== false) {
    print_r($sARRIVALSEARCHV->getResult());
} else {
    print_r($sARRIVALSEARCHV->getLastError());
}
/**
 * Samples for SAUTHENTICATEHOTELV ServiceType
 */
$sAUTHENTICATEHOTELV = new \ServiceType\SAUTHENTICATEHOTELV($options);
/**
 * Sample call for S_AUTHENTICATE_HOTEL_V001 operation/method
 */
if ($sAUTHENTICATEHOTELV->S_AUTHENTICATE_HOTEL_V001(new \StructType\S_AUTHENTICATE_HOTEL_V001Request()) !== false) {
    print_r($sAUTHENTICATEHOTELV->getResult());
} else {
    print_r($sAUTHENTICATEHOTELV->getLastError());
}
/**
 * Samples for SAUTHENTICATEV ServiceType
 */
$sAUTHENTICATEV = new \ServiceType\SAUTHENTICATEV($options);
/**
 * Sample call for S_AUTHENTICATE_V001 operation/method
 */
if ($sAUTHENTICATEV->S_AUTHENTICATE_V001(new \StructType\S_AUTHENTICATE_V001Request()) !== false) {
    print_r($sAUTHENTICATEV->getResult());
} else {
    print_r($sAUTHENTICATEV->getLastError());
}
/**
 * Sample call for S_AUTHENTICATE_V002 operation/method
 */
if ($sAUTHENTICATEV->S_AUTHENTICATE_V002(new \StructType\S_AUTHENTICATE_V002Request()) !== false) {
    print_r($sAUTHENTICATEV->getResult());
} else {
    print_r($sAUTHENTICATEV->getLastError());
}
/**
 * Samples for SAUTHORISATIONCOMMITV ServiceType
 */
$sAUTHORISATIONCOMMITV = new \ServiceType\SAUTHORISATIONCOMMITV($options);
/**
 * Sample call for S_AUTHORISATION_COMMIT_V001 operation/method
 */
if ($sAUTHORISATIONCOMMITV->S_AUTHORISATION_COMMIT_V001(new \StructType\S_AUTHORISATION_COMMIT_V001Request()) !== false) {
    print_r($sAUTHORISATIONCOMMITV->getResult());
} else {
    print_r($sAUTHORISATIONCOMMITV->getLastError());
}
/**
 * Samples for SAUTOTASKCONFIRMATIONV ServiceType
 */
$sAUTOTASKCONFIRMATIONV = new \ServiceType\SAUTOTASKCONFIRMATIONV($options);
/**
 * Sample call for S_AUTOTASK_CONFIRMATION_V001 operation/method
 */
if ($sAUTOTASKCONFIRMATIONV->S_AUTOTASK_CONFIRMATION_V001(new \StructType\S_AUTOTASK_CONFIRMATION_V001Request()) !== false) {
    print_r($sAUTOTASKCONFIRMATIONV->getResult());
} else {
    print_r($sAUTOTASKCONFIRMATIONV->getLastError());
}
/**
 * Samples for SAUTOTASKERRORSETV ServiceType
 */
$sAUTOTASKERRORSETV = new \ServiceType\SAUTOTASKERRORSETV($options);
/**
 * Sample call for S_AUTOTASK_ERROR_SET_V001 operation/method
 */
if ($sAUTOTASKERRORSETV->S_AUTOTASK_ERROR_SET_V001(new \StructType\S_AUTOTASK_ERROR_SET_V001Request()) !== false) {
    print_r($sAUTOTASKERRORSETV->getResult());
} else {
    print_r($sAUTOTASKERRORSETV->getLastError());
}
/**
 * Samples for SAUTOTASKSETERRORV ServiceType
 */
$sAUTOTASKSETERRORV = new \ServiceType\SAUTOTASKSETERRORV($options);
/**
 * Sample call for S_AUTOTASK_SETERROR_V001 operation/method
 */
if ($sAUTOTASKSETERRORV->S_AUTOTASK_SETERROR_V001(new \StructType\S_AUTOTASK_SETERROR_V001Request()) !== false) {
    print_r($sAUTOTASKSETERRORV->getResult());
} else {
    print_r($sAUTOTASKSETERRORV->getLastError());
}
/**
 * Samples for SBEDCATEGORYMASTERFILECOMMENTGETV ServiceType
 */
$sBEDCATEGORYMASTERFILECOMMENTGETV = new \ServiceType\SBEDCATEGORYMASTERFILECOMMENTGETV($options);
/**
 * Sample call for S_BED_CATEGORY_MASTER_FILE_COMMENT_GET_V001 operation/method
 */
if ($sBEDCATEGORYMASTERFILECOMMENTGETV->S_BED_CATEGORY_MASTER_FILE_COMMENT_GET_V001(new \StructType\S_BED_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request()) !== false) {
    print_r($sBEDCATEGORYMASTERFILECOMMENTGETV->getResult());
} else {
    print_r($sBEDCATEGORYMASTERFILECOMMENTGETV->getLastError());
}
/**
 * Samples for SBEDCATEGORYMASTERFILECOMMENTSTOREV ServiceType
 */
$sBEDCATEGORYMASTERFILECOMMENTSTOREV = new \ServiceType\SBEDCATEGORYMASTERFILECOMMENTSTOREV($options);
/**
 * Sample call for S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001 operation/method
 */
if ($sBEDCATEGORYMASTERFILECOMMENTSTOREV->S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001(new \StructType\S_BED_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request()) !== false) {
    print_r($sBEDCATEGORYMASTERFILECOMMENTSTOREV->getResult());
} else {
    print_r($sBEDCATEGORYMASTERFILECOMMENTSTOREV->getLastError());
}
/**
 * Samples for SBEDCATEGORYMASTERFILEGETV ServiceType
 */
$sBEDCATEGORYMASTERFILEGETV = new \ServiceType\SBEDCATEGORYMASTERFILEGETV($options);
/**
 * Sample call for S_BED_CATEGORY_MASTER_FILE_GET_V001 operation/method
 */
if ($sBEDCATEGORYMASTERFILEGETV->S_BED_CATEGORY_MASTER_FILE_GET_V001(new \StructType\S_BED_CATEGORY_MASTER_FILE_GET_V001Request()) !== false) {
    print_r($sBEDCATEGORYMASTERFILEGETV->getResult());
} else {
    print_r($sBEDCATEGORYMASTERFILEGETV->getLastError());
}
/**
 * Samples for SBEDCATEGORYMASTERFILEINTERNETGETV ServiceType
 */
$sBEDCATEGORYMASTERFILEINTERNETGETV = new \ServiceType\SBEDCATEGORYMASTERFILEINTERNETGETV($options);
/**
 * Sample call for S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001 operation/method
 */
if ($sBEDCATEGORYMASTERFILEINTERNETGETV->S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001(new \StructType\S_BED_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request()) !== false) {
    print_r($sBEDCATEGORYMASTERFILEINTERNETGETV->getResult());
} else {
    print_r($sBEDCATEGORYMASTERFILEINTERNETGETV->getLastError());
}
/**
 * Samples for SBEDCATEGORYMASTERFILEINTERNETSTOREV ServiceType
 */
$sBEDCATEGORYMASTERFILEINTERNETSTOREV = new \ServiceType\SBEDCATEGORYMASTERFILEINTERNETSTOREV($options);
/**
 * Sample call for S_BED_CATEGORY_MASTER_FILE_INTERNET_STORE_V001 operation/method
 */
if ($sBEDCATEGORYMASTERFILEINTERNETSTOREV->S_BED_CATEGORY_MASTER_FILE_INTERNET_STORE_V001(new \StructType\S_BED_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request()) !== false) {
    print_r($sBEDCATEGORYMASTERFILEINTERNETSTOREV->getResult());
} else {
    print_r($sBEDCATEGORYMASTERFILEINTERNETSTOREV->getLastError());
}
/**
 * Samples for SBEDCATEGORYMASTERFILEOVERBOOKINGGETV ServiceType
 */
$sBEDCATEGORYMASTERFILEOVERBOOKINGGETV = new \ServiceType\SBEDCATEGORYMASTERFILEOVERBOOKINGGETV($options);
/**
 * Sample call for S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001 operation/method
 */
if ($sBEDCATEGORYMASTERFILEOVERBOOKINGGETV->S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001(new \StructType\S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request()) !== false) {
    print_r($sBEDCATEGORYMASTERFILEOVERBOOKINGGETV->getResult());
} else {
    print_r($sBEDCATEGORYMASTERFILEOVERBOOKINGGETV->getLastError());
}
/**
 * Samples for SBEDCATEGORYMASTERFILEOVERBOOKINGSTOREV ServiceType
 */
$sBEDCATEGORYMASTERFILEOVERBOOKINGSTOREV = new \ServiceType\SBEDCATEGORYMASTERFILEOVERBOOKINGSTOREV($options);
/**
 * Sample call for S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001
 * operation/method
 */
if ($sBEDCATEGORYMASTERFILEOVERBOOKINGSTOREV->S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001(new \StructType\S_BED_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request()) !== false) {
    print_r($sBEDCATEGORYMASTERFILEOVERBOOKINGSTOREV->getResult());
} else {
    print_r($sBEDCATEGORYMASTERFILEOVERBOOKINGSTOREV->getLastError());
}
/**
 * Samples for SBENCHMARKV ServiceType
 */
$sBENCHMARKV = new \ServiceType\SBENCHMARKV($options);
/**
 * Sample call for S_BENCHMARK_V001 operation/method
 */
if ($sBENCHMARKV->S_BENCHMARK_V001(new \StructType\S_BENCHMARK_V001Request()) !== false) {
    print_r($sBENCHMARKV->getResult());
} else {
    print_r($sBENCHMARKV->getLastError());
}
/**
 * Samples for SCATEGORYMAPPINGGETV ServiceType
 */
$sCATEGORYMAPPINGGETV = new \ServiceType\SCATEGORYMAPPINGGETV($options);
/**
 * Sample call for S_CATEGORY_MAPPING_GET_V001 operation/method
 */
if ($sCATEGORYMAPPINGGETV->S_CATEGORY_MAPPING_GET_V001(new \StructType\S_CATEGORY_MAPPING_GET_V001Request()) !== false) {
    print_r($sCATEGORYMAPPINGGETV->getResult());
} else {
    print_r($sCATEGORYMAPPINGGETV->getLastError());
}
/**
 * Samples for SCATEGORYMASTERFILESEARCHV ServiceType
 */
$sCATEGORYMASTERFILESEARCHV = new \ServiceType\SCATEGORYMASTERFILESEARCHV($options);
/**
 * Sample call for S_CATEGORY_MASTER_FILE_SEARCH_V001 operation/method
 */
if ($sCATEGORYMASTERFILESEARCHV->S_CATEGORY_MASTER_FILE_SEARCH_V001(new \StructType\S_CATEGORY_MASTER_FILE_SEARCH_V001Request()) !== false) {
    print_r($sCATEGORYMASTERFILESEARCHV->getResult());
} else {
    print_r($sCATEGORYMASTERFILESEARCHV->getLastError());
}
/**
 * Samples for SCATEGORYRESTRICTIONSEARCHV ServiceType
 */
$sCATEGORYRESTRICTIONSEARCHV = new \ServiceType\SCATEGORYRESTRICTIONSEARCHV($options);
/**
 * Sample call for S_CATEGORY_RESTRICTION_SEARCH_V001 operation/method
 */
if ($sCATEGORYRESTRICTIONSEARCHV->S_CATEGORY_RESTRICTION_SEARCH_V001(new \StructType\S_CATEGORY_RESTRICTION_SEARCH_V001Request()) !== false) {
    print_r($sCATEGORYRESTRICTIONSEARCHV->getResult());
} else {
    print_r($sCATEGORYRESTRICTIONSEARCHV->getLastError());
}
/**
 * Sample call for S_CATEGORY_RESTRICTION_SEARCH_V002 operation/method
 */
if ($sCATEGORYRESTRICTIONSEARCHV->S_CATEGORY_RESTRICTION_SEARCH_V002(new \StructType\S_CATEGORY_RESTRICTION_SEARCH_V002Request()) !== false) {
    print_r($sCATEGORYRESTRICTIONSEARCHV->getResult());
} else {
    print_r($sCATEGORYRESTRICTIONSEARCHV->getLastError());
}
/**
 * Samples for SCITYLEDGERACCOUNTGETV ServiceType
 */
$sCITYLEDGERACCOUNTGETV = new \ServiceType\SCITYLEDGERACCOUNTGETV($options);
/**
 * Sample call for S_CITY_LEDGER_ACCOUNT_GET_V001 operation/method
 */
if ($sCITYLEDGERACCOUNTGETV->S_CITY_LEDGER_ACCOUNT_GET_V001(new \StructType\S_CITY_LEDGER_ACCOUNT_GET_V001Request()) !== false) {
    print_r($sCITYLEDGERACCOUNTGETV->getResult());
} else {
    print_r($sCITYLEDGERACCOUNTGETV->getLastError());
}
/**
 * Samples for SCITYLEDGERACCOUNTSEARCHV ServiceType
 */
$sCITYLEDGERACCOUNTSEARCHV = new \ServiceType\SCITYLEDGERACCOUNTSEARCHV($options);
/**
 * Sample call for S_CITY_LEDGER_ACCOUNT_SEARCH_V001 operation/method
 */
if ($sCITYLEDGERACCOUNTSEARCHV->S_CITY_LEDGER_ACCOUNT_SEARCH_V001(new \StructType\S_CITY_LEDGER_ACCOUNT_SEARCH_V001Request()) !== false) {
    print_r($sCITYLEDGERACCOUNTSEARCHV->getResult());
} else {
    print_r($sCITYLEDGERACCOUNTSEARCHV->getLastError());
}
/**
 * Samples for SCITYLEDGERPAYMENTAPPLYV ServiceType
 */
$sCITYLEDGERPAYMENTAPPLYV = new \ServiceType\SCITYLEDGERPAYMENTAPPLYV($options);
/**
 * Sample call for S_CITY_LEDGER_PAYMENT_APPLY_V001 operation/method
 */
if ($sCITYLEDGERPAYMENTAPPLYV->S_CITY_LEDGER_PAYMENT_APPLY_V001(new \StructType\S_CITY_LEDGER_PAYMENT_APPLY_V001Request()) !== false) {
    print_r($sCITYLEDGERPAYMENTAPPLYV->getResult());
} else {
    print_r($sCITYLEDGERPAYMENTAPPLYV->getLastError());
}
/**
 * Samples for SCITYLEDGERSEARCHV ServiceType
 */
$sCITYLEDGERSEARCHV = new \ServiceType\SCITYLEDGERSEARCHV($options);
/**
 * Sample call for S_CITY_LEDGER_SEARCH_V001 operation/method
 */
if ($sCITYLEDGERSEARCHV->S_CITY_LEDGER_SEARCH_V001(new \StructType\S_CITY_LEDGER_SEARCH_V001Request()) !== false) {
    print_r($sCITYLEDGERSEARCHV->getResult());
} else {
    print_r($sCITYLEDGERSEARCHV->getLastError());
}
/**
 * Samples for SCOMBOBOXSEARCHV ServiceType
 */
$sCOMBOBOXSEARCHV = new \ServiceType\SCOMBOBOXSEARCHV($options);
/**
 * Sample call for S_COMBOBOX_SEARCH_V001 operation/method
 */
if ($sCOMBOBOXSEARCHV->S_COMBOBOX_SEARCH_V001(new \StructType\S_COMBOBOX_SEARCH_V001Request()) !== false) {
    print_r($sCOMBOBOXSEARCHV->getResult());
} else {
    print_r($sCOMBOBOXSEARCHV->getLastError());
}
/**
 * Sample call for S_COMBOBOX_SEARCH_V002 operation/method
 */
if ($sCOMBOBOXSEARCHV->S_COMBOBOX_SEARCH_V002(new \StructType\S_COMBOBOX_SEARCH_V002Request()) !== false) {
    print_r($sCOMBOBOXSEARCHV->getResult());
} else {
    print_r($sCOMBOBOXSEARCHV->getLastError());
}
/**
 * Sample call for S_COMBOBOX_SEARCH_V01 operation/method
 */
if ($sCOMBOBOXSEARCHV->S_COMBOBOX_SEARCH_V01(new \StructType\S_COMBOBOX_SEARCH_V01Request()) !== false) {
    print_r($sCOMBOBOXSEARCHV->getResult());
} else {
    print_r($sCOMBOBOXSEARCHV->getLastError());
}
/**
 * Sample call for S_COMBOBOX_SEARCH_V02 operation/method
 */
if ($sCOMBOBOXSEARCHV->S_COMBOBOX_SEARCH_V02(new \StructType\S_COMBOBOX_SEARCH_V02Request()) !== false) {
    print_r($sCOMBOBOXSEARCHV->getResult());
} else {
    print_r($sCOMBOBOXSEARCHV->getLastError());
}
/**
 * Samples for SCRITERIAGETV ServiceType
 */
$sCRITERIAGETV = new \ServiceType\SCRITERIAGETV($options);
/**
 * Sample call for S_CRITERIA_GET_V001 operation/method
 */
if ($sCRITERIAGETV->S_CRITERIA_GET_V001(new \StructType\S_CRITERIA_GET_V001Request()) !== false) {
    print_r($sCRITERIAGETV->getResult());
} else {
    print_r($sCRITERIAGETV->getLastError());
}
/**
 * Samples for SDISCOUNTCREATEV ServiceType
 */
$sDISCOUNTCREATEV = new \ServiceType\SDISCOUNTCREATEV($options);
/**
 * Sample call for S_DISCOUNT_CREATE_V001 operation/method
 */
if ($sDISCOUNTCREATEV->S_DISCOUNT_CREATE_V001(new \StructType\S_DISCOUNT_CREATE_V001Request()) !== false) {
    print_r($sDISCOUNTCREATEV->getResult());
} else {
    print_r($sDISCOUNTCREATEV->getLastError());
}
/**
 * Samples for SDISCOUNTGETV ServiceType
 */
$sDISCOUNTGETV = new \ServiceType\SDISCOUNTGETV($options);
/**
 * Sample call for S_DISCOUNT_GET_V001 operation/method
 */
if ($sDISCOUNTGETV->S_DISCOUNT_GET_V001(new \StructType\S_DISCOUNT_GET_V001Request()) !== false) {
    print_r($sDISCOUNTGETV->getResult());
} else {
    print_r($sDISCOUNTGETV->getLastError());
}
/**
 * Samples for SDISCOUNTMODIFYV ServiceType
 */
$sDISCOUNTMODIFYV = new \ServiceType\SDISCOUNTMODIFYV($options);
/**
 * Sample call for S_DISCOUNT_MODIFY_V001 operation/method
 */
if ($sDISCOUNTMODIFYV->S_DISCOUNT_MODIFY_V001(new \StructType\S_DISCOUNT_MODIFY_V001Request()) !== false) {
    print_r($sDISCOUNTMODIFYV->getResult());
} else {
    print_r($sDISCOUNTMODIFYV->getLastError());
}
/**
 * Samples for SDISCOUNTSEARCHV ServiceType
 */
$sDISCOUNTSEARCHV = new \ServiceType\SDISCOUNTSEARCHV($options);
/**
 * Sample call for S_DISCOUNT_SEARCH_V001 operation/method
 */
if ($sDISCOUNTSEARCHV->S_DISCOUNT_SEARCH_V001(new \StructType\S_DISCOUNT_SEARCH_V001Request()) !== false) {
    print_r($sDISCOUNTSEARCHV->getResult());
} else {
    print_r($sDISCOUNTSEARCHV->getLastError());
}
/**
 * Samples for SEVENTCBMODULEDESCRIPTIONCOMMENTGETV ServiceType
 */
$sEVENTCBMODULEDESCRIPTIONCOMMENTGETV = new \ServiceType\SEVENTCBMODULEDESCRIPTIONCOMMENTGETV($options);
/**
 * Sample call for S_EVENT_CB_MODULE_DESCRIPTION_COMMENT_GET_V001 operation/method
 */
if ($sEVENTCBMODULEDESCRIPTIONCOMMENTGETV->S_EVENT_CB_MODULE_DESCRIPTION_COMMENT_GET_V001(new \StructType\S_EVENT_CB_MODULE_DESCRIPTION_COMMENT_GET_V001Request()) !== false) {
    print_r($sEVENTCBMODULEDESCRIPTIONCOMMENTGETV->getResult());
} else {
    print_r($sEVENTCBMODULEDESCRIPTIONCOMMENTGETV->getLastError());
}
/**
 * Samples for SEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV ServiceType
 */
$sEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV = new \ServiceType\SEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV($options);
/**
 * Sample call for S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001
 * operation/method
 */
if ($sEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001(new \StructType\S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request()) !== false) {
    print_r($sEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getResult());
} else {
    print_r($sEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getLastError());
}
/**
 * Samples for SEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV ServiceType
 */
$sEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV = new \ServiceType\SEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV($options);
/**
 * Sample call for S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001
 * operation/method
 */
if ($sEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV->S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001(new \StructType\S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request()) !== false) {
    print_r($sEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getResult());
} else {
    print_r($sEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONCREATEV ServiceType
 */
$sEVENTRESERVATIONCREATEV = new \ServiceType\SEVENTRESERVATIONCREATEV($options);
/**
 * Sample call for S_EVENT_RESERVATION_CREATE_V001 operation/method
 */
if ($sEVENTRESERVATIONCREATEV->S_EVENT_RESERVATION_CREATE_V001(new \StructType\S_EVENT_RESERVATION_CREATE_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONCREATEV->getResult());
} else {
    print_r($sEVENTRESERVATIONCREATEV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONGETV ServiceType
 */
$sEVENTRESERVATIONGETV = new \ServiceType\SEVENTRESERVATIONGETV($options);
/**
 * Sample call for S_EVENT_RESERVATION_GET_V001 operation/method
 */
if ($sEVENTRESERVATIONGETV->S_EVENT_RESERVATION_GET_V001(new \StructType\S_EVENT_RESERVATION_GET_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONGETV->getResult());
} else {
    print_r($sEVENTRESERVATIONGETV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONMODIFYV ServiceType
 */
$sEVENTRESERVATIONMODIFYV = new \ServiceType\SEVENTRESERVATIONMODIFYV($options);
/**
 * Sample call for S_EVENT_RESERVATION_MODIFY_V001 operation/method
 */
if ($sEVENTRESERVATIONMODIFYV->S_EVENT_RESERVATION_MODIFY_V001(new \StructType\S_EVENT_RESERVATION_MODIFY_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONMODIFYV->getResult());
} else {
    print_r($sEVENTRESERVATIONMODIFYV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONNODESTRUCTUREGETV ServiceType
 */
$sEVENTRESERVATIONNODESTRUCTUREGETV = new \ServiceType\SEVENTRESERVATIONNODESTRUCTUREGETV($options);
/**
 * Sample call for S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001 operation/method
 */
if ($sEVENTRESERVATIONNODESTRUCTUREGETV->S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001(new \StructType\S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONNODESTRUCTUREGETV->getResult());
} else {
    print_r($sEVENTRESERVATIONNODESTRUCTUREGETV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONROOMGETV ServiceType
 */
$sEVENTRESERVATIONROOMGETV = new \ServiceType\SEVENTRESERVATIONROOMGETV($options);
/**
 * Sample call for S_EVENT_RESERVATION_ROOM_GET_V001 operation/method
 */
if ($sEVENTRESERVATIONROOMGETV->S_EVENT_RESERVATION_ROOM_GET_V001(new \StructType\S_EVENT_RESERVATION_ROOM_GET_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONROOMGETV->getResult());
} else {
    print_r($sEVENTRESERVATIONROOMGETV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONSEARCHV ServiceType
 */
$sEVENTRESERVATIONSEARCHV = new \ServiceType\SEVENTRESERVATIONSEARCHV($options);
/**
 * Sample call for S_EVENT_RESERVATION_SEARCH_V001 operation/method
 */
if ($sEVENTRESERVATIONSEARCHV->S_EVENT_RESERVATION_SEARCH_V001(new \StructType\S_EVENT_RESERVATION_SEARCH_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONSEARCHV->getResult());
} else {
    print_r($sEVENTRESERVATIONSEARCHV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONSERVICEADDV ServiceType
 */
$sEVENTRESERVATIONSERVICEADDV = new \ServiceType\SEVENTRESERVATIONSERVICEADDV($options);
/**
 * Sample call for S_EVENT_RESERVATION_SERVICE_ADD_V001 operation/method
 */
if ($sEVENTRESERVATIONSERVICEADDV->S_EVENT_RESERVATION_SERVICE_ADD_V001(new \StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONSERVICEADDV->getResult());
} else {
    print_r($sEVENTRESERVATIONSERVICEADDV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONSERVICEMODIFYV ServiceType
 */
$sEVENTRESERVATIONSERVICEMODIFYV = new \ServiceType\SEVENTRESERVATIONSERVICEMODIFYV($options);
/**
 * Sample call for S_EVENT_RESERVATION_SERVICE_MODIFY_V001 operation/method
 */
if ($sEVENTRESERVATIONSERVICEMODIFYV->S_EVENT_RESERVATION_SERVICE_MODIFY_V001(new \StructType\S_EVENT_RESERVATION_SERVICE_MODIFY_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONSERVICEMODIFYV->getResult());
} else {
    print_r($sEVENTRESERVATIONSERVICEMODIFYV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONSERVICEREMOVEV ServiceType
 */
$sEVENTRESERVATIONSERVICEREMOVEV = new \ServiceType\SEVENTRESERVATIONSERVICEREMOVEV($options);
/**
 * Sample call for S_EVENT_RESERVATION_SERVICE_REMOVE_V001 operation/method
 */
if ($sEVENTRESERVATIONSERVICEREMOVEV->S_EVENT_RESERVATION_SERVICE_REMOVE_V001(new \StructType\S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONSERVICEREMOVEV->getResult());
} else {
    print_r($sEVENTRESERVATIONSERVICEREMOVEV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONTOKENADDV ServiceType
 */
$sEVENTRESERVATIONTOKENADDV = new \ServiceType\SEVENTRESERVATIONTOKENADDV($options);
/**
 * Sample call for S_EVENT_RESERVATION_TOKEN_ADD_V001 operation/method
 */
if ($sEVENTRESERVATIONTOKENADDV->S_EVENT_RESERVATION_TOKEN_ADD_V001(new \StructType\S_EVENT_RESERVATION_TOKEN_ADD_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONTOKENADDV->getResult());
} else {
    print_r($sEVENTRESERVATIONTOKENADDV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONTRAILNODEGETV ServiceType
 */
$sEVENTRESERVATIONTRAILNODEGETV = new \ServiceType\SEVENTRESERVATIONTRAILNODEGETV($options);
/**
 * Sample call for S_EVENT_RESERVATION_TRAIL_NODE_GET_V001 operation/method
 */
if ($sEVENTRESERVATIONTRAILNODEGETV->S_EVENT_RESERVATION_TRAIL_NODE_GET_V001(new \StructType\S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONTRAILNODEGETV->getResult());
} else {
    print_r($sEVENTRESERVATIONTRAILNODEGETV->getLastError());
}
/**
 * Samples for SEVENTRESERVATIONTRANSFERV ServiceType
 */
$sEVENTRESERVATIONTRANSFERV = new \ServiceType\SEVENTRESERVATIONTRANSFERV($options);
/**
 * Sample call for S_EVENT_RESERVATION_TRANSFER_V001 operation/method
 */
if ($sEVENTRESERVATIONTRANSFERV->S_EVENT_RESERVATION_TRANSFER_V001(new \StructType\S_EVENT_RESERVATION_TRANSFER_V001Request()) !== false) {
    print_r($sEVENTRESERVATIONTRANSFERV->getResult());
} else {
    print_r($sEVENTRESERVATIONTRANSFERV->getLastError());
}
/**
 * Samples for SEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV ServiceType
 */
$sEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV = new \ServiceType\SEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV($options);
/**
 * Sample call for S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001
 * operation/method
 */
if ($sEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV->S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001(new \StructType\S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request()) !== false) {
    print_r($sEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getResult());
} else {
    print_r($sEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getLastError());
}
/**
 * Samples for SFREEROOMSEARCHV ServiceType
 */
$sFREEROOMSEARCHV = new \ServiceType\SFREEROOMSEARCHV($options);
/**
 * Sample call for S_FREE_ROOM_SEARCH_V001 operation/method
 */
if ($sFREEROOMSEARCHV->S_FREE_ROOM_SEARCH_V001(new \StructType\S_FREE_ROOM_SEARCH_V001Request()) !== false) {
    print_r($sFREEROOMSEARCHV->getResult());
} else {
    print_r($sFREEROOMSEARCHV->getLastError());
}
/**
 * Samples for SGETGUESTHIERARCHYV ServiceType
 */
$sGETGUESTHIERARCHYV = new \ServiceType\SGETGUESTHIERARCHYV($options);
/**
 * Sample call for S_GET_GUEST_HIERARCHY_V001 operation/method
 */
if ($sGETGUESTHIERARCHYV->S_GET_GUEST_HIERARCHY_V001(new \StructType\S_GET_GUEST_HIERARCHY_V001Request()) !== false) {
    print_r($sGETGUESTHIERARCHYV->getResult());
} else {
    print_r($sGETGUESTHIERARCHYV->getLastError());
}
/**
 * Samples for SGETSETTLEMENTPROFILEV ServiceType
 */
$sGETSETTLEMENTPROFILEV = new \ServiceType\SGETSETTLEMENTPROFILEV($options);
/**
 * Sample call for S_GET_SETTLEMENT_PROFILE_V001 operation/method
 */
if ($sGETSETTLEMENTPROFILEV->S_GET_SETTLEMENT_PROFILE_V001(new \StructType\S_GET_SETTLEMENT_PROFILE_V001Request()) !== false) {
    print_r($sGETSETTLEMENTPROFILEV->getResult());
} else {
    print_r($sGETSETTLEMENTPROFILEV->getLastError());
}
/**
 * Samples for SGETUSERINFOV ServiceType
 */
$sGETUSERINFOV = new \ServiceType\SGETUSERINFOV($options);
/**
 * Sample call for S_GET_USER_INFO_V001 operation/method
 */
if ($sGETUSERINFOV->S_GET_USER_INFO_V001(new \StructType\S_GET_USER_INFO_V001Request()) !== false) {
    print_r($sGETUSERINFOV->getResult());
} else {
    print_r($sGETUSERINFOV->getLastError());
}
/**
 * Samples for SGIFTVOUCHERREDEEMV ServiceType
 */
$sGIFTVOUCHERREDEEMV = new \ServiceType\SGIFTVOUCHERREDEEMV($options);
/**
 * Sample call for S_GIFTVOUCHER_REDEEM_V001 operation/method
 */
if ($sGIFTVOUCHERREDEEMV->S_GIFTVOUCHER_REDEEM_V001(new \StructType\S_GIFTVOUCHER_REDEEM_V001Request()) !== false) {
    print_r($sGIFTVOUCHERREDEEMV->getResult());
} else {
    print_r($sGIFTVOUCHERREDEEMV->getLastError());
}
/**
 * Sample call for S_GIFT_VOUCHER_REDEEM_V001 operation/method
 */
if ($sGIFTVOUCHERREDEEMV->S_GIFT_VOUCHER_REDEEM_V001(new \StructType\S_GIFT_VOUCHER_REDEEM_V001Request()) !== false) {
    print_r($sGIFTVOUCHERREDEEMV->getResult());
} else {
    print_r($sGIFTVOUCHERREDEEMV->getLastError());
}
/**
 * Samples for SGIFTVOUCHERSEARCHV ServiceType
 */
$sGIFTVOUCHERSEARCHV = new \ServiceType\SGIFTVOUCHERSEARCHV($options);
/**
 * Sample call for S_GIFTVOUCHER_SEARCH_V002 operation/method
 */
if ($sGIFTVOUCHERSEARCHV->S_GIFTVOUCHER_SEARCH_V002(new \StructType\S_GIFTVOUCHER_SEARCH_V002Request()) !== false) {
    print_r($sGIFTVOUCHERSEARCHV->getResult());
} else {
    print_r($sGIFTVOUCHERSEARCHV->getLastError());
}
/**
 * Sample call for S_GIFT_VOUCHER_SEARCH_V002 operation/method
 */
if ($sGIFTVOUCHERSEARCHV->S_GIFT_VOUCHER_SEARCH_V002(new \StructType\S_GIFT_VOUCHER_SEARCH_V002Request()) !== false) {
    print_r($sGIFTVOUCHERSEARCHV->getResult());
} else {
    print_r($sGIFTVOUCHERSEARCHV->getLastError());
}
/**
 * Samples for SGIFTVOUCHERSELLV ServiceType
 */
$sGIFTVOUCHERSELLV = new \ServiceType\SGIFTVOUCHERSELLV($options);
/**
 * Sample call for S_GIFTVOUCHER_SELL_V001 operation/method
 */
if ($sGIFTVOUCHERSELLV->S_GIFTVOUCHER_SELL_V001(new \StructType\S_GIFTVOUCHER_SELL_V001Request()) !== false) {
    print_r($sGIFTVOUCHERSELLV->getResult());
} else {
    print_r($sGIFTVOUCHERSELLV->getLastError());
}
/**
 * Sample call for S_GIFT_VOUCHER_SELL_V001 operation/method
 */
if ($sGIFTVOUCHERSELLV->S_GIFT_VOUCHER_SELL_V001(new \StructType\S_GIFT_VOUCHER_SELL_V001Request()) !== false) {
    print_r($sGIFTVOUCHERSELLV->getResult());
} else {
    print_r($sGIFTVOUCHERSELLV->getLastError());
}
/**
 * Samples for SGOACCOUNTV ServiceType
 */
$sGOACCOUNTV = new \ServiceType\SGOACCOUNTV($options);
/**
 * Sample call for S_GO_ACCOUNT_V001 operation/method
 */
if ($sGOACCOUNTV->S_GO_ACCOUNT_V001(new \StructType\S_GO_ACCOUNT_V001Request()) !== false) {
    print_r($sGOACCOUNTV->getResult());
} else {
    print_r($sGOACCOUNTV->getLastError());
}
/**
 * Samples for SGOCOMBOBOXSEARCHV ServiceType
 */
$sGOCOMBOBOXSEARCHV = new \ServiceType\SGOCOMBOBOXSEARCHV($options);
/**
 * Sample call for S_GO_COMBOBOX_SEARCH_V001 operation/method
 */
if ($sGOCOMBOBOXSEARCHV->S_GO_COMBOBOX_SEARCH_V001(new \StructType\S_GO_COMBOBOX_SEARCH_V001Request()) !== false) {
    print_r($sGOCOMBOBOXSEARCHV->getResult());
} else {
    print_r($sGOCOMBOBOXSEARCHV->getLastError());
}
/**
 * Samples for SGOCONFIGV ServiceType
 */
$sGOCONFIGV = new \ServiceType\SGOCONFIGV($options);
/**
 * Sample call for S_GO_CONFIG_V001 operation/method
 */
if ($sGOCONFIGV->S_GO_CONFIG_V001(new \StructType\S_GO_CONFIG_V001Request()) !== false) {
    print_r($sGOCONFIGV->getResult());
} else {
    print_r($sGOCONFIGV->getLastError());
}
/**
 * Sample call for S_GO_CONFIG_V002 operation/method
 */
if ($sGOCONFIGV->S_GO_CONFIG_V002(new \StructType\S_GO_CONFIG_V002Request()) !== false) {
    print_r($sGOCONFIGV->getResult());
} else {
    print_r($sGOCONFIGV->getLastError());
}
/**
 * Samples for SGOGSTEXTERNALIDADDV ServiceType
 */
$sGOGSTEXTERNALIDADDV = new \ServiceType\SGOGSTEXTERNALIDADDV($options);
/**
 * Sample call for S_GO_GST_EXTERNALID_ADD_V001 operation/method
 */
if ($sGOGSTEXTERNALIDADDV->S_GO_GST_EXTERNALID_ADD_V001(new \StructType\S_GO_GST_EXTERNALID_ADD_V001Request()) !== false) {
    print_r($sGOGSTEXTERNALIDADDV->getResult());
} else {
    print_r($sGOGSTEXTERNALIDADDV->getLastError());
}
/**
 * Samples for SGOGSTEXTERNALIDDELETEV ServiceType
 */
$sGOGSTEXTERNALIDDELETEV = new \ServiceType\SGOGSTEXTERNALIDDELETEV($options);
/**
 * Sample call for S_GO_GST_EXTERNALID_DELETE_V001 operation/method
 */
if ($sGOGSTEXTERNALIDDELETEV->S_GO_GST_EXTERNALID_DELETE_V001(new \StructType\S_GO_GST_EXTERNALID_DELETE_V001Request()) !== false) {
    print_r($sGOGSTEXTERNALIDDELETEV->getResult());
} else {
    print_r($sGOGSTEXTERNALIDDELETEV->getLastError());
}
/**
 * Samples for SGOHOTELSEARCHV ServiceType
 */
$sGOHOTELSEARCHV = new \ServiceType\SGOHOTELSEARCHV($options);
/**
 * Sample call for S_GO_HOTEL_SEARCH_V001 operation/method
 */
if ($sGOHOTELSEARCHV->S_GO_HOTEL_SEARCH_V001(new \StructType\S_GO_HOTEL_SEARCH_V001Request()) !== false) {
    print_r($sGOHOTELSEARCHV->getResult());
} else {
    print_r($sGOHOTELSEARCHV->getLastError());
}
/**
 * Samples for SGOHOTELV ServiceType
 */
$sGOHOTELV = new \ServiceType\SGOHOTELV($options);
/**
 * Sample call for S_GO_HOTEL_V001 operation/method
 */
if ($sGOHOTELV->S_GO_HOTEL_V001(new \StructType\S_GO_HOTEL_V001Request()) !== false) {
    print_r($sGOHOTELV->getResult());
} else {
    print_r($sGOHOTELV->getLastError());
}
/**
 * Samples for SGOPERSONEXTERNALIDADDV ServiceType
 */
$sGOPERSONEXTERNALIDADDV = new \ServiceType\SGOPERSONEXTERNALIDADDV($options);
/**
 * Sample call for S_GO_PERSON_EXTERNALID_ADD_V001 operation/method
 */
if ($sGOPERSONEXTERNALIDADDV->S_GO_PERSON_EXTERNALID_ADD_V001(new \StructType\S_GO_PERSON_EXTERNALID_ADD_V001Request()) !== false) {
    print_r($sGOPERSONEXTERNALIDADDV->getResult());
} else {
    print_r($sGOPERSONEXTERNALIDADDV->getLastError());
}
/**
 * Samples for SGOPERSONEXTERNALIDDELETEV ServiceType
 */
$sGOPERSONEXTERNALIDDELETEV = new \ServiceType\SGOPERSONEXTERNALIDDELETEV($options);
/**
 * Sample call for S_GO_PERSON_EXTERNALID_DELETE_V001 operation/method
 */
if ($sGOPERSONEXTERNALIDDELETEV->S_GO_PERSON_EXTERNALID_DELETE_V001(new \StructType\S_GO_PERSON_EXTERNALID_DELETE_V001Request()) !== false) {
    print_r($sGOPERSONEXTERNALIDDELETEV->getResult());
} else {
    print_r($sGOPERSONEXTERNALIDDELETEV->getLastError());
}
/**
 * Samples for SGOPERSONFEEDBACKADDV ServiceType
 */
$sGOPERSONFEEDBACKADDV = new \ServiceType\SGOPERSONFEEDBACKADDV($options);
/**
 * Sample call for S_GO_PERSON_FEEDBACK_ADD_V001 operation/method
 */
if ($sGOPERSONFEEDBACKADDV->S_GO_PERSON_FEEDBACK_ADD_V001(new \StructType\S_GO_PERSON_FEEDBACK_ADD_V001Request()) !== false) {
    print_r($sGOPERSONFEEDBACKADDV->getResult());
} else {
    print_r($sGOPERSONFEEDBACKADDV->getLastError());
}
/**
 * Samples for SGOPERSONFEEDBACKV ServiceType
 */
$sGOPERSONFEEDBACKV = new \ServiceType\SGOPERSONFEEDBACKV($options);
/**
 * Sample call for S_GO_PERSON_FEEDBACK_V001 operation/method
 */
if ($sGOPERSONFEEDBACKV->S_GO_PERSON_FEEDBACK_V001(new \StructType\S_GO_PERSON_FEEDBACK_V001Request()) !== false) {
    print_r($sGOPERSONFEEDBACKV->getResult());
} else {
    print_r($sGOPERSONFEEDBACKV->getLastError());
}
/**
 * Samples for SGOPERSONLOADV ServiceType
 */
$sGOPERSONLOADV = new \ServiceType\SGOPERSONLOADV($options);
/**
 * Sample call for S_GO_PERSON_LOAD_V001 operation/method
 */
if ($sGOPERSONLOADV->S_GO_PERSON_LOAD_V001(new \StructType\S_GO_PERSON_LOAD_V001Request()) !== false) {
    print_r($sGOPERSONLOADV->getResult());
} else {
    print_r($sGOPERSONLOADV->getLastError());
}
/**
 * Sample call for S_GO_PERSON_LOAD_V002 operation/method
 */
if ($sGOPERSONLOADV->S_GO_PERSON_LOAD_V002(new \StructType\S_GO_PERSON_LOAD_V002Request()) !== false) {
    print_r($sGOPERSONLOADV->getResult());
} else {
    print_r($sGOPERSONLOADV->getLastError());
}
/**
 * Samples for SGOPERSONMODIFYV ServiceType
 */
$sGOPERSONMODIFYV = new \ServiceType\SGOPERSONMODIFYV($options);
/**
 * Sample call for S_GO_PERSON_MODIFY_V001 operation/method
 */
if ($sGOPERSONMODIFYV->S_GO_PERSON_MODIFY_V001(new \StructType\S_GO_PERSON_MODIFY_V001Request()) !== false) {
    print_r($sGOPERSONMODIFYV->getResult());
} else {
    print_r($sGOPERSONMODIFYV->getLastError());
}
/**
 * Samples for SGOPERSONSEARCHV ServiceType
 */
$sGOPERSONSEARCHV = new \ServiceType\SGOPERSONSEARCHV($options);
/**
 * Sample call for S_GO_PERSON_SEARCH_V001 operation/method
 */
if ($sGOPERSONSEARCHV->S_GO_PERSON_SEARCH_V001(new \StructType\S_GO_PERSON_SEARCH_V001Request()) !== false) {
    print_r($sGOPERSONSEARCHV->getResult());
} else {
    print_r($sGOPERSONSEARCHV->getLastError());
}
/**
 * Sample call for S_GO_PERSON_SEARCH_V002 operation/method
 */
if ($sGOPERSONSEARCHV->S_GO_PERSON_SEARCH_V002(new \StructType\S_GO_PERSON_SEARCH_V002Request()) !== false) {
    print_r($sGOPERSONSEARCHV->getResult());
} else {
    print_r($sGOPERSONSEARCHV->getLastError());
}
/**
 * Samples for SGOPOSTPREPAYMENTV ServiceType
 */
$sGOPOSTPREPAYMENTV = new \ServiceType\SGOPOSTPREPAYMENTV($options);
/**
 * Sample call for S_GO_POSTPREPAYMENT_V001 operation/method
 */
if ($sGOPOSTPREPAYMENTV->S_GO_POSTPREPAYMENT_V001(new \StructType\S_GO_POSTPREPAYMENT_V001Request()) !== false) {
    print_r($sGOPOSTPREPAYMENTV->getResult());
} else {
    print_r($sGOPOSTPREPAYMENTV->getLastError());
}
/**
 * Samples for SGOPREPAYMENTPOSTV ServiceType
 */
$sGOPREPAYMENTPOSTV = new \ServiceType\SGOPREPAYMENTPOSTV($options);
/**
 * Sample call for S_GO_PREPAYMENT_POST_V001 operation/method
 */
if ($sGOPREPAYMENTPOSTV->S_GO_PREPAYMENT_POST_V001(new \StructType\S_GO_PREPAYMENT_POST_V001Request()) !== false) {
    print_r($sGOPREPAYMENTPOSTV->getResult());
} else {
    print_r($sGOPREPAYMENTPOSTV->getLastError());
}
/**
 * Samples for SGORESERVATIONSEARCHV ServiceType
 */
$sGORESERVATIONSEARCHV = new \ServiceType\SGORESERVATIONSEARCHV($options);
/**
 * Sample call for S_GO_RESERVATION_SEARCH_V001 operation/method
 */
if ($sGORESERVATIONSEARCHV->S_GO_RESERVATION_SEARCH_V001(new \StructType\S_GO_RESERVATION_SEARCH_V001Request()) !== false) {
    print_r($sGORESERVATIONSEARCHV->getResult());
} else {
    print_r($sGORESERVATIONSEARCHV->getLastError());
}
/**
 * Samples for SGORESERVATIONV ServiceType
 */
$sGORESERVATIONV = new \ServiceType\SGORESERVATIONV($options);
/**
 * Sample call for S_GO_RESERVATION_V001 operation/method
 */
if ($sGORESERVATIONV->S_GO_RESERVATION_V001(new \StructType\S_GO_RESERVATION_V001Request()) !== false) {
    print_r($sGORESERVATIONV->getResult());
} else {
    print_r($sGORESERVATIONV->getLastError());
}
/**
 * Sample call for S_GO_RESERVATION_V002 operation/method
 */
if ($sGORESERVATIONV->S_GO_RESERVATION_V002(new \StructType\S_GO_RESERVATION_V002Request()) !== false) {
    print_r($sGORESERVATIONV->getResult());
} else {
    print_r($sGORESERVATIONV->getLastError());
}
/**
 * Samples for SGOUPSELLCATEGORYASSIGNV ServiceType
 */
$sGOUPSELLCATEGORYASSIGNV = new \ServiceType\SGOUPSELLCATEGORYASSIGNV($options);
/**
 * Sample call for S_GO_UPSELLCATEGORY_ASSIGN_V001 operation/method
 */
if ($sGOUPSELLCATEGORYASSIGNV->S_GO_UPSELLCATEGORY_ASSIGN_V001(new \StructType\S_GO_UPSELLCATEGORY_ASSIGN_V001Request()) !== false) {
    print_r($sGOUPSELLCATEGORYASSIGNV->getResult());
} else {
    print_r($sGOUPSELLCATEGORYASSIGNV->getLastError());
}
/**
 * Samples for SGOUPSELLCATEGORYPOSSIBLEV ServiceType
 */
$sGOUPSELLCATEGORYPOSSIBLEV = new \ServiceType\SGOUPSELLCATEGORYPOSSIBLEV($options);
/**
 * Sample call for S_GO_UPSELLCATEGORY_POSSIBLE_V001 operation/method
 */
if ($sGOUPSELLCATEGORYPOSSIBLEV->S_GO_UPSELLCATEGORY_POSSIBLE_V001(new \StructType\S_GO_UPSELLCATEGORY_POSSIBLE_V001Request()) !== false) {
    print_r($sGOUPSELLCATEGORYPOSSIBLEV->getResult());
} else {
    print_r($sGOUPSELLCATEGORYPOSSIBLEV->getLastError());
}
/**
 * Samples for SGOUPSELLSERVICESPOSSIBLEV ServiceType
 */
$sGOUPSELLSERVICESPOSSIBLEV = new \ServiceType\SGOUPSELLSERVICESPOSSIBLEV($options);
/**
 * Sample call for S_GO_UPSELLSERVICES_POSSIBLE_V001 operation/method
 */
if ($sGOUPSELLSERVICESPOSSIBLEV->S_GO_UPSELLSERVICES_POSSIBLE_V001(new \StructType\S_GO_UPSELLSERVICES_POSSIBLE_V001Request()) !== false) {
    print_r($sGOUPSELLSERVICESPOSSIBLEV->getResult());
} else {
    print_r($sGOUPSELLSERVICESPOSSIBLEV->getLastError());
}
/**
 * Samples for SGOUPSELLSERVICEADDV ServiceType
 */
$sGOUPSELLSERVICEADDV = new \ServiceType\SGOUPSELLSERVICEADDV($options);
/**
 * Sample call for S_GO_UPSELLSERVICE_ADD_V001 operation/method
 */
if ($sGOUPSELLSERVICEADDV->S_GO_UPSELLSERVICE_ADD_V001(new \StructType\S_GO_UPSELLSERVICE_ADD_V001Request()) !== false) {
    print_r($sGOUPSELLSERVICEADDV->getResult());
} else {
    print_r($sGOUPSELLSERVICEADDV->getLastError());
}
/**
 * Samples for SGOUPSELLSERVICEREMOVEV ServiceType
 */
$sGOUPSELLSERVICEREMOVEV = new \ServiceType\SGOUPSELLSERVICEREMOVEV($options);
/**
 * Sample call for S_GO_UPSELLSERVICE_REMOVE_V001 operation/method
 */
if ($sGOUPSELLSERVICEREMOVEV->S_GO_UPSELLSERVICE_REMOVE_V001(new \StructType\S_GO_UPSELLSERVICE_REMOVE_V001Request()) !== false) {
    print_r($sGOUPSELLSERVICEREMOVEV->getResult());
} else {
    print_r($sGOUPSELLSERVICEREMOVEV->getLastError());
}
/**
 * Samples for SGUESTANONYMISEV ServiceType
 */
$sGUESTANONYMISEV = new \ServiceType\SGUESTANONYMISEV($options);
/**
 * Sample call for S_GUEST_ANONYMISE_V001 operation/method
 */
if ($sGUESTANONYMISEV->S_GUEST_ANONYMISE_V001(new \StructType\S_GUEST_ANONYMISE_V001Request()) !== false) {
    print_r($sGUESTANONYMISEV->getResult());
} else {
    print_r($sGUESTANONYMISEV->getLastError());
}
/**
 * Samples for SGUESTCOMMENTGETV ServiceType
 */
$sGUESTCOMMENTGETV = new \ServiceType\SGUESTCOMMENTGETV($options);
/**
 * Sample call for S_GUEST_COMMENT_GET_V001 operation/method
 */
if ($sGUESTCOMMENTGETV->S_GUEST_COMMENT_GET_V001(new \StructType\S_GUEST_COMMENT_GET_V001Request()) !== false) {
    print_r($sGUESTCOMMENTGETV->getResult());
} else {
    print_r($sGUESTCOMMENTGETV->getLastError());
}
/**
 * Samples for SGUESTCOMMENTMODIFYV ServiceType
 */
$sGUESTCOMMENTMODIFYV = new \ServiceType\SGUESTCOMMENTMODIFYV($options);
/**
 * Sample call for S_GUEST_COMMENT_MODIFY_V001 operation/method
 */
if ($sGUESTCOMMENTMODIFYV->S_GUEST_COMMENT_MODIFY_V001(new \StructType\S_GUEST_COMMENT_MODIFY_V001Request()) !== false) {
    print_r($sGUESTCOMMENTMODIFYV->getResult());
} else {
    print_r($sGUESTCOMMENTMODIFYV->getLastError());
}
/**
 * Samples for SGUESTCONTACTPERSONSGETV ServiceType
 */
$sGUESTCONTACTPERSONSGETV = new \ServiceType\SGUESTCONTACTPERSONSGETV($options);
/**
 * Sample call for S_GUEST_CONTACT_PERSONS_GET_V001 operation/method
 */
if ($sGUESTCONTACTPERSONSGETV->S_GUEST_CONTACT_PERSONS_GET_V001(new \StructType\S_GUEST_CONTACT_PERSONS_GET_V001Request()) !== false) {
    print_r($sGUESTCONTACTPERSONSGETV->getResult());
} else {
    print_r($sGUESTCONTACTPERSONSGETV->getLastError());
}
/**
 * Samples for SGUESTCONTACTPERSONADDV ServiceType
 */
$sGUESTCONTACTPERSONADDV = new \ServiceType\SGUESTCONTACTPERSONADDV($options);
/**
 * Sample call for S_GUEST_CONTACT_PERSON_ADD_V001 operation/method
 */
if ($sGUESTCONTACTPERSONADDV->S_GUEST_CONTACT_PERSON_ADD_V001(new \StructType\S_GUEST_CONTACT_PERSON_ADD_V001Request()) !== false) {
    print_r($sGUESTCONTACTPERSONADDV->getResult());
} else {
    print_r($sGUESTCONTACTPERSONADDV->getLastError());
}
/**
 * Samples for SGUESTCONTACTPERSONREMOVEV ServiceType
 */
$sGUESTCONTACTPERSONREMOVEV = new \ServiceType\SGUESTCONTACTPERSONREMOVEV($options);
/**
 * Sample call for S_GUEST_CONTACT_PERSON_REMOVE_V001 operation/method
 */
if ($sGUESTCONTACTPERSONREMOVEV->S_GUEST_CONTACT_PERSON_REMOVE_V001(new \StructType\S_GUEST_CONTACT_PERSON_REMOVE_V001Request()) !== false) {
    print_r($sGUESTCONTACTPERSONREMOVEV->getResult());
} else {
    print_r($sGUESTCONTACTPERSONREMOVEV->getLastError());
}
/**
 * Samples for SGUESTCREATEV ServiceType
 */
$sGUESTCREATEV = new \ServiceType\SGUESTCREATEV($options);
/**
 * Sample call for S_GUEST_CREATE_V001 operation/method
 */
if ($sGUESTCREATEV->S_GUEST_CREATE_V001(new \StructType\S_GUEST_CREATE_V001Request()) !== false) {
    print_r($sGUESTCREATEV->getResult());
} else {
    print_r($sGUESTCREATEV->getLastError());
}
/**
 * Sample call for S_GUEST_CREATE_V002 operation/method
 */
if ($sGUESTCREATEV->S_GUEST_CREATE_V002(new \StructType\S_GUEST_CREATE_V002Request()) !== false) {
    print_r($sGUESTCREATEV->getResult());
} else {
    print_r($sGUESTCREATEV->getLastError());
}
/**
 * Sample call for S_GUEST_CREATE_V003 operation/method
 */
if ($sGUESTCREATEV->S_GUEST_CREATE_V003(new \StructType\S_GUEST_CREATE_V003Request()) !== false) {
    print_r($sGUESTCREATEV->getResult());
} else {
    print_r($sGUESTCREATEV->getLastError());
}
/**
 * Sample call for S_GUEST_CREATE_V004 operation/method
 */
if ($sGUESTCREATEV->S_GUEST_CREATE_V004(new \StructType\S_GUEST_CREATE_V004Request()) !== false) {
    print_r($sGUESTCREATEV->getResult());
} else {
    print_r($sGUESTCREATEV->getLastError());
}
/**
 * Sample call for S_GUEST_CREATE_V005 operation/method
 */
if ($sGUESTCREATEV->S_GUEST_CREATE_V005(new \StructType\S_GUEST_CREATE_V005Request()) !== false) {
    print_r($sGUESTCREATEV->getResult());
} else {
    print_r($sGUESTCREATEV->getLastError());
}
/**
 * Sample call for S_GUEST_CREATE_V006 operation/method
 */
if ($sGUESTCREATEV->S_GUEST_CREATE_V006(new \StructType\S_GUEST_CREATE_V006Request()) !== false) {
    print_r($sGUESTCREATEV->getResult());
} else {
    print_r($sGUESTCREATEV->getLastError());
}
/**
 * Sample call for S_GUEST_CREATE_V007 operation/method
 */
if ($sGUESTCREATEV->S_GUEST_CREATE_V007(new \StructType\S_GUEST_CREATE_V007Request()) !== false) {
    print_r($sGUESTCREATEV->getResult());
} else {
    print_r($sGUESTCREATEV->getLastError());
}
/**
 * Sample call for S_GUEST_CREATE_V008 operation/method
 */
if ($sGUESTCREATEV->S_GUEST_CREATE_V008(new \StructType\S_GUEST_CREATE_V008Request()) !== false) {
    print_r($sGUESTCREATEV->getResult());
} else {
    print_r($sGUESTCREATEV->getLastError());
}
/**
 * Samples for SGUESTCRITERIAGETV ServiceType
 */
$sGUESTCRITERIAGETV = new \ServiceType\SGUESTCRITERIAGETV($options);
/**
 * Sample call for S_GUEST_CRITERIA_GET_V001 operation/method
 */
if ($sGUESTCRITERIAGETV->S_GUEST_CRITERIA_GET_V001(new \StructType\S_GUEST_CRITERIA_GET_V001Request()) !== false) {
    print_r($sGUESTCRITERIAGETV->getResult());
} else {
    print_r($sGUESTCRITERIAGETV->getLastError());
}
/**
 * Samples for SGUESTCRITERIAMODIFYV ServiceType
 */
$sGUESTCRITERIAMODIFYV = new \ServiceType\SGUESTCRITERIAMODIFYV($options);
/**
 * Sample call for S_GUEST_CRITERIA_MODIFY_V001 operation/method
 */
if ($sGUESTCRITERIAMODIFYV->S_GUEST_CRITERIA_MODIFY_V001(new \StructType\S_GUEST_CRITERIA_MODIFY_V001Request()) !== false) {
    print_r($sGUESTCRITERIAMODIFYV->getResult());
} else {
    print_r($sGUESTCRITERIAMODIFYV->getLastError());
}
/**
 * Samples for SGUESTCRITERIASEARCHV ServiceType
 */
$sGUESTCRITERIASEARCHV = new \ServiceType\SGUESTCRITERIASEARCHV($options);
/**
 * Sample call for S_GUEST_CRITERIA_SEARCH_V001 operation/method
 */
if ($sGUESTCRITERIASEARCHV->S_GUEST_CRITERIA_SEARCH_V001(new \StructType\S_GUEST_CRITERIA_SEARCH_V001Request()) !== false) {
    print_r($sGUESTCRITERIASEARCHV->getResult());
} else {
    print_r($sGUESTCRITERIASEARCHV->getLastError());
}
/**
 * Samples for SGUESTGETV ServiceType
 */
$sGUESTGETV = new \ServiceType\SGUESTGETV($options);
/**
 * Sample call for S_GUEST_GET_V001 operation/method
 */
if ($sGUESTGETV->S_GUEST_GET_V001(new \StructType\S_GUEST_GET_V001Request()) !== false) {
    print_r($sGUESTGETV->getResult());
} else {
    print_r($sGUESTGETV->getLastError());
}
/**
 * Sample call for S_GUEST_GET_V002 operation/method
 */
if ($sGUESTGETV->S_GUEST_GET_V002(new \StructType\S_GUEST_GET_V002Request()) !== false) {
    print_r($sGUESTGETV->getResult());
} else {
    print_r($sGUESTGETV->getLastError());
}
/**
 * Sample call for S_GUEST_GET_V003 operation/method
 */
if ($sGUESTGETV->S_GUEST_GET_V003(new \StructType\S_GUEST_GET_V003Request()) !== false) {
    print_r($sGUESTGETV->getResult());
} else {
    print_r($sGUESTGETV->getLastError());
}
/**
 * Sample call for S_GUEST_GET_V004 operation/method
 */
if ($sGUESTGETV->S_GUEST_GET_V004(new \StructType\S_GUEST_GET_V004Request()) !== false) {
    print_r($sGUESTGETV->getResult());
} else {
    print_r($sGUESTGETV->getLastError());
}
/**
 * Sample call for S_GUEST_GET_V005 operation/method
 */
if ($sGUESTGETV->S_GUEST_GET_V005(new \StructType\S_GUEST_GET_V005Request()) !== false) {
    print_r($sGUESTGETV->getResult());
} else {
    print_r($sGUESTGETV->getLastError());
}
/**
 * Sample call for S_GUEST_GET_V006 operation/method
 */
if ($sGUESTGETV->S_GUEST_GET_V006(new \StructType\S_GUEST_GET_V006Request()) !== false) {
    print_r($sGUESTGETV->getResult());
} else {
    print_r($sGUESTGETV->getLastError());
}
/**
 * Sample call for S_GUEST_GET_V007 operation/method
 */
if ($sGUESTGETV->S_GUEST_GET_V007(new \StructType\S_GUEST_GET_V007Request()) !== false) {
    print_r($sGUESTGETV->getResult());
} else {
    print_r($sGUESTGETV->getLastError());
}
/**
 * Sample call for S_GUEST_GET_V008 operation/method
 */
if ($sGUESTGETV->S_GUEST_GET_V008(new \StructType\S_GUEST_GET_V008Request()) !== false) {
    print_r($sGUESTGETV->getResult());
} else {
    print_r($sGUESTGETV->getLastError());
}
/**
 * Samples for SGUESTHIERARCHYGETV ServiceType
 */
$sGUESTHIERARCHYGETV = new \ServiceType\SGUESTHIERARCHYGETV($options);
/**
 * Sample call for S_GUEST_HIERARCHY_GET_V001 operation/method
 */
if ($sGUESTHIERARCHYGETV->S_GUEST_HIERARCHY_GET_V001(new \StructType\S_GUEST_HIERARCHY_GET_V001Request()) !== false) {
    print_r($sGUESTHIERARCHYGETV->getResult());
} else {
    print_r($sGUESTHIERARCHYGETV->getLastError());
}
/**
 * Samples for SGUESTINHOUSESEARCHV ServiceType
 */
$sGUESTINHOUSESEARCHV = new \ServiceType\SGUESTINHOUSESEARCHV($options);
/**
 * Sample call for S_GUEST_IN_HOUSE_SEARCH_V001 operation/method
 */
if ($sGUESTINHOUSESEARCHV->S_GUEST_IN_HOUSE_SEARCH_V001(new \StructType\S_GUEST_IN_HOUSE_SEARCH_V001Request()) !== false) {
    print_r($sGUESTINHOUSESEARCHV->getResult());
} else {
    print_r($sGUESTINHOUSESEARCHV->getLastError());
}
/**
 * Sample call for S_GUEST_IN_HOUSE_SEARCH_V002 operation/method
 */
if ($sGUESTINHOUSESEARCHV->S_GUEST_IN_HOUSE_SEARCH_V002(new \StructType\S_GUEST_IN_HOUSE_SEARCH_V002Request()) !== false) {
    print_r($sGUESTINHOUSESEARCHV->getResult());
} else {
    print_r($sGUESTINHOUSESEARCHV->getLastError());
}
/**
 * Samples for SGUESTLOYALTYCARDSADDV ServiceType
 */
$sGUESTLOYALTYCARDSADDV = new \ServiceType\SGUESTLOYALTYCARDSADDV($options);
/**
 * Sample call for S_GUEST_LOYALTY_CARDS_ADD_V001 operation/method
 */
if ($sGUESTLOYALTYCARDSADDV->S_GUEST_LOYALTY_CARDS_ADD_V001(new \StructType\S_GUEST_LOYALTY_CARDS_ADD_V001Request()) !== false) {
    print_r($sGUESTLOYALTYCARDSADDV->getResult());
} else {
    print_r($sGUESTLOYALTYCARDSADDV->getLastError());
}
/**
 * Samples for SGUESTLOYALTYCARDSDELETEV ServiceType
 */
$sGUESTLOYALTYCARDSDELETEV = new \ServiceType\SGUESTLOYALTYCARDSDELETEV($options);
/**
 * Sample call for S_GUEST_LOYALTY_CARDS_DELETE_V001 operation/method
 */
if ($sGUESTLOYALTYCARDSDELETEV->S_GUEST_LOYALTY_CARDS_DELETE_V001(new \StructType\S_GUEST_LOYALTY_CARDS_DELETE_V001Request()) !== false) {
    print_r($sGUESTLOYALTYCARDSDELETEV->getResult());
} else {
    print_r($sGUESTLOYALTYCARDSDELETEV->getLastError());
}
/**
 * Samples for SGUESTLOYALTYCARDSGETV ServiceType
 */
$sGUESTLOYALTYCARDSGETV = new \ServiceType\SGUESTLOYALTYCARDSGETV($options);
/**
 * Sample call for S_GUEST_LOYALTY_CARDS_GET_V001 operation/method
 */
if ($sGUESTLOYALTYCARDSGETV->S_GUEST_LOYALTY_CARDS_GET_V001(new \StructType\S_GUEST_LOYALTY_CARDS_GET_V001Request()) !== false) {
    print_r($sGUESTLOYALTYCARDSGETV->getResult());
} else {
    print_r($sGUESTLOYALTYCARDSGETV->getLastError());
}
/**
 * Samples for SGUESTLOYALTYCARDSMODIFYV ServiceType
 */
$sGUESTLOYALTYCARDSMODIFYV = new \ServiceType\SGUESTLOYALTYCARDSMODIFYV($options);
/**
 * Sample call for S_GUEST_LOYALTY_CARDS_MODIFY_V001 operation/method
 */
if ($sGUESTLOYALTYCARDSMODIFYV->S_GUEST_LOYALTY_CARDS_MODIFY_V001(new \StructType\S_GUEST_LOYALTY_CARDS_MODIFY_V001Request()) !== false) {
    print_r($sGUESTLOYALTYCARDSMODIFYV->getResult());
} else {
    print_r($sGUESTLOYALTYCARDSMODIFYV->getLastError());
}
/**
 * Samples for SGUESTMERGEV ServiceType
 */
$sGUESTMERGEV = new \ServiceType\SGUESTMERGEV($options);
/**
 * Sample call for S_GUEST_MERGE_V001 operation/method
 */
if ($sGUESTMERGEV->S_GUEST_MERGE_V001(new \StructType\S_GUEST_MERGE_V001Request()) !== false) {
    print_r($sGUESTMERGEV->getResult());
} else {
    print_r($sGUESTMERGEV->getLastError());
}
/**
 * Samples for SGUESTMODIFYV ServiceType
 */
$sGUESTMODIFYV = new \ServiceType\SGUESTMODIFYV($options);
/**
 * Sample call for S_GUEST_MODIFY_V001 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V001(new \StructType\S_GUEST_MODIFY_V001Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Sample call for S_GUEST_MODIFY_V002 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V002(new \StructType\S_GUEST_MODIFY_V002Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Sample call for S_GUEST_MODIFY_V003 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V003(new \StructType\S_GUEST_MODIFY_V003Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Sample call for S_GUEST_MODIFY_V004 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V004(new \StructType\S_GUEST_MODIFY_V004Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Sample call for S_GUEST_MODIFY_V005 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V005(new \StructType\S_GUEST_MODIFY_V005Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Sample call for S_GUEST_MODIFY_V006 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V006(new \StructType\S_GUEST_MODIFY_V006Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Sample call for S_GUEST_MODIFY_V007 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V007(new \StructType\S_GUEST_MODIFY_V007Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Sample call for S_GUEST_MODIFY_V008 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V008(new \StructType\S_GUEST_MODIFY_V008Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Sample call for S_GUEST_MODIFY_V009 operation/method
 */
if ($sGUESTMODIFYV->S_GUEST_MODIFY_V009(new \StructType\S_GUEST_MODIFY_V009Request()) !== false) {
    print_r($sGUESTMODIFYV->getResult());
} else {
    print_r($sGUESTMODIFYV->getLastError());
}
/**
 * Samples for SGUESTPAYMENTINSTRUCTIONSGETV ServiceType
 */
$sGUESTPAYMENTINSTRUCTIONSGETV = new \ServiceType\SGUESTPAYMENTINSTRUCTIONSGETV($options);
/**
 * Sample call for S_GUEST_PAYMENT_INSTRUCTIONS_GET_V001 operation/method
 */
if ($sGUESTPAYMENTINSTRUCTIONSGETV->S_GUEST_PAYMENT_INSTRUCTIONS_GET_V001(new \StructType\S_GUEST_PAYMENT_INSTRUCTIONS_GET_V001Request()) !== false) {
    print_r($sGUESTPAYMENTINSTRUCTIONSGETV->getResult());
} else {
    print_r($sGUESTPAYMENTINSTRUCTIONSGETV->getLastError());
}
/**
 * Samples for SGUESTPAYMENTINSTRUCTIONSSETV ServiceType
 */
$sGUESTPAYMENTINSTRUCTIONSSETV = new \ServiceType\SGUESTPAYMENTINSTRUCTIONSSETV($options);
/**
 * Sample call for S_GUEST_PAYMENT_INSTRUCTIONS_SET_V001 operation/method
 */
if ($sGUESTPAYMENTINSTRUCTIONSSETV->S_GUEST_PAYMENT_INSTRUCTIONS_SET_V001(new \StructType\S_GUEST_PAYMENT_INSTRUCTIONS_SET_V001Request()) !== false) {
    print_r($sGUESTPAYMENTINSTRUCTIONSSETV->getResult());
} else {
    print_r($sGUESTPAYMENTINSTRUCTIONSSETV->getLastError());
}
/**
 * Samples for SGUESTSEARCHV ServiceType
 */
$sGUESTSEARCHV = new \ServiceType\SGUESTSEARCHV($options);
/**
 * Sample call for S_GUEST_SEARCH_V002 operation/method
 */
if ($sGUESTSEARCHV->S_GUEST_SEARCH_V002(new \StructType\S_GUEST_SEARCH_V002Request()) !== false) {
    print_r($sGUESTSEARCHV->getResult());
} else {
    print_r($sGUESTSEARCHV->getLastError());
}
/**
 * Sample call for S_GUEST_SEARCH_V003 operation/method
 */
if ($sGUESTSEARCHV->S_GUEST_SEARCH_V003(new \StructType\S_GUEST_SEARCH_V003Request()) !== false) {
    print_r($sGUESTSEARCHV->getResult());
} else {
    print_r($sGUESTSEARCHV->getLastError());
}
/**
 * Sample call for S_GUEST_SEARCH_V004 operation/method
 */
if ($sGUESTSEARCHV->S_GUEST_SEARCH_V004(new \StructType\S_GUEST_SEARCH_V004Request()) !== false) {
    print_r($sGUESTSEARCHV->getResult());
} else {
    print_r($sGUESTSEARCHV->getLastError());
}
/**
 * Sample call for S_GUEST_SEARCH_V005 operation/method
 */
if ($sGUESTSEARCHV->S_GUEST_SEARCH_V005(new \StructType\S_GUEST_SEARCH_V005Request()) !== false) {
    print_r($sGUESTSEARCHV->getResult());
} else {
    print_r($sGUESTSEARCHV->getLastError());
}
/**
 * Sample call for S_GUEST_SEARCH_V006 operation/method
 */
if ($sGUESTSEARCHV->S_GUEST_SEARCH_V006(new \StructType\S_GUEST_SEARCH_V006Request()) !== false) {
    print_r($sGUESTSEARCHV->getResult());
} else {
    print_r($sGUESTSEARCHV->getLastError());
}
/**
 * Sample call for S_GUEST_SEARCH_V007 operation/method
 */
if ($sGUESTSEARCHV->S_GUEST_SEARCH_V007(new \StructType\S_GUEST_SEARCH_V007Request()) !== false) {
    print_r($sGUESTSEARCHV->getResult());
} else {
    print_r($sGUESTSEARCHV->getLastError());
}
/**
 * Sample call for S_GUEST_SEARCH_V008 operation/method
 */
if ($sGUESTSEARCHV->S_GUEST_SEARCH_V008(new \StructType\S_GUEST_SEARCH_V008Request()) !== false) {
    print_r($sGUESTSEARCHV->getResult());
} else {
    print_r($sGUESTSEARCHV->getLastError());
}
/**
 * Samples for SGUESTSETTLEMENTPROFILEADDV ServiceType
 */
$sGUESTSETTLEMENTPROFILEADDV = new \ServiceType\SGUESTSETTLEMENTPROFILEADDV($options);
/**
 * Sample call for S_GUEST_SETTLEMENT_PROFILE_ADD_V001 operation/method
 */
if ($sGUESTSETTLEMENTPROFILEADDV->S_GUEST_SETTLEMENT_PROFILE_ADD_V001(new \StructType\S_GUEST_SETTLEMENT_PROFILE_ADD_V001Request()) !== false) {
    print_r($sGUESTSETTLEMENTPROFILEADDV->getResult());
} else {
    print_r($sGUESTSETTLEMENTPROFILEADDV->getLastError());
}
/**
 * Sample call for S_GUEST_SETTLEMENT_PROFILE_ADD_V002 operation/method
 */
if ($sGUESTSETTLEMENTPROFILEADDV->S_GUEST_SETTLEMENT_PROFILE_ADD_V002(new \StructType\S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request()) !== false) {
    print_r($sGUESTSETTLEMENTPROFILEADDV->getResult());
} else {
    print_r($sGUESTSETTLEMENTPROFILEADDV->getLastError());
}
/**
 * Samples for SGUESTSETTLEMENTPROFILEGETV ServiceType
 */
$sGUESTSETTLEMENTPROFILEGETV = new \ServiceType\SGUESTSETTLEMENTPROFILEGETV($options);
/**
 * Sample call for S_GUEST_SETTLEMENT_PROFILE_GET_V001 operation/method
 */
if ($sGUESTSETTLEMENTPROFILEGETV->S_GUEST_SETTLEMENT_PROFILE_GET_V001(new \StructType\S_GUEST_SETTLEMENT_PROFILE_GET_V001Request()) !== false) {
    print_r($sGUESTSETTLEMENTPROFILEGETV->getResult());
} else {
    print_r($sGUESTSETTLEMENTPROFILEGETV->getLastError());
}
/**
 * Sample call for S_GUEST_SETTLEMENT_PROFILE_GET_V002 operation/method
 */
if ($sGUESTSETTLEMENTPROFILEGETV->S_GUEST_SETTLEMENT_PROFILE_GET_V002(new \StructType\S_GUEST_SETTLEMENT_PROFILE_GET_V002Request()) !== false) {
    print_r($sGUESTSETTLEMENTPROFILEGETV->getResult());
} else {
    print_r($sGUESTSETTLEMENTPROFILEGETV->getLastError());
}
/**
 * Samples for SGUESTSETTLEMENTPROFILEMODIFYV ServiceType
 */
$sGUESTSETTLEMENTPROFILEMODIFYV = new \ServiceType\SGUESTSETTLEMENTPROFILEMODIFYV($options);
/**
 * Sample call for S_GUEST_SETTLEMENT_PROFILE_MODIFY_V001 operation/method
 */
if ($sGUESTSETTLEMENTPROFILEMODIFYV->S_GUEST_SETTLEMENT_PROFILE_MODIFY_V001(new \StructType\S_GUEST_SETTLEMENT_PROFILE_MODIFY_V001Request()) !== false) {
    print_r($sGUESTSETTLEMENTPROFILEMODIFYV->getResult());
} else {
    print_r($sGUESTSETTLEMENTPROFILEMODIFYV->getLastError());
}
/**
 * Samples for SGUESTSETTLEMENTPROFILEREMOVEV ServiceType
 */
$sGUESTSETTLEMENTPROFILEREMOVEV = new \ServiceType\SGUESTSETTLEMENTPROFILEREMOVEV($options);
/**
 * Sample call for S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001 operation/method
 */
if ($sGUESTSETTLEMENTPROFILEREMOVEV->S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001(new \StructType\S_GUEST_SETTLEMENT_PROFILE_REMOVE_V001Request()) !== false) {
    print_r($sGUESTSETTLEMENTPROFILEREMOVEV->getResult());
} else {
    print_r($sGUESTSETTLEMENTPROFILEREMOVEV->getLastError());
}
/**
 * Samples for SGUESTTOKENADDV ServiceType
 */
$sGUESTTOKENADDV = new \ServiceType\SGUESTTOKENADDV($options);
/**
 * Sample call for S_GUEST_TOKEN_ADD_V001 operation/method
 */
if ($sGUESTTOKENADDV->S_GUEST_TOKEN_ADD_V001(new \StructType\S_GUEST_TOKEN_ADD_V001Request()) !== false) {
    print_r($sGUESTTOKENADDV->getResult());
} else {
    print_r($sGUESTTOKENADDV->getLastError());
}
/**
 * Samples for SGUESTTRAILNODEGETV ServiceType
 */
$sGUESTTRAILNODEGETV = new \ServiceType\SGUESTTRAILNODEGETV($options);
/**
 * Sample call for S_GUEST_TRAIL_NODE_GET_V001 operation/method
 */
if ($sGUESTTRAILNODEGETV->S_GUEST_TRAIL_NODE_GET_V001(new \StructType\S_GUEST_TRAIL_NODE_GET_V001Request()) !== false) {
    print_r($sGUESTTRAILNODEGETV->getResult());
} else {
    print_r($sGUESTTRAILNODEGETV->getLastError());
}
/**
 * Samples for SHOTELGETV ServiceType
 */
$sHOTELGETV = new \ServiceType\SHOTELGETV($options);
/**
 * Sample call for S_HOTEL_GET_V001 operation/method
 */
if ($sHOTELGETV->S_HOTEL_GET_V001(new \StructType\S_HOTEL_GET_V001Request()) !== false) {
    print_r($sHOTELGETV->getResult());
} else {
    print_r($sHOTELGETV->getLastError());
}
/**
 * Samples for SHOTELRESTRICTIONSEARCHV ServiceType
 */
$sHOTELRESTRICTIONSEARCHV = new \ServiceType\SHOTELRESTRICTIONSEARCHV($options);
/**
 * Sample call for S_HOTEL_RESTRICTION_SEARCH_V001 operation/method
 */
if ($sHOTELRESTRICTIONSEARCHV->S_HOTEL_RESTRICTION_SEARCH_V001(new \StructType\S_HOTEL_RESTRICTION_SEARCH_V001Request()) !== false) {
    print_r($sHOTELRESTRICTIONSEARCHV->getResult());
} else {
    print_r($sHOTELRESTRICTIONSEARCHV->getLastError());
}
/**
 * Sample call for S_HOTEL_RESTRICTION_SEARCH_V002 operation/method
 */
if ($sHOTELRESTRICTIONSEARCHV->S_HOTEL_RESTRICTION_SEARCH_V002(new \StructType\S_HOTEL_RESTRICTION_SEARCH_V002Request()) !== false) {
    print_r($sHOTELRESTRICTIONSEARCHV->getResult());
} else {
    print_r($sHOTELRESTRICTIONSEARCHV->getLastError());
}
/**
 * Samples for SHOTELSEARCHV ServiceType
 */
$sHOTELSEARCHV = new \ServiceType\SHOTELSEARCHV($options);
/**
 * Sample call for S_HOTEL_SEARCH_V001 operation/method
 */
if ($sHOTELSEARCHV->S_HOTEL_SEARCH_V001(new \StructType\S_HOTEL_SEARCH_V001Request()) !== false) {
    print_r($sHOTELSEARCHV->getResult());
} else {
    print_r($sHOTELSEARCHV->getLastError());
}
/**
 * Sample call for S_HOTEL_SEARCH_V01 operation/method
 */
if ($sHOTELSEARCHV->S_HOTEL_SEARCH_V01(new \StructType\S_HOTEL_SEARCH_V01Request()) !== false) {
    print_r($sHOTELSEARCHV->getResult());
} else {
    print_r($sHOTELSEARCHV->getLastError());
}
/**
 * Samples for SHOTELV ServiceType
 */
$sHOTELV = new \ServiceType\SHOTELV($options);
/**
 * Sample call for S_HOTEL_V001 operation/method
 */
if ($sHOTELV->S_HOTEL_V001(new \StructType\S_HOTEL_V001Request()) !== false) {
    print_r($sHOTELV->getResult());
} else {
    print_r($sHOTELV->getLastError());
}
/**
 * Samples for SIMAGESADDV ServiceType
 */
$sIMAGESADDV = new \ServiceType\SIMAGESADDV($options);
/**
 * Sample call for S_IMAGES_ADD_V001 operation/method
 */
if ($sIMAGESADDV->S_IMAGES_ADD_V001(new \StructType\S_IMAGES_ADD_V001Request()) !== false) {
    print_r($sIMAGESADDV->getResult());
} else {
    print_r($sIMAGESADDV->getLastError());
}
/**
 * Samples for SIMAGEADDV ServiceType
 */
$sIMAGEADDV = new \ServiceType\SIMAGEADDV($options);
/**
 * Sample call for S_IMAGE_ADD_V001 operation/method
 */
if ($sIMAGEADDV->S_IMAGE_ADD_V001(new \StructType\S_IMAGE_ADD_V001Request()) !== false) {
    print_r($sIMAGEADDV->getResult());
} else {
    print_r($sIMAGEADDV->getLastError());
}
/**
 * Samples for SINVOICEEMAILSETV ServiceType
 */
$sINVOICEEMAILSETV = new \ServiceType\SINVOICEEMAILSETV($options);
/**
 * Sample call for S_INVOICE_EMAIL_SET_V001 operation/method
 */
if ($sINVOICEEMAILSETV->S_INVOICE_EMAIL_SET_V001(new \StructType\S_INVOICE_EMAIL_SET_V001Request()) !== false) {
    print_r($sINVOICEEMAILSETV->getResult());
} else {
    print_r($sINVOICEEMAILSETV->getLastError());
}
/**
 * Samples for SINVOICEEMAILTRIGGERV ServiceType
 */
$sINVOICEEMAILTRIGGERV = new \ServiceType\SINVOICEEMAILTRIGGERV($options);
/**
 * Sample call for S_INVOICE_EMAIL_TRIGGER_V001 operation/method
 */
if ($sINVOICEEMAILTRIGGERV->S_INVOICE_EMAIL_TRIGGER_V001(new \StructType\S_INVOICE_EMAIL_TRIGGER_V001Request()) !== false) {
    print_r($sINVOICEEMAILTRIGGERV->getResult());
} else {
    print_r($sINVOICEEMAILTRIGGERV->getLastError());
}
/**
 * Samples for SINVOICEGETV ServiceType
 */
$sINVOICEGETV = new \ServiceType\SINVOICEGETV($options);
/**
 * Sample call for S_INVOICE_GET_V001 operation/method
 */
if ($sINVOICEGETV->S_INVOICE_GET_V001(new \StructType\S_INVOICE_GET_V001Request()) !== false) {
    print_r($sINVOICEGETV->getResult());
} else {
    print_r($sINVOICEGETV->getLastError());
}
/**
 * Sample call for S_INVOICE_GET_V002 operation/method
 */
if ($sINVOICEGETV->S_INVOICE_GET_V002(new \StructType\S_INVOICE_GET_V002Request()) !== false) {
    print_r($sINVOICEGETV->getResult());
} else {
    print_r($sINVOICEGETV->getLastError());
}
/**
 * Samples for SINVOICESEARCHV ServiceType
 */
$sINVOICESEARCHV = new \ServiceType\SINVOICESEARCHV($options);
/**
 * Sample call for S_INVOICE_SEARCH_V001 operation/method
 */
if ($sINVOICESEARCHV->S_INVOICE_SEARCH_V001(new \StructType\S_INVOICE_SEARCH_V001Request()) !== false) {
    print_r($sINVOICESEARCHV->getResult());
} else {
    print_r($sINVOICESEARCHV->getLastError());
}
/**
 * Samples for SMOBILEGUESTINHOUSESEARCHV ServiceType
 */
$sMOBILEGUESTINHOUSESEARCHV = new \ServiceType\SMOBILEGUESTINHOUSESEARCHV($options);
/**
 * Sample call for S_MOBILE_GUEST_IN_HOUSE_SEARCH_V001 operation/method
 */
if ($sMOBILEGUESTINHOUSESEARCHV->S_MOBILE_GUEST_IN_HOUSE_SEARCH_V001(new \StructType\S_MOBILE_GUEST_IN_HOUSE_SEARCH_V001Request()) !== false) {
    print_r($sMOBILEGUESTINHOUSESEARCHV->getResult());
} else {
    print_r($sMOBILEGUESTINHOUSESEARCHV->getLastError());
}
/**
 * Samples for SMOBILEHOTELGETV ServiceType
 */
$sMOBILEHOTELGETV = new \ServiceType\SMOBILEHOTELGETV($options);
/**
 * Sample call for S_MOBILE_HOTEL_GET_V001 operation/method
 */
if ($sMOBILEHOTELGETV->S_MOBILE_HOTEL_GET_V001(new \StructType\S_MOBILE_HOTEL_GET_V001Request()) !== false) {
    print_r($sMOBILEHOTELGETV->getResult());
} else {
    print_r($sMOBILEHOTELGETV->getLastError());
}
/**
 * Samples for SMOBILEHOTELSEARCHV ServiceType
 */
$sMOBILEHOTELSEARCHV = new \ServiceType\SMOBILEHOTELSEARCHV($options);
/**
 * Sample call for S_MOBILE_HOTEL_SEARCH_V001 operation/method
 */
if ($sMOBILEHOTELSEARCHV->S_MOBILE_HOTEL_SEARCH_V001(new \StructType\S_MOBILE_HOTEL_SEARCH_V001Request()) !== false) {
    print_r($sMOBILEHOTELSEARCHV->getResult());
} else {
    print_r($sMOBILEHOTELSEARCHV->getLastError());
}
/**
 * Samples for SMOBILEIMAGEADDV ServiceType
 */
$sMOBILEIMAGEADDV = new \ServiceType\SMOBILEIMAGEADDV($options);
/**
 * Sample call for S_MOBILE_IMAGE_ADD_V001 operation/method
 */
if ($sMOBILEIMAGEADDV->S_MOBILE_IMAGE_ADD_V001(new \StructType\S_MOBILE_IMAGE_ADD_V001Request()) !== false) {
    print_r($sMOBILEIMAGEADDV->getResult());
} else {
    print_r($sMOBILEIMAGEADDV->getLastError());
}
/**
 * Samples for SMOBILEIMAGEDELETEV ServiceType
 */
$sMOBILEIMAGEDELETEV = new \ServiceType\SMOBILEIMAGEDELETEV($options);
/**
 * Sample call for S_MOBILE_IMAGE_DELETE_V001 operation/method
 */
if ($sMOBILEIMAGEDELETEV->S_MOBILE_IMAGE_DELETE_V001(new \StructType\S_MOBILE_IMAGE_DELETE_V001Request()) !== false) {
    print_r($sMOBILEIMAGEDELETEV->getResult());
} else {
    print_r($sMOBILEIMAGEDELETEV->getLastError());
}
/**
 * Samples for SMOBILEIMAGEMODIFYV ServiceType
 */
$sMOBILEIMAGEMODIFYV = new \ServiceType\SMOBILEIMAGEMODIFYV($options);
/**
 * Sample call for S_MOBILE_IMAGE_MODIFY_V001 operation/method
 */
if ($sMOBILEIMAGEMODIFYV->S_MOBILE_IMAGE_MODIFY_V001(new \StructType\S_MOBILE_IMAGE_MODIFY_V001Request()) !== false) {
    print_r($sMOBILEIMAGEMODIFYV->getResult());
} else {
    print_r($sMOBILEIMAGEMODIFYV->getLastError());
}
/**
 * Samples for SMOBILELOSTANDFOUNDADDV ServiceType
 */
$sMOBILELOSTANDFOUNDADDV = new \ServiceType\SMOBILELOSTANDFOUNDADDV($options);
/**
 * Sample call for S_MOBILE_LOST_AND_FOUND_ADD_V001 operation/method
 */
if ($sMOBILELOSTANDFOUNDADDV->S_MOBILE_LOST_AND_FOUND_ADD_V001(new \StructType\S_MOBILE_LOST_AND_FOUND_ADD_V001Request()) !== false) {
    print_r($sMOBILELOSTANDFOUNDADDV->getResult());
} else {
    print_r($sMOBILELOSTANDFOUNDADDV->getLastError());
}
/**
 * Samples for SMOBILELOSTANDFOUNDDELETEV ServiceType
 */
$sMOBILELOSTANDFOUNDDELETEV = new \ServiceType\SMOBILELOSTANDFOUNDDELETEV($options);
/**
 * Sample call for S_MOBILE_LOST_AND_FOUND_DELETE_V001 operation/method
 */
if ($sMOBILELOSTANDFOUNDDELETEV->S_MOBILE_LOST_AND_FOUND_DELETE_V001(new \StructType\S_MOBILE_LOST_AND_FOUND_DELETE_V001Request()) !== false) {
    print_r($sMOBILELOSTANDFOUNDDELETEV->getResult());
} else {
    print_r($sMOBILELOSTANDFOUNDDELETEV->getLastError());
}
/**
 * Samples for SMOBILELOSTANDFOUNDGETV ServiceType
 */
$sMOBILELOSTANDFOUNDGETV = new \ServiceType\SMOBILELOSTANDFOUNDGETV($options);
/**
 * Sample call for S_MOBILE_LOST_AND_FOUND_GET_V001 operation/method
 */
if ($sMOBILELOSTANDFOUNDGETV->S_MOBILE_LOST_AND_FOUND_GET_V001(new \StructType\S_MOBILE_LOST_AND_FOUND_GET_V001Request()) !== false) {
    print_r($sMOBILELOSTANDFOUNDGETV->getResult());
} else {
    print_r($sMOBILELOSTANDFOUNDGETV->getLastError());
}
/**
 * Samples for SMOBILELOSTANDFOUNDIMAGEGETV ServiceType
 */
$sMOBILELOSTANDFOUNDIMAGEGETV = new \ServiceType\SMOBILELOSTANDFOUNDIMAGEGETV($options);
/**
 * Sample call for S_MOBILE_LOST_AND_FOUND_IMAGE_GET_V001 operation/method
 */
if ($sMOBILELOSTANDFOUNDIMAGEGETV->S_MOBILE_LOST_AND_FOUND_IMAGE_GET_V001(new \StructType\S_MOBILE_LOST_AND_FOUND_IMAGE_GET_V001Request()) !== false) {
    print_r($sMOBILELOSTANDFOUNDIMAGEGETV->getResult());
} else {
    print_r($sMOBILELOSTANDFOUNDIMAGEGETV->getLastError());
}
/**
 * Samples for SMOBILELOSTANDFOUNDMODIFYV ServiceType
 */
$sMOBILELOSTANDFOUNDMODIFYV = new \ServiceType\SMOBILELOSTANDFOUNDMODIFYV($options);
/**
 * Sample call for S_MOBILE_LOST_AND_FOUND_MODIFY_V001 operation/method
 */
if ($sMOBILELOSTANDFOUNDMODIFYV->S_MOBILE_LOST_AND_FOUND_MODIFY_V001(new \StructType\S_MOBILE_LOST_AND_FOUND_MODIFY_V001Request()) !== false) {
    print_r($sMOBILELOSTANDFOUNDMODIFYV->getResult());
} else {
    print_r($sMOBILELOSTANDFOUNDMODIFYV->getLastError());
}
/**
 * Samples for SMOBILELOSTANDFOUNDSEARCHV ServiceType
 */
$sMOBILELOSTANDFOUNDSEARCHV = new \ServiceType\SMOBILELOSTANDFOUNDSEARCHV($options);
/**
 * Sample call for S_MOBILE_LOST_AND_FOUND_SEARCH_V001 operation/method
 */
if ($sMOBILELOSTANDFOUNDSEARCHV->S_MOBILE_LOST_AND_FOUND_SEARCH_V001(new \StructType\S_MOBILE_LOST_AND_FOUND_SEARCH_V001Request()) !== false) {
    print_r($sMOBILELOSTANDFOUNDSEARCHV->getResult());
} else {
    print_r($sMOBILELOSTANDFOUNDSEARCHV->getLastError());
}
/**
 * Samples for SMOBILEROOMSTOCLEANINDIVIDUALGETV ServiceType
 */
$sMOBILEROOMSTOCLEANINDIVIDUALGETV = new \ServiceType\SMOBILEROOMSTOCLEANINDIVIDUALGETV($options);
/**
 * Sample call for S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_GET_V001 operation/method
 */
if ($sMOBILEROOMSTOCLEANINDIVIDUALGETV->S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_GET_V001(new \StructType\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_GET_V001Request()) !== false) {
    print_r($sMOBILEROOMSTOCLEANINDIVIDUALGETV->getResult());
} else {
    print_r($sMOBILEROOMSTOCLEANINDIVIDUALGETV->getLastError());
}
/**
 * Samples for SMOBILEROOMSTOCLEANINDIVIDUALMODIFYV ServiceType
 */
$sMOBILEROOMSTOCLEANINDIVIDUALMODIFYV = new \ServiceType\SMOBILEROOMSTOCLEANINDIVIDUALMODIFYV($options);
/**
 * Sample call for S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_MODIFY_V001 operation/method
 */
if ($sMOBILEROOMSTOCLEANINDIVIDUALMODIFYV->S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_MODIFY_V001(new \StructType\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_MODIFY_V001Request()) !== false) {
    print_r($sMOBILEROOMSTOCLEANINDIVIDUALMODIFYV->getResult());
} else {
    print_r($sMOBILEROOMSTOCLEANINDIVIDUALMODIFYV->getLastError());
}
/**
 * Samples for SMOBILEROOMSTOCLEANINDIVIDUALSEARCHV ServiceType
 */
$sMOBILEROOMSTOCLEANINDIVIDUALSEARCHV = new \ServiceType\SMOBILEROOMSTOCLEANINDIVIDUALSEARCHV($options);
/**
 * Sample call for S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_SEARCH_V001 operation/method
 */
if ($sMOBILEROOMSTOCLEANINDIVIDUALSEARCHV->S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_SEARCH_V001(new \StructType\S_MOBILE_ROOMS_TO_CLEAN_INDIVIDUAL_SEARCH_V001Request()) !== false) {
    print_r($sMOBILEROOMSTOCLEANINDIVIDUALSEARCHV->getResult());
} else {
    print_r($sMOBILEROOMSTOCLEANINDIVIDUALSEARCHV->getLastError());
}
/**
 * Samples for SMOBILEROOMACTIVEMAINTENANCESTATEGETV ServiceType
 */
$sMOBILEROOMACTIVEMAINTENANCESTATEGETV = new \ServiceType\SMOBILEROOMACTIVEMAINTENANCESTATEGETV($options);
/**
 * Sample call for S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001 operation/method
 */
if ($sMOBILEROOMACTIVEMAINTENANCESTATEGETV->S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001(new \StructType\S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Request()) !== false) {
    print_r($sMOBILEROOMACTIVEMAINTENANCESTATEGETV->getResult());
} else {
    print_r($sMOBILEROOMACTIVEMAINTENANCESTATEGETV->getLastError());
}
/**
 * Samples for SMOBILEROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV ServiceType
 */
$sMOBILEROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV = new \ServiceType\SMOBILEROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV($options);
/**
 * Sample call for S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001
 * operation/method
 */
if ($sMOBILEROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV->S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001(new \StructType\S_MOBILE_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request()) !== false) {
    print_r($sMOBILEROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV->getResult());
} else {
    print_r($sMOBILEROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV->getLastError());
}
/**
 * Samples for SMOBILEROOMCLEANINGSTATUSCHANGEV ServiceType
 */
$sMOBILEROOMCLEANINGSTATUSCHANGEV = new \ServiceType\SMOBILEROOMCLEANINGSTATUSCHANGEV($options);
/**
 * Sample call for S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001 operation/method
 */
if ($sMOBILEROOMCLEANINGSTATUSCHANGEV->S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001(new \StructType\S_MOBILE_ROOM_CLEANING_STATUS_CHANGE_V001Request()) !== false) {
    print_r($sMOBILEROOMCLEANINGSTATUSCHANGEV->getResult());
} else {
    print_r($sMOBILEROOMCLEANINGSTATUSCHANGEV->getLastError());
}
/**
 * Samples for SMOBILEROOMMAINTENANCESTATERESETV ServiceType
 */
$sMOBILEROOMMAINTENANCESTATERESETV = new \ServiceType\SMOBILEROOMMAINTENANCESTATERESETV($options);
/**
 * Sample call for S_MOBILE_ROOM_MAINTENANCE_STATE_RESET_V001 operation/method
 */
if ($sMOBILEROOMMAINTENANCESTATERESETV->S_MOBILE_ROOM_MAINTENANCE_STATE_RESET_V001(new \StructType\S_MOBILE_ROOM_MAINTENANCE_STATE_RESET_V001Request()) !== false) {
    print_r($sMOBILEROOMMAINTENANCESTATERESETV->getResult());
} else {
    print_r($sMOBILEROOMMAINTENANCESTATERESETV->getLastError());
}
/**
 * Samples for SMOBILEROOMSTATECHANGEV ServiceType
 */
$sMOBILEROOMSTATECHANGEV = new \ServiceType\SMOBILEROOMSTATECHANGEV($options);
/**
 * Sample call for S_MOBILE_ROOM_STATE_CHANGE_V001 operation/method
 */
if ($sMOBILEROOMSTATECHANGEV->S_MOBILE_ROOM_STATE_CHANGE_V001(new \StructType\S_MOBILE_ROOM_STATE_CHANGE_V001Request()) !== false) {
    print_r($sMOBILEROOMSTATECHANGEV->getResult());
} else {
    print_r($sMOBILEROOMSTATECHANGEV->getLastError());
}
/**
 * Samples for SMOBILEROOMSTATESEARCHV ServiceType
 */
$sMOBILEROOMSTATESEARCHV = new \ServiceType\SMOBILEROOMSTATESEARCHV($options);
/**
 * Sample call for S_MOBILE_ROOM_STATE_SEARCH_V001 operation/method
 */
if ($sMOBILEROOMSTATESEARCHV->S_MOBILE_ROOM_STATE_SEARCH_V001(new \StructType\S_MOBILE_ROOM_STATE_SEARCH_V001Request()) !== false) {
    print_r($sMOBILEROOMSTATESEARCHV->getResult());
} else {
    print_r($sMOBILEROOMSTATESEARCHV->getLastError());
}
/**
 * Samples for SNOTIFICATIONCONFIRMV ServiceType
 */
$sNOTIFICATIONCONFIRMV = new \ServiceType\SNOTIFICATIONCONFIRMV($options);
/**
 * Sample call for S_NOTIFICATION_CONFIRM_V001 operation/method
 */
if ($sNOTIFICATIONCONFIRMV->S_NOTIFICATION_CONFIRM_V001(new \StructType\S_NOTIFICATION_CONFIRM_V001Request()) !== false) {
    print_r($sNOTIFICATIONCONFIRMV->getResult());
} else {
    print_r($sNOTIFICATIONCONFIRMV->getLastError());
}
/**
 * Samples for SNOTIFICATIONERRORSETV ServiceType
 */
$sNOTIFICATIONERRORSETV = new \ServiceType\SNOTIFICATIONERRORSETV($options);
/**
 * Sample call for S_NOTIFICATION_ERROR_SET_V001 operation/method
 */
if ($sNOTIFICATIONERRORSETV->S_NOTIFICATION_ERROR_SET_V001(new \StructType\S_NOTIFICATION_ERROR_SET_V001Request()) !== false) {
    print_r($sNOTIFICATIONERRORSETV->getResult());
} else {
    print_r($sNOTIFICATIONERRORSETV->getLastError());
}
/**
 * Samples for SNOTIFICATIONREGISTERV ServiceType
 */
$sNOTIFICATIONREGISTERV = new \ServiceType\SNOTIFICATIONREGISTERV($options);
/**
 * Sample call for S_NOTIFICATION_REGISTER_V001 operation/method
 */
if ($sNOTIFICATIONREGISTERV->S_NOTIFICATION_REGISTER_V001(new \StructType\S_NOTIFICATION_REGISTER_V001Request()) !== false) {
    print_r($sNOTIFICATIONREGISTERV->getResult());
} else {
    print_r($sNOTIFICATIONREGISTERV->getLastError());
}
/**
 * Sample call for S_NOTIFICATION_REGISTER_V002 operation/method
 */
if ($sNOTIFICATIONREGISTERV->S_NOTIFICATION_REGISTER_V002(new \StructType\S_NOTIFICATION_REGISTER_V002Request()) !== false) {
    print_r($sNOTIFICATIONREGISTERV->getResult());
} else {
    print_r($sNOTIFICATIONREGISTERV->getLastError());
}
/**
 * Samples for SNOTIFICATIONREGISTRATIONSEARCHV ServiceType
 */
$sNOTIFICATIONREGISTRATIONSEARCHV = new \ServiceType\SNOTIFICATIONREGISTRATIONSEARCHV($options);
/**
 * Sample call for S_NOTIFICATION_REGISTRATION_SEARCH_V001 operation/method
 */
if ($sNOTIFICATIONREGISTRATIONSEARCHV->S_NOTIFICATION_REGISTRATION_SEARCH_V001(new \StructType\S_NOTIFICATION_REGISTRATION_SEARCH_V001Request()) !== false) {
    print_r($sNOTIFICATIONREGISTRATIONSEARCHV->getResult());
} else {
    print_r($sNOTIFICATIONREGISTRATIONSEARCHV->getLastError());
}
/**
 * Samples for SNOTIFICATIONSEARCHV ServiceType
 */
$sNOTIFICATIONSEARCHV = new \ServiceType\SNOTIFICATIONSEARCHV($options);
/**
 * Sample call for S_NOTIFICATION_SEARCH_V001 operation/method
 */
if ($sNOTIFICATIONSEARCHV->S_NOTIFICATION_SEARCH_V001(new \StructType\S_NOTIFICATION_SEARCH_V001Request()) !== false) {
    print_r($sNOTIFICATIONSEARCHV->getResult());
} else {
    print_r($sNOTIFICATIONSEARCHV->getLastError());
}
/**
 * Samples for SNOTIFICATIONUNREGISTERV ServiceType
 */
$sNOTIFICATIONUNREGISTERV = new \ServiceType\SNOTIFICATIONUNREGISTERV($options);
/**
 * Sample call for S_NOTIFICATION_UNREGISTER_V001 operation/method
 */
if ($sNOTIFICATIONUNREGISTERV->S_NOTIFICATION_UNREGISTER_V001(new \StructType\S_NOTIFICATION_UNREGISTER_V001Request()) !== false) {
    print_r($sNOTIFICATIONUNREGISTERV->getResult());
} else {
    print_r($sNOTIFICATIONUNREGISTERV->getLastError());
}
/**
 * Samples for SPACKAGESSEARCHV ServiceType
 */
$sPACKAGESSEARCHV = new \ServiceType\SPACKAGESSEARCHV($options);
/**
 * Sample call for S_PACKAGES_SEARCH_V001 operation/method
 */
if ($sPACKAGESSEARCHV->S_PACKAGES_SEARCH_V001(new \StructType\S_PACKAGES_SEARCH_V001Request()) !== false) {
    print_r($sPACKAGESSEARCHV->getResult());
} else {
    print_r($sPACKAGESSEARCHV->getLastError());
}
/**
 * Sample call for S_PACKAGES_SEARCH_V002 operation/method
 */
if ($sPACKAGESSEARCHV->S_PACKAGES_SEARCH_V002(new \StructType\S_PACKAGES_SEARCH_V002Request()) !== false) {
    print_r($sPACKAGESSEARCHV->getResult());
} else {
    print_r($sPACKAGESSEARCHV->getLastError());
}
/**
 * Samples for SPACKAGEMAPPINGGETV ServiceType
 */
$sPACKAGEMAPPINGGETV = new \ServiceType\SPACKAGEMAPPINGGETV($options);
/**
 * Sample call for S_PACKAGE_MAPPING_GET_V001 operation/method
 */
if ($sPACKAGEMAPPINGGETV->S_PACKAGE_MAPPING_GET_V001(new \StructType\S_PACKAGE_MAPPING_GET_V001Request()) !== false) {
    print_r($sPACKAGEMAPPINGGETV->getResult());
} else {
    print_r($sPACKAGEMAPPINGGETV->getLastError());
}
/**
 * Samples for SPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV ServiceType
 */
$sPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV = new \ServiceType\SPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV($options);
/**
 * Sample call for S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001
 * operation/method
 */
if ($sPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001(new \StructType\S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request()) !== false) {
    print_r($sPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getResult());
} else {
    print_r($sPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getLastError());
}
/**
 * Samples for SPACKAGESEARCHV ServiceType
 */
$sPACKAGESEARCHV = new \ServiceType\SPACKAGESEARCHV($options);
/**
 * Sample call for S_PACKAGE_SEARCH_V001 operation/method
 */
if ($sPACKAGESEARCHV->S_PACKAGE_SEARCH_V001(new \StructType\S_PACKAGE_SEARCH_V001Request()) !== false) {
    print_r($sPACKAGESEARCHV->getResult());
} else {
    print_r($sPACKAGESEARCHV->getLastError());
}
/**
 * Sample call for S_PACKAGE_SEARCH_V002 operation/method
 */
if ($sPACKAGESEARCHV->S_PACKAGE_SEARCH_V002(new \StructType\S_PACKAGE_SEARCH_V002Request()) !== false) {
    print_r($sPACKAGESEARCHV->getResult());
} else {
    print_r($sPACKAGESEARCHV->getLastError());
}
/**
 * Samples for SPAYMENTABORTV ServiceType
 */
$sPAYMENTABORTV = new \ServiceType\SPAYMENTABORTV($options);
/**
 * Sample call for S_PAYMENT_ABORT_V001 operation/method
 */
if ($sPAYMENTABORTV->S_PAYMENT_ABORT_V001(new \StructType\S_PAYMENT_ABORT_V001Request()) !== false) {
    print_r($sPAYMENTABORTV->getResult());
} else {
    print_r($sPAYMENTABORTV->getLastError());
}
/**
 * Samples for SPAYMENTCOMMITV ServiceType
 */
$sPAYMENTCOMMITV = new \ServiceType\SPAYMENTCOMMITV($options);
/**
 * Sample call for S_PAYMENT_COMMIT_V001 operation/method
 */
if ($sPAYMENTCOMMITV->S_PAYMENT_COMMIT_V001(new \StructType\S_PAYMENT_COMMIT_V001Request()) !== false) {
    print_r($sPAYMENTCOMMITV->getResult());
} else {
    print_r($sPAYMENTCOMMITV->getLastError());
}
/**
 * Samples for SPAYMENTPOSTINGSEARCHV ServiceType
 */
$sPAYMENTPOSTINGSEARCHV = new \ServiceType\SPAYMENTPOSTINGSEARCHV($options);
/**
 * Sample call for S_PAYMENT_POSTING_SEARCH_V001 operation/method
 */
if ($sPAYMENTPOSTINGSEARCHV->S_PAYMENT_POSTING_SEARCH_V001(new \StructType\S_PAYMENT_POSTING_SEARCH_V001Request()) !== false) {
    print_r($sPAYMENTPOSTINGSEARCHV->getResult());
} else {
    print_r($sPAYMENTPOSTINGSEARCHV->getLastError());
}
/**
 * Samples for SPERSONADDSERVICEMANUALRATEV ServiceType
 */
$sPERSONADDSERVICEMANUALRATEV = new \ServiceType\SPERSONADDSERVICEMANUALRATEV($options);
/**
 * Sample call for S_PERSON_ADD_SERVICE_MANUAL_RATE_V001 operation/method
 */
if ($sPERSONADDSERVICEMANUALRATEV->S_PERSON_ADD_SERVICE_MANUAL_RATE_V001(new \StructType\S_PERSON_ADD_SERVICE_MANUAL_RATE_V001Request()) !== false) {
    print_r($sPERSONADDSERVICEMANUALRATEV->getResult());
} else {
    print_r($sPERSONADDSERVICEMANUALRATEV->getLastError());
}
/**
 * Samples for SPERSONADDSERVICEV ServiceType
 */
$sPERSONADDSERVICEV = new \ServiceType\SPERSONADDSERVICEV($options);
/**
 * Sample call for S_PERSON_ADD_SERVICE_V001 operation/method
 */
if ($sPERSONADDSERVICEV->S_PERSON_ADD_SERVICE_V001(new \StructType\S_PERSON_ADD_SERVICE_V001Request()) !== false) {
    print_r($sPERSONADDSERVICEV->getResult());
} else {
    print_r($sPERSONADDSERVICEV->getLastError());
}
/**
 * Samples for SPERSONASSSIGNGUESTV ServiceType
 */
$sPERSONASSSIGNGUESTV = new \ServiceType\SPERSONASSSIGNGUESTV($options);
/**
 * Sample call for S_PERSON_ASSSIGN_GUEST_V001 operation/method
 */
if ($sPERSONASSSIGNGUESTV->S_PERSON_ASSSIGN_GUEST_V001(new \StructType\S_PERSON_ASSSIGN_GUEST_V001Request()) !== false) {
    print_r($sPERSONASSSIGNGUESTV->getResult());
} else {
    print_r($sPERSONASSSIGNGUESTV->getLastError());
}
/**
 * Samples for SPERSONGETSERVICESV ServiceType
 */
$sPERSONGETSERVICESV = new \ServiceType\SPERSONGETSERVICESV($options);
/**
 * Sample call for S_PERSON_GET_SERVICES_V01 operation/method
 */
if ($sPERSONGETSERVICESV->S_PERSON_GET_SERVICES_V01(new \StructType\S_PERSON_GET_SERVICES_V01Request()) !== false) {
    print_r($sPERSONGETSERVICESV->getResult());
} else {
    print_r($sPERSONGETSERVICESV->getLastError());
}
/**
 * Samples for SPERSONGUESTASSIGNV ServiceType
 */
$sPERSONGUESTASSIGNV = new \ServiceType\SPERSONGUESTASSIGNV($options);
/**
 * Sample call for S_PERSON_GUEST_ASSIGN_V001 operation/method
 */
if ($sPERSONGUESTASSIGNV->S_PERSON_GUEST_ASSIGN_V001(new \StructType\S_PERSON_GUEST_ASSIGN_V001Request()) !== false) {
    print_r($sPERSONGUESTASSIGNV->getResult());
} else {
    print_r($sPERSONGUESTASSIGNV->getLastError());
}
/**
 * Samples for SPERSONGUESTUNASSIGNV ServiceType
 */
$sPERSONGUESTUNASSIGNV = new \ServiceType\SPERSONGUESTUNASSIGNV($options);
/**
 * Sample call for S_PERSON_GUEST_UNASSIGN_V001 operation/method
 */
if ($sPERSONGUESTUNASSIGNV->S_PERSON_GUEST_UNASSIGN_V001(new \StructType\S_PERSON_GUEST_UNASSIGN_V001Request()) !== false) {
    print_r($sPERSONGUESTUNASSIGNV->getResult());
} else {
    print_r($sPERSONGUESTUNASSIGNV->getLastError());
}
/**
 * Samples for SPERSONMODIFYV ServiceType
 */
$sPERSONMODIFYV = new \ServiceType\SPERSONMODIFYV($options);
/**
 * Sample call for S_PERSON_MODIFY_V001 operation/method
 */
if ($sPERSONMODIFYV->S_PERSON_MODIFY_V001(new \StructType\S_PERSON_MODIFY_V001Request()) !== false) {
    print_r($sPERSONMODIFYV->getResult());
} else {
    print_r($sPERSONMODIFYV->getLastError());
}
/**
 * Sample call for S_PERSON_MODIFY_V002 operation/method
 */
if ($sPERSONMODIFYV->S_PERSON_MODIFY_V002(new \StructType\S_PERSON_MODIFY_V002Request()) !== false) {
    print_r($sPERSONMODIFYV->getResult());
} else {
    print_r($sPERSONMODIFYV->getLastError());
}
/**
 * Sample call for S_PERSON_MODIFY_V003 operation/method
 */
if ($sPERSONMODIFYV->S_PERSON_MODIFY_V003(new \StructType\S_PERSON_MODIFY_V003Request()) !== false) {
    print_r($sPERSONMODIFYV->getResult());
} else {
    print_r($sPERSONMODIFYV->getLastError());
}
/**
 * Samples for SPERSONPRECHECKINV ServiceType
 */
$sPERSONPRECHECKINV = new \ServiceType\SPERSONPRECHECKINV($options);
/**
 * Sample call for S_PERSON_PRE_CHECK_IN_V001 operation/method
 */
if ($sPERSONPRECHECKINV->S_PERSON_PRE_CHECK_IN_V001(new \StructType\S_PERSON_PRE_CHECK_IN_V001Request()) !== false) {
    print_r($sPERSONPRECHECKINV->getResult());
} else {
    print_r($sPERSONPRECHECKINV->getLastError());
}
/**
 * Samples for SPERSONPRECHECKOUTV ServiceType
 */
$sPERSONPRECHECKOUTV = new \ServiceType\SPERSONPRECHECKOUTV($options);
/**
 * Sample call for S_PERSON_PRE_CHECK_OUT_V001 operation/method
 */
if ($sPERSONPRECHECKOUTV->S_PERSON_PRE_CHECK_OUT_V001(new \StructType\S_PERSON_PRE_CHECK_OUT_V001Request()) !== false) {
    print_r($sPERSONPRECHECKOUTV->getResult());
} else {
    print_r($sPERSONPRECHECKOUTV->getLastError());
}
/**
 * Samples for SPERSONREMOVESERVICEV ServiceType
 */
$sPERSONREMOVESERVICEV = new \ServiceType\SPERSONREMOVESERVICEV($options);
/**
 * Sample call for S_PERSON_REMOVE_SERVICE_V001 operation/method
 */
if ($sPERSONREMOVESERVICEV->S_PERSON_REMOVE_SERVICE_V001(new \StructType\S_PERSON_REMOVE_SERVICE_V001Request()) !== false) {
    print_r($sPERSONREMOVESERVICEV->getResult());
} else {
    print_r($sPERSONREMOVESERVICEV->getLastError());
}
/**
 * Samples for SPERSONREMOVEV ServiceType
 */
$sPERSONREMOVEV = new \ServiceType\SPERSONREMOVEV($options);
/**
 * Sample call for S_PERSON_REMOVE_V001 operation/method
 */
if ($sPERSONREMOVEV->S_PERSON_REMOVE_V001(new \StructType\S_PERSON_REMOVE_V001Request()) !== false) {
    print_r($sPERSONREMOVEV->getResult());
} else {
    print_r($sPERSONREMOVEV->getLastError());
}
/**
 * Samples for SPERSONROOMHOLDERASSIGNV ServiceType
 */
$sPERSONROOMHOLDERASSIGNV = new \ServiceType\SPERSONROOMHOLDERASSIGNV($options);
/**
 * Sample call for S_PERSON_ROOM_HOLDER_ASSIGN_V001 operation/method
 */
if ($sPERSONROOMHOLDERASSIGNV->S_PERSON_ROOM_HOLDER_ASSIGN_V001(new \StructType\S_PERSON_ROOM_HOLDER_ASSIGN_V001Request()) !== false) {
    print_r($sPERSONROOMHOLDERASSIGNV->getResult());
} else {
    print_r($sPERSONROOMHOLDERASSIGNV->getLastError());
}
/**
 * Samples for SPERSONSERVICEADDV ServiceType
 */
$sPERSONSERVICEADDV = new \ServiceType\SPERSONSERVICEADDV($options);
/**
 * Sample call for S_PERSON_SERVICE_ADD_V001 operation/method
 */
if ($sPERSONSERVICEADDV->S_PERSON_SERVICE_ADD_V001(new \StructType\S_PERSON_SERVICE_ADD_V001Request()) !== false) {
    print_r($sPERSONSERVICEADDV->getResult());
} else {
    print_r($sPERSONSERVICEADDV->getLastError());
}
/**
 * Samples for SPERSONSERVICEFORCEMODIFYV ServiceType
 */
$sPERSONSERVICEFORCEMODIFYV = new \ServiceType\SPERSONSERVICEFORCEMODIFYV($options);
/**
 * Sample call for S_PERSON_SERVICE_FORCE_MODIFY_V001 operation/method
 */
if ($sPERSONSERVICEFORCEMODIFYV->S_PERSON_SERVICE_FORCE_MODIFY_V001(new \StructType\S_PERSON_SERVICE_FORCE_MODIFY_V001Request()) !== false) {
    print_r($sPERSONSERVICEFORCEMODIFYV->getResult());
} else {
    print_r($sPERSONSERVICEFORCEMODIFYV->getLastError());
}
/**
 * Samples for SPERSONSERVICEGETV ServiceType
 */
$sPERSONSERVICEGETV = new \ServiceType\SPERSONSERVICEGETV($options);
/**
 * Sample call for S_PERSON_SERVICE_GET_V001 operation/method
 */
if ($sPERSONSERVICEGETV->S_PERSON_SERVICE_GET_V001(new \StructType\S_PERSON_SERVICE_GET_V001Request()) !== false) {
    print_r($sPERSONSERVICEGETV->getResult());
} else {
    print_r($sPERSONSERVICEGETV->getLastError());
}
/**
 * Sample call for S_PERSON_SERVICE_GET_V002 operation/method
 */
if ($sPERSONSERVICEGETV->S_PERSON_SERVICE_GET_V002(new \StructType\S_PERSON_SERVICE_GET_V002Request()) !== false) {
    print_r($sPERSONSERVICEGETV->getResult());
} else {
    print_r($sPERSONSERVICEGETV->getLastError());
}
/**
 * Samples for SPERSONSERVICEMANUALRATEADDV ServiceType
 */
$sPERSONSERVICEMANUALRATEADDV = new \ServiceType\SPERSONSERVICEMANUALRATEADDV($options);
/**
 * Sample call for S_PERSON_SERVICE_MANUAL_RATE_ADD_V001 operation/method
 */
if ($sPERSONSERVICEMANUALRATEADDV->S_PERSON_SERVICE_MANUAL_RATE_ADD_V001(new \StructType\S_PERSON_SERVICE_MANUAL_RATE_ADD_V001Request()) !== false) {
    print_r($sPERSONSERVICEMANUALRATEADDV->getResult());
} else {
    print_r($sPERSONSERVICEMANUALRATEADDV->getLastError());
}
/**
 * Samples for SPERSONSERVICEMANUALRATEFORCEMODIFYV ServiceType
 */
$sPERSONSERVICEMANUALRATEFORCEMODIFYV = new \ServiceType\SPERSONSERVICEMANUALRATEFORCEMODIFYV($options);
/**
 * Sample call for S_PERSON_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001 operation/method
 */
if ($sPERSONSERVICEMANUALRATEFORCEMODIFYV->S_PERSON_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001(new \StructType\S_PERSON_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Request()) !== false) {
    print_r($sPERSONSERVICEMANUALRATEFORCEMODIFYV->getResult());
} else {
    print_r($sPERSONSERVICEMANUALRATEFORCEMODIFYV->getLastError());
}
/**
 * Samples for SPERSONSERVICEMANUALRATEMODIFYV ServiceType
 */
$sPERSONSERVICEMANUALRATEMODIFYV = new \ServiceType\SPERSONSERVICEMANUALRATEMODIFYV($options);
/**
 * Sample call for S_PERSON_SERVICE_MANUAL_RATE_MODIFY_V001 operation/method
 */
if ($sPERSONSERVICEMANUALRATEMODIFYV->S_PERSON_SERVICE_MANUAL_RATE_MODIFY_V001(new \StructType\S_PERSON_SERVICE_MANUAL_RATE_MODIFY_V001Request()) !== false) {
    print_r($sPERSONSERVICEMANUALRATEMODIFYV->getResult());
} else {
    print_r($sPERSONSERVICEMANUALRATEMODIFYV->getLastError());
}
/**
 * Samples for SPERSONSERVICEMODIFYV ServiceType
 */
$sPERSONSERVICEMODIFYV = new \ServiceType\SPERSONSERVICEMODIFYV($options);
/**
 * Sample call for S_PERSON_SERVICE_MODIFY_V001 operation/method
 */
if ($sPERSONSERVICEMODIFYV->S_PERSON_SERVICE_MODIFY_V001(new \StructType\S_PERSON_SERVICE_MODIFY_V001Request()) !== false) {
    print_r($sPERSONSERVICEMODIFYV->getResult());
} else {
    print_r($sPERSONSERVICEMODIFYV->getLastError());
}
/**
 * Sample call for S_PERSON_SERVICE_MODIFY_V002 operation/method
 */
if ($sPERSONSERVICEMODIFYV->S_PERSON_SERVICE_MODIFY_V002(new \StructType\S_PERSON_SERVICE_MODIFY_V002Request()) !== false) {
    print_r($sPERSONSERVICEMODIFYV->getResult());
} else {
    print_r($sPERSONSERVICEMODIFYV->getLastError());
}
/**
 * Samples for SPERSONSERVICEREMOVEV ServiceType
 */
$sPERSONSERVICEREMOVEV = new \ServiceType\SPERSONSERVICEREMOVEV($options);
/**
 * Sample call for S_PERSON_SERVICE_REMOVE_V001 operation/method
 */
if ($sPERSONSERVICEREMOVEV->S_PERSON_SERVICE_REMOVE_V001(new \StructType\S_PERSON_SERVICE_REMOVE_V001Request()) !== false) {
    print_r($sPERSONSERVICEREMOVEV->getResult());
} else {
    print_r($sPERSONSERVICEREMOVEV->getLastError());
}
/**
 * Samples for SPERSONTOKENADDV ServiceType
 */
$sPERSONTOKENADDV = new \ServiceType\SPERSONTOKENADDV($options);
/**
 * Sample call for S_PERSON_TOKEN_ADD_V001 operation/method
 */
if ($sPERSONTOKENADDV->S_PERSON_TOKEN_ADD_V001(new \StructType\S_PERSON_TOKEN_ADD_V001Request()) !== false) {
    print_r($sPERSONTOKENADDV->getResult());
} else {
    print_r($sPERSONTOKENADDV->getLastError());
}
/**
 * Samples for SPOLICELISTADDV ServiceType
 */
$sPOLICELISTADDV = new \ServiceType\SPOLICELISTADDV($options);
/**
 * Sample call for S_POLICELIST_ADD_V001 operation/method
 */
if ($sPOLICELISTADDV->S_POLICELIST_ADD_V001(new \StructType\S_POLICELIST_ADD_V001Request()) !== false) {
    print_r($sPOLICELISTADDV->getResult());
} else {
    print_r($sPOLICELISTADDV->getLastError());
}
/**
 * Samples for SPOLICELISTMODIFYV ServiceType
 */
$sPOLICELISTMODIFYV = new \ServiceType\SPOLICELISTMODIFYV($options);
/**
 * Sample call for S_POLICELIST_MODIFY_V001 operation/method
 */
if ($sPOLICELISTMODIFYV->S_POLICELIST_MODIFY_V001(new \StructType\S_POLICELIST_MODIFY_V001Request()) !== false) {
    print_r($sPOLICELISTMODIFYV->getResult());
} else {
    print_r($sPOLICELISTMODIFYV->getLastError());
}
/**
 * Samples for SPRODUCTFEATURESGETV ServiceType
 */
$sPRODUCTFEATURESGETV = new \ServiceType\SPRODUCTFEATURESGETV($options);
/**
 * Sample call for S_PRODUCT_FEATURES_GET_V001 operation/method
 */
if ($sPRODUCTFEATURESGETV->S_PRODUCT_FEATURES_GET_V001(new \StructType\S_PRODUCT_FEATURES_GET_V001Request()) !== false) {
    print_r($sPRODUCTFEATURESGETV->getResult());
} else {
    print_r($sPRODUCTFEATURESGETV->getLastError());
}
/**
 * Samples for SRATESEARCHV ServiceType
 */
$sRATESEARCHV = new \ServiceType\SRATESEARCHV($options);
/**
 * Sample call for S_RATE_SEARCH_V001 operation/method
 */
if ($sRATESEARCHV->S_RATE_SEARCH_V001(new \StructType\S_RATE_SEARCH_V001Request()) !== false) {
    print_r($sRATESEARCHV->getResult());
} else {
    print_r($sRATESEARCHV->getLastError());
}
/**
 * Samples for SRATESEGMENTRESTRICTIONSEARCHV ServiceType
 */
$sRATESEGMENTRESTRICTIONSEARCHV = new \ServiceType\SRATESEGMENTRESTRICTIONSEARCHV($options);
/**
 * Sample call for S_RATE_SEGMENT_RESTRICTION_SEARCH_V001 operation/method
 */
if ($sRATESEGMENTRESTRICTIONSEARCHV->S_RATE_SEGMENT_RESTRICTION_SEARCH_V001(new \StructType\S_RATE_SEGMENT_RESTRICTION_SEARCH_V001Request()) !== false) {
    print_r($sRATESEGMENTRESTRICTIONSEARCHV->getResult());
} else {
    print_r($sRATESEGMENTRESTRICTIONSEARCHV->getLastError());
}
/**
 * Sample call for S_RATE_SEGMENT_RESTRICTION_SEARCH_V002 operation/method
 */
if ($sRATESEGMENTRESTRICTIONSEARCHV->S_RATE_SEGMENT_RESTRICTION_SEARCH_V002(new \StructType\S_RATE_SEGMENT_RESTRICTION_SEARCH_V002Request()) !== false) {
    print_r($sRATESEGMENTRESTRICTIONSEARCHV->getResult());
} else {
    print_r($sRATESEGMENTRESTRICTIONSEARCHV->getLastError());
}
/**
 * Samples for SREGISTRATIONCARDGETV ServiceType
 */
$sREGISTRATIONCARDGETV = new \ServiceType\SREGISTRATIONCARDGETV($options);
/**
 * Sample call for S_REGISTRATIONCARD_GET_V001 operation/method
 */
if ($sREGISTRATIONCARDGETV->S_REGISTRATIONCARD_GET_V001(new \StructType\S_REGISTRATIONCARD_GET_V001Request()) !== false) {
    print_r($sREGISTRATIONCARDGETV->getResult());
} else {
    print_r($sREGISTRATIONCARDGETV->getLastError());
}
/**
 * Sample call for S_REGISTRATIONCARD_GET_V002 operation/method
 */
if ($sREGISTRATIONCARDGETV->S_REGISTRATIONCARD_GET_V002(new \StructType\S_REGISTRATIONCARD_GET_V002Request()) !== false) {
    print_r($sREGISTRATIONCARDGETV->getResult());
} else {
    print_r($sREGISTRATIONCARDGETV->getLastError());
}
/**
 * Samples for SREGISTRATIONCARDMODIFYV ServiceType
 */
$sREGISTRATIONCARDMODIFYV = new \ServiceType\SREGISTRATIONCARDMODIFYV($options);
/**
 * Sample call for S_REGISTRATIONCARD_MODIFY_V001 operation/method
 */
if ($sREGISTRATIONCARDMODIFYV->S_REGISTRATIONCARD_MODIFY_V001(new \StructType\S_REGISTRATIONCARD_MODIFY_V001Request()) !== false) {
    print_r($sREGISTRATIONCARDMODIFYV->getResult());
} else {
    print_r($sREGISTRATIONCARDMODIFYV->getLastError());
}
/**
 * Samples for SREGISTRYSPEEDTESTV ServiceType
 */
$sREGISTRYSPEEDTESTV = new \ServiceType\SREGISTRYSPEEDTESTV($options);
/**
 * Sample call for S_REGISTRY_SPEED_TEST_V001 operation/method
 */
if ($sREGISTRYSPEEDTESTV->S_REGISTRY_SPEED_TEST_V001(new \StructType\S_REGISTRY_SPEED_TEST_V001Request()) !== false) {
    print_r($sREGISTRYSPEEDTESTV->getResult());
} else {
    print_r($sREGISTRYSPEEDTESTV->getLastError());
}
/**
 * Samples for SREMOVESETTLEMENTPROFILEV ServiceType
 */
$sREMOVESETTLEMENTPROFILEV = new \ServiceType\SREMOVESETTLEMENTPROFILEV($options);
/**
 * Sample call for S_REMOVE_SETTLEMENT_PROFILE_V001 operation/method
 */
if ($sREMOVESETTLEMENTPROFILEV->S_REMOVE_SETTLEMENT_PROFILE_V001(new \StructType\S_REMOVE_SETTLEMENT_PROFILE_V001Request()) !== false) {
    print_r($sREMOVESETTLEMENTPROFILEV->getResult());
} else {
    print_r($sREMOVESETTLEMENTPROFILEV->getLastError());
}
/**
 * Samples for SRESERVATIONADDROOMV ServiceType
 */
$sRESERVATIONADDROOMV = new \ServiceType\SRESERVATIONADDROOMV($options);
/**
 * Sample call for S_RESERVATION_ADD_ROOM_V001 operation/method
 */
if ($sRESERVATIONADDROOMV->S_RESERVATION_ADD_ROOM_V001(new \StructType\S_RESERVATION_ADD_ROOM_V001Request()) !== false) {
    print_r($sRESERVATIONADDROOMV->getResult());
} else {
    print_r($sRESERVATIONADDROOMV->getLastError());
}
/**
 * Samples for SRESERVATIONADDSERVICEMANUALRATEV ServiceType
 */
$sRESERVATIONADDSERVICEMANUALRATEV = new \ServiceType\SRESERVATIONADDSERVICEMANUALRATEV($options);
/**
 * Sample call for S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001 operation/method
 */
if ($sRESERVATIONADDSERVICEMANUALRATEV->S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001(new \StructType\S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001Request()) !== false) {
    print_r($sRESERVATIONADDSERVICEMANUALRATEV->getResult());
} else {
    print_r($sRESERVATIONADDSERVICEMANUALRATEV->getLastError());
}
/**
 * Samples for SRESERVATIONADDSERVICEV ServiceType
 */
$sRESERVATIONADDSERVICEV = new \ServiceType\SRESERVATIONADDSERVICEV($options);
/**
 * Sample call for S_RESERVATION_ADD_SERVICE_V001 operation/method
 */
if ($sRESERVATIONADDSERVICEV->S_RESERVATION_ADD_SERVICE_V001(new \StructType\S_RESERVATION_ADD_SERVICE_V001Request()) !== false) {
    print_r($sRESERVATIONADDSERVICEV->getResult());
} else {
    print_r($sRESERVATIONADDSERVICEV->getLastError());
}
/**
 * Samples for SRESERVATIONAUTOASSIGNROOMV ServiceType
 */
$sRESERVATIONAUTOASSIGNROOMV = new \ServiceType\SRESERVATIONAUTOASSIGNROOMV($options);
/**
 * Sample call for S_RESERVATION_AUTO_ASSIGN_ROOM_V001 operation/method
 */
if ($sRESERVATIONAUTOASSIGNROOMV->S_RESERVATION_AUTO_ASSIGN_ROOM_V001(new \StructType\S_RESERVATION_AUTO_ASSIGN_ROOM_V001Request()) !== false) {
    print_r($sRESERVATIONAUTOASSIGNROOMV->getResult());
} else {
    print_r($sRESERVATIONAUTOASSIGNROOMV->getLastError());
}
/**
 * Samples for SRESERVATIONCHANGEPREVIEWV ServiceType
 */
$sRESERVATIONCHANGEPREVIEWV = new \ServiceType\SRESERVATIONCHANGEPREVIEWV($options);
/**
 * Sample call for S_RESERVATION_CHANGE_PREVIEW_V001 operation/method
 */
if ($sRESERVATIONCHANGEPREVIEWV->S_RESERVATION_CHANGE_PREVIEW_V001(new \StructType\S_RESERVATION_CHANGE_PREVIEW_V001Request()) !== false) {
    print_r($sRESERVATIONCHANGEPREVIEWV->getResult());
} else {
    print_r($sRESERVATIONCHANGEPREVIEWV->getLastError());
}
/**
 * Samples for SRESERVATIONCHECKINV ServiceType
 */
$sRESERVATIONCHECKINV = new \ServiceType\SRESERVATIONCHECKINV($options);
/**
 * Sample call for S_RESERVATION_CHECK_IN_V001 operation/method
 */
if ($sRESERVATIONCHECKINV->S_RESERVATION_CHECK_IN_V001(new \StructType\S_RESERVATION_CHECK_IN_V001Request()) !== false) {
    print_r($sRESERVATIONCHECKINV->getResult());
} else {
    print_r($sRESERVATIONCHECKINV->getLastError());
}
/**
 * Sample call for S_RESERVATION_CHECK_IN_V002 operation/method
 */
if ($sRESERVATIONCHECKINV->S_RESERVATION_CHECK_IN_V002(new \StructType\S_RESERVATION_CHECK_IN_V002Request()) !== false) {
    print_r($sRESERVATIONCHECKINV->getResult());
} else {
    print_r($sRESERVATIONCHECKINV->getLastError());
}
/**
 * Samples for SRESERVATIONCREATEV ServiceType
 */
$sRESERVATIONCREATEV = new \ServiceType\SRESERVATIONCREATEV($options);
/**
 * Sample call for S_RESERVATION_CREATE_V001 operation/method
 */
if ($sRESERVATIONCREATEV->S_RESERVATION_CREATE_V001(new \StructType\S_RESERVATION_CREATE_V001Request()) !== false) {
    print_r($sRESERVATIONCREATEV->getResult());
} else {
    print_r($sRESERVATIONCREATEV->getLastError());
}
/**
 * Sample call for S_RESERVATION_CREATE_V002 operation/method
 */
if ($sRESERVATIONCREATEV->S_RESERVATION_CREATE_V002(new \StructType\S_RESERVATION_CREATE_V002Request()) !== false) {
    print_r($sRESERVATIONCREATEV->getResult());
} else {
    print_r($sRESERVATIONCREATEV->getLastError());
}
/**
 * Sample call for S_RESERVATION_CREATE_V003 operation/method
 */
if ($sRESERVATIONCREATEV->S_RESERVATION_CREATE_V003(new \StructType\S_RESERVATION_CREATE_V003Request()) !== false) {
    print_r($sRESERVATIONCREATEV->getResult());
} else {
    print_r($sRESERVATIONCREATEV->getLastError());
}
/**
 * Sample call for S_RESERVATION_CREATE_V004 operation/method
 */
if ($sRESERVATIONCREATEV->S_RESERVATION_CREATE_V004(new \StructType\S_RESERVATION_CREATE_V004Request()) !== false) {
    print_r($sRESERVATIONCREATEV->getResult());
} else {
    print_r($sRESERVATIONCREATEV->getLastError());
}
/**
 * Sample call for S_RESERVATION_CREATE_V005 operation/method
 */
if ($sRESERVATIONCREATEV->S_RESERVATION_CREATE_V005(new \StructType\S_RESERVATION_CREATE_V005Request()) !== false) {
    print_r($sRESERVATIONCREATEV->getResult());
} else {
    print_r($sRESERVATIONCREATEV->getLastError());
}
/**
 * Sample call for S_RESERVATION_CREATE_V006 operation/method
 */
if ($sRESERVATIONCREATEV->S_RESERVATION_CREATE_V006(new \StructType\S_RESERVATION_CREATE_V006Request()) !== false) {
    print_r($sRESERVATIONCREATEV->getResult());
} else {
    print_r($sRESERVATIONCREATEV->getLastError());
}
/**
 * Samples for SRESERVATIONDEPOSITINCREDITWITHFORECASTADDV ServiceType
 */
$sRESERVATIONDEPOSITINCREDITWITHFORECASTADDV = new \ServiceType\SRESERVATIONDEPOSITINCREDITWITHFORECASTADDV($options);
/**
 * Sample call for S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V001
 * operation/method
 */
if ($sRESERVATIONDEPOSITINCREDITWITHFORECASTADDV->S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V001(new \StructType\S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONDEPOSITINCREDITWITHFORECASTADDV->getResult());
} else {
    print_r($sRESERVATIONDEPOSITINCREDITWITHFORECASTADDV->getLastError());
}
/**
 * Sample call for S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V002
 * operation/method
 */
if ($sRESERVATIONDEPOSITINCREDITWITHFORECASTADDV->S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V002(new \StructType\S_RESERVATION_DEPOSITIN_CREDIT_WITH_FORECAST_ADD_V002Request()) !== false) {
    print_r($sRESERVATIONDEPOSITINCREDITWITHFORECASTADDV->getResult());
} else {
    print_r($sRESERVATIONDEPOSITINCREDITWITHFORECASTADDV->getLastError());
}
/**
 * Samples for SRESERVATIONDEPOSITINWITHFORECASTADDV ServiceType
 */
$sRESERVATIONDEPOSITINWITHFORECASTADDV = new \ServiceType\SRESERVATIONDEPOSITINWITHFORECASTADDV($options);
/**
 * Sample call for S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001 operation/method
 */
if ($sRESERVATIONDEPOSITINWITHFORECASTADDV->S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001(new \StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONDEPOSITINWITHFORECASTADDV->getResult());
} else {
    print_r($sRESERVATIONDEPOSITINWITHFORECASTADDV->getLastError());
}
/**
 * Sample call for S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002 operation/method
 */
if ($sRESERVATIONDEPOSITINWITHFORECASTADDV->S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002(new \StructType\S_RESERVATION_DEPOSITIN_WITH_FORECAST_ADD_V002Request()) !== false) {
    print_r($sRESERVATIONDEPOSITINWITHFORECASTADDV->getResult());
} else {
    print_r($sRESERVATIONDEPOSITINWITHFORECASTADDV->getLastError());
}
/**
 * Samples for SRESERVATIONDEPOSITINWITHPAYMENTADDV ServiceType
 */
$sRESERVATIONDEPOSITINWITHPAYMENTADDV = new \ServiceType\SRESERVATIONDEPOSITINWITHPAYMENTADDV($options);
/**
 * Sample call for S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001 operation/method
 */
if ($sRESERVATIONDEPOSITINWITHPAYMENTADDV->S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001(new \StructType\S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONDEPOSITINWITHPAYMENTADDV->getResult());
} else {
    print_r($sRESERVATIONDEPOSITINWITHPAYMENTADDV->getLastError());
}
/**
 * Samples for SRESERVATIONDEPOSITINWITHSERVICEADDV ServiceType
 */
$sRESERVATIONDEPOSITINWITHSERVICEADDV = new \ServiceType\SRESERVATIONDEPOSITINWITHSERVICEADDV($options);
/**
 * Sample call for S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001 operation/method
 */
if ($sRESERVATIONDEPOSITINWITHSERVICEADDV->S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001(new \StructType\S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONDEPOSITINWITHSERVICEADDV->getResult());
} else {
    print_r($sRESERVATIONDEPOSITINWITHSERVICEADDV->getLastError());
}
/**
 * Samples for SRESERVATIONDEPOSITAGREEMENTGETV ServiceType
 */
$sRESERVATIONDEPOSITAGREEMENTGETV = new \ServiceType\SRESERVATIONDEPOSITAGREEMENTGETV($options);
/**
 * Sample call for S_RESERVATION_DEPOSIT_AGREEMENT_GET_V001 operation/method
 */
if ($sRESERVATIONDEPOSITAGREEMENTGETV->S_RESERVATION_DEPOSIT_AGREEMENT_GET_V001(new \StructType\S_RESERVATION_DEPOSIT_AGREEMENT_GET_V001Request()) !== false) {
    print_r($sRESERVATIONDEPOSITAGREEMENTGETV->getResult());
} else {
    print_r($sRESERVATIONDEPOSITAGREEMENTGETV->getLastError());
}
/**
 * Samples for SRESERVATIONDEPOSITAGREEMENTSETV ServiceType
 */
$sRESERVATIONDEPOSITAGREEMENTSETV = new \ServiceType\SRESERVATIONDEPOSITAGREEMENTSETV($options);
/**
 * Sample call for S_RESERVATION_DEPOSIT_AGREEMENT_SET_V001 operation/method
 */
if ($sRESERVATIONDEPOSITAGREEMENTSETV->S_RESERVATION_DEPOSIT_AGREEMENT_SET_V001(new \StructType\S_RESERVATION_DEPOSIT_AGREEMENT_SET_V001Request()) !== false) {
    print_r($sRESERVATIONDEPOSITAGREEMENTSETV->getResult());
} else {
    print_r($sRESERVATIONDEPOSITAGREEMENTSETV->getLastError());
}
/**
 * Samples for SRESERVATIONFROZENRATEDISCOUNTV ServiceType
 */
$sRESERVATIONFROZENRATEDISCOUNTV = new \ServiceType\SRESERVATIONFROZENRATEDISCOUNTV($options);
/**
 * Sample call for S_RESERVATION_FROZEN_RATE_DISCOUNT_V001 operation/method
 */
if ($sRESERVATIONFROZENRATEDISCOUNTV->S_RESERVATION_FROZEN_RATE_DISCOUNT_V001(new \StructType\S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Request()) !== false) {
    print_r($sRESERVATIONFROZENRATEDISCOUNTV->getResult());
} else {
    print_r($sRESERVATIONFROZENRATEDISCOUNTV->getLastError());
}
/**
 * Samples for SRESERVATIONGETSERVICESV ServiceType
 */
$sRESERVATIONGETSERVICESV = new \ServiceType\SRESERVATIONGETSERVICESV($options);
/**
 * Sample call for S_RESERVATION_GET_SERVICES_V01 operation/method
 */
if ($sRESERVATIONGETSERVICESV->S_RESERVATION_GET_SERVICES_V01(new \StructType\S_RESERVATION_GET_SERVICES_V01Request()) !== false) {
    print_r($sRESERVATIONGETSERVICESV->getResult());
} else {
    print_r($sRESERVATIONGETSERVICESV->getLastError());
}
/**
 * Samples for SRESERVATIONGETV ServiceType
 */
$sRESERVATIONGETV = new \ServiceType\SRESERVATIONGETV($options);
/**
 * Sample call for S_RESERVATION_GET_V001 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V001(new \StructType\S_RESERVATION_GET_V001Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V002 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V002(new \StructType\S_RESERVATION_GET_V002Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V003 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V003(new \StructType\S_RESERVATION_GET_V003Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V004 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V004(new \StructType\S_RESERVATION_GET_V004Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V005 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V005(new \StructType\S_RESERVATION_GET_V005Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V006 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V006(new \StructType\S_RESERVATION_GET_V006Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V007 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V007(new \StructType\S_RESERVATION_GET_V007Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V008 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V008(new \StructType\S_RESERVATION_GET_V008Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V009 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V009(new \StructType\S_RESERVATION_GET_V009Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GET_V010 operation/method
 */
if ($sRESERVATIONGETV->S_RESERVATION_GET_V010(new \StructType\S_RESERVATION_GET_V010Request()) !== false) {
    print_r($sRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGETV->getLastError());
}
/**
 * Samples for SRESERVATIONGROUPCREATEV ServiceType
 */
$sRESERVATIONGROUPCREATEV = new \ServiceType\SRESERVATIONGROUPCREATEV($options);
/**
 * Sample call for S_RESERVATION_GROUP_CREATE_V001 operation/method
 */
if ($sRESERVATIONGROUPCREATEV->S_RESERVATION_GROUP_CREATE_V001(new \StructType\S_RESERVATION_GROUP_CREATE_V001Request()) !== false) {
    print_r($sRESERVATIONGROUPCREATEV->getResult());
} else {
    print_r($sRESERVATIONGROUPCREATEV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GROUP_CREATE_V002 operation/method
 */
if ($sRESERVATIONGROUPCREATEV->S_RESERVATION_GROUP_CREATE_V002(new \StructType\S_RESERVATION_GROUP_CREATE_V002Request()) !== false) {
    print_r($sRESERVATIONGROUPCREATEV->getResult());
} else {
    print_r($sRESERVATIONGROUPCREATEV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GROUP_CREATE_V003 operation/method
 */
if ($sRESERVATIONGROUPCREATEV->S_RESERVATION_GROUP_CREATE_V003(new \StructType\S_RESERVATION_GROUP_CREATE_V003Request()) !== false) {
    print_r($sRESERVATIONGROUPCREATEV->getResult());
} else {
    print_r($sRESERVATIONGROUPCREATEV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GROUP_CREATE_V004 operation/method
 */
if ($sRESERVATIONGROUPCREATEV->S_RESERVATION_GROUP_CREATE_V004(new \StructType\S_RESERVATION_GROUP_CREATE_V004Request()) !== false) {
    print_r($sRESERVATIONGROUPCREATEV->getResult());
} else {
    print_r($sRESERVATIONGROUPCREATEV->getLastError());
}
/**
 * Samples for SRESERVATIONGROUPHANDLINGACTIVATEV ServiceType
 */
$sRESERVATIONGROUPHANDLINGACTIVATEV = new \ServiceType\SRESERVATIONGROUPHANDLINGACTIVATEV($options);
/**
 * Sample call for S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001 operation/method
 */
if ($sRESERVATIONGROUPHANDLINGACTIVATEV->S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001(new \StructType\S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001Request()) !== false) {
    print_r($sRESERVATIONGROUPHANDLINGACTIVATEV->getResult());
} else {
    print_r($sRESERVATIONGROUPHANDLINGACTIVATEV->getLastError());
}
/**
 * Samples for SRESERVATIONGROUPRESERVATIONADDV ServiceType
 */
$sRESERVATIONGROUPRESERVATIONADDV = new \ServiceType\SRESERVATIONGROUPRESERVATIONADDV($options);
/**
 * Sample call for S_RESERVATION_GROUP_RESERVATION_ADD_V001 operation/method
 */
if ($sRESERVATIONGROUPRESERVATIONADDV->S_RESERVATION_GROUP_RESERVATION_ADD_V001(new \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONGROUPRESERVATIONADDV->getResult());
} else {
    print_r($sRESERVATIONGROUPRESERVATIONADDV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GROUP_RESERVATION_ADD_V002 operation/method
 */
if ($sRESERVATIONGROUPRESERVATIONADDV->S_RESERVATION_GROUP_RESERVATION_ADD_V002(new \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V002Request()) !== false) {
    print_r($sRESERVATIONGROUPRESERVATIONADDV->getResult());
} else {
    print_r($sRESERVATIONGROUPRESERVATIONADDV->getLastError());
}
/**
 * Sample call for S_RESERVATION_GROUP_RESERVATION_ADD_V003 operation/method
 */
if ($sRESERVATIONGROUPRESERVATIONADDV->S_RESERVATION_GROUP_RESERVATION_ADD_V003(new \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V003Request()) !== false) {
    print_r($sRESERVATIONGROUPRESERVATIONADDV->getResult());
} else {
    print_r($sRESERVATIONGROUPRESERVATIONADDV->getLastError());
}
/**
 * Samples for SRESERVATIONGROUPRESERVATIONGETV ServiceType
 */
$sRESERVATIONGROUPRESERVATIONGETV = new \ServiceType\SRESERVATIONGROUPRESERVATIONGETV($options);
/**
 * Sample call for S_RESERVATION_GROUP_RESERVATION_GET_V001 operation/method
 */
if ($sRESERVATIONGROUPRESERVATIONGETV->S_RESERVATION_GROUP_RESERVATION_GET_V001(new \StructType\S_RESERVATION_GROUP_RESERVATION_GET_V001Request()) !== false) {
    print_r($sRESERVATIONGROUPRESERVATIONGETV->getResult());
} else {
    print_r($sRESERVATIONGROUPRESERVATIONGETV->getLastError());
}
/**
 * Samples for SRESERVATIONGROUPRESERVATIONSETCANCELV ServiceType
 */
$sRESERVATIONGROUPRESERVATIONSETCANCELV = new \ServiceType\SRESERVATIONGROUPRESERVATIONSETCANCELV($options);
/**
 * Sample call for S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001 operation/method
 */
if ($sRESERVATIONGROUPRESERVATIONSETCANCELV->S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001(new \StructType\S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001Request()) !== false) {
    print_r($sRESERVATIONGROUPRESERVATIONSETCANCELV->getResult());
} else {
    print_r($sRESERVATIONGROUPRESERVATIONSETCANCELV->getLastError());
}
/**
 * Samples for SRESERVATIONGROUPRESERVATIONSETNOSHOWV ServiceType
 */
$sRESERVATIONGROUPRESERVATIONSETNOSHOWV = new \ServiceType\SRESERVATIONGROUPRESERVATIONSETNOSHOWV($options);
/**
 * Sample call for S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001 operation/method
 */
if ($sRESERVATIONGROUPRESERVATIONSETNOSHOWV->S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001(new \StructType\S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001Request()) !== false) {
    print_r($sRESERVATIONGROUPRESERVATIONSETNOSHOWV->getResult());
} else {
    print_r($sRESERVATIONGROUPRESERVATIONSETNOSHOWV->getLastError());
}
/**
 * Samples for SRESERVATIONGROUPRESERVATIONSETRELEASEV ServiceType
 */
$sRESERVATIONGROUPRESERVATIONSETRELEASEV = new \ServiceType\SRESERVATIONGROUPRESERVATIONSETRELEASEV($options);
/**
 * Sample call for S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001
 * operation/method
 */
if ($sRESERVATIONGROUPRESERVATIONSETRELEASEV->S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001(new \StructType\S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001Request()) !== false) {
    print_r($sRESERVATIONGROUPRESERVATIONSETRELEASEV->getResult());
} else {
    print_r($sRESERVATIONGROUPRESERVATIONSETRELEASEV->getLastError());
}
/**
 * Samples for SRESERVATIONMODIFYV ServiceType
 */
$sRESERVATIONMODIFYV = new \ServiceType\SRESERVATIONMODIFYV($options);
/**
 * Sample call for S_RESERVATION_MODIFY_V001 operation/method
 */
if ($sRESERVATIONMODIFYV->S_RESERVATION_MODIFY_V001(new \StructType\S_RESERVATION_MODIFY_V001Request()) !== false) {
    print_r($sRESERVATIONMODIFYV->getResult());
} else {
    print_r($sRESERVATIONMODIFYV->getLastError());
}
/**
 * Sample call for S_RESERVATION_MODIFY_V002 operation/method
 */
if ($sRESERVATIONMODIFYV->S_RESERVATION_MODIFY_V002(new \StructType\S_RESERVATION_MODIFY_V002Request()) !== false) {
    print_r($sRESERVATIONMODIFYV->getResult());
} else {
    print_r($sRESERVATIONMODIFYV->getLastError());
}
/**
 * Sample call for S_RESERVATION_MODIFY_V003 operation/method
 */
if ($sRESERVATIONMODIFYV->S_RESERVATION_MODIFY_V003(new \StructType\S_RESERVATION_MODIFY_V003Request()) !== false) {
    print_r($sRESERVATIONMODIFYV->getResult());
} else {
    print_r($sRESERVATIONMODIFYV->getLastError());
}
/**
 * Sample call for S_RESERVATION_MODIFY_V004 operation/method
 */
if ($sRESERVATIONMODIFYV->S_RESERVATION_MODIFY_V004(new \StructType\S_RESERVATION_MODIFY_V004Request()) !== false) {
    print_r($sRESERVATIONMODIFYV->getResult());
} else {
    print_r($sRESERVATIONMODIFYV->getLastError());
}
/**
 * Sample call for S_RESERVATION_MODIFY_V005 operation/method
 */
if ($sRESERVATIONMODIFYV->S_RESERVATION_MODIFY_V005(new \StructType\S_RESERVATION_MODIFY_V005Request()) !== false) {
    print_r($sRESERVATIONMODIFYV->getResult());
} else {
    print_r($sRESERVATIONMODIFYV->getLastError());
}
/**
 * Sample call for S_RESERVATION_MODIFY_V006 operation/method
 */
if ($sRESERVATIONMODIFYV->S_RESERVATION_MODIFY_V006(new \StructType\S_RESERVATION_MODIFY_V006Request()) !== false) {
    print_r($sRESERVATIONMODIFYV->getResult());
} else {
    print_r($sRESERVATIONMODIFYV->getLastError());
}
/**
 * Sample call for S_RESERVATION_MODIFY_V007 operation/method
 */
if ($sRESERVATIONMODIFYV->S_RESERVATION_MODIFY_V007(new \StructType\S_RESERVATION_MODIFY_V007Request()) !== false) {
    print_r($sRESERVATIONMODIFYV->getResult());
} else {
    print_r($sRESERVATIONMODIFYV->getLastError());
}
/**
 * Samples for SRESERVATIONPAYMENTINSTRUCTIONSETV ServiceType
 */
$sRESERVATIONPAYMENTINSTRUCTIONSETV = new \ServiceType\SRESERVATIONPAYMENTINSTRUCTIONSETV($options);
/**
 * Sample call for S_RESERVATION_PAYMENTINSTRUCTION_SET_V001 operation/method
 */
if ($sRESERVATIONPAYMENTINSTRUCTIONSETV->S_RESERVATION_PAYMENTINSTRUCTION_SET_V001(new \StructType\S_RESERVATION_PAYMENTINSTRUCTION_SET_V001Request()) !== false) {
    print_r($sRESERVATIONPAYMENTINSTRUCTIONSETV->getResult());
} else {
    print_r($sRESERVATIONPAYMENTINSTRUCTIONSETV->getLastError());
}
/**
 * Samples for SRESERVATIONPAYMENTINSTRUCTIONSGETV ServiceType
 */
$sRESERVATIONPAYMENTINSTRUCTIONSGETV = new \ServiceType\SRESERVATIONPAYMENTINSTRUCTIONSGETV($options);
/**
 * Sample call for S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V001 operation/method
 */
if ($sRESERVATIONPAYMENTINSTRUCTIONSGETV->S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V001(new \StructType\S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V001Request()) !== false) {
    print_r($sRESERVATIONPAYMENTINSTRUCTIONSGETV->getResult());
} else {
    print_r($sRESERVATIONPAYMENTINSTRUCTIONSGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V002 operation/method
 */
if ($sRESERVATIONPAYMENTINSTRUCTIONSGETV->S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V002(new \StructType\S_RESERVATION_PAYMENT_INSTRUCTIONS_GET_V002Request()) !== false) {
    print_r($sRESERVATIONPAYMENTINSTRUCTIONSGETV->getResult());
} else {
    print_r($sRESERVATIONPAYMENTINSTRUCTIONSGETV->getLastError());
}
/**
 * Samples for SRESERVATIONPAYMENTINSTRUCTIONSSETV ServiceType
 */
$sRESERVATIONPAYMENTINSTRUCTIONSSETV = new \ServiceType\SRESERVATIONPAYMENTINSTRUCTIONSSETV($options);
/**
 * Sample call for S_RESERVATION_PAYMENT_INSTRUCTIONS_SET_V002 operation/method
 */
if ($sRESERVATIONPAYMENTINSTRUCTIONSSETV->S_RESERVATION_PAYMENT_INSTRUCTIONS_SET_V002(new \StructType\S_RESERVATION_PAYMENT_INSTRUCTIONS_SET_V002Request()) !== false) {
    print_r($sRESERVATIONPAYMENTINSTRUCTIONSSETV->getResult());
} else {
    print_r($sRESERVATIONPAYMENTINSTRUCTIONSSETV->getLastError());
}
/**
 * Samples for SRESERVATIONPREVIEWPOSTINGSV ServiceType
 */
$sRESERVATIONPREVIEWPOSTINGSV = new \ServiceType\SRESERVATIONPREVIEWPOSTINGSV($options);
/**
 * Sample call for S_RESERVATION_PREVIEW_POSTINGS_V001 operation/method
 */
if ($sRESERVATIONPREVIEWPOSTINGSV->S_RESERVATION_PREVIEW_POSTINGS_V001(new \StructType\S_RESERVATION_PREVIEW_POSTINGS_V001Request()) !== false) {
    print_r($sRESERVATIONPREVIEWPOSTINGSV->getResult());
} else {
    print_r($sRESERVATIONPREVIEWPOSTINGSV->getLastError());
}
/**
 * Samples for SRESERVATIONRATEFREEZEV ServiceType
 */
$sRESERVATIONRATEFREEZEV = new \ServiceType\SRESERVATIONRATEFREEZEV($options);
/**
 * Sample call for S_RESERVATION_RATE_FREEZE_V001 operation/method
 */
if ($sRESERVATIONRATEFREEZEV->S_RESERVATION_RATE_FREEZE_V001(new \StructType\S_RESERVATION_RATE_FREEZE_V001Request()) !== false) {
    print_r($sRESERVATIONRATEFREEZEV->getResult());
} else {
    print_r($sRESERVATIONRATEFREEZEV->getLastError());
}
/**
 * Samples for SRESERVATIONRATEUNFREEZEV ServiceType
 */
$sRESERVATIONRATEUNFREEZEV = new \ServiceType\SRESERVATIONRATEUNFREEZEV($options);
/**
 * Sample call for S_RESERVATION_RATE_UNFREEZE_V001 operation/method
 */
if ($sRESERVATIONRATEUNFREEZEV->S_RESERVATION_RATE_UNFREEZE_V001(new \StructType\S_RESERVATION_RATE_UNFREEZE_V001Request()) !== false) {
    print_r($sRESERVATIONRATEUNFREEZEV->getResult());
} else {
    print_r($sRESERVATIONRATEUNFREEZEV->getLastError());
}
/**
 * Samples for SRESERVATIONRELEASEROOMV ServiceType
 */
$sRESERVATIONRELEASEROOMV = new \ServiceType\SRESERVATIONRELEASEROOMV($options);
/**
 * Sample call for S_RESERVATION_RELEASE_ROOM_V001 operation/method
 */
if ($sRESERVATIONRELEASEROOMV->S_RESERVATION_RELEASE_ROOM_V001(new \StructType\S_RESERVATION_RELEASE_ROOM_V001Request()) !== false) {
    print_r($sRESERVATIONRELEASEROOMV->getResult());
} else {
    print_r($sRESERVATIONRELEASEROOMV->getLastError());
}
/**
 * Samples for SRESERVATIONREMOVESERVICEV ServiceType
 */
$sRESERVATIONREMOVESERVICEV = new \ServiceType\SRESERVATIONREMOVESERVICEV($options);
/**
 * Sample call for S_RESERVATION_REMOVE_SERVICE_V001 operation/method
 */
if ($sRESERVATIONREMOVESERVICEV->S_RESERVATION_REMOVE_SERVICE_V001(new \StructType\S_RESERVATION_REMOVE_SERVICE_V001Request()) !== false) {
    print_r($sRESERVATIONREMOVESERVICEV->getResult());
} else {
    print_r($sRESERVATIONREMOVESERVICEV->getLastError());
}
/**
 * Samples for SRESERVATIONROOMADDV ServiceType
 */
$sRESERVATIONROOMADDV = new \ServiceType\SRESERVATIONROOMADDV($options);
/**
 * Sample call for S_RESERVATION_ROOM_ADD_V001 operation/method
 */
if ($sRESERVATIONROOMADDV->S_RESERVATION_ROOM_ADD_V001(new \StructType\S_RESERVATION_ROOM_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONROOMADDV->getResult());
} else {
    print_r($sRESERVATIONROOMADDV->getLastError());
}
/**
 * Samples for SRESERVATIONROOMAUTOASSIGNV ServiceType
 */
$sRESERVATIONROOMAUTOASSIGNV = new \ServiceType\SRESERVATIONROOMAUTOASSIGNV($options);
/**
 * Sample call for S_RESERVATION_ROOM_AUTO_ASSIGN_V001 operation/method
 */
if ($sRESERVATIONROOMAUTOASSIGNV->S_RESERVATION_ROOM_AUTO_ASSIGN_V001(new \StructType\S_RESERVATION_ROOM_AUTO_ASSIGN_V001Request()) !== false) {
    print_r($sRESERVATIONROOMAUTOASSIGNV->getResult());
} else {
    print_r($sRESERVATIONROOMAUTOASSIGNV->getLastError());
}
/**
 * Sample call for S_RESERVATION_ROOM_AUTO_ASSIGN_V002 operation/method
 */
if ($sRESERVATIONROOMAUTOASSIGNV->S_RESERVATION_ROOM_AUTO_ASSIGN_V002(new \StructType\S_RESERVATION_ROOM_AUTO_ASSIGN_V002Request()) !== false) {
    print_r($sRESERVATIONROOMAUTOASSIGNV->getResult());
} else {
    print_r($sRESERVATIONROOMAUTOASSIGNV->getLastError());
}
/**
 * Samples for SRESERVATIONROOMRELEASEV ServiceType
 */
$sRESERVATIONROOMRELEASEV = new \ServiceType\SRESERVATIONROOMRELEASEV($options);
/**
 * Sample call for S_RESERVATION_ROOM_RELEASE_V001 operation/method
 */
if ($sRESERVATIONROOMRELEASEV->S_RESERVATION_ROOM_RELEASE_V001(new \StructType\S_RESERVATION_ROOM_RELEASE_V001Request()) !== false) {
    print_r($sRESERVATIONROOMRELEASEV->getResult());
} else {
    print_r($sRESERVATIONROOMRELEASEV->getLastError());
}
/**
 * Samples for SRESERVATIONSEARCHV ServiceType
 */
$sRESERVATIONSEARCHV = new \ServiceType\SRESERVATIONSEARCHV($options);
/**
 * Sample call for S_RESERVATION_SEARCH_V001 operation/method
 */
if ($sRESERVATIONSEARCHV->S_RESERVATION_SEARCH_V001(new \StructType\S_RESERVATION_SEARCH_V001Request()) !== false) {
    print_r($sRESERVATIONSEARCHV->getResult());
} else {
    print_r($sRESERVATIONSEARCHV->getLastError());
}
/**
 * Sample call for S_RESERVATION_SEARCH_V002 operation/method
 */
if ($sRESERVATIONSEARCHV->S_RESERVATION_SEARCH_V002(new \StructType\S_RESERVATION_SEARCH_V002Request()) !== false) {
    print_r($sRESERVATIONSEARCHV->getResult());
} else {
    print_r($sRESERVATIONSEARCHV->getLastError());
}
/**
 * Sample call for S_RESERVATION_SEARCH_V003 operation/method
 */
if ($sRESERVATIONSEARCHV->S_RESERVATION_SEARCH_V003(new \StructType\S_RESERVATION_SEARCH_V003Request()) !== false) {
    print_r($sRESERVATIONSEARCHV->getResult());
} else {
    print_r($sRESERVATIONSEARCHV->getLastError());
}
/**
 * Sample call for S_RESERVATION_SEARCH_V004 operation/method
 */
if ($sRESERVATIONSEARCHV->S_RESERVATION_SEARCH_V004(new \StructType\S_RESERVATION_SEARCH_V004Request()) !== false) {
    print_r($sRESERVATIONSEARCHV->getResult());
} else {
    print_r($sRESERVATIONSEARCHV->getLastError());
}
/**
 * Sample call for S_RESERVATION_SEARCH_V005 operation/method
 */
if ($sRESERVATIONSEARCHV->S_RESERVATION_SEARCH_V005(new \StructType\S_RESERVATION_SEARCH_V005Request()) !== false) {
    print_r($sRESERVATIONSEARCHV->getResult());
} else {
    print_r($sRESERVATIONSEARCHV->getLastError());
}
/**
 * Samples for SRESERVATIONSERVICEADDV ServiceType
 */
$sRESERVATIONSERVICEADDV = new \ServiceType\SRESERVATIONSERVICEADDV($options);
/**
 * Sample call for S_RESERVATION_SERVICE_ADD_V001 operation/method
 */
if ($sRESERVATIONSERVICEADDV->S_RESERVATION_SERVICE_ADD_V001(new \StructType\S_RESERVATION_SERVICE_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONSERVICEADDV->getResult());
} else {
    print_r($sRESERVATIONSERVICEADDV->getLastError());
}
/**
 * Samples for SRESERVATIONSERVICEFORCEMODIFYV ServiceType
 */
$sRESERVATIONSERVICEFORCEMODIFYV = new \ServiceType\SRESERVATIONSERVICEFORCEMODIFYV($options);
/**
 * Sample call for S_RESERVATION_SERVICE_FORCE_MODIFY_V001 operation/method
 */
if ($sRESERVATIONSERVICEFORCEMODIFYV->S_RESERVATION_SERVICE_FORCE_MODIFY_V001(new \StructType\S_RESERVATION_SERVICE_FORCE_MODIFY_V001Request()) !== false) {
    print_r($sRESERVATIONSERVICEFORCEMODIFYV->getResult());
} else {
    print_r($sRESERVATIONSERVICEFORCEMODIFYV->getLastError());
}
/**
 * Samples for SRESERVATIONSERVICEGETV ServiceType
 */
$sRESERVATIONSERVICEGETV = new \ServiceType\SRESERVATIONSERVICEGETV($options);
/**
 * Sample call for S_RESERVATION_SERVICE_GET_V001 operation/method
 */
if ($sRESERVATIONSERVICEGETV->S_RESERVATION_SERVICE_GET_V001(new \StructType\S_RESERVATION_SERVICE_GET_V001Request()) !== false) {
    print_r($sRESERVATIONSERVICEGETV->getResult());
} else {
    print_r($sRESERVATIONSERVICEGETV->getLastError());
}
/**
 * Sample call for S_RESERVATION_SERVICE_GET_V002 operation/method
 */
if ($sRESERVATIONSERVICEGETV->S_RESERVATION_SERVICE_GET_V002(new \StructType\S_RESERVATION_SERVICE_GET_V002Request()) !== false) {
    print_r($sRESERVATIONSERVICEGETV->getResult());
} else {
    print_r($sRESERVATIONSERVICEGETV->getLastError());
}
/**
 * Samples for SRESERVATIONSERVICEMANUALRATEADDV ServiceType
 */
$sRESERVATIONSERVICEMANUALRATEADDV = new \ServiceType\SRESERVATIONSERVICEMANUALRATEADDV($options);
/**
 * Sample call for S_RESERVATION_SERVICE_MANUAL_RATE_ADD_V001 operation/method
 */
if ($sRESERVATIONSERVICEMANUALRATEADDV->S_RESERVATION_SERVICE_MANUAL_RATE_ADD_V001(new \StructType\S_RESERVATION_SERVICE_MANUAL_RATE_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONSERVICEMANUALRATEADDV->getResult());
} else {
    print_r($sRESERVATIONSERVICEMANUALRATEADDV->getLastError());
}
/**
 * Samples for SRESERVATIONSERVICEMANUALRATEFORCEMODIFYV ServiceType
 */
$sRESERVATIONSERVICEMANUALRATEFORCEMODIFYV = new \ServiceType\SRESERVATIONSERVICEMANUALRATEFORCEMODIFYV($options);
/**
 * Sample call for S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001
 * operation/method
 */
if ($sRESERVATIONSERVICEMANUALRATEFORCEMODIFYV->S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001(new \StructType\S_RESERVATION_SERVICE_MANUAL_RATE_FORCE_MODIFY_V001Request()) !== false) {
    print_r($sRESERVATIONSERVICEMANUALRATEFORCEMODIFYV->getResult());
} else {
    print_r($sRESERVATIONSERVICEMANUALRATEFORCEMODIFYV->getLastError());
}
/**
 * Samples for SRESERVATIONSERVICEMANUALRATEMODIFYV ServiceType
 */
$sRESERVATIONSERVICEMANUALRATEMODIFYV = new \ServiceType\SRESERVATIONSERVICEMANUALRATEMODIFYV($options);
/**
 * Sample call for S_RESERVATION_SERVICE_MANUAL_RATE_MODIFY_V001 operation/method
 */
if ($sRESERVATIONSERVICEMANUALRATEMODIFYV->S_RESERVATION_SERVICE_MANUAL_RATE_MODIFY_V001(new \StructType\S_RESERVATION_SERVICE_MANUAL_RATE_MODIFY_V001Request()) !== false) {
    print_r($sRESERVATIONSERVICEMANUALRATEMODIFYV->getResult());
} else {
    print_r($sRESERVATIONSERVICEMANUALRATEMODIFYV->getLastError());
}
/**
 * Samples for SRESERVATIONSERVICEMODIFYV ServiceType
 */
$sRESERVATIONSERVICEMODIFYV = new \ServiceType\SRESERVATIONSERVICEMODIFYV($options);
/**
 * Sample call for S_RESERVATION_SERVICE_MODIFY_V001 operation/method
 */
if ($sRESERVATIONSERVICEMODIFYV->S_RESERVATION_SERVICE_MODIFY_V001(new \StructType\S_RESERVATION_SERVICE_MODIFY_V001Request()) !== false) {
    print_r($sRESERVATIONSERVICEMODIFYV->getResult());
} else {
    print_r($sRESERVATIONSERVICEMODIFYV->getLastError());
}
/**
 * Samples for SRESERVATIONSERVICEREMOVEV ServiceType
 */
$sRESERVATIONSERVICEREMOVEV = new \ServiceType\SRESERVATIONSERVICEREMOVEV($options);
/**
 * Sample call for S_RESERVATION_SERVICE_REMOVE_V001 operation/method
 */
if ($sRESERVATIONSERVICEREMOVEV->S_RESERVATION_SERVICE_REMOVE_V001(new \StructType\S_RESERVATION_SERVICE_REMOVE_V001Request()) !== false) {
    print_r($sRESERVATIONSERVICEREMOVEV->getResult());
} else {
    print_r($sRESERVATIONSERVICEREMOVEV->getLastError());
}
/**
 * Samples for SRESERVATIONSETPAYMENTINSTRCUTIONV ServiceType
 */
$sRESERVATIONSETPAYMENTINSTRCUTIONV = new \ServiceType\SRESERVATIONSETPAYMENTINSTRCUTIONV($options);
/**
 * Sample call for S_RESERVATION_SET_PAYMENTINSTRCUTION_V001 operation/method
 */
if ($sRESERVATIONSETPAYMENTINSTRCUTIONV->S_RESERVATION_SET_PAYMENTINSTRCUTION_V001(new \StructType\S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request()) !== false) {
    print_r($sRESERVATIONSETPAYMENTINSTRCUTIONV->getResult());
} else {
    print_r($sRESERVATIONSETPAYMENTINSTRCUTIONV->getLastError());
}
/**
 * Samples for SRESERVATIONTOKENADDV ServiceType
 */
$sRESERVATIONTOKENADDV = new \ServiceType\SRESERVATIONTOKENADDV($options);
/**
 * Sample call for S_RESERVATION_TOKEN_ADD_V001 operation/method
 */
if ($sRESERVATIONTOKENADDV->S_RESERVATION_TOKEN_ADD_V001(new \StructType\S_RESERVATION_TOKEN_ADD_V001Request()) !== false) {
    print_r($sRESERVATIONTOKENADDV->getResult());
} else {
    print_r($sRESERVATIONTOKENADDV->getLastError());
}
/**
 * Samples for SRESERVATIONV ServiceType
 */
$sRESERVATIONV = new \ServiceType\SRESERVATIONV($options);
/**
 * Sample call for S_RESERVATION_V001 operation/method
 */
if ($sRESERVATIONV->S_RESERVATION_V001(new \StructType\S_RESERVATION_V001Request()) !== false) {
    print_r($sRESERVATIONV->getResult());
} else {
    print_r($sRESERVATIONV->getLastError());
}
/**
 * Sample call for S_RESERVATION_V002 operation/method
 */
if ($sRESERVATIONV->S_RESERVATION_V002(new \StructType\S_RESERVATION_V002Request()) !== false) {
    print_r($sRESERVATIONV->getResult());
} else {
    print_r($sRESERVATIONV->getLastError());
}
/**
 * Sample call for S_RESERVATION_V003 operation/method
 */
if ($sRESERVATIONV->S_RESERVATION_V003(new \StructType\S_RESERVATION_V003Request()) !== false) {
    print_r($sRESERVATIONV->getResult());
} else {
    print_r($sRESERVATIONV->getLastError());
}
/**
 * Samples for SROOMINGLISTASSIGNROOMV ServiceType
 */
$sROOMINGLISTASSIGNROOMV = new \ServiceType\SROOMINGLISTASSIGNROOMV($options);
/**
 * Sample call for S_ROOMINGLIST_ASSIGN_ROOM_V001 operation/method
 */
if ($sROOMINGLISTASSIGNROOMV->S_ROOMINGLIST_ASSIGN_ROOM_V001(new \StructType\S_ROOMINGLIST_ASSIGN_ROOM_V001Request()) !== false) {
    print_r($sROOMINGLISTASSIGNROOMV->getResult());
} else {
    print_r($sROOMINGLISTASSIGNROOMV->getLastError());
}
/**
 * Samples for SROOMINGLISTAUTOASSIGNROOMV ServiceType
 */
$sROOMINGLISTAUTOASSIGNROOMV = new \ServiceType\SROOMINGLISTAUTOASSIGNROOMV($options);
/**
 * Sample call for S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001 operation/method
 */
if ($sROOMINGLISTAUTOASSIGNROOMV->S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001(new \StructType\S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001Request()) !== false) {
    print_r($sROOMINGLISTAUTOASSIGNROOMV->getResult());
} else {
    print_r($sROOMINGLISTAUTOASSIGNROOMV->getLastError());
}
/**
 * Samples for SROOMINGLISTCHECKINV ServiceType
 */
$sROOMINGLISTCHECKINV = new \ServiceType\SROOMINGLISTCHECKINV($options);
/**
 * Sample call for S_ROOMINGLIST_CHECK_IN_V001 operation/method
 */
if ($sROOMINGLISTCHECKINV->S_ROOMINGLIST_CHECK_IN_V001(new \StructType\S_ROOMINGLIST_CHECK_IN_V001Request()) !== false) {
    print_r($sROOMINGLISTCHECKINV->getResult());
} else {
    print_r($sROOMINGLISTCHECKINV->getLastError());
}
/**
 * Sample call for S_ROOMINGLIST_CHECK_IN_V002 operation/method
 */
if ($sROOMINGLISTCHECKINV->S_ROOMINGLIST_CHECK_IN_V002(new \StructType\S_ROOMINGLIST_CHECK_IN_V002Request()) !== false) {
    print_r($sROOMINGLISTCHECKINV->getResult());
} else {
    print_r($sROOMINGLISTCHECKINV->getLastError());
}
/**
 * Samples for SROOMINGLISTCLEANROOMAUTOASSIGNV ServiceType
 */
$sROOMINGLISTCLEANROOMAUTOASSIGNV = new \ServiceType\SROOMINGLISTCLEANROOMAUTOASSIGNV($options);
/**
 * Sample call for S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001 operation/method
 */
if ($sROOMINGLISTCLEANROOMAUTOASSIGNV->S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001(new \StructType\S_ROOMINGLIST_CLEAN_ROOM_AUTO_ASSIGN_V001Request()) !== false) {
    print_r($sROOMINGLISTCLEANROOMAUTOASSIGNV->getResult());
} else {
    print_r($sROOMINGLISTCLEANROOMAUTOASSIGNV->getLastError());
}
/**
 * Samples for SROOMINGLISTPRECHECKINV ServiceType
 */
$sROOMINGLISTPRECHECKINV = new \ServiceType\SROOMINGLISTPRECHECKINV($options);
/**
 * Sample call for S_ROOMINGLIST_PRE_CHECK_IN_V001 operation/method
 */
if ($sROOMINGLISTPRECHECKINV->S_ROOMINGLIST_PRE_CHECK_IN_V001(new \StructType\S_ROOMINGLIST_PRE_CHECK_IN_V001Request()) !== false) {
    print_r($sROOMINGLISTPRECHECKINV->getResult());
} else {
    print_r($sROOMINGLISTPRECHECKINV->getLastError());
}
/**
 * Samples for SROOMINGLISTPRECHECKOUTV ServiceType
 */
$sROOMINGLISTPRECHECKOUTV = new \ServiceType\SROOMINGLISTPRECHECKOUTV($options);
/**
 * Sample call for S_ROOMINGLIST_PRE_CHECK_OUT_V001 operation/method
 */
if ($sROOMINGLISTPRECHECKOUTV->S_ROOMINGLIST_PRE_CHECK_OUT_V001(new \StructType\S_ROOMINGLIST_PRE_CHECK_OUT_V001Request()) !== false) {
    print_r($sROOMINGLISTPRECHECKOUTV->getResult());
} else {
    print_r($sROOMINGLISTPRECHECKOUTV->getLastError());
}
/**
 * Samples for SROOMINGLISTRELEASEROOMV ServiceType
 */
$sROOMINGLISTRELEASEROOMV = new \ServiceType\SROOMINGLISTRELEASEROOMV($options);
/**
 * Sample call for S_ROOMINGLIST_RELEASE_ROOM_V001 operation/method
 */
if ($sROOMINGLISTRELEASEROOMV->S_ROOMINGLIST_RELEASE_ROOM_V001(new \StructType\S_ROOMINGLIST_RELEASE_ROOM_V001Request()) !== false) {
    print_r($sROOMINGLISTRELEASEROOMV->getResult());
} else {
    print_r($sROOMINGLISTRELEASEROOMV->getLastError());
}
/**
 * Samples for SROOMINGLISTROOMASSIGNV ServiceType
 */
$sROOMINGLISTROOMASSIGNV = new \ServiceType\SROOMINGLISTROOMASSIGNV($options);
/**
 * Sample call for S_ROOMINGLIST_ROOM_ASSIGN_V001 operation/method
 */
if ($sROOMINGLISTROOMASSIGNV->S_ROOMINGLIST_ROOM_ASSIGN_V001(new \StructType\S_ROOMINGLIST_ROOM_ASSIGN_V001Request()) !== false) {
    print_r($sROOMINGLISTROOMASSIGNV->getResult());
} else {
    print_r($sROOMINGLISTROOMASSIGNV->getLastError());
}
/**
 * Samples for SROOMINGLISTROOMAUTOASSIGNV ServiceType
 */
$sROOMINGLISTROOMAUTOASSIGNV = new \ServiceType\SROOMINGLISTROOMAUTOASSIGNV($options);
/**
 * Sample call for S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V001 operation/method
 */
if ($sROOMINGLISTROOMAUTOASSIGNV->S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V001(new \StructType\S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V001Request()) !== false) {
    print_r($sROOMINGLISTROOMAUTOASSIGNV->getResult());
} else {
    print_r($sROOMINGLISTROOMAUTOASSIGNV->getLastError());
}
/**
 * Sample call for S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V002 operation/method
 */
if ($sROOMINGLISTROOMAUTOASSIGNV->S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V002(new \StructType\S_ROOMINGLIST_ROOM_AUTO_ASSIGN_V002Request()) !== false) {
    print_r($sROOMINGLISTROOMAUTOASSIGNV->getResult());
} else {
    print_r($sROOMINGLISTROOMAUTOASSIGNV->getLastError());
}
/**
 * Samples for SROOMINGLISTROOMDELETEV ServiceType
 */
$sROOMINGLISTROOMDELETEV = new \ServiceType\SROOMINGLISTROOMDELETEV($options);
/**
 * Sample call for S_ROOMINGLIST_ROOM_DELETE_V001 operation/method
 */
if ($sROOMINGLISTROOMDELETEV->S_ROOMINGLIST_ROOM_DELETE_V001(new \StructType\S_ROOMINGLIST_ROOM_DELETE_V001Request()) !== false) {
    print_r($sROOMINGLISTROOMDELETEV->getResult());
} else {
    print_r($sROOMINGLISTROOMDELETEV->getLastError());
}
/**
 * Samples for SROOMINGLISTROOMFORECASTGETV ServiceType
 */
$sROOMINGLISTROOMFORECASTGETV = new \ServiceType\SROOMINGLISTROOMFORECASTGETV($options);
/**
 * Sample call for S_ROOMINGLIST_ROOM_FORECAST_GET_V001 operation/method
 */
if ($sROOMINGLISTROOMFORECASTGETV->S_ROOMINGLIST_ROOM_FORECAST_GET_V001(new \StructType\S_ROOMINGLIST_ROOM_FORECAST_GET_V001Request()) !== false) {
    print_r($sROOMINGLISTROOMFORECASTGETV->getResult());
} else {
    print_r($sROOMINGLISTROOMFORECASTGETV->getLastError());
}
/**
 * Samples for SROOMINGLISTROOMRELEASEV ServiceType
 */
$sROOMINGLISTROOMRELEASEV = new \ServiceType\SROOMINGLISTROOMRELEASEV($options);
/**
 * Sample call for S_ROOMINGLIST_ROOM_RELEASE_V001 operation/method
 */
if ($sROOMINGLISTROOMRELEASEV->S_ROOMINGLIST_ROOM_RELEASE_V001(new \StructType\S_ROOMINGLIST_ROOM_RELEASE_V001Request()) !== false) {
    print_r($sROOMINGLISTROOMRELEASEV->getResult());
} else {
    print_r($sROOMINGLISTROOMRELEASEV->getLastError());
}
/**
 * Samples for SROOMACTIVEMAINTENANCESTATEGETV ServiceType
 */
$sROOMACTIVEMAINTENANCESTATEGETV = new \ServiceType\SROOMACTIVEMAINTENANCESTATEGETV($options);
/**
 * Sample call for S_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001 operation/method
 */
if ($sROOMACTIVEMAINTENANCESTATEGETV->S_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001(new \StructType\S_ROOM_ACTIVE_MAINTENANCE_STATE_GET_V001Request()) !== false) {
    print_r($sROOMACTIVEMAINTENANCESTATEGETV->getResult());
} else {
    print_r($sROOMACTIVEMAINTENANCESTATEGETV->getLastError());
}
/**
 * Samples for SROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV ServiceType
 */
$sROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV = new \ServiceType\SROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV($options);
/**
 * Sample call for S_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001
 * operation/method
 */
if ($sROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV->S_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001(new \StructType\S_ROOM_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request()) !== false) {
    print_r($sROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV->getResult());
} else {
    print_r($sROOMACTIVEMAINTENANCESTATEWITHOUTIMAGEGETV->getLastError());
}
/**
 * Samples for SROOMBOOKINGOOILOCKV ServiceType
 */
$sROOMBOOKINGOOILOCKV = new \ServiceType\SROOMBOOKINGOOILOCKV($options);
/**
 * Sample call for S_ROOM_BOOKING_OOI_LOCK_V001 operation/method
 */
if ($sROOMBOOKINGOOILOCKV->S_ROOM_BOOKING_OOI_LOCK_V001(new \StructType\S_ROOM_BOOKING_OOI_LOCK_V001Request()) !== false) {
    print_r($sROOMBOOKINGOOILOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOILOCKV->getLastError());
}
/**
 * Samples for SROOMBOOKINGOOIUNLOCKV ServiceType
 */
$sROOMBOOKINGOOIUNLOCKV = new \ServiceType\SROOMBOOKINGOOIUNLOCKV($options);
/**
 * Sample call for S_ROOM_BOOKING_OOI_UNLOCK_V001 operation/method
 */
if ($sROOMBOOKINGOOIUNLOCKV->S_ROOM_BOOKING_OOI_UNLOCK_V001(new \StructType\S_ROOM_BOOKING_OOI_UNLOCK_V001Request()) !== false) {
    print_r($sROOMBOOKINGOOIUNLOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOIUNLOCKV->getLastError());
}
/**
 * Sample call for S_ROOM_BOOKING_OOI_UNLOCK_V002 operation/method
 */
if ($sROOMBOOKINGOOIUNLOCKV->S_ROOM_BOOKING_OOI_UNLOCK_V002(new \StructType\S_ROOM_BOOKING_OOI_UNLOCK_V002Request()) !== false) {
    print_r($sROOMBOOKINGOOIUNLOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOIUNLOCKV->getLastError());
}
/**
 * Samples for SROOMBOOKINGOOOLOCKV ServiceType
 */
$sROOMBOOKINGOOOLOCKV = new \ServiceType\SROOMBOOKINGOOOLOCKV($options);
/**
 * Sample call for S_ROOM_BOOKING_OOO_LOCK_V001 operation/method
 */
if ($sROOMBOOKINGOOOLOCKV->S_ROOM_BOOKING_OOO_LOCK_V001(new \StructType\S_ROOM_BOOKING_OOO_LOCK_V001Request()) !== false) {
    print_r($sROOMBOOKINGOOOLOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOOLOCKV->getLastError());
}
/**
 * Samples for SROOMBOOKINGOOOUNLOCKV ServiceType
 */
$sROOMBOOKINGOOOUNLOCKV = new \ServiceType\SROOMBOOKINGOOOUNLOCKV($options);
/**
 * Sample call for S_ROOM_BOOKING_OOO_UNLOCK_V001 operation/method
 */
if ($sROOMBOOKINGOOOUNLOCKV->S_ROOM_BOOKING_OOO_UNLOCK_V001(new \StructType\S_ROOM_BOOKING_OOO_UNLOCK_V001Request()) !== false) {
    print_r($sROOMBOOKINGOOOUNLOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOOUNLOCKV->getLastError());
}
/**
 * Sample call for S_ROOM_BOOKING_OOO_UNLOCK_V002 operation/method
 */
if ($sROOMBOOKINGOOOUNLOCKV->S_ROOM_BOOKING_OOO_UNLOCK_V002(new \StructType\S_ROOM_BOOKING_OOO_UNLOCK_V002Request()) !== false) {
    print_r($sROOMBOOKINGOOOUNLOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOOUNLOCKV->getLastError());
}
/**
 * Samples for SROOMBOOKINGOOSLOCKV ServiceType
 */
$sROOMBOOKINGOOSLOCKV = new \ServiceType\SROOMBOOKINGOOSLOCKV($options);
/**
 * Sample call for S_ROOM_BOOKING_OOS_LOCK_V001 operation/method
 */
if ($sROOMBOOKINGOOSLOCKV->S_ROOM_BOOKING_OOS_LOCK_V001(new \StructType\S_ROOM_BOOKING_OOS_LOCK_V001Request()) !== false) {
    print_r($sROOMBOOKINGOOSLOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOSLOCKV->getLastError());
}
/**
 * Samples for SROOMBOOKINGOOSUNLOCKV ServiceType
 */
$sROOMBOOKINGOOSUNLOCKV = new \ServiceType\SROOMBOOKINGOOSUNLOCKV($options);
/**
 * Sample call for S_ROOM_BOOKING_OOS_UNLOCK_V001 operation/method
 */
if ($sROOMBOOKINGOOSUNLOCKV->S_ROOM_BOOKING_OOS_UNLOCK_V001(new \StructType\S_ROOM_BOOKING_OOS_UNLOCK_V001Request()) !== false) {
    print_r($sROOMBOOKINGOOSUNLOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOSUNLOCKV->getLastError());
}
/**
 * Sample call for S_ROOM_BOOKING_OOS_UNLOCK_V002 operation/method
 */
if ($sROOMBOOKINGOOSUNLOCKV->S_ROOM_BOOKING_OOS_UNLOCK_V002(new \StructType\S_ROOM_BOOKING_OOS_UNLOCK_V002Request()) !== false) {
    print_r($sROOMBOOKINGOOSUNLOCKV->getResult());
} else {
    print_r($sROOMBOOKINGOOSUNLOCKV->getLastError());
}
/**
 * Samples for SROOMBOOKINGSTATEV ServiceType
 */
$sROOMBOOKINGSTATEV = new \ServiceType\SROOMBOOKINGSTATEV($options);
/**
 * Sample call for S_ROOM_BOOKING_STATE_V001 operation/method
 */
if ($sROOMBOOKINGSTATEV->S_ROOM_BOOKING_STATE_V001(new \StructType\S_ROOM_BOOKING_STATE_V001Request()) !== false) {
    print_r($sROOMBOOKINGSTATEV->getResult());
} else {
    print_r($sROOMBOOKINGSTATEV->getLastError());
}
/**
 * Sample call for S_ROOM_BOOKING_STATE_V002 operation/method
 */
if ($sROOMBOOKINGSTATEV->S_ROOM_BOOKING_STATE_V002(new \StructType\S_ROOM_BOOKING_STATE_V002Request()) !== false) {
    print_r($sROOMBOOKINGSTATEV->getResult());
} else {
    print_r($sROOMBOOKINGSTATEV->getLastError());
}
/**
 * Sample call for S_ROOM_BOOKING_STATE_V01 operation/method
 */
if ($sROOMBOOKINGSTATEV->S_ROOM_BOOKING_STATE_V01(new \StructType\S_ROOM_BOOKING_STATE_V01Request()) !== false) {
    print_r($sROOMBOOKINGSTATEV->getResult());
} else {
    print_r($sROOMBOOKINGSTATEV->getLastError());
}
/**
 * Samples for SROOMCATEGORYMASTERFILECOMMENTGETV ServiceType
 */
$sROOMCATEGORYMASTERFILECOMMENTGETV = new \ServiceType\SROOMCATEGORYMASTERFILECOMMENTGETV($options);
/**
 * Sample call for S_ROOM_CATEGORY_MASTER_FILE_COMMENT_GET_V001 operation/method
 */
if ($sROOMCATEGORYMASTERFILECOMMENTGETV->S_ROOM_CATEGORY_MASTER_FILE_COMMENT_GET_V001(new \StructType\S_ROOM_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request()) !== false) {
    print_r($sROOMCATEGORYMASTERFILECOMMENTGETV->getResult());
} else {
    print_r($sROOMCATEGORYMASTERFILECOMMENTGETV->getLastError());
}
/**
 * Samples for SROOMCATEGORYMASTERFILECOMMENTSTOREV ServiceType
 */
$sROOMCATEGORYMASTERFILECOMMENTSTOREV = new \ServiceType\SROOMCATEGORYMASTERFILECOMMENTSTOREV($options);
/**
 * Sample call for S_ROOM_CATEGORY_MASTER_FILE_COMMENT_STORE_V001 operation/method
 */
if ($sROOMCATEGORYMASTERFILECOMMENTSTOREV->S_ROOM_CATEGORY_MASTER_FILE_COMMENT_STORE_V001(new \StructType\S_ROOM_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request()) !== false) {
    print_r($sROOMCATEGORYMASTERFILECOMMENTSTOREV->getResult());
} else {
    print_r($sROOMCATEGORYMASTERFILECOMMENTSTOREV->getLastError());
}
/**
 * Samples for SROOMCATEGORYMASTERFILEGETV ServiceType
 */
$sROOMCATEGORYMASTERFILEGETV = new \ServiceType\SROOMCATEGORYMASTERFILEGETV($options);
/**
 * Sample call for S_ROOM_CATEGORY_MASTER_FILE_GET_V001 operation/method
 */
if ($sROOMCATEGORYMASTERFILEGETV->S_ROOM_CATEGORY_MASTER_FILE_GET_V001(new \StructType\S_ROOM_CATEGORY_MASTER_FILE_GET_V001Request()) !== false) {
    print_r($sROOMCATEGORYMASTERFILEGETV->getResult());
} else {
    print_r($sROOMCATEGORYMASTERFILEGETV->getLastError());
}
/**
 * Samples for SROOMCATEGORYMASTERFILEINTERNETGETV ServiceType
 */
$sROOMCATEGORYMASTERFILEINTERNETGETV = new \ServiceType\SROOMCATEGORYMASTERFILEINTERNETGETV($options);
/**
 * Sample call for S_ROOM_CATEGORY_MASTER_FILE_INTERNET_GET_V001 operation/method
 */
if ($sROOMCATEGORYMASTERFILEINTERNETGETV->S_ROOM_CATEGORY_MASTER_FILE_INTERNET_GET_V001(new \StructType\S_ROOM_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request()) !== false) {
    print_r($sROOMCATEGORYMASTERFILEINTERNETGETV->getResult());
} else {
    print_r($sROOMCATEGORYMASTERFILEINTERNETGETV->getLastError());
}
/**
 * Samples for SROOMCATEGORYMASTERFILEINTERNETSTOREV ServiceType
 */
$sROOMCATEGORYMASTERFILEINTERNETSTOREV = new \ServiceType\SROOMCATEGORYMASTERFILEINTERNETSTOREV($options);
/**
 * Sample call for S_ROOM_CATEGORY_MASTER_FILE_INTERNET_STORE_V001 operation/method
 */
if ($sROOMCATEGORYMASTERFILEINTERNETSTOREV->S_ROOM_CATEGORY_MASTER_FILE_INTERNET_STORE_V001(new \StructType\S_ROOM_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request()) !== false) {
    print_r($sROOMCATEGORYMASTERFILEINTERNETSTOREV->getResult());
} else {
    print_r($sROOMCATEGORYMASTERFILEINTERNETSTOREV->getLastError());
}
/**
 * Samples for SROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV
 * ServiceType
 */
$sROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV = new \ServiceType\SROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV($options);
/**
 * Sample call for
 * S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001
 * operation/method
 */
if ($sROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001(new \StructType\S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request()) !== false) {
    print_r($sROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getResult());
} else {
    print_r($sROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getLastError());
}
/**
 * Samples for SROOMCATEGORYMASTERFILEOVERBOOKINGGETV ServiceType
 */
$sROOMCATEGORYMASTERFILEOVERBOOKINGGETV = new \ServiceType\SROOMCATEGORYMASTERFILEOVERBOOKINGGETV($options);
/**
 * Sample call for S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001
 * operation/method
 */
if ($sROOMCATEGORYMASTERFILEOVERBOOKINGGETV->S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001(new \StructType\S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request()) !== false) {
    print_r($sROOMCATEGORYMASTERFILEOVERBOOKINGGETV->getResult());
} else {
    print_r($sROOMCATEGORYMASTERFILEOVERBOOKINGGETV->getLastError());
}
/**
 * Samples for SROOMCATEGORYMASTERFILEOVERBOOKINGSTOREV ServiceType
 */
$sROOMCATEGORYMASTERFILEOVERBOOKINGSTOREV = new \ServiceType\SROOMCATEGORYMASTERFILEOVERBOOKINGSTOREV($options);
/**
 * Sample call for S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001
 * operation/method
 */
if ($sROOMCATEGORYMASTERFILEOVERBOOKINGSTOREV->S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001(new \StructType\S_ROOM_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request()) !== false) {
    print_r($sROOMCATEGORYMASTERFILEOVERBOOKINGSTOREV->getResult());
} else {
    print_r($sROOMCATEGORYMASTERFILEOVERBOOKINGSTOREV->getLastError());
}
/**
 * Samples for SROOMCHANGECLEANINGSTATUSV ServiceType
 */
$sROOMCHANGECLEANINGSTATUSV = new \ServiceType\SROOMCHANGECLEANINGSTATUSV($options);
/**
 * Sample call for S_ROOM_CHANGE_CLEANING_STATUS_V01 operation/method
 */
if ($sROOMCHANGECLEANINGSTATUSV->S_ROOM_CHANGE_CLEANING_STATUS_V01(new \StructType\S_ROOM_CHANGE_CLEANING_STATUS_V01Request()) !== false) {
    print_r($sROOMCHANGECLEANINGSTATUSV->getResult());
} else {
    print_r($sROOMCHANGECLEANINGSTATUSV->getLastError());
}
/**
 * Samples for SROOMCHANGECLEANUNGSTATUSV ServiceType
 */
$sROOMCHANGECLEANUNGSTATUSV = new \ServiceType\SROOMCHANGECLEANUNGSTATUSV($options);
/**
 * Sample call for S_ROOM_CHANGE_CLEANUNG_STATUS_V01 operation/method
 */
if ($sROOMCHANGECLEANUNGSTATUSV->S_ROOM_CHANGE_CLEANUNG_STATUS_V01(new \StructType\S_ROOM_CHANGE_CLEANUNG_STATUS_V01Request()) !== false) {
    print_r($sROOMCHANGECLEANUNGSTATUSV->getResult());
} else {
    print_r($sROOMCHANGECLEANUNGSTATUSV->getLastError());
}
/**
 * Samples for SROOMCHANGEMAINTENANCESTATUSV ServiceType
 */
$sROOMCHANGEMAINTENANCESTATUSV = new \ServiceType\SROOMCHANGEMAINTENANCESTATUSV($options);
/**
 * Sample call for S_ROOM_CHANGE_MAINTENANCE_STATUS_V01 operation/method
 */
if ($sROOMCHANGEMAINTENANCESTATUSV->S_ROOM_CHANGE_MAINTENANCE_STATUS_V01(new \StructType\S_ROOM_CHANGE_MAINTENANCE_STATUS_V01Request()) !== false) {
    print_r($sROOMCHANGEMAINTENANCESTATUSV->getResult());
} else {
    print_r($sROOMCHANGEMAINTENANCESTATUSV->getLastError());
}
/**
 * Samples for SROOMCHANGESTATEV ServiceType
 */
$sROOMCHANGESTATEV = new \ServiceType\SROOMCHANGESTATEV($options);
/**
 * Sample call for S_ROOM_CHANGE_STATE_V01 operation/method
 */
if ($sROOMCHANGESTATEV->S_ROOM_CHANGE_STATE_V01(new \StructType\S_ROOM_CHANGE_STATE_V01Request()) !== false) {
    print_r($sROOMCHANGESTATEV->getResult());
} else {
    print_r($sROOMCHANGESTATEV->getLastError());
}
/**
 * Samples for SROOMCLEANINGSTATUSCHANGEV ServiceType
 */
$sROOMCLEANINGSTATUSCHANGEV = new \ServiceType\SROOMCLEANINGSTATUSCHANGEV($options);
/**
 * Sample call for S_ROOM_CLEANING_STATUS_CHANGE_V001 operation/method
 */
if ($sROOMCLEANINGSTATUSCHANGEV->S_ROOM_CLEANING_STATUS_CHANGE_V001(new \StructType\S_ROOM_CLEANING_STATUS_CHANGE_V001Request()) !== false) {
    print_r($sROOMCLEANINGSTATUSCHANGEV->getResult());
} else {
    print_r($sROOMCLEANINGSTATUSCHANGEV->getLastError());
}
/**
 * Samples for SROOMFREEROOMSEARCHV ServiceType
 */
$sROOMFREEROOMSEARCHV = new \ServiceType\SROOMFREEROOMSEARCHV($options);
/**
 * Sample call for S_ROOM_FREE_ROOM_SEARCH_V001 operation/method
 */
if ($sROOMFREEROOMSEARCHV->S_ROOM_FREE_ROOM_SEARCH_V001(new \StructType\S_ROOM_FREE_ROOM_SEARCH_V001Request()) !== false) {
    print_r($sROOMFREEROOMSEARCHV->getResult());
} else {
    print_r($sROOMFREEROOMSEARCHV->getLastError());
}
/**
 * Samples for SROOMGETACTIVEMAINTENANCESTATEV ServiceType
 */
$sROOMGETACTIVEMAINTENANCESTATEV = new \ServiceType\SROOMGETACTIVEMAINTENANCESTATEV($options);
/**
 * Sample call for S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001 operation/method
 */
if ($sROOMGETACTIVEMAINTENANCESTATEV->S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001(new \StructType\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Request()) !== false) {
    print_r($sROOMGETACTIVEMAINTENANCESTATEV->getResult());
} else {
    print_r($sROOMGETACTIVEMAINTENANCESTATEV->getLastError());
}
/**
 * Samples for SROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV ServiceType
 */
$sROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV = new \ServiceType\SROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV($options);
/**
 * Sample call for S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001
 * operation/method
 */
if ($sROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV->S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001(new \StructType\S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Request()) !== false) {
    print_r($sROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV->getResult());
} else {
    print_r($sROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV->getLastError());
}
/**
 * Samples for SROOMGETHOUSKEEPINGSTATEMOBILEV ServiceType
 */
$sROOMGETHOUSKEEPINGSTATEMOBILEV = new \ServiceType\SROOMGETHOUSKEEPINGSTATEMOBILEV($options);
/**
 * Sample call for S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001 operation/method
 */
if ($sROOMGETHOUSKEEPINGSTATEMOBILEV->S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001(new \StructType\S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001Request()) !== false) {
    print_r($sROOMGETHOUSKEEPINGSTATEMOBILEV->getResult());
} else {
    print_r($sROOMGETHOUSKEEPINGSTATEMOBILEV->getLastError());
}
/**
 * Samples for SROOMGETHOUSKEEPINGSTATEV ServiceType
 */
$sROOMGETHOUSKEEPINGSTATEV = new \ServiceType\SROOMGETHOUSKEEPINGSTATEV($options);
/**
 * Sample call for S_ROOM_GET_HOUSKEEPING_STATE_V001 operation/method
 */
if ($sROOMGETHOUSKEEPINGSTATEV->S_ROOM_GET_HOUSKEEPING_STATE_V001(new \StructType\S_ROOM_GET_HOUSKEEPING_STATE_V001Request()) !== false) {
    print_r($sROOMGETHOUSKEEPINGSTATEV->getResult());
} else {
    print_r($sROOMGETHOUSKEEPINGSTATEV->getLastError());
}
/**
 * Samples for SROOMGETMAINENANCESTATEV ServiceType
 */
$sROOMGETMAINENANCESTATEV = new \ServiceType\SROOMGETMAINENANCESTATEV($options);
/**
 * Sample call for S_ROOM_GET_MAINENANCE_STATE_V001 operation/method
 */
if ($sROOMGETMAINENANCESTATEV->S_ROOM_GET_MAINENANCE_STATE_V001(new \StructType\S_ROOM_GET_MAINENANCE_STATE_V001Request()) !== false) {
    print_r($sROOMGETMAINENANCESTATEV->getResult());
} else {
    print_r($sROOMGETMAINENANCESTATEV->getLastError());
}
/**
 * Samples for SROOMGETMAINTENANCESTATEMOBILEV ServiceType
 */
$sROOMGETMAINTENANCESTATEMOBILEV = new \ServiceType\SROOMGETMAINTENANCESTATEMOBILEV($options);
/**
 * Sample call for S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001 operation/method
 */
if ($sROOMGETMAINTENANCESTATEMOBILEV->S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001(new \StructType\S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001Request()) !== false) {
    print_r($sROOMGETMAINTENANCESTATEMOBILEV->getResult());
} else {
    print_r($sROOMGETMAINTENANCESTATEMOBILEV->getLastError());
}
/**
 * Samples for SROOMGETMAINTENANCESTATEV ServiceType
 */
$sROOMGETMAINTENANCESTATEV = new \ServiceType\SROOMGETMAINTENANCESTATEV($options);
/**
 * Sample call for S_ROOM_GET_MAINTENANCE_STATE_V002 operation/method
 */
if ($sROOMGETMAINTENANCESTATEV->S_ROOM_GET_MAINTENANCE_STATE_V002(new \StructType\S_ROOM_GET_MAINTENANCE_STATE_V002Request()) !== false) {
    print_r($sROOMGETMAINTENANCESTATEV->getResult());
} else {
    print_r($sROOMGETMAINTENANCESTATEV->getLastError());
}
/**
 * Samples for SROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV ServiceType
 */
$sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV = new \ServiceType\SROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV($options);
/**
 * Sample call for S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001
 * operation/method
 */
if ($sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV->S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001(new \StructType\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001Request()) !== false) {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV->getResult());
} else {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV->getLastError());
}
/**
 * Sample call for S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002
 * operation/method
 */
if ($sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV->S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002(new \StructType\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002Request()) !== false) {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV->getResult());
} else {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV->getLastError());
}
/**
 * Samples for SROOMGETMAINTENANCESTATEWITHOUTIMAGEV ServiceType
 */
$sROOMGETMAINTENANCESTATEWITHOUTIMAGEV = new \ServiceType\SROOMGETMAINTENANCESTATEWITHOUTIMAGEV($options);
/**
 * Sample call for S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001 operation/method
 */
if ($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001(new \StructType\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Request()) !== false) {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->getResult());
} else {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->getLastError());
}
/**
 * Sample call for S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002 operation/method
 */
if ($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002(new \StructType\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002Request()) !== false) {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->getResult());
} else {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->getLastError());
}
/**
 * Sample call for S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003 operation/method
 */
if ($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003(new \StructType\S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request()) !== false) {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->getResult());
} else {
    print_r($sROOMGETMAINTENANCESTATEWITHOUTIMAGEV->getLastError());
}
/**
 * Samples for SROOMHOUSKEEPINGSTATEGETV ServiceType
 */
$sROOMHOUSKEEPINGSTATEGETV = new \ServiceType\SROOMHOUSKEEPINGSTATEGETV($options);
/**
 * Sample call for S_ROOM_HOUSKEEPING_STATE_GET_V001 operation/method
 */
if ($sROOMHOUSKEEPINGSTATEGETV->S_ROOM_HOUSKEEPING_STATE_GET_V001(new \StructType\S_ROOM_HOUSKEEPING_STATE_GET_V001Request()) !== false) {
    print_r($sROOMHOUSKEEPINGSTATEGETV->getResult());
} else {
    print_r($sROOMHOUSKEEPINGSTATEGETV->getLastError());
}
/**
 * Samples for SROOMHOUSKEEPINGSTATEMOBILEGETV ServiceType
 */
$sROOMHOUSKEEPINGSTATEMOBILEGETV = new \ServiceType\SROOMHOUSKEEPINGSTATEMOBILEGETV($options);
/**
 * Sample call for S_ROOM_HOUSKEEPING_STATE_MOBILE_GET_V001 operation/method
 */
if ($sROOMHOUSKEEPINGSTATEMOBILEGETV->S_ROOM_HOUSKEEPING_STATE_MOBILE_GET_V001(new \StructType\S_ROOM_HOUSKEEPING_STATE_MOBILE_GET_V001Request()) !== false) {
    print_r($sROOMHOUSKEEPINGSTATEMOBILEGETV->getResult());
} else {
    print_r($sROOMHOUSKEEPINGSTATEMOBILEGETV->getLastError());
}
/**
 * Samples for SROOMLOCKSTATESEARCHV ServiceType
 */
$sROOMLOCKSTATESEARCHV = new \ServiceType\SROOMLOCKSTATESEARCHV($options);
/**
 * Sample call for S_ROOM_LOCK_STATE_SEARCH_V001 operation/method
 */
if ($sROOMLOCKSTATESEARCHV->S_ROOM_LOCK_STATE_SEARCH_V001(new \StructType\S_ROOM_LOCK_STATE_SEARCH_V001Request()) !== false) {
    print_r($sROOMLOCKSTATESEARCHV->getResult());
} else {
    print_r($sROOMLOCKSTATESEARCHV->getLastError());
}
/**
 * Samples for SROOMMAINTENANCESTATEGETV ServiceType
 */
$sROOMMAINTENANCESTATEGETV = new \ServiceType\SROOMMAINTENANCESTATEGETV($options);
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_GET_V001 operation/method
 */
if ($sROOMMAINTENANCESTATEGETV->S_ROOM_MAINTENANCE_STATE_GET_V001(new \StructType\S_ROOM_MAINTENANCE_STATE_GET_V001Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEGETV->getLastError());
}
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_GET_V002 operation/method
 */
if ($sROOMMAINTENANCESTATEGETV->S_ROOM_MAINTENANCE_STATE_GET_V002(new \StructType\S_ROOM_MAINTENANCE_STATE_GET_V002Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEGETV->getLastError());
}
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_GET_V003 operation/method
 */
if ($sROOMMAINTENANCESTATEGETV->S_ROOM_MAINTENANCE_STATE_GET_V003(new \StructType\S_ROOM_MAINTENANCE_STATE_GET_V003Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEGETV->getLastError());
}
/**
 * Samples for SROOMMAINTENANCESTATEMOBILEGETV ServiceType
 */
$sROOMMAINTENANCESTATEMOBILEGETV = new \ServiceType\SROOMMAINTENANCESTATEMOBILEGETV($options);
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V001 operation/method
 */
if ($sROOMMAINTENANCESTATEMOBILEGETV->S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V001(new \StructType\S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V001Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEMOBILEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEMOBILEGETV->getLastError());
}
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V002 operation/method
 */
if ($sROOMMAINTENANCESTATEMOBILEGETV->S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V002(new \StructType\S_ROOM_MAINTENANCE_STATE_MOBILE_GET_V002Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEMOBILEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEMOBILEGETV->getLastError());
}
/**
 * Samples for SROOMMAINTENANCESTATERESETV ServiceType
 */
$sROOMMAINTENANCESTATERESETV = new \ServiceType\SROOMMAINTENANCESTATERESETV($options);
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_RESET_V001 operation/method
 */
if ($sROOMMAINTENANCESTATERESETV->S_ROOM_MAINTENANCE_STATE_RESET_V001(new \StructType\S_ROOM_MAINTENANCE_STATE_RESET_V001Request()) !== false) {
    print_r($sROOMMAINTENANCESTATERESETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATERESETV->getLastError());
}
/**
 * Samples for SROOMMAINTENANCESTATEWITHOUTIMAGEGETV ServiceType
 */
$sROOMMAINTENANCESTATEWITHOUTIMAGEGETV = new \ServiceType\SROOMMAINTENANCESTATEWITHOUTIMAGEGETV($options);
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001 operation/method
 */
if ($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001(new \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V001Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->getLastError());
}
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V002 operation/method
 */
if ($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V002(new \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V002Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->getLastError());
}
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003 operation/method
 */
if ($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003(new \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEGETV->getLastError());
}
/**
 * Samples for SROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV ServiceType
 */
$sROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV = new \ServiceType\SROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV($options);
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V001
 * operation/method
 */
if ($sROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV->S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V001(new \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V001Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV->getLastError());
}
/**
 * Sample call for S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V002
 * operation/method
 */
if ($sROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV->S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V002(new \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_GET_V002Request()) !== false) {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATEWITHOUTIMAGEMOBILEGETV->getLastError());
}
/**
 * Samples for SROOMMAINTENANCESTATUSCHANGEV ServiceType
 */
$sROOMMAINTENANCESTATUSCHANGEV = new \ServiceType\SROOMMAINTENANCESTATUSCHANGEV($options);
/**
 * Sample call for S_ROOM_MAINTENANCE_STATUS_CHANGE_V001 operation/method
 */
if ($sROOMMAINTENANCESTATUSCHANGEV->S_ROOM_MAINTENANCE_STATUS_CHANGE_V001(new \StructType\S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Request()) !== false) {
    print_r($sROOMMAINTENANCESTATUSCHANGEV->getResult());
} else {
    print_r($sROOMMAINTENANCESTATUSCHANGEV->getLastError());
}
/**
 * Samples for SROOMRESETMAINTENANCESTATEV ServiceType
 */
$sROOMRESETMAINTENANCESTATEV = new \ServiceType\SROOMRESETMAINTENANCESTATEV($options);
/**
 * Sample call for S_ROOM_RESET_MAINTENANCE_STATE_V001 operation/method
 */
if ($sROOMRESETMAINTENANCESTATEV->S_ROOM_RESET_MAINTENANCE_STATE_V001(new \StructType\S_ROOM_RESET_MAINTENANCE_STATE_V001Request()) !== false) {
    print_r($sROOMRESETMAINTENANCESTATEV->getResult());
} else {
    print_r($sROOMRESETMAINTENANCESTATEV->getLastError());
}
/**
 * Samples for SROOMSTATECHANGEV ServiceType
 */
$sROOMSTATECHANGEV = new \ServiceType\SROOMSTATECHANGEV($options);
/**
 * Sample call for S_ROOM_STATE_CHANGE_V001 operation/method
 */
if ($sROOMSTATECHANGEV->S_ROOM_STATE_CHANGE_V001(new \StructType\S_ROOM_STATE_CHANGE_V001Request()) !== false) {
    print_r($sROOMSTATECHANGEV->getResult());
} else {
    print_r($sROOMSTATECHANGEV->getLastError());
}
/**
 * Samples for SROOMSTATESEARCHV ServiceType
 */
$sROOMSTATESEARCHV = new \ServiceType\SROOMSTATESEARCHV($options);
/**
 * Sample call for S_ROOM_STATE_SEARCH_V002 operation/method
 */
if ($sROOMSTATESEARCHV->S_ROOM_STATE_SEARCH_V002(new \StructType\S_ROOM_STATE_SEARCH_V002Request()) !== false) {
    print_r($sROOMSTATESEARCHV->getResult());
} else {
    print_r($sROOMSTATESEARCHV->getLastError());
}
/**
 * Sample call for S_ROOM_STATE_SEARCH_V003 operation/method
 */
if ($sROOMSTATESEARCHV->S_ROOM_STATE_SEARCH_V003(new \StructType\S_ROOM_STATE_SEARCH_V003Request()) !== false) {
    print_r($sROOMSTATESEARCHV->getResult());
} else {
    print_r($sROOMSTATESEARCHV->getLastError());
}
/**
 * Sample call for S_ROOM_STATE_SEARCH_V01 operation/method
 */
if ($sROOMSTATESEARCHV->S_ROOM_STATE_SEARCH_V01(new \StructType\S_ROOM_STATE_SEARCH_V01Request()) !== false) {
    print_r($sROOMSTATESEARCHV->getResult());
} else {
    print_r($sROOMSTATESEARCHV->getLastError());
}
/**
 * Samples for SSALESPOTENTIALCREATEV ServiceType
 */
$sSALESPOTENTIALCREATEV = new \ServiceType\SSALESPOTENTIALCREATEV($options);
/**
 * Sample call for S_SALESPOTENTIAL_CREATE_V001 operation/method
 */
if ($sSALESPOTENTIALCREATEV->S_SALESPOTENTIAL_CREATE_V001(new \StructType\S_SALESPOTENTIAL_CREATE_V001Request()) !== false) {
    print_r($sSALESPOTENTIALCREATEV->getResult());
} else {
    print_r($sSALESPOTENTIALCREATEV->getLastError());
}
/**
 * Samples for SSALESPOTENTIALGETV ServiceType
 */
$sSALESPOTENTIALGETV = new \ServiceType\SSALESPOTENTIALGETV($options);
/**
 * Sample call for S_SALESPOTENTIAL_GET_V001 operation/method
 */
if ($sSALESPOTENTIALGETV->S_SALESPOTENTIAL_GET_V001(new \StructType\S_SALESPOTENTIAL_GET_V001Request()) !== false) {
    print_r($sSALESPOTENTIALGETV->getResult());
} else {
    print_r($sSALESPOTENTIALGETV->getLastError());
}
/**
 * Samples for SSALESPOTENTIALGUESTCREATEV ServiceType
 */
$sSALESPOTENTIALGUESTCREATEV = new \ServiceType\SSALESPOTENTIALGUESTCREATEV($options);
/**
 * Sample call for S_SALESPOTENTIAL_GUEST_CREATE_V001 operation/method
 */
if ($sSALESPOTENTIALGUESTCREATEV->S_SALESPOTENTIAL_GUEST_CREATE_V001(new \StructType\S_SALESPOTENTIAL_GUEST_CREATE_V001Request()) !== false) {
    print_r($sSALESPOTENTIALGUESTCREATEV->getResult());
} else {
    print_r($sSALESPOTENTIALGUESTCREATEV->getLastError());
}
/**
 * Samples for SSALESPOTENTIALMODIFYV ServiceType
 */
$sSALESPOTENTIALMODIFYV = new \ServiceType\SSALESPOTENTIALMODIFYV($options);
/**
 * Sample call for S_SALESPOTENTIAL_MODIFY_V001 operation/method
 */
if ($sSALESPOTENTIALMODIFYV->S_SALESPOTENTIAL_MODIFY_V001(new \StructType\S_SALESPOTENTIAL_MODIFY_V001Request()) !== false) {
    print_r($sSALESPOTENTIALMODIFYV->getResult());
} else {
    print_r($sSALESPOTENTIALMODIFYV->getLastError());
}
/**
 * Samples for SSALESPOTENTIALSEARCHV ServiceType
 */
$sSALESPOTENTIALSEARCHV = new \ServiceType\SSALESPOTENTIALSEARCHV($options);
/**
 * Sample call for S_SALESPOTENTIAL_SEARCH_V001 operation/method
 */
if ($sSALESPOTENTIALSEARCHV->S_SALESPOTENTIAL_SEARCH_V001(new \StructType\S_SALESPOTENTIAL_SEARCH_V001Request()) !== false) {
    print_r($sSALESPOTENTIALSEARCHV->getResult());
} else {
    print_r($sSALESPOTENTIALSEARCHV->getLastError());
}
/**
 * Samples for SSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV ServiceType
 */
$sSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV = new \ServiceType\SSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV($options);
/**
 * Sample call for
 * S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001
 * operation/method
 */
if ($sSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001(new \StructType\S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request()) !== false) {
    print_r($sSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getResult());
} else {
    print_r($sSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getLastError());
}
/**
 * Samples for SSERVICESSEARCHV ServiceType
 */
$sSERVICESSEARCHV = new \ServiceType\SSERVICESSEARCHV($options);
/**
 * Sample call for S_SERVICES_SEARCH_V001 operation/method
 */
if ($sSERVICESSEARCHV->S_SERVICES_SEARCH_V001(new \StructType\S_SERVICES_SEARCH_V001Request()) !== false) {
    print_r($sSERVICESSEARCHV->getResult());
} else {
    print_r($sSERVICESSEARCHV->getLastError());
}
/**
 * Sample call for S_SERVICES_SEARCH_V002 operation/method
 */
if ($sSERVICESSEARCHV->S_SERVICES_SEARCH_V002(new \StructType\S_SERVICES_SEARCH_V002Request()) !== false) {
    print_r($sSERVICESSEARCHV->getResult());
} else {
    print_r($sSERVICESSEARCHV->getLastError());
}
/**
 * Samples for SSERVICEMAPPINGGETV ServiceType
 */
$sSERVICEMAPPINGGETV = new \ServiceType\SSERVICEMAPPINGGETV($options);
/**
 * Sample call for S_SERVICE_MAPPING_GET_V001 operation/method
 */
if ($sSERVICEMAPPINGGETV->S_SERVICE_MAPPING_GET_V001(new \StructType\S_SERVICE_MAPPING_GET_V001Request()) !== false) {
    print_r($sSERVICEMAPPINGGETV->getResult());
} else {
    print_r($sSERVICEMAPPINGGETV->getLastError());
}
/**
 * Samples for SSERVICEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV ServiceType
 */
$sSERVICEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV = new \ServiceType\SSERVICEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV($options);
/**
 * Sample call for S_SERVICE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001
 * operation/method
 */
if ($sSERVICEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->S_SERVICE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001(new \StructType\S_SERVICE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request()) !== false) {
    print_r($sSERVICEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getResult());
} else {
    print_r($sSERVICEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV->getLastError());
}
/**
 * Samples for SSERVICEPACKAGERESTRICTIONSEARCHV ServiceType
 */
$sSERVICEPACKAGERESTRICTIONSEARCHV = new \ServiceType\SSERVICEPACKAGERESTRICTIONSEARCHV($options);
/**
 * Sample call for S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001 operation/method
 */
if ($sSERVICEPACKAGERESTRICTIONSEARCHV->S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001(new \StructType\S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001Request()) !== false) {
    print_r($sSERVICEPACKAGERESTRICTIONSEARCHV->getResult());
} else {
    print_r($sSERVICEPACKAGERESTRICTIONSEARCHV->getLastError());
}
/**
 * Sample call for S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V002 operation/method
 */
if ($sSERVICEPACKAGERESTRICTIONSEARCHV->S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V002(new \StructType\S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V002Request()) !== false) {
    print_r($sSERVICEPACKAGERESTRICTIONSEARCHV->getResult());
} else {
    print_r($sSERVICEPACKAGERESTRICTIONSEARCHV->getLastError());
}
/**
 * Samples for SSERVICESEARCHV ServiceType
 */
$sSERVICESEARCHV = new \ServiceType\SSERVICESEARCHV($options);
/**
 * Sample call for S_SERVICE_SEARCH_V001 operation/method
 */
if ($sSERVICESEARCHV->S_SERVICE_SEARCH_V001(new \StructType\S_SERVICE_SEARCH_V001Request()) !== false) {
    print_r($sSERVICESEARCHV->getResult());
} else {
    print_r($sSERVICESEARCHV->getLastError());
}
/**
 * Sample call for S_SERVICE_SEARCH_V002 operation/method
 */
if ($sSERVICESEARCHV->S_SERVICE_SEARCH_V002(new \StructType\S_SERVICE_SEARCH_V002Request()) !== false) {
    print_r($sSERVICESEARCHV->getResult());
} else {
    print_r($sSERVICESEARCHV->getLastError());
}
/**
 * Samples for SSUITECATEGORYMASTERFILECOMMENTGETV ServiceType
 */
$sSUITECATEGORYMASTERFILECOMMENTGETV = new \ServiceType\SSUITECATEGORYMASTERFILECOMMENTGETV($options);
/**
 * Sample call for S_SUITE_CATEGORY_MASTER_FILE_COMMENT_GET_V001 operation/method
 */
if ($sSUITECATEGORYMASTERFILECOMMENTGETV->S_SUITE_CATEGORY_MASTER_FILE_COMMENT_GET_V001(new \StructType\S_SUITE_CATEGORY_MASTER_FILE_COMMENT_GET_V001Request()) !== false) {
    print_r($sSUITECATEGORYMASTERFILECOMMENTGETV->getResult());
} else {
    print_r($sSUITECATEGORYMASTERFILECOMMENTGETV->getLastError());
}
/**
 * Samples for SSUITECATEGORYMASTERFILECOMMENTSTOREV ServiceType
 */
$sSUITECATEGORYMASTERFILECOMMENTSTOREV = new \ServiceType\SSUITECATEGORYMASTERFILECOMMENTSTOREV($options);
/**
 * Sample call for S_SUITE_CATEGORY_MASTER_FILE_COMMENT_STORE_V001 operation/method
 */
if ($sSUITECATEGORYMASTERFILECOMMENTSTOREV->S_SUITE_CATEGORY_MASTER_FILE_COMMENT_STORE_V001(new \StructType\S_SUITE_CATEGORY_MASTER_FILE_COMMENT_STORE_V001Request()) !== false) {
    print_r($sSUITECATEGORYMASTERFILECOMMENTSTOREV->getResult());
} else {
    print_r($sSUITECATEGORYMASTERFILECOMMENTSTOREV->getLastError());
}
/**
 * Samples for SSUITECATEGORYMASTERFILEGETV ServiceType
 */
$sSUITECATEGORYMASTERFILEGETV = new \ServiceType\SSUITECATEGORYMASTERFILEGETV($options);
/**
 * Sample call for S_SUITE_CATEGORY_MASTER_FILE_GET_V001 operation/method
 */
if ($sSUITECATEGORYMASTERFILEGETV->S_SUITE_CATEGORY_MASTER_FILE_GET_V001(new \StructType\S_SUITE_CATEGORY_MASTER_FILE_GET_V001Request()) !== false) {
    print_r($sSUITECATEGORYMASTERFILEGETV->getResult());
} else {
    print_r($sSUITECATEGORYMASTERFILEGETV->getLastError());
}
/**
 * Samples for SSUITECATEGORYMASTERFILEINTERNETGETV ServiceType
 */
$sSUITECATEGORYMASTERFILEINTERNETGETV = new \ServiceType\SSUITECATEGORYMASTERFILEINTERNETGETV($options);
/**
 * Sample call for S_SUITE_CATEGORY_MASTER_FILE_INTERNET_GET_V001 operation/method
 */
if ($sSUITECATEGORYMASTERFILEINTERNETGETV->S_SUITE_CATEGORY_MASTER_FILE_INTERNET_GET_V001(new \StructType\S_SUITE_CATEGORY_MASTER_FILE_INTERNET_GET_V001Request()) !== false) {
    print_r($sSUITECATEGORYMASTERFILEINTERNETGETV->getResult());
} else {
    print_r($sSUITECATEGORYMASTERFILEINTERNETGETV->getLastError());
}
/**
 * Samples for SSUITECATEGORYMASTERFILEINTERNETSTOREV ServiceType
 */
$sSUITECATEGORYMASTERFILEINTERNETSTOREV = new \ServiceType\SSUITECATEGORYMASTERFILEINTERNETSTOREV($options);
/**
 * Sample call for S_SUITE_CATEGORY_MASTER_FILE_INTERNET_STORE_V001
 * operation/method
 */
if ($sSUITECATEGORYMASTERFILEINTERNETSTOREV->S_SUITE_CATEGORY_MASTER_FILE_INTERNET_STORE_V001(new \StructType\S_SUITE_CATEGORY_MASTER_FILE_INTERNET_STORE_V001Request()) !== false) {
    print_r($sSUITECATEGORYMASTERFILEINTERNETSTOREV->getResult());
} else {
    print_r($sSUITECATEGORYMASTERFILEINTERNETSTOREV->getLastError());
}
/**
 * Samples for SSUITECATEGORYMASTERFILEOVERBOOKINGGETV ServiceType
 */
$sSUITECATEGORYMASTERFILEOVERBOOKINGGETV = new \ServiceType\SSUITECATEGORYMASTERFILEOVERBOOKINGGETV($options);
/**
 * Sample call for S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001
 * operation/method
 */
if ($sSUITECATEGORYMASTERFILEOVERBOOKINGGETV->S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001(new \StructType\S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_GET_V001Request()) !== false) {
    print_r($sSUITECATEGORYMASTERFILEOVERBOOKINGGETV->getResult());
} else {
    print_r($sSUITECATEGORYMASTERFILEOVERBOOKINGGETV->getLastError());
}
/**
 * Samples for SSUITECATEGORYMASTERFILEOVERBOOKINGSTOREV ServiceType
 */
$sSUITECATEGORYMASTERFILEOVERBOOKINGSTOREV = new \ServiceType\SSUITECATEGORYMASTERFILEOVERBOOKINGSTOREV($options);
/**
 * Sample call for S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001
 * operation/method
 */
if ($sSUITECATEGORYMASTERFILEOVERBOOKINGSTOREV->S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001(new \StructType\S_SUITE_CATEGORY_MASTER_FILE_OVERBOOKING_STORE_V001Request()) !== false) {
    print_r($sSUITECATEGORYMASTERFILEOVERBOOKINGSTOREV->getResult());
} else {
    print_r($sSUITECATEGORYMASTERFILEOVERBOOKINGSTOREV->getLastError());
}
/**
 * Samples for SSYSMESSAGEADDV ServiceType
 */
$sSYSMESSAGEADDV = new \ServiceType\SSYSMESSAGEADDV($options);
/**
 * Sample call for S_SYSMESSAGE_ADD_V001 operation/method
 */
if ($sSYSMESSAGEADDV->S_SYSMESSAGE_ADD_V001(new \StructType\S_SYSMESSAGE_ADD_V001Request()) !== false) {
    print_r($sSYSMESSAGEADDV->getResult());
} else {
    print_r($sSYSMESSAGEADDV->getLastError());
}
/**
 * Sample call for S_SYSMESSAGE_ADD_V002 operation/method
 */
if ($sSYSMESSAGEADDV->S_SYSMESSAGE_ADD_V002(new \StructType\S_SYSMESSAGE_ADD_V002Request()) !== false) {
    print_r($sSYSMESSAGEADDV->getResult());
} else {
    print_r($sSYSMESSAGEADDV->getLastError());
}
/**
 * Samples for STOKENISATIONNOTIFICATIONV ServiceType
 */
$sTOKENISATIONNOTIFICATIONV = new \ServiceType\STOKENISATIONNOTIFICATIONV($options);
/**
 * Sample call for S_TOKENISATION_NOTIFICATION_V01 operation/method
 */
if ($sTOKENISATIONNOTIFICATIONV->S_TOKENISATION_NOTIFICATION_V01(new \StructType\S_TOKENISATION_NOTIFICATION_V01Request()) !== false) {
    print_r($sTOKENISATIONNOTIFICATIONV->getResult());
} else {
    print_r($sTOKENISATIONNOTIFICATIONV->getLastError());
}
/**
 * Sample call for S_TOKENISATION_NOTIFICATION_V02 operation/method
 */
if ($sTOKENISATIONNOTIFICATIONV->S_TOKENISATION_NOTIFICATION_V02(new \StructType\S_TOKENISATION_NOTIFICATION_V02Request()) !== false) {
    print_r($sTOKENISATIONNOTIFICATIONV->getResult());
} else {
    print_r($sTOKENISATIONNOTIFICATIONV->getLastError());
}
/**
 * Samples for STRAILATTACHMENTTOEXTERNALDOCUMENTADDV ServiceType
 */
$sTRAILATTACHMENTTOEXTERNALDOCUMENTADDV = new \ServiceType\STRAILATTACHMENTTOEXTERNALDOCUMENTADDV($options);
/**
 * Sample call for S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001
 * operation/method
 */
if ($sTRAILATTACHMENTTOEXTERNALDOCUMENTADDV->S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001(new \StructType\S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request()) !== false) {
    print_r($sTRAILATTACHMENTTOEXTERNALDOCUMENTADDV->getResult());
} else {
    print_r($sTRAILATTACHMENTTOEXTERNALDOCUMENTADDV->getLastError());
}
/**
 * Samples for STRAILEXTERNALDOCUMENTADDV ServiceType
 */
$sTRAILEXTERNALDOCUMENTADDV = new \ServiceType\STRAILEXTERNALDOCUMENTADDV($options);
/**
 * Sample call for S_TRAIL_EXTERNAL_DOCUMENT_ADD_V001 operation/method
 */
if ($sTRAILEXTERNALDOCUMENTADDV->S_TRAIL_EXTERNAL_DOCUMENT_ADD_V001(new \StructType\S_TRAIL_EXTERNAL_DOCUMENT_ADD_V001Request()) !== false) {
    print_r($sTRAILEXTERNALDOCUMENTADDV->getResult());
} else {
    print_r($sTRAILEXTERNALDOCUMENTADDV->getLastError());
}
/**
 * Samples for SUSERGETCURRENTV ServiceType
 */
$sUSERGETCURRENTV = new \ServiceType\SUSERGETCURRENTV($options);
/**
 * Sample call for S_USER_GET_CURRENT_V001 operation/method
 */
if ($sUSERGETCURRENTV->S_USER_GET_CURRENT_V001(new \StructType\S_USER_GET_CURRENT_V001Request()) !== false) {
    print_r($sUSERGETCURRENTV->getResult());
} else {
    print_r($sUSERGETCURRENTV->getLastError());
}
/**
 * Samples for SUSERINFOGETV ServiceType
 */
$sUSERINFOGETV = new \ServiceType\SUSERINFOGETV($options);
/**
 * Sample call for S_USER_INFO_GET_V001 operation/method
 */
if ($sUSERINFOGETV->S_USER_INFO_GET_V001(new \StructType\S_USER_INFO_GET_V001Request()) !== false) {
    print_r($sUSERINFOGETV->getResult());
} else {
    print_r($sUSERINFOGETV->getLastError());
}
/**
 * Sample call for S_USER_INFO_GET_V002 operation/method
 */
if ($sUSERINFOGETV->S_USER_INFO_GET_V002(new \StructType\S_USER_INFO_GET_V002Request()) !== false) {
    print_r($sUSERINFOGETV->getResult());
} else {
    print_r($sUSERINFOGETV->getLastError());
}
/**
 * Sample call for S_USER_INFO_GET_V003 operation/method
 */
if ($sUSERINFOGETV->S_USER_INFO_GET_V003(new \StructType\S_USER_INFO_GET_V003Request()) !== false) {
    print_r($sUSERINFOGETV->getResult());
} else {
    print_r($sUSERINFOGETV->getLastError());
}
/**
 * Samples for SUSERSEARCHV ServiceType
 */
$sUSERSEARCHV = new \ServiceType\SUSERSEARCHV($options);
/**
 * Sample call for S_USER_SEARCH_V001 operation/method
 */
if ($sUSERSEARCHV->S_USER_SEARCH_V001(new \StructType\S_USER_SEARCH_V001Request()) !== false) {
    print_r($sUSERSEARCHV->getResult());
} else {
    print_r($sUSERSEARCHV->getLastError());
}
/**
 * Sample call for S_USER_SEARCH_V002 operation/method
 */
if ($sUSERSEARCHV->S_USER_SEARCH_V002(new \StructType\S_USER_SEARCH_V002Request()) !== false) {
    print_r($sUSERSEARCHV->getResult());
} else {
    print_r($sUSERSEARCHV->getLastError());
}
/**
 * Samples for SYIELDHURDLEPRODUCTIONSEARCHV ServiceType
 */
$sYIELDHURDLEPRODUCTIONSEARCHV = new \ServiceType\SYIELDHURDLEPRODUCTIONSEARCHV($options);
/**
 * Sample call for S_YIELD_HURDLE_PRODUCTION_SEARCH_V001 operation/method
 */
if ($sYIELDHURDLEPRODUCTIONSEARCHV->S_YIELD_HURDLE_PRODUCTION_SEARCH_V001(new \StructType\S_YIELD_HURDLE_PRODUCTION_SEARCH_V001Request()) !== false) {
    print_r($sYIELDHURDLEPRODUCTIONSEARCHV->getResult());
} else {
    print_r($sYIELDHURDLEPRODUCTIONSEARCHV->getLastError());
}
