<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for YieldHurdleProduction StructType
 * @subpackage Structs
 */
class YieldHurdleProduction extends AbstractStructBase
{
    /**
     * The YIELDHURDLEPRODUCTION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $YIELDHURDLEPRODUCTION_OBJID;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The yieldseasontexts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $yieldseasontexts;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The hurdleBase
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $hurdleBase;
    /**
     * The delta
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $delta;
    /**
     * The ceiling
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $ceiling;
    /**
     * The maxsold
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxsold;
    /**
     * The newsold
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $newsold;
    /**
     * The creationOperator
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $creationOperator;
    /**
     * The creationdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $creationdate;
    /**
     * The creationTime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $creationTime;
    /**
     * The modificationoperator
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $modificationoperator;
    /**
     * The modificationdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $modificationdate;
    /**
     * The modificationtime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $modificationtime;
    /**
     * Constructor method for YieldHurdleProduction
     * @uses YieldHurdleProduction::setYIELDHURDLEPRODUCTION_OBJID()
     * @uses YieldHurdleProduction::setDate()
     * @uses YieldHurdleProduction::setYieldseasontexts()
     * @uses YieldHurdleProduction::setCategory()
     * @uses YieldHurdleProduction::setHurdleBase()
     * @uses YieldHurdleProduction::setDelta()
     * @uses YieldHurdleProduction::setCeiling()
     * @uses YieldHurdleProduction::setMaxsold()
     * @uses YieldHurdleProduction::setNewsold()
     * @uses YieldHurdleProduction::setCreationOperator()
     * @uses YieldHurdleProduction::setCreationdate()
     * @uses YieldHurdleProduction::setCreationTime()
     * @uses YieldHurdleProduction::setModificationoperator()
     * @uses YieldHurdleProduction::setModificationdate()
     * @uses YieldHurdleProduction::setModificationtime()
     * @param string $yIELDHURDLEPRODUCTION_OBJID
     * @param string $date
     * @param string $yieldseasontexts
     * @param string $category
     * @param string $hurdleBase
     * @param string $delta
     * @param string $ceiling
     * @param string $maxsold
     * @param string $newsold
     * @param string $creationOperator
     * @param string $creationdate
     * @param string $creationTime
     * @param string $modificationoperator
     * @param string $modificationdate
     * @param string $modificationtime
     */
    public function __construct($yIELDHURDLEPRODUCTION_OBJID = null, $date = null, $yieldseasontexts = null, $category = null, $hurdleBase = null, $delta = null, $ceiling = null, $maxsold = null, $newsold = null, $creationOperator = null, $creationdate = null, $creationTime = null, $modificationoperator = null, $modificationdate = null, $modificationtime = null)
    {
        $this
            ->setYIELDHURDLEPRODUCTION_OBJID($yIELDHURDLEPRODUCTION_OBJID)
            ->setDate($date)
            ->setYieldseasontexts($yieldseasontexts)
            ->setCategory($category)
            ->setHurdleBase($hurdleBase)
            ->setDelta($delta)
            ->setCeiling($ceiling)
            ->setMaxsold($maxsold)
            ->setNewsold($newsold)
            ->setCreationOperator($creationOperator)
            ->setCreationdate($creationdate)
            ->setCreationTime($creationTime)
            ->setModificationoperator($modificationoperator)
            ->setModificationdate($modificationdate)
            ->setModificationtime($modificationtime);
    }
    /**
     * Get YIELDHURDLEPRODUCTION_OBJID value
     * @return string
     */
    public function getYIELDHURDLEPRODUCTION_OBJID()
    {
        return $this->{'YIELDHURDLEPRODUCTION-OBJID'};
    }
    /**
     * Set YIELDHURDLEPRODUCTION_OBJID value
     * @param string $yIELDHURDLEPRODUCTION_OBJID
     * @return \StructType\YieldHurdleProduction
     */
    public function setYIELDHURDLEPRODUCTION_OBJID($yIELDHURDLEPRODUCTION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($yIELDHURDLEPRODUCTION_OBJID) && !is_string($yIELDHURDLEPRODUCTION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yIELDHURDLEPRODUCTION_OBJID, true), gettype($yIELDHURDLEPRODUCTION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($yIELDHURDLEPRODUCTION_OBJID) && !preg_match('/([0-9])*/', $yIELDHURDLEPRODUCTION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($yIELDHURDLEPRODUCTION_OBJID, true)), __LINE__);
        }
        $this->YIELDHURDLEPRODUCTION_OBJID = $this->{'YIELDHURDLEPRODUCTION-OBJID'} = $yIELDHURDLEPRODUCTION_OBJID;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\YieldHurdleProduction
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get yieldseasontexts value
     * @return string
     */
    public function getYieldseasontexts()
    {
        return $this->yieldseasontexts;
    }
    /**
     * Set yieldseasontexts value
     * @param string $yieldseasontexts
     * @return \StructType\YieldHurdleProduction
     */
    public function setYieldseasontexts($yieldseasontexts = null)
    {
        // validation for constraint: string
        if (!is_null($yieldseasontexts) && !is_string($yieldseasontexts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yieldseasontexts, true), gettype($yieldseasontexts)), __LINE__);
        }
        $this->yieldseasontexts = $yieldseasontexts;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\YieldHurdleProduction
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get hurdleBase value
     * @return string
     */
    public function getHurdleBase()
    {
        return $this->hurdleBase;
    }
    /**
     * Set hurdleBase value
     * @param string $hurdleBase
     * @return \StructType\YieldHurdleProduction
     */
    public function setHurdleBase($hurdleBase = null)
    {
        // validation for constraint: string
        if (!is_null($hurdleBase) && !is_string($hurdleBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hurdleBase, true), gettype($hurdleBase)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($hurdleBase) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $hurdleBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($hurdleBase, true)), __LINE__);
        }
        $this->hurdleBase = $hurdleBase;
        return $this;
    }
    /**
     * Get delta value
     * @return string
     */
    public function getDelta()
    {
        return $this->delta;
    }
    /**
     * Set delta value
     * @param string $delta
     * @return \StructType\YieldHurdleProduction
     */
    public function setDelta($delta = null)
    {
        // validation for constraint: string
        if (!is_null($delta) && !is_string($delta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delta, true), gettype($delta)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($delta) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $delta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($delta, true)), __LINE__);
        }
        $this->delta = $delta;
        return $this;
    }
    /**
     * Get ceiling value
     * @return string
     */
    public function getCeiling()
    {
        return $this->ceiling;
    }
    /**
     * Set ceiling value
     * @param string $ceiling
     * @return \StructType\YieldHurdleProduction
     */
    public function setCeiling($ceiling = null)
    {
        // validation for constraint: string
        if (!is_null($ceiling) && !is_string($ceiling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ceiling, true), gettype($ceiling)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($ceiling) && !preg_match('/([-+]){0,1}([0-9])*/', $ceiling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($ceiling, true)), __LINE__);
        }
        $this->ceiling = $ceiling;
        return $this;
    }
    /**
     * Get maxsold value
     * @return string
     */
    public function getMaxsold()
    {
        return $this->maxsold;
    }
    /**
     * Set maxsold value
     * @param string $maxsold
     * @return \StructType\YieldHurdleProduction
     */
    public function setMaxsold($maxsold = null)
    {
        // validation for constraint: string
        if (!is_null($maxsold) && !is_string($maxsold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxsold, true), gettype($maxsold)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxsold) && !preg_match('/([-+]){0,1}([0-9])*/', $maxsold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxsold, true)), __LINE__);
        }
        $this->maxsold = $maxsold;
        return $this;
    }
    /**
     * Get newsold value
     * @return string
     */
    public function getNewsold()
    {
        return $this->newsold;
    }
    /**
     * Set newsold value
     * @param string $newsold
     * @return \StructType\YieldHurdleProduction
     */
    public function setNewsold($newsold = null)
    {
        // validation for constraint: string
        if (!is_null($newsold) && !is_string($newsold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newsold, true), gettype($newsold)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($newsold) && !preg_match('/([-+]){0,1}([0-9])*/', $newsold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($newsold, true)), __LINE__);
        }
        $this->newsold = $newsold;
        return $this;
    }
    /**
     * Get creationOperator value
     * @return string
     */
    public function getCreationOperator()
    {
        return $this->creationOperator;
    }
    /**
     * Set creationOperator value
     * @param string $creationOperator
     * @return \StructType\YieldHurdleProduction
     */
    public function setCreationOperator($creationOperator = null)
    {
        // validation for constraint: string
        if (!is_null($creationOperator) && !is_string($creationOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationOperator, true), gettype($creationOperator)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($creationOperator) && mb_strlen($creationOperator) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($creationOperator)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($creationOperator) && mb_strlen($creationOperator) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($creationOperator)), __LINE__);
        }
        $this->creationOperator = $creationOperator;
        return $this;
    }
    /**
     * Get creationdate value
     * @return string
     */
    public function getCreationdate()
    {
        return $this->creationdate;
    }
    /**
     * Set creationdate value
     * @param string $creationdate
     * @return \StructType\YieldHurdleProduction
     */
    public function setCreationdate($creationdate = null)
    {
        // validation for constraint: string
        if (!is_null($creationdate) && !is_string($creationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationdate, true), gettype($creationdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($creationdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $creationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($creationdate, true)), __LINE__);
        }
        $this->creationdate = $creationdate;
        return $this;
    }
    /**
     * Get creationTime value
     * @return string
     */
    public function getCreationTime()
    {
        return $this->creationTime;
    }
    /**
     * Set creationTime value
     * @param string $creationTime
     * @return \StructType\YieldHurdleProduction
     */
    public function setCreationTime($creationTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationTime) && !is_string($creationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationTime, true), gettype($creationTime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($creationTime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $creationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($creationTime, true)), __LINE__);
        }
        $this->creationTime = $creationTime;
        return $this;
    }
    /**
     * Get modificationoperator value
     * @return string
     */
    public function getModificationoperator()
    {
        return $this->modificationoperator;
    }
    /**
     * Set modificationoperator value
     * @param string $modificationoperator
     * @return \StructType\YieldHurdleProduction
     */
    public function setModificationoperator($modificationoperator = null)
    {
        // validation for constraint: string
        if (!is_null($modificationoperator) && !is_string($modificationoperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationoperator, true), gettype($modificationoperator)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($modificationoperator) && mb_strlen($modificationoperator) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($modificationoperator)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($modificationoperator) && mb_strlen($modificationoperator) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($modificationoperator)), __LINE__);
        }
        $this->modificationoperator = $modificationoperator;
        return $this;
    }
    /**
     * Get modificationdate value
     * @return string
     */
    public function getModificationdate()
    {
        return $this->modificationdate;
    }
    /**
     * Set modificationdate value
     * @param string $modificationdate
     * @return \StructType\YieldHurdleProduction
     */
    public function setModificationdate($modificationdate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationdate) && !is_string($modificationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationdate, true), gettype($modificationdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($modificationdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $modificationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($modificationdate, true)), __LINE__);
        }
        $this->modificationdate = $modificationdate;
        return $this;
    }
    /**
     * Get modificationtime value
     * @return string
     */
    public function getModificationtime()
    {
        return $this->modificationtime;
    }
    /**
     * Set modificationtime value
     * @param string $modificationtime
     * @return \StructType\YieldHurdleProduction
     */
    public function setModificationtime($modificationtime = null)
    {
        // validation for constraint: string
        if (!is_null($modificationtime) && !is_string($modificationtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationtime, true), gettype($modificationtime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($modificationtime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $modificationtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($modificationtime, true)), __LINE__);
        }
        $this->modificationtime = $modificationtime;
        return $this;
    }
}
