<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VATS StructType
 * @subpackage Structs
 */
class VATS extends AbstractStructBase
{
    /**
     * The VAT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VAT[]
     */
    public $VAT;
    /**
     * Constructor method for VATS
     * @uses VATS::setVAT()
     * @param \StructType\VAT[] $vAT
     */
    public function __construct(array $vAT = array())
    {
        $this
            ->setVAT($vAT);
    }
    /**
     * Get VAT value
     * @return \StructType\VAT[]|null
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * This method is responsible for validating the values passed to the setVAT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVAT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVATForArrayConstraintsFromSetVAT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vATSVATItem) {
            // validation for constraint: itemType
            if (!$vATSVATItem instanceof \StructType\VAT) {
                $invalidValues[] = is_object($vATSVATItem) ? get_class($vATSVATItem) : sprintf('%s(%s)', gettype($vATSVATItem), var_export($vATSVATItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VAT property can only contain items of type \StructType\VAT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VAT value
     * @throws \InvalidArgumentException
     * @param \StructType\VAT[] $vAT
     * @return \StructType\VATS
     */
    public function setVAT(array $vAT = array())
    {
        // validation for constraint: array
        if ('' !== ($vATArrayErrorMessage = self::validateVATForArrayConstraintsFromSetVAT($vAT))) {
            throw new \InvalidArgumentException($vATArrayErrorMessage, __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Add item to VAT value
     * @throws \InvalidArgumentException
     * @param \StructType\VAT $item
     * @return \StructType\VATS
     */
    public function addToVAT(\StructType\VAT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VAT) {
            throw new \InvalidArgumentException(sprintf('The VAT property can only contain items of type \StructType\VAT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VAT[] = $item;
        return $this;
    }
}
