<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailNode1 StructType
 * @subpackage Structs
 */
class TrailNode1 extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The Node1Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Node1Type;
    /**
     * The TrailData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TrailData[]
     */
    public $TrailData;
    /**
     * The SubTrails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubTrails[]
     */
    public $SubTrails;
    /**
     * Constructor method for TrailNode1
     * @uses TrailNode1::setDescription()
     * @uses TrailNode1::setNode1Type()
     * @uses TrailNode1::setTrailData()
     * @uses TrailNode1::setSubTrails()
     * @param string $description
     * @param string $node1Type
     * @param \StructType\TrailData[] $trailData
     * @param \StructType\SubTrails[] $subTrails
     */
    public function __construct($description = null, $node1Type = null, array $trailData = array(), array $subTrails = array())
    {
        $this
            ->setDescription($description)
            ->setNode1Type($node1Type)
            ->setTrailData($trailData)
            ->setSubTrails($subTrails);
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TrailNode1
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get Node1Type value
     * @return string
     */
    public function getNode1Type()
    {
        return $this->Node1Type;
    }
    /**
     * Set Node1Type value
     * @param string $node1Type
     * @return \StructType\TrailNode1
     */
    public function setNode1Type($node1Type = null)
    {
        // validation for constraint: string
        if (!is_null($node1Type) && !is_string($node1Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node1Type, true), gettype($node1Type)), __LINE__);
        }
        $this->Node1Type = $node1Type;
        return $this;
    }
    /**
     * Get TrailData value
     * @return \StructType\TrailData[]|null
     */
    public function getTrailData()
    {
        return $this->TrailData;
    }
    /**
     * This method is responsible for validating the values passed to the setTrailData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrailData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrailDataForArrayConstraintsFromSetTrailData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trailNode1TrailDataItem) {
            // validation for constraint: itemType
            if (!$trailNode1TrailDataItem instanceof \StructType\TrailData) {
                $invalidValues[] = is_object($trailNode1TrailDataItem) ? get_class($trailNode1TrailDataItem) : sprintf('%s(%s)', gettype($trailNode1TrailDataItem), var_export($trailNode1TrailDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrailData property can only contain items of type \StructType\TrailData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrailData value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailData[] $trailData
     * @return \StructType\TrailNode1
     */
    public function setTrailData(array $trailData = array())
    {
        // validation for constraint: array
        if ('' !== ($trailDataArrayErrorMessage = self::validateTrailDataForArrayConstraintsFromSetTrailData($trailData))) {
            throw new \InvalidArgumentException($trailDataArrayErrorMessage, __LINE__);
        }
        $this->TrailData = $trailData;
        return $this;
    }
    /**
     * Add item to TrailData value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailData $item
     * @return \StructType\TrailNode1
     */
    public function addToTrailData(\StructType\TrailData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrailData) {
            throw new \InvalidArgumentException(sprintf('The TrailData property can only contain items of type \StructType\TrailData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrailData[] = $item;
        return $this;
    }
    /**
     * Get SubTrails value
     * @return \StructType\SubTrails[]|null
     */
    public function getSubTrails()
    {
        return $this->SubTrails;
    }
    /**
     * This method is responsible for validating the values passed to the setSubTrails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubTrails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubTrailsForArrayConstraintsFromSetSubTrails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trailNode1SubTrailsItem) {
            // validation for constraint: itemType
            if (!$trailNode1SubTrailsItem instanceof \StructType\SubTrails) {
                $invalidValues[] = is_object($trailNode1SubTrailsItem) ? get_class($trailNode1SubTrailsItem) : sprintf('%s(%s)', gettype($trailNode1SubTrailsItem), var_export($trailNode1SubTrailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubTrails property can only contain items of type \StructType\SubTrails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubTrails value
     * @throws \InvalidArgumentException
     * @param \StructType\SubTrails[] $subTrails
     * @return \StructType\TrailNode1
     */
    public function setSubTrails(array $subTrails = array())
    {
        // validation for constraint: array
        if ('' !== ($subTrailsArrayErrorMessage = self::validateSubTrailsForArrayConstraintsFromSetSubTrails($subTrails))) {
            throw new \InvalidArgumentException($subTrailsArrayErrorMessage, __LINE__);
        }
        $this->SubTrails = $subTrails;
        return $this;
    }
    /**
     * Add item to SubTrails value
     * @throws \InvalidArgumentException
     * @param \StructType\SubTrails $item
     * @return \StructType\TrailNode1
     */
    public function addToSubTrails(\StructType\SubTrails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubTrails) {
            throw new \InvalidArgumentException(sprintf('The SubTrails property can only contain items of type \StructType\SubTrails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubTrails[] = $item;
        return $this;
    }
}
