<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailAdd StructType
 * @subpackage Structs
 */
class TrailAdd extends AbstractStructBase
{
    /**
     * The trailtype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $trailtype;
    /**
     * The Node1Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Node1Type;
    /**
     * The refobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $refobjid;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The appointmentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $appointmentdate;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $time;
    /**
     * The Node2Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Node2Type;
    /**
     * The reftreeobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $reftreeobjid;
    /**
     * The parentrefobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $parentrefobjid;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The enddate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $enddate;
    /**
     * The endtime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $endtime;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for TrailAdd
     * @uses TrailAdd::setTrailtype()
     * @uses TrailAdd::setNode1Type()
     * @uses TrailAdd::setRefobjid()
     * @uses TrailAdd::setDescription()
     * @uses TrailAdd::setAppointmentdate()
     * @uses TrailAdd::setTime()
     * @uses TrailAdd::setNode2Type()
     * @uses TrailAdd::setReftreeobjid()
     * @uses TrailAdd::setParentrefobjid()
     * @uses TrailAdd::setUser()
     * @uses TrailAdd::setStatus()
     * @uses TrailAdd::setLocation()
     * @uses TrailAdd::setEnddate()
     * @uses TrailAdd::setEndtime()
     * @uses TrailAdd::setComment()
     * @param string $trailtype
     * @param string $node1Type
     * @param string $refobjid
     * @param string $description
     * @param string $appointmentdate
     * @param string $time
     * @param string $node2Type
     * @param string $reftreeobjid
     * @param string $parentrefobjid
     * @param string $user
     * @param string $status
     * @param string $location
     * @param string $enddate
     * @param string $endtime
     * @param string $comment
     */
    public function __construct($trailtype = null, $node1Type = null, $refobjid = null, $description = null, $appointmentdate = null, $time = null, $node2Type = null, $reftreeobjid = null, $parentrefobjid = null, $user = null, $status = null, $location = null, $enddate = null, $endtime = null, $comment = null)
    {
        $this
            ->setTrailtype($trailtype)
            ->setNode1Type($node1Type)
            ->setRefobjid($refobjid)
            ->setDescription($description)
            ->setAppointmentdate($appointmentdate)
            ->setTime($time)
            ->setNode2Type($node2Type)
            ->setReftreeobjid($reftreeobjid)
            ->setParentrefobjid($parentrefobjid)
            ->setUser($user)
            ->setStatus($status)
            ->setLocation($location)
            ->setEnddate($enddate)
            ->setEndtime($endtime)
            ->setComment($comment);
    }
    /**
     * Get trailtype value
     * @return string
     */
    public function getTrailtype()
    {
        return $this->trailtype;
    }
    /**
     * Set trailtype value
     * @param string $trailtype
     * @return \StructType\TrailAdd
     */
    public function setTrailtype($trailtype = null)
    {
        // validation for constraint: string
        if (!is_null($trailtype) && !is_string($trailtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailtype, true), gettype($trailtype)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($trailtype) && !preg_match('/([-+]){0,1}([0-9])*/', $trailtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($trailtype, true)), __LINE__);
        }
        $this->trailtype = $trailtype;
        return $this;
    }
    /**
     * Get Node1Type value
     * @return string
     */
    public function getNode1Type()
    {
        return $this->Node1Type;
    }
    /**
     * Set Node1Type value
     * @param string $node1Type
     * @return \StructType\TrailAdd
     */
    public function setNode1Type($node1Type = null)
    {
        // validation for constraint: string
        if (!is_null($node1Type) && !is_string($node1Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node1Type, true), gettype($node1Type)), __LINE__);
        }
        $this->Node1Type = $node1Type;
        return $this;
    }
    /**
     * Get refobjid value
     * @return string
     */
    public function getRefobjid()
    {
        return $this->refobjid;
    }
    /**
     * Set refobjid value
     * @param string $refobjid
     * @return \StructType\TrailAdd
     */
    public function setRefobjid($refobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refobjid) && !is_string($refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refobjid, true), gettype($refobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refobjid) && !preg_match('/([0-9])*/', $refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refobjid, true)), __LINE__);
        }
        $this->refobjid = $refobjid;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TrailAdd
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($description) && mb_strlen($description) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get appointmentdate value
     * @return string
     */
    public function getAppointmentdate()
    {
        return $this->appointmentdate;
    }
    /**
     * Set appointmentdate value
     * @param string $appointmentdate
     * @return \StructType\TrailAdd
     */
    public function setAppointmentdate($appointmentdate = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentdate) && !is_string($appointmentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentdate, true), gettype($appointmentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($appointmentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $appointmentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($appointmentdate, true)), __LINE__);
        }
        $this->appointmentdate = $appointmentdate;
        return $this;
    }
    /**
     * Get time value
     * @return string
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\TrailAdd
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($time) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($time, true)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get Node2Type value
     * @return string|null
     */
    public function getNode2Type()
    {
        return $this->Node2Type;
    }
    /**
     * Set Node2Type value
     * @param string $node2Type
     * @return \StructType\TrailAdd
     */
    public function setNode2Type($node2Type = null)
    {
        // validation for constraint: string
        if (!is_null($node2Type) && !is_string($node2Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node2Type, true), gettype($node2Type)), __LINE__);
        }
        $this->Node2Type = $node2Type;
        return $this;
    }
    /**
     * Get reftreeobjid value
     * @return string|null
     */
    public function getReftreeobjid()
    {
        return $this->reftreeobjid;
    }
    /**
     * Set reftreeobjid value
     * @param string $reftreeobjid
     * @return \StructType\TrailAdd
     */
    public function setReftreeobjid($reftreeobjid = null)
    {
        // validation for constraint: string
        if (!is_null($reftreeobjid) && !is_string($reftreeobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reftreeobjid, true), gettype($reftreeobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($reftreeobjid) && !preg_match('/([0-9])*/', $reftreeobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($reftreeobjid, true)), __LINE__);
        }
        $this->reftreeobjid = $reftreeobjid;
        return $this;
    }
    /**
     * Get parentrefobjid value
     * @return string|null
     */
    public function getParentrefobjid()
    {
        return $this->parentrefobjid;
    }
    /**
     * Set parentrefobjid value
     * @param string $parentrefobjid
     * @return \StructType\TrailAdd
     */
    public function setParentrefobjid($parentrefobjid = null)
    {
        // validation for constraint: string
        if (!is_null($parentrefobjid) && !is_string($parentrefobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentrefobjid, true), gettype($parentrefobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($parentrefobjid) && !preg_match('/([0-9])*/', $parentrefobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($parentrefobjid, true)), __LINE__);
        }
        $this->parentrefobjid = $parentrefobjid;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\TrailAdd
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($user) && mb_strlen($user) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($user)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($user) && mb_strlen($user) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\TrailAdd
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($status) && mb_strlen($status) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($status)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($status) && mb_strlen($status) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\TrailAdd
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($location) && mb_strlen($location) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($location)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($location) && mb_strlen($location) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get enddate value
     * @return string|null
     */
    public function getEnddate()
    {
        return $this->enddate;
    }
    /**
     * Set enddate value
     * @param string $enddate
     * @return \StructType\TrailAdd
     */
    public function setEnddate($enddate = null)
    {
        // validation for constraint: string
        if (!is_null($enddate) && !is_string($enddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enddate, true), gettype($enddate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($enddate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $enddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($enddate, true)), __LINE__);
        }
        $this->enddate = $enddate;
        return $this;
    }
    /**
     * Get endtime value
     * @return string|null
     */
    public function getEndtime()
    {
        return $this->endtime;
    }
    /**
     * Set endtime value
     * @param string $endtime
     * @return \StructType\TrailAdd
     */
    public function setEndtime($endtime = null)
    {
        // validation for constraint: string
        if (!is_null($endtime) && !is_string($endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endtime, true), gettype($endtime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($endtime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($endtime, true)), __LINE__);
        }
        $this->endtime = $endtime;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\TrailAdd
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
