<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Trail StructType
 * @subpackage Structs
 */
class Trail extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The trailType
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $trailType;
    /**
     * The TrailNode1
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TrailNode1[]
     */
    public $TrailNode1;
    /**
     * Constructor method for Trail
     * @uses Trail::setDescription()
     * @uses Trail::setTrailType()
     * @uses Trail::setTrailNode1()
     * @param string $description
     * @param string $trailType
     * @param \StructType\TrailNode1[] $trailNode1
     */
    public function __construct($description = null, $trailType = null, array $trailNode1 = array())
    {
        $this
            ->setDescription($description)
            ->setTrailType($trailType)
            ->setTrailNode1($trailNode1);
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Trail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get trailType value
     * @return string
     */
    public function getTrailType()
    {
        return $this->trailType;
    }
    /**
     * Set trailType value
     * @param string $trailType
     * @return \StructType\Trail
     */
    public function setTrailType($trailType = null)
    {
        // validation for constraint: string
        if (!is_null($trailType) && !is_string($trailType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailType, true), gettype($trailType)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($trailType) && !preg_match('/([-+]){0,1}([0-9])*/', $trailType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($trailType, true)), __LINE__);
        }
        $this->trailType = $trailType;
        return $this;
    }
    /**
     * Get TrailNode1 value
     * @return \StructType\TrailNode1[]|null
     */
    public function getTrailNode1()
    {
        return $this->TrailNode1;
    }
    /**
     * This method is responsible for validating the values passed to the setTrailNode1 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrailNode1 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrailNode1ForArrayConstraintsFromSetTrailNode1(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trailTrailNode1Item) {
            // validation for constraint: itemType
            if (!$trailTrailNode1Item instanceof \StructType\TrailNode1) {
                $invalidValues[] = is_object($trailTrailNode1Item) ? get_class($trailTrailNode1Item) : sprintf('%s(%s)', gettype($trailTrailNode1Item), var_export($trailTrailNode1Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrailNode1 property can only contain items of type \StructType\TrailNode1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrailNode1 value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailNode1[] $trailNode1
     * @return \StructType\Trail
     */
    public function setTrailNode1(array $trailNode1 = array())
    {
        // validation for constraint: array
        if ('' !== ($trailNode1ArrayErrorMessage = self::validateTrailNode1ForArrayConstraintsFromSetTrailNode1($trailNode1))) {
            throw new \InvalidArgumentException($trailNode1ArrayErrorMessage, __LINE__);
        }
        $this->TrailNode1 = $trailNode1;
        return $this;
    }
    /**
     * Add item to TrailNode1 value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailNode1 $item
     * @return \StructType\Trail
     */
    public function addToTrailNode1(\StructType\TrailNode1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrailNode1) {
            throw new \InvalidArgumentException(sprintf('The TrailNode1 property can only contain items of type \StructType\TrailNode1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrailNode1[] = $item;
        return $this;
    }
}
