<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SysMessage StructType
 * @subpackage Structs
 */
class SysMessage extends AbstractStructBase
{
    /**
     * The messageText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messageText;
    /**
     * The messagelevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messagelevel;
    /**
     * The taskid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $taskid;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hotel;
    /**
     * The textid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $textid;
    /**
     * The TextParameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TextParameter[]
     */
    public $TextParameter;
    /**
     * Constructor method for SysMessage
     * @uses SysMessage::setMessageText()
     * @uses SysMessage::setMessagelevel()
     * @uses SysMessage::setTaskid()
     * @uses SysMessage::setHotel()
     * @uses SysMessage::setTextid()
     * @uses SysMessage::setTextParameter()
     * @param string $messageText
     * @param string $messagelevel
     * @param string $taskid
     * @param string $hotel
     * @param string $textid
     * @param \StructType\TextParameter[] $textParameter
     */
    public function __construct($messageText = null, $messagelevel = null, $taskid = null, $hotel = null, $textid = null, array $textParameter = array())
    {
        $this
            ->setMessageText($messageText)
            ->setMessagelevel($messagelevel)
            ->setTaskid($taskid)
            ->setHotel($hotel)
            ->setTextid($textid)
            ->setTextParameter($textParameter);
    }
    /**
     * Get messageText value
     * @return string|null
     */
    public function getMessageText()
    {
        return $this->messageText;
    }
    /**
     * Set messageText value
     * @param string $messageText
     * @return \StructType\SysMessage
     */
    public function setMessageText($messageText = null)
    {
        // validation for constraint: string
        if (!is_null($messageText) && !is_string($messageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageText, true), gettype($messageText)), __LINE__);
        }
        $this->messageText = $messageText;
        return $this;
    }
    /**
     * Get messagelevel value
     * @return string|null
     */
    public function getMessagelevel()
    {
        return $this->messagelevel;
    }
    /**
     * Set messagelevel value
     * @param string $messagelevel
     * @return \StructType\SysMessage
     */
    public function setMessagelevel($messagelevel = null)
    {
        // validation for constraint: string
        if (!is_null($messagelevel) && !is_string($messagelevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messagelevel, true), gettype($messagelevel)), __LINE__);
        }
        $this->messagelevel = $messagelevel;
        return $this;
    }
    /**
     * Get taskid value
     * @return string|null
     */
    public function getTaskid()
    {
        return $this->taskid;
    }
    /**
     * Set taskid value
     * @param string $taskid
     * @return \StructType\SysMessage
     */
    public function setTaskid($taskid = null)
    {
        // validation for constraint: string
        if (!is_null($taskid) && !is_string($taskid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taskid, true), gettype($taskid)), __LINE__);
        }
        $this->taskid = $taskid;
        return $this;
    }
    /**
     * Get hotel value
     * @return string|null
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\SysMessage
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get textid value
     * @return string|null
     */
    public function getTextid()
    {
        return $this->textid;
    }
    /**
     * Set textid value
     * @param string $textid
     * @return \StructType\SysMessage
     */
    public function setTextid($textid = null)
    {
        // validation for constraint: string
        if (!is_null($textid) && !is_string($textid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textid, true), gettype($textid)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($textid) && !preg_match('/([-+]){0,1}([0-9])*/', $textid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($textid, true)), __LINE__);
        }
        $this->textid = $textid;
        return $this;
    }
    /**
     * Get TextParameter value
     * @return \StructType\TextParameter[]|null
     */
    public function getTextParameter()
    {
        return $this->TextParameter;
    }
    /**
     * This method is responsible for validating the values passed to the setTextParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTextParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextParameterForArrayConstraintsFromSetTextParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sysMessageTextParameterItem) {
            // validation for constraint: itemType
            if (!$sysMessageTextParameterItem instanceof \StructType\TextParameter) {
                $invalidValues[] = is_object($sysMessageTextParameterItem) ? get_class($sysMessageTextParameterItem) : sprintf('%s(%s)', gettype($sysMessageTextParameterItem), var_export($sysMessageTextParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TextParameter property can only contain items of type \StructType\TextParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TextParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\TextParameter[] $textParameter
     * @return \StructType\SysMessage
     */
    public function setTextParameter(array $textParameter = array())
    {
        // validation for constraint: array
        if ('' !== ($textParameterArrayErrorMessage = self::validateTextParameterForArrayConstraintsFromSetTextParameter($textParameter))) {
            throw new \InvalidArgumentException($textParameterArrayErrorMessage, __LINE__);
        }
        $this->TextParameter = $textParameter;
        return $this;
    }
    /**
     * Add item to TextParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\TextParameter $item
     * @return \StructType\SysMessage
     */
    public function addToTextParameter(\StructType\TextParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TextParameter) {
            throw new \InvalidArgumentException(sprintf('The TextParameter property can only contain items of type \StructType\TextParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TextParameter[] = $item;
        return $this;
    }
}
