<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StandardRateByCategory StructType
 * @subpackage Structs
 */
class StandardRateByCategory extends AbstractStructBase
{
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The StandardRateEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StandardRateEntry[]
     */
    public $StandardRateEntry;
    /**
     * Constructor method for StandardRateByCategory
     * @uses StandardRateByCategory::setRatecategory()
     * @uses StandardRateByCategory::setStandardRateEntry()
     * @param string $ratecategory
     * @param \StructType\StandardRateEntry[] $standardRateEntry
     */
    public function __construct($ratecategory = null, array $standardRateEntry = array())
    {
        $this
            ->setRatecategory($ratecategory)
            ->setStandardRateEntry($standardRateEntry);
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\StandardRateByCategory
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get StandardRateEntry value
     * @return \StructType\StandardRateEntry[]|null
     */
    public function getStandardRateEntry()
    {
        return $this->StandardRateEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setStandardRateEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandardRateEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStandardRateEntryForArrayConstraintsFromSetStandardRateEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $standardRateByCategoryStandardRateEntryItem) {
            // validation for constraint: itemType
            if (!$standardRateByCategoryStandardRateEntryItem instanceof \StructType\StandardRateEntry) {
                $invalidValues[] = is_object($standardRateByCategoryStandardRateEntryItem) ? get_class($standardRateByCategoryStandardRateEntryItem) : sprintf('%s(%s)', gettype($standardRateByCategoryStandardRateEntryItem), var_export($standardRateByCategoryStandardRateEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StandardRateEntry property can only contain items of type \StructType\StandardRateEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StandardRateEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StandardRateEntry[] $standardRateEntry
     * @return \StructType\StandardRateByCategory
     */
    public function setStandardRateEntry(array $standardRateEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($standardRateEntryArrayErrorMessage = self::validateStandardRateEntryForArrayConstraintsFromSetStandardRateEntry($standardRateEntry))) {
            throw new \InvalidArgumentException($standardRateEntryArrayErrorMessage, __LINE__);
        }
        $this->StandardRateEntry = $standardRateEntry;
        return $this;
    }
    /**
     * Add item to StandardRateEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StandardRateEntry $item
     * @return \StructType\StandardRateByCategory
     */
    public function addToStandardRateEntry(\StructType\StandardRateEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StandardRateEntry) {
            throw new \InvalidArgumentException(sprintf('The StandardRateEntry property can only contain items of type \StructType\StandardRateEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StandardRateEntry[] = $item;
        return $this;
    }
}
