<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceData StructType
 * @subpackage Structs
 */
class ServiceData extends AbstractStructBase
{
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratecategory;
    /**
     * The pricesegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pricesegment;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $quantity;
    /**
     * The manualrate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $manualrate;
    /**
     * The discountgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $discountgroup;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * Constructor method for ServiceData
     * @uses ServiceData::setServicecode()
     * @uses ServiceData::setDatefrom()
     * @uses ServiceData::setDateto()
     * @uses ServiceData::setRatecategory()
     * @uses ServiceData::setPricesegment()
     * @uses ServiceData::setQuantity()
     * @uses ServiceData::setManualrate()
     * @uses ServiceData::setDiscountgroup()
     * @uses ServiceData::setCurrency()
     * @param string $servicecode
     * @param string $datefrom
     * @param string $dateto
     * @param string $ratecategory
     * @param string $pricesegment
     * @param string $quantity
     * @param string $manualrate
     * @param string $discountgroup
     * @param string $currency
     */
    public function __construct($servicecode = null, $datefrom = null, $dateto = null, $ratecategory = null, $pricesegment = null, $quantity = null, $manualrate = null, $discountgroup = null, $currency = null)
    {
        $this
            ->setServicecode($servicecode)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setRatecategory($ratecategory)
            ->setPricesegment($pricesegment)
            ->setQuantity($quantity)
            ->setManualrate($manualrate)
            ->setDiscountgroup($discountgroup)
            ->setCurrency($currency);
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\ServiceData
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\ServiceData
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\ServiceData
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string|null
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\ServiceData
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get pricesegment value
     * @return string|null
     */
    public function getPricesegment()
    {
        return $this->pricesegment;
    }
    /**
     * Set pricesegment value
     * @param string $pricesegment
     * @return \StructType\ServiceData
     */
    public function setPricesegment($pricesegment = null)
    {
        // validation for constraint: string
        if (!is_null($pricesegment) && !is_string($pricesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricesegment, true), gettype($pricesegment)), __LINE__);
        }
        $this->pricesegment = $pricesegment;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\ServiceData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($quantity) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($quantity, true)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get manualrate value
     * @return string|null
     */
    public function getManualrate()
    {
        return $this->manualrate;
    }
    /**
     * Set manualrate value
     * @param string $manualrate
     * @return \StructType\ServiceData
     */
    public function setManualrate($manualrate = null)
    {
        // validation for constraint: string
        if (!is_null($manualrate) && !is_string($manualrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manualrate, true), gettype($manualrate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($manualrate) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $manualrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($manualrate, true)), __LINE__);
        }
        $this->manualrate = $manualrate;
        return $this;
    }
    /**
     * Get discountgroup value
     * @return string|null
     */
    public function getDiscountgroup()
    {
        return $this->discountgroup;
    }
    /**
     * Set discountgroup value
     * @param string $discountgroup
     * @return \StructType\ServiceData
     */
    public function setDiscountgroup($discountgroup = null)
    {
        // validation for constraint: string
        if (!is_null($discountgroup) && !is_string($discountgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountgroup, true), gettype($discountgroup)), __LINE__);
        }
        $this->discountgroup = $discountgroup;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ServiceData
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
}
