<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeasonalRate StructType
 * @subpackage Structs
 */
class SeasonalRate extends AbstractStructBase
{
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $rate;
    /**
     * The SeasonalRateCat
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeasonalRateCat[]
     */
    public $SeasonalRateCat;
    /**
     * Constructor method for SeasonalRate
     * @uses SeasonalRate::setRate()
     * @uses SeasonalRate::setSeasonalRateCat()
     * @param string $rate
     * @param \StructType\SeasonalRateCat[] $seasonalRateCat
     */
    public function __construct($rate = null, array $seasonalRateCat = array())
    {
        $this
            ->setRate($rate)
            ->setSeasonalRateCat($seasonalRateCat);
    }
    /**
     * Get rate value
     * @return string
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\SeasonalRate
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($rate) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($rate, true)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get SeasonalRateCat value
     * @return \StructType\SeasonalRateCat[]|null
     */
    public function getSeasonalRateCat()
    {
        return $this->SeasonalRateCat;
    }
    /**
     * This method is responsible for validating the values passed to the setSeasonalRateCat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeasonalRateCat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeasonalRateCatForArrayConstraintsFromSetSeasonalRateCat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seasonalRateSeasonalRateCatItem) {
            // validation for constraint: itemType
            if (!$seasonalRateSeasonalRateCatItem instanceof \StructType\SeasonalRateCat) {
                $invalidValues[] = is_object($seasonalRateSeasonalRateCatItem) ? get_class($seasonalRateSeasonalRateCatItem) : sprintf('%s(%s)', gettype($seasonalRateSeasonalRateCatItem), var_export($seasonalRateSeasonalRateCatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeasonalRateCat property can only contain items of type \StructType\SeasonalRateCat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeasonalRateCat value
     * @throws \InvalidArgumentException
     * @param \StructType\SeasonalRateCat[] $seasonalRateCat
     * @return \StructType\SeasonalRate
     */
    public function setSeasonalRateCat(array $seasonalRateCat = array())
    {
        // validation for constraint: array
        if ('' !== ($seasonalRateCatArrayErrorMessage = self::validateSeasonalRateCatForArrayConstraintsFromSetSeasonalRateCat($seasonalRateCat))) {
            throw new \InvalidArgumentException($seasonalRateCatArrayErrorMessage, __LINE__);
        }
        $this->SeasonalRateCat = $seasonalRateCat;
        return $this;
    }
    /**
     * Add item to SeasonalRateCat value
     * @throws \InvalidArgumentException
     * @param \StructType\SeasonalRateCat $item
     * @return \StructType\SeasonalRate
     */
    public function addToSeasonalRateCat(\StructType\SeasonalRateCat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeasonalRateCat) {
            throw new \InvalidArgumentException(sprintf('The SeasonalRateCat property can only contain items of type \StructType\SeasonalRateCat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeasonalRateCat[] = $item;
        return $this;
    }
}
